/*:ja
 * @target MZ
 * @plugindesc イベントの位置を保存します。
 * @author ガバチョ（溟犬一六）
 * @url https://star-write-dream.com/
 *
 * @help GABA_SaveEventLocation.js(ver1.0.0)
 *
 * マップを出る時にイベントの位置を保存します。
 * マップに入った時にイベントを保存データの位置に再配置するかどうかは、
 * プラグインコマンドでON/OFFを指定して制御します。
 * プラグインコマンドで指定されていない場合、パラメーターの値に従います。
 *
 * プラグインコマンドは次のとおりです。
 *
 * ■このマップで機能を有効化
 * 再配置するかどうかを、マップ単位で決めます。
 * ONにするとイベントごとの設定値に従います。
 * OFFにすると再配置は実行されません。
 * 
 * ■イベントごとに設定
 * 指定したイベントIDについて、
 * マップに入った時、保存されている位置に再配置するか決めます。
 *  
 * ■全イベントを設定
 * 今いるマップの全イベントについて、
 * マップに入った時、保存されている位置に再配置するか決めます。
 *  
 * ■全マップの位置情報を削除
 * 全マップの位置情報を削除します。
 * 容量が気になる場合に実行してください。
 *
 * ■メモ
 * 簡単イベント作成「扉」の最後の向きの画像は透明です。
 * 向きを保存すると扉が見えなくなってしまいます。
 * ・開けたら閉めるようにする
 * ・扉イベントだけ個別に機能OFFにする
 * ・パラメーターで向きを保存しない設定にする
 * などで対応してください。
 *
 * --------------------------
 * Copyright (c) 2021 Gabacho(Ichiro Meiken)
 * Released under the MIT license
 * https://opensource.org/licenses/mit-license.php
 * --------------------------
 *
 * @param defaultMapEnabled
 * @text マップごとの初期値
 * @type boolean
 * @desc ON:有効 OFF:無効
 * @on ON
 * @off OFF
 * @default true
 *
 * @param defaultEventEnabled
 * @text イベントごとの初期値
 * @type boolean
 * @desc ON:有効 OFF:無効
 * @on ON
 * @off OFF
 * @default true
 *
 * @param saveDirectionEnabled
 * @text 向きを保存する
 * @type boolean
 * @desc ON:向きを保存する OFF:向きは保存しない
 * @on ON
 * @off OFF
 * @default true
 *
 * @command setMap
 * @text このマップで機能を有効化
 * @desc 保存されている位置情報を使うか指定します
 *
 * @arg mapEnabled
 * @type boolean
 * @text 有効/無効
 * @desc ON:有効 OFF:無効
 * @on ON
 * @off OFF
 * @default true
 *
 * @command setEvent
 * @text イベントごとに設定
 * @desc 保存されている位置情報を使うか指定します。マップがOFFだと無視されます。
 *
 * @arg eventId
 * @type text
 * @text イベントID
 * @desc イベントIDを指定します。例)1 または 1,2,3
 *
 * @arg eventEnabled
 * @type boolean
 * @text 有効/無効
 * @desc ON:指定イベントで有効 OFF:指定イベントで無効
 * @on ON
 * @off OFF
 * @default true
 *
 * @command setEventAll
 * @text 全イベントを設定
 * @desc 保存されている位置情報を使うか指定します。マップがOFFだと無視されます。
 *
 * @arg eventEnabled
 * @type boolean
 * @text 有効/無効
 * @desc ON:このマップの全イベントで有効 OFF:このマップの全イベントで無効
 * @on ON
 * @off OFF
 * @default true
 *
 * @command deleteAll
 * @text 全マップの位置情報を削除
 * @desc 全マップの位置情報を削除します。容量が気になる場合に実行してください。
 *
 */