/*:
 * @target MZ
 * @plugindesc Compare variables 61 to 100 and store the ID of the variable with the largest value into variable 101.
 * @help
 * This plugin compares the values of variables 61 to 100 and stores the ID of the variable with the largest value into variable 101.
 */

(() => {
    const startVariableId = 61;
    const endVariableId = 100;
    const resultVariableId = 101;

    const getMaxVariable = () => {
        let maxVarId = startVariableId;
        let maxValue = $gameVariables.value(startVariableId);

        for (let i = startVariableId + 1; i <= endVariableId; i++) {
            const currentValue = $gameVariables.value(i);
            if (currentValue > maxValue) {
                maxValue = currentValue;
                maxVarId = i;
            }
        }

        $gameVariables.setValue(resultVariableId, maxVarId);
    };

    const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'GetMaxVariable') {
            getMaxVariable();
        }
    };
})();
