//=============================================================================
// TRP_SkitMZ_ExZOrderChange.js
//=============================================================================
/*:
 * @author Thirop
 * @target 立ち絵の画面重なり順を変更
 * @help
 * 【更新履歴】
 * 1.00 2022/1/25  初版
 *
 * @command changeZOrder
 * @text 重ね順の変更
 * @desc 重ね順を変更。表示中の立ち絵にも反映されます
 * 
 * @arg zorder
 * @text 重なり順
 * @desc 重なり順
 * @type select
 * @option メッセージウィンドウの手前
 * @value 0
 * @option ピクチャの手前
 * @value 1
 * @option ピクチャの後ろ
 * @value 2
 * @default 2
 */
//============================================================================= 

(function(){
'use strict';

var pluginName = 'TRP_SkitMZ_ExZOrderChange';
PluginManager.registerCommand(pluginName, 'changeZOrder', function(args){
	var argsArr = Object.values(args)
	argsArr.unshift('changeZOrder');
	$gameSkit.processCommand(argsArr);
	this.setWaitMode('skit');
});



var _Skit_clearParameters = Skit.prototype.clearParameters;
Skit.prototype.clearParameters = function(){
	_Skit_clearParameters.call(this);
	this._zOrder = TRP_CORE.skitParameters.zOrder;
};

var _Skit__processCommand = Skit.prototype._processCommand;
Skit.prototype._processCommand = function(args,macroPos){
	if(args[0].toLowerCase()==='changezorder'){
		this.changeZOrder(args);
	}else{
		_Skit__processCommand.call(this,args,macroPos);
	}
};

Skit.prototype.changeZOrder = function(args){
	var zOrder = TRP_CORE.supplementDefNum(2,args[1]);
	if(this._zOrder === zOrder)return;
	this._zOrder = zOrder;

	var sprset = SceneManager._scene._spriteset;
	if(!sprset)return;

	var baseContainer = sprset.bustPictureBaseContainer ? sprset.bustPictureBaseContainer() : null;
	if(!baseContainer)return;

	if(baseContainer.parent){
		baseContainer.parent.removeChild(baseContainer);
	}

	if(zOrder===0){
		SceneManager._scene.addChild(baseContainer);
	}else{
		var index = (sprset.children.indexOf(sprset._pictureContainer))||0;
		if(zOrder === 1){
			index = index+1;
		}else{
			index = index;
		}
		sprset.addChildAt(baseContainer,index);
	}
};

Skit.prototype.zOrder = function(){
	if(this._zOrder===undefined){
		this._zOrder = TRP_CORE.skitParameters.zOrder;
	}
	return this._zOrder;
};

Skit.prototype.needsBustPictureAddToScene = function(){
	return this.zOrder() === 0;
}

Spriteset_Base.prototype.needsBustPictureAddToScene = function(){
	return $gameSkit.needsBustPictureAddToScene();
};



})();