/*:
 * @target MZ
 * @plugindesc パートボイス・Hボイスをカテゴリ別に制御。音量調整・停止・ループに対応。オプション名も変更済み。@ChatGPT
 * @author ChatGPT
 */

var VoiceControl = VoiceControl || {};

(() => {
  // カテゴリ名とオプション表示名を対応付け
  const CATEGORY_LABELS = {
    part: "パートボイス",
    h: "Hボイス"
  };

  // ConfigManager に初期値を登録
  Object.keys(CATEGORY_LABELS).forEach(cat => {
    ConfigManager[`volume_${cat}`] = 100;
  });

  // 設定保存
  const _ConfigManager_makeData = ConfigManager.makeData;
  ConfigManager.makeData = function() {
    const config = _ConfigManager_makeData.call(this);
    Object.keys(CATEGORY_LABELS).forEach(cat => {
      config[`volume_${cat}`] = this[`volume_${cat}`];
    });
    return config;
  };

  // 設定読込
  const _ConfigManager_applyData = ConfigManager.applyData;
  ConfigManager.applyData = function(config) {
    _ConfigManager_applyData.call(this, config);
    Object.keys(CATEGORY_LABELS).forEach(cat => {
      this[`volume_${cat}`] = this.readVolume(config, `volume_${cat}`);
    });
  };

  // オプション画面に音量設定を追加
  const _Window_Options_addVolumeOptions = Window_Options.prototype.addVolumeOptions;
  Window_Options.prototype.addVolumeOptions = function() {
    _Window_Options_addVolumeOptions.call(this);
    for (const cat in CATEGORY_LABELS) {
      this.addCommand(CATEGORY_LABELS[cat], `volume_${cat}`);
    }
  };

  // スライダー表示対応
  const _Window_Options_isVolumeSymbol = Window_Options.prototype.isVolumeSymbol;
  Window_Options.prototype.isVolumeSymbol = function(symbol) {
    const keys = Object.keys(CATEGORY_LABELS).map(cat => `volume_${cat}`);
    return keys.includes(symbol) || _Window_Options_isVolumeSymbol.call(this, symbol);
  };

  // 音声バッファをカテゴリ別に管理
  VoiceControl._buffers = {};

  // カテゴリ音量（0〜1.0）
  VoiceControl.volume = function(category) {
    const key = `volume_${category}`;
    const vol = ConfigManager[key];
    return vol != null ? vol / 100 : 1.0;
  };

  /**
   * 音声を再生
   * @param {string} filename - 再生ファイル名（拡張子不要）
   * @param {boolean} [loop=false] - ループ再生
   * @param {string} [category='part'] - カテゴリ名（audio/{category}/ に配置）
   */
  VoiceControl.play = function(filename, loop = false, category = 'part') {
    if (!filename) return;
    this.stop(category);

    const url = `audio/${category}/${filename}.ogg`;
    const buffer = new WebAudio(url);
    buffer.volume = this.volume(category);
    buffer.loop = loop;
    buffer.play(loop);

    this._buffers[category] = buffer;
  };

  /**
   * 音声停止
   * @param {string} [category] - 指定カテゴリのみ停止（未指定なら全停止）
   */
  VoiceControl.stop = function(category) {
    if (category) {
      if (this._buffers[category]) {
        this._buffers[category].stop();
        delete this._buffers[category];
      }
    } else {
      for (const key in this._buffers) {
        this._buffers[key].stop();
      }
      this._buffers = {};
    }
  };
})();
