//=============================================================================
// Zoom_MenuPatch.js
//=============================================================================
/*:
 * @target MZ
 * @plugindesc マップズーム時のメニュー開閉によるちらつきを防ぎます。
 * @help
 * このプラグインは、マップズーム時においてメニューシーンへ遷移する際に発生する画面のちらつきを防ぎます。
 * 営利・非営利を問わず、自由に使用、変更、再配布が可能です。クレジットは必要ありません。
 */
(() => {
    Scene_Map.prototype.terminate = function(){
        Scene_Message.prototype.terminate.call(this);
        if(!SceneManager.isNextScene(Scene_Battle)){
            this._spriteset.update();
            this._mapNameWindow.hide();
            this.hideMenuButton();
            SceneManager.snapForBackground();
        }
        if(!SceneManager.isNextScene(Scene_Menu)){
            $gameScreen.clearZoom();
        }
    };
})();