/*:
 * @plugindesc 所持済みアイテム購入禁止プラグイン
 * @author ChatGPT
 * @target MZ
 *
 * @param message
 * @text 所持済みメッセージ
 * @desc 既に所持しているアイテムを選択したときに表示されるメッセージ
 * @default このアイテムはすでに所持しています。
 *
 * @help
 * このプラグインを導入すると、ショップで<NoDoublePurchase>タグがついた商品を
 * すでに持っている場合、その商品を再度購入することができなくなります。
 * 薬草などの消耗品にはこの設定を適用しないよう、メモにタグを記載しないでください。
 */

(function() {
    var parameters = PluginManager.parameters('NoDoublePurchase');
    var alreadyOwnedMessage = String(parameters['message']);

    const _Window_ShopBuy_isEnabled = Window_ShopBuy.prototype.isEnabled;
    Window_ShopBuy.prototype.isEnabled = function(item) {
        // <NoDoublePurchase>タグがついているアイテムで、すでにアイテムを持っている場合は、購入不可にする
        if (item && item.meta.NoDoublePurchase && $gameParty.hasItem(item)) {
            return false;
        }
        return _Window_ShopBuy_isEnabled.call(this, item);
    };

    const _Window_ShopBuy_updateHelp = Window_ShopBuy.prototype.updateHelp;
    Window_ShopBuy.prototype.updateHelp = function() {
        _Window_ShopBuy_updateHelp.call(this);
        const item = this.item();
        if (item && item.meta.NoDoublePurchase && $gameParty.hasItem(item)) {
            this._helpWindow.setText(alreadyOwnedMessage);
        }
    };
})();
