cbuffer constBuffer
{
    float4x4 matFinal;
}
cbuffer HeatBuffer
{
    float RedLevel;
    float BlueLevel;
}
struct VS_INPUT
{
    float3 position : POSITION;
    float2 texcoord : TEXCOORD;
    float4 color : COLOR;
};

struct PS_INPUT
{
    float4 position : SV_POSITION;
    float2 texcoord : TEXCOORD;
    float4 color : COLOR;
};

PS_INPUT VS(VS_INPUT input)
{

    PS_INPUT output;
    output.position = float4(input.position, 1.0f);
    //3D-Projection
    //output.position = mul(matFinal, float4(input.position, 1.0f));
    
    output.texcoord = input.texcoord;

    //Hot or Cold
    output.color.r *= RedLevel;    // set the red channel in each vertex
    output.color.b *= BlueLevel;   // set the blue channel in each vertex

    output.color = input.color;

    return output;
}

