//=============================================================================
// EmptyconditionEquip.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 装備の空きに専用装備をセットします。
 * @author まっつＵＰ
 * 
 * @param defaultAct
 * @desc メモに装備を設定していないアクターは
 * このIDのアクターのメモの装備を参照します。
 * @type actor
 * @default 1
 * 
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * アクターの装備が空になった時に専用装備を装備します。
 * それらの装備は所持品に含まれている必要はありません。
 * （含んでしまうとこのプラグインを使う必要性がなくなってしまいます。）
 * アクター毎に任意の装備を設定できますが
 * 必ずそのスロットに装備できる設定にしてください。
 * また、外した時に所持品から削除するので
 * このプラグイン以外の用途で使うことはできません。
 * 
 * アクターのノートタグ
 * <EEece:x,x,x>
 * アクターのスロット順に専用装備を設定します。
 * xには装備のIDをいれてください。
 * 
 * 例：<EEece:5,4,5>
 * 
 * このプラグインを利用する場合は
 * readmeなどに「まっつＵＰ」の名を入れてください。
 * また、素材のみの販売はダメです。
 * 上記以外の規約等はございません。
 * もちろんツクールMVで使用する前提です。
 * 何か不具合ありましたら気軽にどうぞ。
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

(function() {

var parameters = PluginManager.parameters('EmptyconditionEquip');
var EEdefaultAct = Number(parameters['defaultAct'] || 1);

//起動時にデータに加える。
var _Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
    _Game_Temp_initialize.call(this);
    for(var a = 1; a < $dataActors.length; a++){
        $dataActors[a].EEemptyconditionequip = 0;
        var note = $dataActors[a].note;
        var tag = /<(?:EEece):[ ]*(\d+(?:\s*,\s*\d+)*)>/i;
        var notedata = note.split(/[\r\n]+/);
        for (var i = 0; i < notedata.length; i++) {
            var line = notedata[i];
            if(line.match(tag)){
                $dataActors[a].EEemptyconditionequip = JSON.parse('[' + RegExp.$1.match(/\d+/g) + ']');
            }
        }
    }
};

Game_Actor.prototype.Emptyconditionequips = function() {
    var orizin = this.actor().EEemptyconditionequip;
    if(orizin === 0){
        if(this.actorId() === EEdefaultAct){
            var another = 0;
        }else{
            var another = $gameActors.actor(EEdefaultAct).actor().EEemptyconditionequip;
        }
        if(another === 0){
            return [];
        }else{
            return another;
        }
    }
    return orizin;
};

Game_Actor.prototype.Emptyconditionequipsobj = function() {
    var slots = this.equipSlots();
    return this.Emptyconditionequips().map(function(id, index) {
        if(!id) return null;
        if(slots[index] === 1){
            return $dataWeapons[id];
        }else{
            return $dataArmors[id];
        }
    });
};

Game_Actor.prototype.isEmptycondition = function(item) {
    if(!item) return false;
    return this.Emptyconditionequipsobj().some(function(obj) {
        return obj && item.etypeId === obj.etypeId && item.id === obj.id;
    });
};

//コアスクリプトを尊重して返り値を真偽値にする。
var _Game_Actor_tradeItemWithParty = Game_Actor.prototype.tradeItemWithParty;
Game_Actor.prototype.tradeItemWithParty = function(newItem, oldItem) {
    var result = _Game_Actor_tradeItemWithParty.call(this, newItem, oldItem);
    if(result && this.isEmptycondition(oldItem)){
        $gameParty.loseItem(oldItem, $gameParty.maxItems(oldItem));
    }
    return result;
};

//refresh内の同関数の呼び出し時のみ処理する。したがって内部でrefreshは呼ばない。
//各スロットに装備がない時に専用装備をセットする。
var _Game_Actor_releaseUnequippableItems = Game_Actor.prototype.releaseUnequippableItems;
Game_Actor.prototype.releaseUnequippableItems = function(forcing) {
    _Game_Actor_releaseUnequippableItems.call(this, forcing);
    if(forcing) return;
    var slots = this.equipSlots();
    var equips = this.equips();
    for (var i = 0; i < equips.length; i++) {
        var item = equips[i];
        if(item) continue;
        var obj = this.Emptyconditionequipsobj()[i];
        if(!obj) continue;
        if(!this.canEquip(obj) || obj.etypeId !== slots[i]) continue;
        this._equips[i].setObject(obj);
    }
};
 
})();
