//=============================================================================
// AddPlugin_PictureUpAnimation - 立ち絵より上にアニメーションが表示される様に変更
// バージョン: 1.0.0
//=============================================================================
// Copyright (c) 2026 とりぬー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 立ち絵より上にアニメーションが表示される様に変更
 * @author とりぬー
 *
 * @help
 * 【ver.1.0.0】
 *  立ち絵より上にアニメーションが表示される様に変更
 * @command pluginOn
 * @text プラグインの有効化
 * @desc プラグインの有効化
 * 
 * @command pluginOff
 * @text プラグインの無効化
 * @desc プラグインの無効化
 * 
 * @param プラグインのON又はOFF
 * @default true
 * @type boolean
 */
(() => {  
    'use strict';
    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
    const parameters = PluginManager.parameters(pluginName);

    let switchValue =  parameters['プラグインのON又はOFF'];
    let pluginSwitch = switchValue;

    PluginManager.registerCommand(pluginName, "pluginOn", args => {
        pluginSwitch =  true;
    });
    PluginManager.registerCommand(pluginName, "pluginOff", args => {
        pluginSwitch =  false;
    });

    Spriteset_Base.prototype.createAnimationSprite = function(
        targets, animation, mirror, delay
    ) {
        const mv = this.isMVAnimation(animation);
        const sprite = new (mv ? Sprite_AnimationMV : Sprite_Animation)();
        const targetSprites = this.makeTargetSprites(targets);
        const baseDelay = this.animationBaseDelay();
        const previous = delay > baseDelay ? this.lastAnimationSprite() : null;
        if (this.animationShouldMirror(targets[0])) {
            mirror = !mirror;
        }
        sprite.targetObjects = targets;
        sprite.setup(targetSprites, animation, mirror, delay, previous);

        if(pluginSwitch){
            SceneManager._scene.addWindow(sprite);
        }else{
            this._effectsContainer.addChild(sprite);
        }

        this._animationSprites.push(sprite);
    };
})();