//=============================================================================
// AddPlugin_RegenerateSwitches - HP、MP、TPの自動再生を切り替える
// バージョン: 1.0.0
//=============================================================================
// Copyright (c) 2026 とりぬー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc HP、MP、TPの自動再生を切り替える
 * @author とりぬー
 * 
 * @help 
 *  HP、MP、TPの自動再生を行うか、スイッチで管理します。
 * 
 * @param regenerateSwitch
 * @text HP、MP、TPの自動再生を制御するスイッチ
 * @desc スイッチIDを設定します。デフォルトは1です。
 *       ONの場合、自動再生しないようになります。
 * @default 1
 * @type switch
 * 
 */
 
(() => {
  'use strict';
  const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];

  const params = PluginManager.parameters(pluginName);
  let regenerateSwitchValue = Number(params["regenerateSwitch"]);

  const _Game_Actor_regenerateAll = Game_Actor.prototype.regenerateAll;
  Game_Actor.prototype.regenerateAll = function () {
    if ($gameSwitches.value(regenerateSwitchValue)) {
      return;
    }
    _Game_Actor_regenerateAll.call(this);
  };
})();
