//=============================================================================
// AddPlugin_StatusActorMenu
// バージョン: 1.0.0
//=============================================================================
// Copyright (c) 2026 とりぬー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc メニュー画面にステータス項目を表示
 * @author とりぬー
 * 
 * @help
 * メニュー画面にステータス項目を表示します。
 * 想定表示対象はアクター1人までです。
 * 
 */

(() => {
    "use strict";
    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];

    function isPluginEnabled(pluginName) {
        return PluginManager._scripts.includes(pluginName);
    }

    Window_MenuStatus.prototype.drawCustomGauge = function(x, y, width, current, max, color1, color2) {
        const rate = current / max;
        const gaugeHeight = 8; // ゲージの高さ
        const fillWidth = Math.ceil(width * rate);

        this.contents.fillRect(x, y + 24, width, gaugeHeight, ColorManager.gaugeBackColor()); // 背景
        this.contents.gradientFillRect(x, y + 24, fillWidth, gaugeHeight, color1, color2); // ゲージ
    };
    
    // メニューの項目作成
    Window_MenuStatus.prototype.drawItem = function(index) {
        const actor = $gameParty.members()[index];
        const rect = this.itemRect(index);
        const lineHeight = this.lineHeight();

        // 顔グラフィックが設定されているかを確認
        const hasFaceGraphic = actor.faceName() !== ""; // 顔グラフィックがある場合に true

        let drawX = rect.x + (hasFaceGraphic ? 150 : 1); // 顔グラフィックがない場合は左詰め
        let drawY = rect.y; // 描画開始位置Y

        // 顔グラフィックの描画
        if (hasFaceGraphic) {
            this.drawActorFace(actor, rect.x + 1, rect.y + 1, 144, 0);
        }

        this.drawActorName(actor, drawX, drawY, 200); // 名前
        drawY += lineHeight;
        //this.drawActorClass(actor, drawX, drawY, 200); // 職業
        //drawY += lineHeight;
        this.drawActorLevel(actor, drawX, drawY, 200); // レベル
        drawY += lineHeight;
        //this.drawActorNickname(actor, drawX, drawY, 200); // 二つ名
        //drawY += lineHeight;

        this.drawCustomGauge(drawX, drawY, 200, actor.hp, actor.mhp, ColorManager.hpGaugeColor1(), ColorManager.hpGaugeColor2()); // HPゲージ
        this.drawAlignedText(actor.hp + " / " + actor.mhp, drawX, drawY, 200); // HP値
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("HP", drawX, drawY, 100); // HPラベル
        this.resetTextColor();
        drawY += lineHeight;

        this.drawCustomGauge(drawX, drawY, 200, actor.mp, actor.mmp, ColorManager.mpGaugeColor1(), ColorManager.mpGaugeColor2()); // MPゲージ
        this.drawAlignedText(actor.mp + " / " + actor.mmp, drawX, drawY, 200); // MP値
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("MP", drawX, drawY, 100); // MPラベル
        this.resetTextColor();
        drawY += lineHeight;

        // 「ウィンドウにTPを表示」がONならTPゲージを描画
        if ($dataSystem.optDisplayTp) {
            this.drawCustomGauge(drawX, drawY, 200, actor.tp, actor.maxTp(), ColorManager.tpGaugeColor1(), ColorManager.tpGaugeColor2()); // TPゲージ
            this.drawAlignedText(actor.tp + " / " + actor.maxTp(), drawX, drawY, 200); // TP値
            this.changeTextColor(ColorManager.systemColor());
            this.drawText("TP", drawX, drawY, 100); // TPラベル
            this.resetTextColor();
            drawY += lineHeight;
        }

        drawY += lineHeight;

        //const params = ["攻撃力", "防御力", "魔法力", "魔法防御", "敏捷性", "運"];
        const params = ["攻撃力", "防御力", "魔法力", "魔法防御"];
        params.forEach((paramName, i) => {
            this.changeTextColor(ColorManager.systemColor());
            this.drawText(paramName, drawX, drawY, 100); // パラメータラベル
            this.resetTextColor();
            this.drawAlignedText(actor.param(i + 2).toString(), drawX + 100, drawY, 100); // パラメータ値
            drawY += lineHeight;
        });

        // 命中率と回避率を追加表示（正しい計算）
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("命中率", drawX, drawY, 100); // 命中率ラベル
        this.resetTextColor();
        this.drawAlignedText(Math.round(actor.hit * 100) + "%", drawX + 100, drawY, 100); // 命中率値
        drawY += lineHeight;

        this.changeTextColor(ColorManager.systemColor());
        this.drawText("回避率", drawX, drawY, 100); // 回避率ラベル
        this.resetTextColor();
        this.drawAlignedText(Math.round(actor.eva * 100) + "%", drawX + 100, drawY, 100); // 回避率値
        drawY += lineHeight;

        if (isPluginEnabled("AddPlugin_Base")) {
            this.changeTextColor(ColorManager.systemColor());
            this.drawText("HP再生率", drawX, drawY, 100); // HP再生率ラベル
            this.resetTextColor();
            let traitsRet = actorAllTraitsRet(actor.actorId(),22); //plugin Base
            const hpRegenTrait = traitsRet.find(trait => trait.code === 22 && trait.dataId === 7);
            const hpRegenRate = hpRegenTrait ? Math.round(hpRegenTrait.value * 100) + "%" : "0%";
            this.drawAlignedText(hpRegenRate, drawX + 100, drawY, 100); // HP再生率値
            drawY += lineHeight;
        } 

        // ステートの描画（アイコン形式で表示）
        this.drawActorStates(actor, drawX, drawY);
        drawY += lineHeight;

        //右側に配置
        let equipX = drawX + 240;
        let equipY = rect.y + lineHeight; // レベルと同じY座標

        // EXPの描画
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("現在のEXP", equipX, equipY, 150); // 現在のEXPラベル
        this.resetTextColor();
        this.drawAlignedText(actor.currentExp().toString(), equipX + 150, equipY, 100); // 現在のEXP
        equipY += lineHeight;

        this.changeTextColor(ColorManager.systemColor());
        this.drawText("次のレベルまで", equipX, equipY, 150); // 次のレベルまでラベル
        this.resetTextColor();
        this.drawAlignedText((actor.nextRequiredExp()).toString(), equipX + 150, equipY, 100); // 次のレベルまで
        equipY += lineHeight;

        // 特殊ゲージを描画
        this.drawCustomGauge(equipX, equipY, 200, actor.tp, actor.maxTp(), "#ff4444", "#ff4444"); // EPゲージ
        this.drawAlignedText(actor.tp + " / " + actor.maxTp(), equipX, equipY, 200); // EP値
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("EP", equipX, equipY, 100); // EPラベル
        this.resetTextColor();
        equipY += lineHeight;

        //TP表示時の改行制御
        if ($dataSystem.optDisplayTp) {
            equipY += lineHeight;
        }

        equipY += lineHeight;

        // 装備品の描画（アイコン付き）
        const equips = actor.equips();
        //const equipSlots = $dataSystem.equipTypes; // 装備種類の名称を取得
        const equipSlots = actor.equipSlots(); // アクターの装備スロットを取得
        const isDualWield = actor.equipSlots().filter(slot => slot === 1).length > 1;
        equips.forEach((equip, i) => {
            this.changeTextColor(ColorManager.systemColor());
            const slotTypeId = equipSlots[i]; // 正しいスロットIDを取得
            if (isPluginEnabled("AddPlugin_SecondWeaponChange") && i == 1 && isDualWield) {
                this.drawText("武器2", equipX, equipY, 100); // スロット名を表示
            }else{
                this.drawText($dataSystem.equipTypes[slotTypeId], equipX, equipY, 100); // スロット名を表示
            }
            this.resetTextColor();
            if (equip) {
                const iconX = equipX + 100; // アイコンのX座標
                const iconY = equipY + (lineHeight - ImageManager.iconHeight) / 2; // アイコンをセンター揃え
                this.drawIcon(equip.iconIndex, iconX, iconY); // アイコンを描画
                this.drawText(equip.name, iconX + ImageManager.iconWidth + 4, equipY, 200); // アイコンの右側に装備名を表示
            } else {
                this.drawText("", equipX + 100, equipY, 200); // 装備がない場合
            }
            equipY += lineHeight; // 次の装備は下に表示
        });
    };

    Window_MenuStatus.prototype.drawCustomGauge = function(x, y, width, current, max, color1, color2) {
        const rate = current / max;
        const gaugeHeight = 8; // ゲージの高さ
        const fillWidth = Math.ceil(width * rate);
        this.contents.fillRect(x, y + 24, width, gaugeHeight, ColorManager.gaugeBackColor()); // 背景
        this.contents.gradientFillRect(x, y + 24, fillWidth, gaugeHeight, color1, color2); // ゲージ
    };

    Window_MenuStatus.prototype.drawActorStates = function(actor, x, y) {
        const icons = actor.allIcons(); // ステートアイコンのリストを取得
        const iconWidth = ImageManager.iconWidth;
        icons.forEach((icon, i) => {
            const iconX = x + i * iconWidth; // アイコン位置を計算
            this.drawIcon(icon, iconX, y); // アイコンを描画
        });
    };

    Window_MenuStatus.prototype.drawAlignedText = function(value, x, y, width) {
        // フォントサイズを維持しながら指定桁数で右揃え描画
        const originalFontSize = this.contents.fontSize; // 現在のフォントサイズを保存
        this.contents.fontSize = originalFontSize; // フォントサイズをHPのものと統一
        this.drawText(value, x, y, width, 'right'); // 右揃えで描画
        this.contents.fontSize = originalFontSize; // フォントサイズを元に戻す
    };
})();