//=============================================================================
// RPG Maker MZ - Extension for name input window
//=============================================================================

/*:
 * @target MZ
 * @plugindesc Extension for name input window
 * @author MihailJP
 * @url https://github.com/MihailJP/mihamzplugin/blob/master/TimerText.js
 *
 * @help TimerText.js
 *
 * This plugin extends the feature of the character name input scene.
 *
 * For Japanese, Korean and Chinese versions.
 * Nothing to do in English version.
 *
 * It does not provide plugin commands.
 *
 * License: The Unlicense
 *
 * Changelog
 * 11 Oct 2020: First edition. Nothing to do in English version.
 */

/*:ru
 * @target MZ
 * @plugindesc Расширение окна ввода имени
 * @author MihailJP
 * @url https://github.com/MihailJP/mihamzplugin/blob/master/TimerText.js
 *
 * @help TimerText.js
 *
 * Этот плагин расширяет функцию окна ввода имени персонажа.
 *
 * Для японской, корейской и китайской версий.
 * В русской версии делать нечего.
 *
 * Команды плагина нет.
 *
 * Лицензия: Unlicense
 *
 * Журнал изменений
 * 11 октября  2020 г.: первая версия. В русской версии делать нечего.
 */

/*:ja
 * @target MZ
 * @plugindesc 名前入力ウィンドウの拡張
 * @author MihailJP
 * @url https://github.com/MihailJP/mihamzplugin/blob/master/ExtendedNameInput.js
 *
 * @help ExtendedNameInput.js
 *
 * このプラグインは、キャラクター名入力画面の機能を拡張します。
 *
 * 日本語版では、漢字入力機能が追加されます。
 * 漢字入力は五十音の見出しからJIS第1水準漢字を、
 * 部首画数の見出しからJIS第2水準漢字を選択することができます。
 * (部首画数が3画、4画、6画は該当数が多いので2つ（4画は3つ）に分かれています。)
 *
 * プラグインコマンドはありません。
 *
 * ライセンス：Unlicense
 *
 * 更新履歴
 * 令和2年10月11日 初版
 *
 * @param returnWithCancelButton
 * @text キャンセルボタンで索引に戻る
 * @desc 漢字入力時にキャンセルボタンを押すとバックスペースの代わりに索引に戻る
 * @default false
 * @type boolean
 */

/*:ko
 * @target MZ
 * @plugindesc 이름 입력 윈도우의 확장
 * @author MihailJP
 * @url https://github.com/MihailJP/mihamzplugin/blob/master/ExtendedNameInput.js
 *
 * @help ExtendedNameInput.js
 *
 * 이 플러그인은 캐릭터명 입력 화면의 기능을 확장합니다.
 *
 * 한국어 환경에서는 한글 문자판이 추가됩니다.
 * 한글 문자판에서는 자음과 모음의 자모를 합성할 수가 있습니다.
 * 세벌식 문자판입니다. 위 자음 자모는 첫소리 자모이라고,
 * 아래 자음 자모는 끝소리 자모입니다.
 *
 * (두벌식 문자판을 실장하고 싶었지만, 처리가 복잡하기 때문에, 못했습니다.
 * 문자판 1 페이지에는 88개 문자를 정의할 수 있지만, EUC-KR (또는 KS X 1001) 에
 * 자모가 93개 있기 때문에 1 페이지에서는 모자랍니다.)
 *
 * 옛한글 자모가 문자판에 있습니다만, 합성할 수는 없습니다.
 *
 * 플러그인 커맨드는 없습니다.
 *
 * 라이선스: Unlicense
 *
 * 갱신역사
 * 2020년 10월 11일: 첫판
 */

/*:zh
 * @target MZ
 * @plugindesc 擴展輸入角色名字の屏幕
 * @author MihailJP
 * @url https://github.com/MihailJP/mihamzplugin/blob/master/ExtendedNameInput.js
 *
 * @help ExtendedNameInput.js
 *
 * 該插件擴展輸入角色名字の屏幕の功能。
 *
 * 在中文版，加輸入漢字の功能。用聲母索引或者總劃索引可以輸入漢字。
 *
 * 在繁體字模式，可以輸入CNS11643第1字面の漢字和追加的『の』『囧』2字。
 * 第1字面包含台灣教育部『常用國字標準字體表』の所有漢字。
 * 『の』字是代用『的』或『之』的日文平假名。
 * 『囧』字在『次常用國字標準字體表』及中文標準交換碼の第2字面。
 * 聲母索引是注音符號排列的。
 *
 * 簡體字模式是未實裝的。简体字模式是未实装的。
 *
 * 沒有插件命令。
 *
 * 許可: Unlicense
 *
 * 更新歷史
 * 2020年10月11日 第一版
 *
 * @param returnWithCancelButton
 * @text 按取消鈕返回到索引
 * @desc 在輸入漢字時按取消鈕，返回到索引而不是退格
 * @default false
 * @type boolean
 */

(() => {
	const CharacterBoardPages = 4;

	const pluginName = "ExtendedNameInput";
	const param = PluginManager.parameters(pluginName);
	const returnWithCancelButton = JSON.parse(param.returnWithCancelButton);

	/* 日本語拡張 */
	Window_NameInput.JAPAN3[88] = "漢字";
	Window_NameInput.JAPAN4 =
		[ "あ","い","う","え","お",  "１画","２画","３画▶","口～大","女～彳",
		  "か","き","く","け","こ",  "４画▶","心～月","木","欠～犬","５画",
		  "さ","し","す","せ","そ",  "６画▶","竹～舛","舟～襾","７画","８画",
		  "た","ち","つ","て","と",  "９画","10画","11画","12画","13画",
		  "な","に","ぬ","ね","の",  "14画","15画","16画","17画","追補",
		  "は","ひ","ふ","へ","ほ",  "",  "",  "",  "",  "",
		  "ま","み","む","め","も",  "",  "",  "",  "",  "",
		  "や","ゆ","よ","わ","",    "",  "",  "",  "",  "",
		  "ら","り","る","れ","ろ",  "",  "",  "",  "かな","決定" ];
	Window_NameInput.JAPAN_KANJI_INDEX =
		[    4,   5,   6,   7,   8,    65,  66,   3,  69,  72,
		     9,  12,  15,  16,  18,     3,  75,  79,  82,  86,
		    20,  22,  27,  28,  30,     3,  90,  94,  98, 102,
		    32,  34,  35,  36,  37,   105, 106, 107, 109, 110,
		    39,  40,  41,  42,  43,   111, 112, 113, 114, 115,
		    44,  46,  47,  48,  49,     3,   3,   3,   3,   3,
		    51,  52,  53,  54,  55,     3,   3,   3,   3,   3,
		    56,  57,  58,  64,   3,     3,   3,   3,   3,   3,
		    59,  60,  61,  62,  63,     3,   3,   3,   3,   3 ];
	Window_NameInput.JAPAN_KANJI_LEVEL1 =
		[
			[ "亜","唖","娃","阿","哀",  "",  "",  "",  "",  "",   // あ
			  "愛","挨","姶","逢","葵",  "",  "",  "",  "",  "",
			  "茜","穐","悪","握","渥",  "",  "",  "",  "",  "",
			  "旭","葦","芦","鯵","梓",  "",  "",  "",  "",  "",
			  "圧","斡","扱","宛","姐",  "",  "",  "",  "",  "",
			  "虻","飴","絢","綾","鮎",  "",  "",  "",  "",  "",
			  "或","粟","袷","安","庵",  "",  "",  "",  "",  "",
			  "按","暗","案","闇","鞍",  "",  "",  "",  "",  "",
			  "杏","",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "以","伊","位","依","偉",  "員","因","姻","引","飲", // い
			  "囲","夷","委","威","尉",  "淫","胤","蔭","院","陰",
			  "惟","意","慰","易","椅",  "隠","韻","吋","",  "",
			  "為","畏","異","移","維",  "",  "",  "",  "",  "",
			  "緯","胃","萎","衣","謂",  "",  "",  "",  "",  "",
			  "違","遺","医","井","亥",  "",  "",  "",  "",  "",
			  "域","育","郁","磯","一",  "",  "",  "",  "",  "",
			  "壱","溢","逸","稲","茨",  "",  "",  "",  "",  "",
			  "芋","鰯","允","印","咽",  "",  "",  "",  "戻る","決定"],
			[ "右","宇","烏","羽","迂",  "",  "",  "",  "",  "",   // う
			  "雨","卯","鵜","窺","丑",  "",  "",  "",  "",  "",
			  "碓","臼","渦","嘘","唄",  "",  "",  "",  "",  "",
			  "欝","蔚","鰻","姥","厩",  "",  "",  "",  "",  "",
			  "浦","瓜","閏","噂","云",  "",  "",  "",  "",  "",
			  "運","雲","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "荏","餌","叡","営","嬰",  "猿","縁","艶","苑","薗", // え
			  "影","映","曳","栄","永",  "遠","鉛","鴛","塩","",
			  "泳","洩","瑛","盈","穎",  "",  "",  "",  "",  "",
			  "頴","英","衛","詠","鋭",  "",  "",  "",  "",  "",
			  "液","疫","益","駅","悦",  "",  "",  "",  "",  "",
			  "謁","越","閲","榎","厭",  "",  "",  "",  "",  "",
			  "円","園","堰","奄","宴",  "",  "",  "",  "",  "",
			  "延","怨","掩","援","沿",  "",  "",  "",  "",  "",
			  "演","炎","焔","煙","燕",  "",  "",  "",  "戻る","決定"],
			[ "於","汚","甥","凹","央",  "",  "",  "",  "",  "",   // お
			  "奥","往","応","押","旺",  "",  "",  "",  "",  "",
			  "横","欧","殴","王","翁",  "",  "",  "",  "",  "",
			  "襖","鴬","鴎","黄","岡",  "",  "",  "",  "",  "",
			  "沖","荻","億","屋","憶",  "",  "",  "",  "",  "",
			  "臆","桶","牡","乙","俺",  "",  "",  "",  "",  "",
			  "卸","恩","温","穏","音",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "下","化","仮","何","伽",  "臥","芽","蛾","賀","雅", // か
			  "価","佳","加","可","嘉",  "餓","駕","介","会","解",
			  "夏","嫁","家","寡","科",  "回","塊","壊","廻","快",
			  "暇","果","架","歌","河",  "怪","悔","恢","懐","戒",
			  "火","珂","禍","禾","稼",  "拐","改","魁","晦","械",
			  "箇","花","苛","茄","荷",  "海","灰","界","皆","絵",
			  "華","菓","蝦","課","嘩",  "芥","蟹","開","階","貝",
			  "貨","迦","過","霞","蚊",  "凱","劾","外","咳","害",
			  "俄","峨","我","牙","画",  "崖","慨","概","続き","決定"],
			[ "涯","碍","蓋","街","該",  "潟","割","喝","恰","括",
			  "鎧","骸","浬","馨","蛙",  "活","渇","滑","葛","褐",
			  "垣","柿","蛎","鈎","劃",  "轄","且","鰹","叶","椛",
			  "嚇","各","廓","拡","撹",  "樺","鞄","株","兜","竃",
			  "格","核","殻","獲","確",  "蒲","釜","鎌","噛","鴨",
			  "穫","覚","角","赫","較",  "栢","茅","萱","粥","刈",
			  "郭","閣","隔","革","学",  "苅","瓦","乾","侃","冠",
			  "岳","楽","額","顎","掛",  "寒","刊","勘","勧","巻",
			  "笠","樫","橿","梶","鰍",  "喚","堪","姦","続き","決定"],
			[ "完","官","寛","干","幹",  "丸","含","岸","巌","玩",
			  "患","感","慣","憾","換",  "癌","眼","岩","翫","贋",
			  "敢","柑","桓","棺","款",  "雁","頑","顔","願","",
			  "歓","汗","漢","澗","潅",  "",  "",  "",  "",  "",
			  "環","甘","監","看","竿",  "",  "",  "",  "",  "",
			  "管","簡","緩","缶","翰",  "",  "",  "",  "",  "",
			  "肝","艦","莞","観","諌",  "",  "",  "",  "",  "",
			  "貫","還","鑑","間","閑",  "",  "",  "",  "",  "",
			  "関","陥","韓","館","舘",  "",  "",  "",  "戻る","決定"],
			[ "企","伎","危","喜","器",  "戯","技","擬","欺","犠", // き
			  "基","奇","嬉","寄","岐",  "疑","祇","義","蟻","誼",
			  "希","幾","忌","揮","机",  "議","掬","菊","鞠","吉",
			  "旗","既","期","棋","棄",  "吃","喫","桔","橘","詰",
			  "機","帰","毅","気","汽",  "砧","杵","黍","却","客",
			  "畿","祈","季","稀","紀",  "脚","虐","逆","丘","久",
			  "徽","規","記","貴","起",  "仇","休","及","吸","宮",
			  "軌","輝","飢","騎","鬼",  "弓","急","救","朽","求",
			  "亀","偽","儀","妓","宜",  "汲","泣","灸","続き","決定"],
			[ "球","究","窮","笈","級",  "挟","教","橋","況","狂",
			  "糾","給","旧","牛","去",  "狭","矯","胸","脅","興",
			  "居","巨","拒","拠","挙",  "蕎","郷","鏡","響","饗",
			  "渠","虚","許","距","鋸",  "驚","仰","凝","尭","暁",
			  "漁","禦","魚","亨","享",  "業","局","曲","極","玉",
			  "京","供","侠","僑","兇",  "桐","粁","僅","勤","均",
			  "競","共","凶","協","匡",  "巾","錦","斤","欣","欽",
			  "卿","叫","喬","境","峡",  "琴","禁","禽","筋","緊",
			  "強","彊","怯","恐","恭",  "芹","菌","衿","続き","決定"],
			[ "襟","謹","近","金","吟",  "",  "",  "",  "",  "",
			  "銀","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "九","倶","句","区","狗",  "郡","",  "",  "",  "",   // く
			  "玖","矩","苦","躯","駆",  "",  "",  "",  "",  "",
			  "駈","駒","具","愚","虞",  "",  "",  "",  "",  "",
			  "喰","空","偶","寓","遇",  "",  "",  "",  "",  "",
			  "隅","串","櫛","釧","屑",  "",  "",  "",  "",  "",
			  "屈","掘","窟","沓","靴",  "",  "",  "",  "",  "",
			  "轡","窪","熊","隈","粂",  "",  "",  "",  "",  "",
			  "栗","繰","桑","鍬","勲",  "",  "",  "",  "",  "",
			  "君","薫","訓","群","軍",  "",  "",  "",  "戻る","決定"],
			[ "卦","袈","祁","係","傾",  "撃","激","隙","桁","傑", // け
			  "刑","兄","啓","圭","珪",  "欠","決","潔","穴","結",
			  "型","契","形","径","恵",  "血","訣","月","件","倹",
			  "慶","慧","憩","掲","携",  "倦","健","兼","券","剣",
			  "敬","景","桂","渓","畦",  "喧","圏","堅","嫌","建",
			  "稽","系","経","継","繋",  "憲","懸","拳","捲","検",
			  "罫","茎","荊","蛍","計",  "権","牽","犬","献","研",
			  "詣","警","軽","頚","鶏",  "硯","絹","県","肩","見",
			  "芸","迎","鯨","劇","戟",  "謙","賢","軒","続き","決定"],
			[ "遣","鍵","険","顕","験",  "",  "",  "",  "",  "",
			  "鹸","元","原","厳","幻",  "",  "",  "",  "",  "",
			  "弦","減","源","玄","現",  "",  "",  "",  "",  "",
			  "絃","舷","言","諺","限",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "乎","個","古","呼","固",  "乞","鯉","交","佼","侯", // こ
			  "姑","孤","己","庫","弧",  "候","倖","光","公","功",
			  "戸","故","枯","湖","狐",  "効","勾","厚","口","向",
			  "糊","袴","股","胡","菰",  "后","喉","坑","垢","好",
			  "虎","誇","跨","鈷","雇",  "孔","孝","宏","工","巧",
			  "顧","鼓","五","互","伍",  "巷","幸","広","庚","康",
			  "午","呉","吾","娯","後",  "弘","恒","慌","抗","拘",
			  "御","悟","梧","檎","瑚",  "控","攻","昂","晃","更",
			  "碁","語","誤","護","醐",  "杭","校","梗","続き","決定"],
			[ "構","江","洪","浩","港",  "濠","豪","轟","麹","克",
			  "溝","甲","皇","硬","稿",  "刻","告","国","穀","酷",
			  "糠","紅","紘","絞","綱",  "鵠","黒","獄","漉","腰",
			  "耕","考","肯","肱","腔",  "甑","忽","惚","骨","狛",
			  "膏","航","荒","行","衡",  "込","此","頃","今","困",
			  "講","貢","購","郊","酵",  "坤","墾","婚","恨","懇",
			  "鉱","砿","鋼","閤","降",  "昏","昆","根","梱","混",
			  "項","香","高","鴻","剛",  "痕","紺","艮","魂","",
			  "劫","号","合","壕","拷",  "",  "",  "",  "戻る","決定"],
			[ "些","佐","叉","唆","嵯",  "材","罪","財","冴","坂", // さ
			  "左","差","査","沙","瑳",  "阪","堺","榊","肴","咲",
			  "砂","詐","鎖","裟","坐",  "崎","埼","碕","鷺","作",
			  "座","挫","債","催","再",  "削","咋","搾","昨","朔",
			  "最","哉","塞","妻","宰",  "柵","窄","策","索","錯",
			  "彩","才","採","栽","歳",  "桜","鮭","笹","匙","冊",
			  "済","災","采","犀","砕",  "刷","察","拶","撮","擦",
			  "砦","祭","斎","細","菜",  "札","殺","薩","雑","皐",
			  "裁","載","際","剤","在",  "鯖","捌","錆","続き","決定"],
			[ "鮫","皿","晒","三","傘",  "",  "",  "",  "",  "",
			  "参","山","惨","撒","散",  "",  "",  "",  "",  "",
			  "桟","燦","珊","産","算",  "",  "",  "",  "",  "",
			  "纂","蚕","讃","賛","酸",  "",  "",  "",  "",  "",
			  "餐","斬","暫","残","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "仕","仔","伺","使","刺",  "賜","雌","飼","歯","事", // し
			  "司","史","嗣","四","士",  "似","侍","児","字","寺",
			  "始","姉","姿","子","屍",  "慈","持","時","次","滋",
			  "市","師","志","思","指",  "治","爾","璽","痔","磁",
			  "支","孜","斯","施","旨",  "示","而","耳","自","蒔",
			  "枝","止","死","氏","獅",  "辞","汐","鹿","式","識",
			  "祉","私","糸","紙","紫",  "鴫","竺","軸","宍","雫",
			  "肢","脂","至","視","詞",  "七","叱","執","失","嫉",
			  "詩","試","誌","諮","資",  "室","悉","湿","続き","決定"],
			[ "漆","疾","質","実","蔀",  "殊","狩","珠","種","腫",
			  "篠","偲","柴","芝","屡",  "趣","酒","首","儒","受",
			  "蕊","縞","舎","写","射",  "呪","寿","授","樹","綬",
			  "捨","赦","斜","煮","社",  "需","囚","収","周","宗",
			  "紗","者","謝","車","遮",  "就","州","修","愁","拾",
			  "蛇","邪","借","勺","尺",  "洲","秀","秋","終","繍",
			  "杓","灼","爵","酌","釈",  "習","臭","舟","蒐","衆",
			  "錫","若","寂","弱","惹",  "襲","讐","蹴","輯","週",
			  "主","取","守","手","朱",  "酋","酬","集","続き","決定"],
			[ "醜","什","住","充","十",  "醇","順","処","初","所",
			  "従","戎","柔","汁","渋",  "暑","曙","渚","庶","緒",
			  "獣","縦","重","銃","叔",  "署","書","薯","藷","諸",
			  "夙","宿","淑","祝","縮",  "助","叙","女","序","徐",
			  "粛","塾","熟","出","術",  "恕","鋤","除","傷","償",
			  "述","俊","峻","春","瞬",  "勝","匠","升","召","哨",
			  "竣","舜","駿","准","循",  "商","唱","嘗","奨","妾",
			  "旬","楯","殉","淳","準",  "娼","宵","将","小","少",
			  "潤","盾","純","巡","遵",  "尚","庄","床","続き","決定"],
			[ "廠","彰","承","抄","招",  "鉦","鍾","鐘","障","鞘",
			  "掌","捷","昇","昌","昭",  "上","丈","丞","乗","冗",
			  "晶","松","梢","樟","樵",  "剰","城","場","壌","嬢",
			  "沼","消","渉","湘","焼",  "常","情","擾","条","杖",
			  "焦","照","症","省","硝",  "浄","状","畳","穣","蒸",
			  "礁","祥","称","章","笑",  "譲","醸","錠","嘱","埴",
			  "粧","紹","肖","菖","蒋",  "飾","拭","植","殖","燭",
			  "蕉","衝","裳","訟","証",  "織","職","色","触","食",
			  "詔","詳","象","賞","醤",  "蝕","辱","尻","続き","決定"],
			[ "伸","信","侵","唇","娠",  "",  "",  "",  "",  "",
			  "寝","審","心","慎","振",  "",  "",  "",  "",  "",
			  "新","晋","森","榛","浸",  "",  "",  "",  "",  "",
			  "深","申","疹","真","神",  "",  "",  "",  "",  "",
			  "秦","紳","臣","芯","薪",  "",  "",  "",  "",  "",
			  "親","診","身","辛","進",  "",  "",  "",  "",  "",
			  "針","震","人","仁","刃",  "",  "",  "",  "",  "",
			  "塵","壬","尋","甚","尽",  "",  "",  "",  "",  "",
			  "腎","訊","迅","陣","靭",  "",  "",  "",  "戻る","決定"],
			[ "笥","諏","須","酢","図",  "",  "",  "",  "",  "",   // す
			  "厨","逗","吹","垂","帥",  "",  "",  "",  "",  "",
			  "推","水","炊","睡","粋",  "",  "",  "",  "",  "",
			  "翠","衰","遂","酔","錐",  "",  "",  "",  "",  "",
			  "錘","随","瑞","髄","崇",  "",  "",  "",  "",  "",
			  "嵩","数","枢","趨","雛",  "",  "",  "",  "",  "",
			  "据","杉","椙","菅","頗",  "",  "",  "",  "",  "",
			  "雀","裾","澄","摺","寸",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "世","瀬","畝","是","凄",  "積","籍","績","脊","責", // せ
			  "制","勢","姓","征","性",  "赤","跡","蹟","碩","切",
			  "成","政","整","星","晴",  "拙","接","摂","折","設",
			  "棲","栖","正","清","牲",  "窃","節","説","雪","絶",
			  "生","盛","精","聖","声",  "舌","蝉","仙","先","千",
			  "製","西","誠","誓","請",  "占","宣","専","尖","川",
			  "逝","醒","青","静","斉",  "戦","扇","撰","栓","栴",
			  "税","脆","隻","席","惜",  "泉","浅","洗","染","潜",
			  "戚","斥","昔","析","石",  "煎","煽","旋","続き","決定"],
			[ "穿","箭","線","繊","羨",  "",  "",  "",  "",  "",
			  "腺","舛","船","薦","詮",  "",  "",  "",  "",  "",
			  "賎","践","選","遷","銭",  "",  "",  "",  "",  "",
			  "銑","閃","鮮","前","善",  "",  "",  "",  "",  "",
			  "漸","然","全","禅","繕",  "",  "",  "",  "",  "",
			  "膳","糎","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "噌","塑","岨","措","曾",  "漕","燥","争","痩","相", // そ
			  "曽","楚","狙","疏","疎",  "窓","糟","総","綜","聡",
			  "礎","祖","租","粗","素",  "草","荘","葬","蒼","藻",
			  "組","蘇","訴","阻","遡",  "装","走","送","遭","鎗",
			  "鼠","僧","創","双","叢",  "霜","騒","像","増","憎",
			  "倉","喪","壮","奏","爽",  "臓","蔵","贈","造","促",
			  "宋","層","匝","惣","想",  "側","則","即","息","捉",
			  "捜","掃","挿","掻","操",  "束","測","足","速","俗",
			  "早","曹","巣","槍","槽",  "属","賊","族","続き","決定"],
			[ "続","卒","袖","其","揃",  "",  "",  "",  "",  "",
			  "存","孫","尊","損","村",  "",  "",  "",  "",  "",
			  "遜","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "他","多","太","汰","詑",  "鷹","滝","瀧","卓","啄", // た
			  "唾","堕","妥","惰","打",  "宅","托","択","拓","沢",
			  "柁","舵","楕","陀","駄",  "濯","琢","託","鐸","濁",
			  "騨","体","堆","対","耐",  "諾","茸","凧","蛸","只",
			  "岱","帯","待","怠","態",  "叩","但","達","辰","奪",
			  "戴","替","泰","滞","胎",  "脱","巽","竪","辿","棚",
			  "腿","苔","袋","貸","退",  "谷","狸","鱈","樽","誰",
			  "逮","隊","黛","鯛","代",  "丹","単","嘆","坦","担",
			  "台","大","第","醍","題",  "探","旦","歎","続き","決定"],
			[ "淡","湛","炭","短","端",  "",  "",  "",  "",  "",
			  "箪","綻","耽","胆","蛋",  "",  "",  "",  "",  "",
			  "誕","鍛","団","壇","弾",  "",  "",  "",  "",  "",
			  "断","暖","檀","段","男",  "",  "",  "",  "",  "",
			  "談","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "値","知","地","弛","恥",  "丁","兆","凋","喋","寵", // ち
			  "智","池","痴","稚","置",  "帖","帳","庁","弔","張",
			  "致","蜘","遅","馳","築",  "彫","徴","懲","挑","暢",
			  "畜","竹","筑","蓄","逐",  "朝","潮","牒","町","眺",
			  "秩","窒","茶","嫡","着",  "聴","脹","腸","蝶","調",
			  "中","仲","宙","忠","抽",  "諜","超","跳","銚","長",
			  "昼","柱","注","虫","衷",  "頂","鳥","勅","捗","直",
			  "註","酎","鋳","駐","樗",  "朕","沈","珍","賃","鎮",
			  "瀦","猪","苧","著","貯",  "陳","",  "",  "戻る","決定"],
			[ "津","墜","椎","槌","追",  "",  "",  "",  "",  "",   // つ
			  "鎚","痛","通","塚","栂",  "",  "",  "",  "",  "",
			  "掴","槻","佃","漬","柘",  "",  "",  "",  "",  "",
			  "辻","蔦","綴","鍔","椿",  "",  "",  "",  "",  "",
			  "潰","坪","壷","嬬","紬",  "",  "",  "",  "",  "",
			  "爪","吊","釣","鶴","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "亭","低","停","偵","剃",  "撤","轍","迭","鉄","典", // て
			  "貞","呈","堤","定","帝",  "填","天","展","店","添",
			  "底","庭","廷","弟","悌",  "纏","甜","貼","転","顛",
			  "抵","挺","提","梯","汀",  "点","伝","殿","澱","田",
			  "碇","禎","程","締","艇",  "電","",  "",  "",  "",
			  "訂","諦","蹄","逓","邸",  "",  "",  "",  "",  "",
			  "鄭","釘","鼎","泥","摘",  "",  "",  "",  "",  "",
			  "擢","敵","滴","的","笛",  "",  "",  "",  "",  "",
			  "適","鏑","溺","哲","徹",  "",  "",  "",  "戻る","決定"],
			[ "兎","吐","堵","塗","妬",  "涛","灯","燈","当","痘", // と
			  "屠","徒","斗","杜","渡",  "祷","等","答","筒","糖",
			  "登","菟","賭","途","都",  "統","到","董","蕩","藤",
			  "鍍","砥","砺","努","度",  "討","謄","豆","踏","逃",
			  "土","奴","怒","倒","党",  "透","鐙","陶","頭","騰",
			  "冬","凍","刀","唐","塔",  "闘","働","動","同","仝",
			  "塘","套","宕","島","嶋",  "堂","導","憧","撞","洞",
			  "悼","投","搭","東","桃",  "瞳","童","胴","萄","道",
			  "梼","棟","盗","淘","湯",  "銅","峠","鴇","続き","決定"],
			[ "匿","得","徳","涜","特",  "",  "",  "",  "",  "",
			  "督","禿","篤","毒","独",  "",  "",  "",  "",  "",
			  "読","栃","橡","凸","突",  "",  "",  "",  "",  "",
			  "椴","届","鳶","苫","寅",  "",  "",  "",  "",  "",
			  "酉","瀞","噸","屯","惇",  "",  "",  "",  "",  "",
			  "敦","沌","豚","遁","頓",  "",  "",  "",  "",  "",
			  "呑","曇","鈍","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "奈","那","内","乍","凪",  "",  "",  "",  "",  "",   // な
			  "薙","謎","灘","捺","鍋",  "",  "",  "",  "",  "",
			  "楢","馴","縄","畷","南",  "",  "",  "",  "",  "",
			  "楠","軟","難","汝","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "二","尼","弐","迩","匂",  "",  "",  "",  "",  "",   // に
			  "賑","肉","虹","廿","日",  "",  "",  "",  "",  "",
			  "乳","入","如","尿","韮",  "",  "",  "",  "",  "",
			  "任","妊","忍","認","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "濡","",  "",  "",  "",    "",  "",  "",  "",  "",   // ぬ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "禰","祢","寧","葱","猫",  "",  "",  "",  "",  "",   // ね
			  "熱","年","念","捻","撚",  "",  "",  "",  "",  "",
			  "燃","粘","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "乃","廼","之","埜","嚢",  "",  "",  "",  "",  "",   // の
			  "悩","濃","納","能","脳",  "",  "",  "",  "",  "",
			  "膿","農","覗","蚤","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "巴","把","播","覇","杷",  "柏","泊","白","箔","粕", // は
			  "波","派","琶","破","婆",  "舶","薄","迫","曝","漠",
			  "罵","芭","馬","俳","廃",  "爆","縛","莫","駁","麦",
			  "拝","排","敗","杯","盃",  "函","箱","硲","箸","肇",
			  "牌","背","肺","輩","配",  "筈","櫨","幡","肌","畑",
			  "倍","培","媒","梅","楳",  "畠","八","鉢","溌","発",
			  "煤","狽","買","売","賠",  "醗","髪","伐","罰","抜",
			  "陪","這","蝿","秤","矧",  "筏","閥","鳩","噺","塙",
			  "萩","伯","剥","博","拍",  "蛤","隼","伴","続き","決定"],
			[ "判","半","反","叛","帆",  "",  "",  "",  "",  "",
			  "搬","斑","板","氾","汎",  "",  "",  "",  "",  "",
			  "版","犯","班","畔","繁",  "",  "",  "",  "",  "",
			  "般","藩","販","範","釆",  "",  "",  "",  "",  "",
			  "煩","頒","飯","挽","晩",  "",  "",  "",  "",  "",
			  "番","盤","磐","蕃","蛮",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "匪","卑","否","妃","庇",  "肘","弼","必","畢","筆", // ひ
			  "彼","悲","扉","批","披",  "逼","桧","姫","媛","紐",
			  "斐","比","泌","疲","皮",  "百","謬","俵","彪","標",
			  "碑","秘","緋","罷","肥",  "氷","漂","瓢","票","表",
			  "被","誹","費","避","非",  "評","豹","廟","描","病",
			  "飛","樋","簸","備","尾",  "秒","苗","錨","鋲","蒜",
			  "微","枇","毘","琵","眉",  "蛭","鰭","品","彬","斌",
			  "美","鼻","柊","稗","匹",  "浜","瀕","貧","賓","頻",
			  "疋","髭","彦","膝","菱",  "敏","瓶","",  "戻る","決定"],
			[ "不","付","埠","夫","婦",  "複","覆","淵","弗","払", // ふ
			  "富","冨","布","府","怖",  "沸","仏","物","鮒","分",
			  "扶","敷","斧","普","浮",  "吻","噴","墳","憤","扮",
			  "父","符","腐","膚","芙",  "焚","奮","粉","糞","紛",
			  "譜","負","賦","赴","阜",  "雰","文","聞","",  "",
			  "附","侮","撫","武","舞",  "",  "",  "",  "",  "",
			  "葡","蕪","部","封","楓",  "",  "",  "",  "",  "",
			  "風","葺","蕗","伏","副",  "",  "",  "",  "",  "",
			  "復","幅","服","福","腹",  "",  "",  "",  "戻る","決定"],
			[ "丙","併","兵","塀","幣",  "",  "",  "",  "",  "",   // へ
			  "平","弊","柄","並","蔽",  "",  "",  "",  "",  "",
			  "閉","陛","米","頁","僻",  "",  "",  "",  "",  "",
			  "壁","癖","碧","別","瞥",  "",  "",  "",  "",  "",
			  "蔑","箆","偏","変","片",  "",  "",  "",  "",  "",
			  "篇","編","辺","返","遍",  "",  "",  "",  "",  "",
			  "便","勉","娩","弁","鞭",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "保","舗","鋪","圃","捕",  "訪","豊","邦","鋒","飽", // ほ
			  "歩","甫","補","輔","穂",  "鳳","鵬","乏","亡","傍",
			  "募","墓","慕","戊","暮",  "剖","坊","妨","帽","忘",
			  "母","簿","菩","倣","俸",  "忙","房","暴","望","某",
			  "包","呆","報","奉","宝",  "棒","冒","紡","肪","膨",
			  "峰","峯","崩","庖","抱",  "謀","貌","貿","鉾","防",
			  "捧","放","方","朋","法",  "吠","頬","北","僕","卜",
			  "泡","烹","砲","縫","胞",  "墨","撲","朴","牧","睦",
			  "芳","萌","蓬","蜂","褒",  "穆","釦","勃","続き","決定"],
			[ "没","殆","堀","幌","奔",  "",  "",  "",  "",  "",
			  "本","翻","凡","盆","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "摩","磨","魔","麻","埋",  "",  "",  "",  "",  "",   // ま
			  "妹","昧","枚","毎","哩",  "",  "",  "",  "",  "",
			  "槙","幕","膜","枕","鮪",  "",  "",  "",  "",  "",
			  "柾","鱒","桝","亦","俣",  "",  "",  "",  "",  "",
			  "又","抹","末","沫","迄",  "",  "",  "",  "",  "",
			  "侭","繭","麿","万","慢",  "",  "",  "",  "",  "",
			  "満","漫","蔓","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "味","未","魅","巳","箕",  "",  "",  "",  "",  "",   // み
			  "岬","密","蜜","湊","蓑",  "",  "",  "",  "",  "",
			  "稔","脈","妙","粍","民",  "",  "",  "",  "",  "",
			  "眠","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "務","夢","無","牟","矛",  "",  "",  "",  "",  "",   // む
			  "霧","鵡","椋","婿","娘",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "冥","名","命","明","盟",  "",  "",  "",  "",  "",   // め
			  "迷","銘","鳴","姪","牝",  "",  "",  "",  "",  "",
			  "滅","免","棉","綿","緬",  "",  "",  "",  "",  "",
			  "面","麺","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "摸","模","茂","妄","孟",  "",  "",  "",  "",  "",   // も
			  "毛","猛","盲","網","耗",  "",  "",  "",  "",  "",
			  "蒙","儲","木","黙","目",  "",  "",  "",  "",  "",
			  "杢","勿","餅","尤","戻",  "",  "",  "",  "",  "",
			  "籾","貰","問","悶","紋",  "",  "",  "",  "",  "",
			  "門","匁","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "也","冶","夜","爺","耶",  "",  "",  "",  "",  "",   // や
			  "野","弥","矢","厄","役",  "",  "",  "",  "",  "",
			  "約","薬","訳","躍","靖",  "",  "",  "",  "",  "",
			  "柳","薮","鑓","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "愉","愈","油","癒","諭",  "",  "",  "",  "",  "",   // ゆ
			  "輸","唯","佑","優","勇",  "",  "",  "",  "",  "",
			  "友","宥","幽","悠","憂",  "",  "",  "",  "",  "",
			  "揖","有","柚","湧","涌",  "",  "",  "",  "",  "",
			  "猶","猷","由","祐","裕",  "",  "",  "",  "",  "",
			  "誘","遊","邑","郵","雄",  "",  "",  "",  "",  "",
			  "融","夕","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "予","余","与","誉","輿",  "",  "",  "",  "",  "",   // よ
			  "預","傭","幼","妖","容",  "",  "",  "",  "",  "",
			  "庸","揚","揺","擁","曜",  "",  "",  "",  "",  "",
			  "楊","様","洋","溶","熔",  "",  "",  "",  "",  "",
			  "用","窯","羊","耀","葉",  "",  "",  "",  "",  "",
			  "蓉","要","謡","踊","遥",  "",  "",  "",  "",  "",
			  "陽","養","慾","抑","欲",  "",  "",  "",  "",  "",
			  "沃","浴","翌","翼","淀",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "羅","螺","裸","来","莱",  "",  "",  "",  "",  "",   // ら
			  "頼","雷","洛","絡","落",  "",  "",  "",  "",  "",
			  "酪","乱","卵","嵐","欄",  "",  "",  "",  "",  "",
			  "濫","藍","蘭","覧","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "利","吏","履","李","梨",  "稜","糧","良","諒","遼", // り
			  "理","璃","痢","裏","裡",  "量","陵","領","力","緑",
			  "里","離","陸","律","率",  "倫","厘","林","淋","燐",
			  "立","葎","掠","略","劉",  "琳","臨","輪","隣","鱗",
			  "流","溜","琉","留","硫",  "麟","",  "",  "",  "",
			  "粒","隆","竜","龍","侶",  "",  "",  "",  "",  "",
			  "慮","旅","虜","了","亮",  "",  "",  "",  "",  "",
			  "僚","両","凌","寮","料",  "",  "",  "",  "",  "",
			  "梁","涼","猟","療","瞭",  "",  "",  "",  "戻る","決定"],
			[ "瑠","塁","涙","累","類",  "",  "",  "",  "",  "",   // る
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "令","伶","例","冷","励",  "",  "",  "",  "",  "",   // れ
			  "嶺","怜","玲","礼","苓",  "",  "",  "",  "",  "",
			  "鈴","隷","零","霊","麗",  "",  "",  "",  "",  "",
			  "齢","暦","歴","列","劣",  "",  "",  "",  "",  "",
			  "烈","裂","廉","恋","憐",  "",  "",  "",  "",  "",
			  "漣","煉","簾","練","聯",  "",  "",  "",  "",  "",
			  "蓮","連","錬","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "呂","魯","櫓","炉","賂",  "",  "",  "",  "",  "",   // ろ
			  "路","露","労","婁","廊",  "",  "",  "",  "",  "",
			  "弄","朗","楼","榔","浪",  "",  "",  "",  "",  "",
			  "漏","牢","狼","篭","老",  "",  "",  "",  "",  "",
			  "聾","蝋","郎","六","麓",  "",  "",  "",  "",  "",
			  "禄","肋","録","論","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "倭","和","話","歪","賄",  "",  "",  "",  "",  "",   // わ
			  "脇","惑","枠","鷲","亙",  "",  "",  "",  "",  "",
			  "亘","鰐","詫","藁","蕨",  "",  "",  "",  "",  "",
			  "椀","湾","碗","腕","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
		];
	Window_NameInput.JAPAN_KANJI_LEVEL2 =
		[
			[ "弌","丐","丕","个","丱",  "",  "",  "",  "",  "",   // 部首画数1
			  "丶","丼","丿","乂","乖",  "",  "",  "",  "",  "",
			  "乘","亂","亅","豫","亊",  "",  "",  "",  "",  "",
			  "舒","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "弍","于","亞","亟","亠",  "俐","俤","俥","倚","倨", // 部首画数2
			  "亢","亰","亳","亶","从",  "倔","倪","倥","倅","伜",
			  "仍","仄","仆","仂","仗",  "俶","倡","倩","倬","俾",
			  "仞","仭","仟","价","伉",  "俯","們","倆","偃","假",
			  "佚","估","佛","佝","佗",  "會","偕","偐","偈","做",
			  "佇","佶","侈","侏","侘",  "偖","偬","偸","傀","傚",
			  "佻","佩","佰","侑","佯",  "傅","傴","傲","僉","僊",
			  "來","侖","儘","俔","俟",  "傳","僂","僖","僞","僥",
			  "俎","俘","俛","俑","俚",  "僭","僣","僮","続き","決定"],
			[ "價","僵","儉","儁","儂",  "冽","凅","凉","凛","几",
			  "儖","儕","儔","儚","儡",  "處","凩","凭","凰","凵",
			  "儺","儷","儼","儻","儿",  "凾","刄","刋","刔","刎",
			  "兀","兒","兌","兔","兢",  "刧","刪","刮","刳","刹",
			  "竸","兩","兪","兮","冀",  "剏","剄","剋","剌","剞",
			  "冂","囘","册","冉","冏",  "剔","剪","剴","剩","剳",
			  "冑","冓","冕","冖","冤",  "剿","剽","劍","劔","劒",
			  "冦","冢","冩","冪","冫",  "剱","劈","劑","辨","辧",
			  "决","冱","冲","冰","况",  "劬","劭","劼","続き","決定"],
			[ "劵","勁","勍","勗","勞",  "厰","厶","參","簒","雙",
			  "勣","勦","飭","勠","勳",  "叟","曼","燮","",  "",
			  "勵","勸","勹","匆","匈",  "",  "",  "",  "",  "",
			  "甸","匍","匐","匏","匕",  "",  "",  "",  "",  "",
			  "匚","匣","匯","匱","匳",  "",  "",  "",  "",  "",
			  "匸","區","卆","卅","丗",  "",  "",  "",  "",  "",
			  "卉","卍","凖","卞","卩",  "",  "",  "",  "",  "",
			  "卮","夘","卻","卷","厂",  "",  "",  "",  "",  "",
			  "厖","厠","厦","厥","厮",  "",  "",  "",  "戻る","決定"],
			[ "叮","叨","叭","叺","吁",  "唏","唔","哽","哮","哭", // 部首画数3 A
			  "吽","呀","听","吭","吼",  "哺","哢","唹","啀","啣",
			  "吮","吶","吩","吝","呎",  "啌","售","啜","啅","啖",
			  "咏","呵","咎","呟","呱",  "啗","唸","唳","啝","喙",
			  "呷","呰","咒","呻","咀",  "喀","咯","喊","喟","啻",
			  "呶","咄","咐","咆","哇",  "啾","喘","喞","單","啼",
			  "咢","咸","咥","咬","哄",  "喃","喩","喇","喨","嗚",
			  "哈","咨","咫","哂","咤",  "嗅","嗟","嗄","嗜","嗤",
			  "咾","咼","哘","哥","哦",  "嗔","嘔","嗷","続き","決定"],
			[ "嘖","嗾","嗽","嘛","嗹",  "圍","圓","團","圖","嗇",
			  "噎","噐","營","嘴","嘶",  "圜","圦","圷","圸","坎",
			  "嘲","嘸","噫","噤","嘯",  "圻","址","坏","坩","埀",
			  "噬","噪","嚆","嚀","嚊",  "垈","坡","坿","垉","垓",
			  "嚠","嚔","嚏","嚥","嚮",  "垠","垳","垤","垪","垰",
			  "嚶","嚴","囂","嚼","囁",  "埃","埆","埔","埒","埓",
			  "囃","囀","囈","囎","囑",  "堊","埖","埣","堋","堙",
			  "囓","囗","囮","囹","圀",  "堝","塲","堡","塢","塋",
			  "囿","圄","圉","圈","國",  "塰","毀","塒","続き","決定"],
			[ "堽","塹","墅","墹","墟",  "奠","奧","奬","奩","",
			  "墫","墺","壞","墻","墸",  "",  "",  "",  "",  "",
			  "墮","壅","壓","壑","壗",  "",  "",  "",  "",  "",
			  "壙","壘","壥","壜","壤",  "",  "",  "",  "",  "",
			  "壟","壯","壺","壹","壻",  "",  "",  "",  "",  "",
			  "壼","壽","夂","夊","夐",  "",  "",  "",  "",  "",
			  "夛","梦","夥","夬","夭",  "",  "",  "",  "",  "",
			  "夲","夸","夾","竒","奕",  "",  "",  "",  "",  "",
			  "奐","奎","奚","奘","奢",  "",  "",  "",  "戻る","決定"],
			[ "奸","妁","妝","佞","侫",  "嬶","嬾","孃","孅","孀", // 部首画数3 B
			  "妣","妲","姆","姨","姜",  "孑","孕","孚","孛","孥",
			  "妍","姙","姚","娥","娟",  "孩","孰","孳","孵","學",
			  "娑","娜","娉","娚","婀",  "斈","孺","宀","它","宦",
			  "婬","婉","娵","娶","婢",  "宸","寃","寇","寉","寔",
			  "婪","媚","媼","媾","嫋",  "寐","寤","實","寢","寞",
			  "嫂","媽","嫣","嫗","嫦",  "寥","寫","寰","寶","寳",
			  "嫩","嫖","嫺","嫻","嬌",  "尅","將","專","對","尓",
			  "嬋","嬖","嬲","嫐","嬪",  "尠","尢","尨","続き","決定"],
			[ "尸","尹","屁","屆","屎",  "嵌","嵒","嵎","嵋","嵬",
			  "屓","屐","屏","孱","屬",  "嵳","嵶","嶇","嶄","嶂",
			  "屮","乢","屶","屹","岌",  "嶢","嶝","嶬","嶮","嶽",
			  "岑","岔","妛","岫","岻",  "嶐","嶷","嶼","巉","巍",
			  "岶","岼","岷","峅","岾",  "巓","巒","巖","巛","巫",
			  "峇","峙","峩","峽","峺",  "已","巵","帋","帚","帙",
			  "峭","嶌","峪","崋","崕",  "帑","帛","帶","帷","幄",
			  "崗","嵜","崟","崛","崑",  "幃","幀","幎","幗","幔",
			  "崔","崢","崚","崙","崘",  "幟","幢","幤","続き","決定"],
			[ "幇","幵","并","幺","麼",  "彗","彙","彡","彭","彳",
			  "广","庠","廁","廂","廈",  "彷","徃","徂","彿","徊",
			  "廐","廏","廖","廣","廝",  "很","徑","徇","從","徙",
			  "廚","廛","廢","廡","廨",  "徘","徠","徨","徭","徼",
			  "廩","廬","廱","廳","廰",  "",  "",  "",  "",  "",
			  "廴","廸","廾","弃","弉",  "",  "",  "",  "",  "",
			  "彝","彜","弋","弑","弖",  "",  "",  "",  "",  "",
			  "弩","弭","弸","彁","彈",  "",  "",  "",  "",  "",
			  "彌","彎","弯","彑","彖",  "",  "",  "",  "戻る","決定"],
			[ "忖","忻","忤","忸","忱",  "悒","悧","悋","惡","悸", // 部首画数4 A
			  "忝","悳","忿","怡","恠",  "惠","惓","悴","忰","悽",
			  "怙","怐","怩","怎","怱",  "惆","悵","惘","慍","愕",
			  "怛","怕","怫","怦","怏",  "愆","惶","惷","愀","惴",
			  "怺","恚","恁","恪","恷",  "惺","愃","愡","惻","惱",
			  "恟","恊","恆","恍","恣",  "愍","愎","慇","愾","愨",
			  "恃","恤","恂","恬","恫",  "愧","慊","愿","愼","愬",
			  "恙","悁","悍","惧","悃",  "愴","愽","慂","慄","慳",
			  "悚","悄","悛","悖","悗",  "慷","慘","慙","続き","決定"],
			[ "慚","慫","慴","慯","慥",  "戔","戛","戞","戡","截",
			  "慱","慟","慝","慓","慵",  "戮","戰","戲","戳","扁",
			  "憙","憖","憇","憬","憔",  "扎","扞","扣","扛","扠",
			  "憚","憊","憑","憫","憮",  "扨","扼","抂","抉","找",
			  "懌","懊","應","懷","懈",  "抒","抓","抖","拔","抃",
			  "懃","懆","憺","懋","罹",  "抔","拗","拑","抻","拏",
			  "懍","懦","懣","懶","懺",  "拿","拆","擔","拈","拜",
			  "懴","懿","懽","懼","懾",  "拌","拊","拂","拇","抛",
			  "戀","戈","戉","戍","戌",  "拉","挌","拮","続き","決定"],
			[ "拱","挧","挂","挈","拯",  "摎","攪","撕","撓","撥",
			  "拵","捐","挾","捍","搜",  "撩","撈","撼","據","擒",
			  "捏","掖","掎","掀","掫",  "擅","擇","撻","擘","擂",
			  "捶","掣","掏","掉","掟",  "擱","擧","舉","擠","擡",
			  "掵","捫","捩","掾","揩",  "抬","擣","擯","攬","擶",
			  "揀","揆","揣","揉","插",  "擴","擲","擺","攀","擽",
			  "揶","揄","搖","搴","搆",  "攘","攜","攅","攤","攣",
			  "搓","搦","搶","攝","搗",  "攫","攴","攵","攷","收",
			  "搨","搏","摧","摯","摶",  "攸","畋","效","続き","決定"],
			[ "敖","敕","敍","敘","敞",  "晢","晰","暃","暈","暎",
			  "敝","敲","數","斂","斃",  "暉","暄","暘","暝","曁",
			  "變","斛","斟","斫","斷",  "暹","曉","暾","暼","曄",
			  "旃","旆","旁","旄","旌",  "暸","曖","曚","曠","昿",
			  "旒","旛","旙","无","旡",  "曦","曩","曰","曵","曷",
			  "旱","杲","昊","昃","旻",  "朏","朖","朞","朦","朧",
			  "杳","昵","昶","昴","昜",  "霸","",  "",  "",  "",
			  "晏","晄","晉","晁","晞",  "",  "",  "",  "",  "",
			  "晝","晤","晧","晨","晟",  "",  "",  "",  "戻る","決定"],
			[ "朮","朿","朶","杁","朸",  "桎","梳","栫","桙","档", // 部首画数4 B
			  "朷","杆","杞","杠","杙",  "桷","桿","梟","梏","梭",
			  "杣","杤","枉","杰","枩",  "梔","條","梛","梃","檮",
			  "杼","杪","枌","枋","枦",  "梹","桴","梵","梠","梺",
			  "枡","枅","枷","柯","枴",  "椏","梍","桾","椁","棊",
			  "柬","枳","柩","枸","柤",  "椈","棘","椢","椦","棡",
			  "柞","柝","柢","柮","枹",  "椌","棍","棔","棧","棕",
			  "柎","柆","柧","檜","栞",  "椶","椒","椄","棗","棣",
			  "框","栩","桀","桍","栲",  "椥","棹","棠","続き","決定"],
			[ "棯","椨","椪","椚","椣",  "槞","槨","樂","樛","槿",
			  "椡","棆","楹","楷","楜",  "權","槹","槲","槧","樅",
			  "楸","楫","楔","楾","楮",  "榱","樞","槭","樔","槫",
			  "椹","楴","椽","楙","椰",  "樊","樒","櫁","樣","樓",
			  "楡","楞","楝","榁","楪",  "橄","樌","橲","樶","橸",
			  "榲","榮","槐","榿","槁",  "橇","橢","橙","橦","橈",
			  "槓","榾","槎","寨","槊",  "樸","樢","檐","檍","檠",
			  "槝","榻","槃","榧","樮",  "檄","檢","檣","檗","蘗",
			  "榑","榠","榜","榕","榴",  "檻","櫃","櫂","続き","決定"],
			[ "檸","檳","檬","櫞","櫑",  "",  "",  "",  "",  "",
			  "櫟","檪","櫚","櫪","櫻",  "",  "",  "",  "",  "",
			  "欅","蘖","櫺","欒","欖",  "",  "",  "",  "",  "",
			  "鬱","欟","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "欸","欷","盜","欹","飮",  "氛","氤","氣","汞","汕", // 部首画数4 C
			  "歇","歃","歉","歐","歙",  "汢","汪","沂","沍","沚",
			  "歔","歛","歟","歡","歸",  "沁","沛","汾","汨","汳",
			  "歹","歿","殀","殄","殃",  "沒","沐","泄","泱","泓",
			  "殍","殘","殕","殞","殤",  "沽","泗","泅","泝","沮",
			  "殪","殫","殯","殲","殱",  "沱","沾","沺","泛","泯",
			  "殳","殷","殼","毆","毋",  "泙","泪","洟","衍","洶",
			  "毓","毟","毬","毫","毳",  "洫","洽","洸","洙","洵",
			  "毯","麾","氈","氓","气",  "洳","洒","洌","続き","決定"],
			[ "浣","涓","浤","浚","浹",  "湎","渤","滿","渝","游",
			  "浙","涎","涕","濤","涅",  "溂","溪","溘","滉","溷",
			  "淹","渕","渊","涵","淇",  "滓","溽","溯","滄","溲",
			  "淦","涸","淆","淬","淞",  "滔","滕","溏","溥","滂",
			  "淌","淨","淒","淅","淺",  "溟","潁","漑","灌","滬",
			  "淙","淤","淕","淪","淮",  "滸","滾","漿","滲","漱",
			  "渭","湮","渮","渙","湲",  "滯","漲","滌","漾","漓",
			  "湟","渾","渣","湫","渫",  "滷","澆","潺","潸","澁",
			  "湶","湍","渟","湃","渺",  "澀","潯","潛","続き","決定"],
			[ "濳","潭","澂","潼","潘",  "烱","炬","炸","炳","炮",
			  "澎","澑","濂","潦","澳",  "烟","烋","烝","烙","焉",
			  "澣","澡","澤","澹","濆",  "烽","焜","焙","煥","煕",
			  "澪","濟","濕","濬","濔",  "熈","煦","煢","煌","煖",
			  "濘","濱","濮","濛","瀉",  "煬","熏","燻","熄","熕",
			  "瀋","濺","瀑","瀁","瀏",  "熨","熬","燗","熹","熾",
			  "濾","瀛","瀚","潴","瀝",  "燒","燉","燔","燎","燠",
			  "瀘","瀟","瀰","瀾","瀲",  "燬","燧","燵","燼","燹",
			  "灑","灣","炙","炒","炯",  "燿","爍","爐","続き","決定"],
			[ "爛","爨","爭","爬","爰",  "獎","獏","默","獗","獪",
			  "爲","爻","爼","爿","牀",  "獨","獰","獸","獵","獻",
			  "牆","牋","牘","牴","牾",  "獺","",  "",  "",  "",
			  "犂","犁","犇","犒","犖",  "",  "",  "",  "",  "",
			  "犢","犧","犹","犲","狃",  "",  "",  "",  "",  "",
			  "狆","狄","狎","狒","狢",  "",  "",  "",  "",  "",
			  "狠","狡","狹","狷","倏",  "",  "",  "",  "",  "",
			  "猗","猊","猜","猖","猝",  "",  "",  "",  "",  "",
			  "猴","猯","猩","猥","猾",  "",  "",  "",  "戻る","決定"],
			[ "珈","玳","珎","玻","珀",  "甃","甅","甌","甎","甍", // 部首画数5
			  "珥","珮","珞","璢","琅",  "甕","甓","甞","甦","甬",
			  "瑯","琥","珸","琲","琺",  "甼","畄","畍","畊","畉",
			  "瑕","琿","瑟","瑙","瑁",  "畛","畆","畚","畩","畤",
			  "瑜","瑩","瑰","瑣","瑪",  "畧","畫","畭","畸","當",
			  "瑶","瑾","璋","璞","璧",  "疆","疇","畴","疊","疉",
			  "瓊","瓏","瓔","珱","瓠",  "疂","疔","疚","疝","疥",
			  "瓣","瓧","瓩","瓮","瓲",  "疣","痂","疳","痃","疵",
			  "瓰","瓱","瓸","瓷","甄",  "疽","疸","疼","続き","決定"],
			[ "疱","痍","痊","痒","痙",  "皃","皈","皋","皎","皖",
			  "痣","痞","痾","痿","痼",  "皓","皙","皚","皰","皴",
			  "瘁","痰","痺","痲","痳",  "皸","皹","皺","盂","盍",
			  "瘋","瘍","瘉","瘟","瘧",  "盖","盒","盞","盡","盥",
			  "瘠","瘡","瘢","瘤","瘴",  "盧","盪","蘯","盻","眈",
			  "瘰","瘻","癇","癈","癆",  "眇","眄","眩","眤","眞",
			  "癜","癘","癡","癢","癨",  "眥","眦","眛","眷","眸",
			  "癩","癪","癧","癬","癰",  "睇","睚","睨","睫","睛",
			  "癲","癶","癸","發","皀",  "睥","睿","睾","続き","決定"],
			[ "睹","瞎","瞋","瞑","瞠",  "磬","磧","磚","磽","磴",
			  "瞞","瞰","瞶","瞹","瞿",  "礇","礒","礑","礙","礬",
			  "瞼","瞽","瞻","矇","矍",  "礫","祀","祠","祗","祟",
			  "矗","矚","矜","矣","矮",  "祚","祕","祓","祺","祿",
			  "矼","砌","砒","礦","砠",  "禊","禝","禧","齋","禪",
			  "礪","硅","碎","硴","碆",  "禮","禳","禹","禺","秉",
			  "硼","碚","碌","碣","碵",  "秕","秧","秬","秡","秣",
			  "碪","碯","磑","磆","磋",  "稈","稍","稘","稙","稠",
			  "磔","碾","碼","磅","磊",  "稟","禀","稱","続き","決定"],
			[ "稻","稾","稷","穃","穗",  "",  "",  "",  "",  "",
			  "穉","穡","穢","穩","龝",  "",  "",  "",  "",  "",
			  "穰","穹","穽","窈","窗",  "",  "",  "",  "",  "",
			  "窕","窘","窖","窩","竈",  "",  "",  "",  "",  "",
			  "窰","窶","竅","竄","窿",  "",  "",  "",  "",  "",
			  "邃","竇","竊","竍","竏",  "",  "",  "",  "",  "",
			  "竕","竓","站","竚","竝",  "",  "",  "",  "",  "",
			  "竡","竢","竦","竭","竰",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "笂","笏","笊","笆","笳",  "簑","簔","篦","篥","籠", // 部首画数6 A
			  "笘","笙","笞","笵","笨",  "簀","簇","簓","篳","篷",
			  "笶","筐","筺","笄","筍",  "簗","簍","篶","簣","簧",
			  "笋","筌","筅","筵","筥",  "簪","簟","簷","簫","簽",
			  "筴","筧","筰","筱","筬",  "籌","籃","籔","籏","籀",
			  "筮","箝","箘","箟","箍",  "籐","籘","籟","籤","籖",
			  "箜","箚","箋","箒","箏",  "籥","籬","籵","粃","粐",
			  "筝","箙","篋","篁","篌",  "粤","粭","粢","粫","粡",
			  "篏","箴","篆","篝","篩",  "粨","粳","粲","続き","決定"],
			[ "粱","粮","粹","粽","糀",  "綣","綵","緇","綽","綫",
			  "糅","糂","糘","糒","糜",  "總","綢","綯","緜","綸",
			  "糢","鬻","糯","糲","糴",  "綟","綰","緘","緝","緤",
			  "糶","糺","紆","紂","紜",  "緞","緻","緲","緡","縅",
			  "紕","紊","絅","絋","紮",  "縊","縣","縡","縒","縱",
			  "紲","紿","紵","絆","絳",  "縟","縉","縋","縢","繆",
			  "絖","絎","絲","絨","絮",  "繦","縻","縵","縹","繃",
			  "絏","絣","經","綉","絛",  "縷","縲","縺","繧","繝",
			  "綏","絽","綛","綺","綮",  "繖","繞","繙","続き","決定"],
			[ "繚","繹","繪","繩","繼",  "羔","羞","羝","羚","羣",
			  "繻","纃","緕","繽","辮",  "羯","羲","羹","羮","羶",
			  "繿","纈","纉","續","纒",  "羸","譱","翅","翆","翊",
			  "纐","纓","纔","纖","纎",  "翕","翔","翡","翦","翩",
			  "纛","纜","缸","缺","罅",  "翳","翹","飜","耆","耄",
			  "罌","罍","罎","罐","网",  "耋","耒","耘","耙","耜",
			  "罕","罔","罘","罟","罠",  "耡","耨","耿","耻","聊",
			  "罨","罩","罧","罸","羂",  "聆","聒","聘","聚","聟",
			  "羆","羃","羈","羇","羌",  "聢","聨","聳","続き","決定"],
			[ "聲","聰","聶","聹","聽",  "膂","膠","膕","膤","膣",
			  "聿","肄","肆","肅","肛",  "腟","膓","膩","膰","膵",
			  "肓","肚","肭","冐","肬",  "膾","膸","膽","臀","臂",
			  "胛","胥","胙","胝","胄",  "膺","臉","臍","臑","臙",
			  "胚","胖","脉","胯","胱",  "臘","臈","臚","臟","臠",
			  "脛","脩","脣","脯","腋",  "臧","臺","臻","臾","舁",
			  "隋","腆","脾","腓","腑",  "舂","舅","與","舊","舍",
			  "胼","腱","腮","腥","腦",  "舐","舖","",  "",  "",
			  "腴","膃","膈","膊","膀",  "",  "",  "",  "戻る","決定"],
			[ "舩","舫","舸","舳","艀",  "茲","茱","荀","茹","荐", // 部首画数6 B
			  "艙","艘","艝","艚","艟",  "荅","茯","茫","茗","茘",
			  "艤","艢","艨","艪","艫",  "莅","莚","莪","莟","莢",
			  "舮","艱","艷","艸","艾",  "莖","茣","莎","莇","莊",
			  "芍","芒","芫","芟","芻",  "荼","莵","荳","荵","莠",
			  "芬","苡","苣","苟","苒",  "莉","莨","菴","萓","菫",
			  "苴","苳","苺","莓","范",  "菎","菽","萃","菘","萋",
			  "苻","苹","苞","茆","苜",  "菁","菷","萇","菠","菲",
			  "茉","苙","茵","茴","茖",  "萍","萢","萠","続き","決定"],
			[ "莽","萸","蔆","菻","葭",  "蕣","蕘","蕈","蕁","蘂",
			  "萪","萼","蕚","蒄","葷",  "蕋","蕕","薀","薤","薈",
			  "葫","蒭","葮","蒂","葩",  "薑","薊","薨","蕭","薔",
			  "葆","萬","葯","葹","萵",  "薛","藪","薇","薜","蕷",
			  "蓊","葢","蒹","蒿","蒟",  "蕾","薐","藉","薺","藏",
			  "蓙","蓍","蒻","蓚","蓐",  "薹","藐","藕","藝","藥",
			  "蓁","蓆","蓖","蒡","蔡",  "藜","藹","蘊","蘓","蘋",
			  "蓿","蓴","蔗","蔘","蔬",  "藾","藺","蘆","蘢","蘚",
			  "蔟","蔕","蔔","蓼","蕀",  "蘰","蘿","虍","続き","決定"],
			[ "乕","虔","號","虧","虱",  "蝟","蝸","蝌","蝎","蝴",
			  "蚓","蚣","蚩","蚪","蚋",  "蝗","蝨","蝮","蝙","蝓",
			  "蚌","蚶","蚯","蛄","蛆",  "蝣","蝪","蠅","螢","螟",
			  "蚰","蛉","蠣","蚫","蛔",  "螂","螯","蟋","螽","蟀",
			  "蛞","蛩","蛬","蛟","蛛",  "蟐","雖","螫","蟄","螳",
			  "蛯","蜒","蜆","蜈","蜀",  "蟇","蟆","螻","蟯","蟲",
			  "蜃","蛻","蜑","蜉","蜍",  "蟠","蠏","蠍","蟾","蟶",
			  "蛹","蜊","蜴","蜿","蜷",  "蟷","蠎","蟒","蠑","蠖",
			  "蜻","蜥","蜩","蜚","蝠",  "蠕","蠢","蠡","続き","決定"],
			[ "蠱","蠶","蠹","蠧","蠻",  "褓","襃","褞","褥","褪",
			  "衄","衂","衒","衙","衞",  "褫","襁","襄","褻","褶",
			  "衢","衫","袁","衾","袞",  "褸","襌","褝","襠","襞",
			  "衵","衽","袵","衲","袂",  "襦","襤","襭","襪","襯",
			  "袗","袒","袮","袙","袢",  "襴","襷","襾","覃","覈",
			  "袍","袤","袰","袿","袱",  "覊","",  "",  "",  "",  
			  "裃","裄","裔","裘","裙",  "",  "",  "",  "",  "",  
			  "裝","裹","褂","裼","裴",  "",  "",  "",  "",  "",  
			  "裨","裲","褄","褌","褊",  "",  "",  "",  "戻る","決定"],
			[ "覓","覘","覡","覩","覦",  "諄","諍","諂","諚","諫", // 部首画数7
			  "覬","覯","覲","覺","覽",  "諳","諧","諤","諱","謔",
			  "覿","觀","觚","觜","觝",  "諠","諢","諷","諞","諛",
			  "觧","觴","觸","訃","訖",  "謌","謇","謚","諡","謖",
			  "訐","訌","訛","訝","訥",  "謐","謗","謠","謳","鞫",
			  "訶","詁","詛","詒","詆",  "謦","謫","謾","謨","譁",
			  "詈","詼","詭","詬","詢",  "譌","譏","譎","證","譖",
			  "誅","誂","誄","誨","誡",  "譛","譚","譫","譟","譬",
			  "誑","誥","誦","誚","誣",  "譯","譴","譽","続き","決定"],
			[ "讀","讌","讎","讒","讓",  "贄","贅","贊","贇","贏",
			  "讖","讙","讚","谺","豁",  "贍","贐","齎","贓","賍",
			  "谿","豈","豌","豎","豐",  "贔","贖","赧","赭","赱",
			  "豕","豢","豬","豸","豺",  "赳","趁","趙","跂","趾",
			  "貂","貉","貅","貊","貍",  "趺","跏","跚","跖","跌",
			  "貎","貔","豼","貘","戝",  "跛","跋","跪","跫","跟",
			  "貭","貪","貽","貲","貳",  "跣","跼","踈","踉","跿",
			  "貮","貶","賈","賁","賤",  "踝","踞","踐","踟","蹂",
			  "賣","賚","賽","賺","賻",  "踵","踰","踴","続き","決定"],
			[ "蹊","蹇","蹉","蹌","蹐",  "輙","輓","輜","輟","輛",
			  "蹈","蹙","蹤","蹠","踪",  "輌","輦","輳","輻","輹",
			  "蹣","蹕","蹶","蹲","蹼",  "轅","轂","輾","轌","轉",
			  "躁","躇","躅","躄","躋",  "轆","轎","轗","轜","轢",
			  "躊","躓","躑","躔","躙",  "轣","轤","辜","辟","辣",
			  "躪","躡","躬","躰","軆",  "辭","辯","辷","迚","迥",
			  "躱","躾","軅","軈","軋",  "迢","迪","迯","邇","迴",
			  "軛","軣","軼","軻","軫",  "逅","迹","迺","逑","逕",
			  "軾","輊","輅","輕","輒",  "逡","逍","逞","続き","決定"],
			[ "逖","逋","逧","逶","逵",  "酣","酥","酩","酳","酲",
			  "逹","迸","遏","遐","遑",  "醋","醉","醂","醢","醫",
			  "遒","逎","遉","逾","遖",  "醯","醪","醵","醴","醺",
			  "遘","遞","遨","遯","遶",  "釀","釁","釉","釋","釐",
			  "隨","遲","邂","遽","邁",  "",  "",  "",  "",  "",
			  "邀","邊","邉","邏","邨",  "",  "",  "",  "",  "",
			  "邯","邱","邵","郢","郤",  "",  "",  "",  "",  "",
			  "扈","郛","鄂","鄒","鄙",  "",  "",  "",  "",  "",
			  "鄲","鄰","酊","酖","酘",  "",  "",  "",  "戻る","決定"],
			[ "釖","釟","釡","釛","釼",  "鍼","鍮","鍖","鎰","鎬", // 部首画数8
			  "釵","釶","鈞","釿","鈔",  "鎭","鎔","鎹","鏖","鏗",
			  "鈬","鈕","鈑","鉞","鉗",  "鏨","鏥","鏘","鏃","鏝",
			  "鉅","鉉","鉤","鉈","銕",  "鏐","鏈","鏤","鐚","鐔",
			  "鈿","鉋","鉐","銜","銖",  "鐓","鐃","鐇","鐐","鐶",
			  "銓","銛","鉚","鋏","銹",  "鐫","鐵","鐡","鐺","鑁",
			  "銷","鋩","錏","鋺","鍄",  "鑒","鑄","鑛","鑠","鑢",
			  "錮","錙","錢","錚","錣",  "鑞","鑪","鈩","鑰","鑵",
			  "錺","錵","錻","鍜","鍠",  "鑷","鑽","鑚","続き","決定"],
			[ "鑼","鑾","钁","鑿","閂",  "陲","陬","隍","隘","隕",
			  "閇","閊","閔","閖","閘",  "隗","險","隧","隱","隲",
			  "閙","閠","閨","閧","閭",  "隰","隴","隶","隸","隹",
			  "閼","閻","閹","閾","闊",  "雎","雋","雉","雍","襍",
			  "濶","闃","闍","闌","闕",  "雜","霍","雕","雹","霄",
			  "闔","闖","關","闡","闥",  "霆","霈","霓","霎","霑",
			  "闢","阡","阨","阮","阯",  "霏","霖","霙","霤","霪",
			  "陂","陌","陏","陋","陷",  "霰","霹","霽","霾","靄",
			  "陜","陞","陝","陟","陦",  "靆","靈","靂","続き","決定"],
			[ "靉","靜","靠","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "靤","靦","靨","勒","靫",  "顱","顴","顳","颪","颯", // 部首画数9
			  "靱","靹","鞅","靼","鞁",  "颱","颶","飄","飃","飆",
			  "靺","鞆","鞋","鞏","鞐",  "飩","飫","餃","餉","餒",
			  "鞜","鞨","鞦","鞣","鞳",  "餔","餘","餡","餝","餞",
			  "鞴","韃","韆","韈","韋",  "餤","餠","餬","餮","餽",
			  "韜","韭","齏","韲","竟",  "餾","饂","饉","饅","饐",
			  "韶","韵","頏","頌","頸",  "饋","饑","饒","饌","饕",
			  "頤","頡","頷","頽","顆",  "馗","馘","馥","",  "",
			  "顏","顋","顫","顯","顰",  "",  "",  "",  "戻る","決定"],
			[ "馭","馮","馼","駟","駛",  "髞","髟","髢","髣","髦", // 部首画数10
			  "駝","駘","駑","駭","駮",  "髯","髫","髮","髴","髱",
			  "駱","駲","駻","駸","騁",  "髷","髻","鬆","鬘","鬚",
			  "騏","騅","駢","騙","騫",  "鬟","鬢","鬣","鬥","鬧",
			  "騷","驅","驂","驀","驃",  "鬨","鬩","鬪","鬮","鬯",
			  "騾","驕","驍","驛","驗",  "鬲","魄","魃","魏","魍",
			  "驟","驢","驥","驤","驩",  "魎","魑","魘","",  "",
			  "驫","驪","骭","骰","骼",  "",  "",  "",  "",  "",
			  "髀","髏","髑","髓","體",  "",  "",  "",  "戻る","決定"],
			[ "魴","鮓","鮃","鮑","鮖",  "鰾","鱚","鱠","鱧","鱶", // 部首画数11
			  "鮗","鮟","鮠","鮨","鮴",  "鱸","鳧","鳬","鳰","鴉",
			  "鯀","鯊","鮹","鯆","鯏",  "鴈","鳫","鴃","鴆","鴪",
			  "鯑","鯒","鯣","鯢","鯤",  "鴦","鶯","鴣","鴟","鵄",
			  "鯔","鯡","鰺","鯲","鯱",  "鴕","鴒","鵁","鴿","鴾",
			  "鯰","鰕","鰔","鰉","鰓",  "鵆","鵈","鵝","鵞","鵤",
			  "鰌","鰆","鰈","鰒","鰊",  "鵑","鵐","鵙","鵲","鶉",
			  "鰄","鰮","鰛","鰥","鰤",  "鶇","鶫","鵯","鵺","鶚",
			  "鰡","鰰","鱇","鰲","鱆",  "鶤","鶩","鶲","続き","決定"],
			[ "鷄","鷁","鶻","鶸","鶺",  "",  "",  "",  "",  "",
			  "鷆","鷏","鷂","鷙","鷓",  "",  "",  "",  "",  "",
			  "鷸","鷦","鷭","鷯","鷽",  "",  "",  "",  "",  "",
			  "鸚","鸛","鸞","鹵","鹹",  "",  "",  "",  "",  "",
			  "鹽","麁","麈","麋","麌",  "",  "",  "",  "",  "",
			  "麒","麕","麑","麝","麥",  "",  "",  "",  "",  "",
			  "麩","麸","麪","麭","靡",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "黌","黎","黏","黐","黔",  "",  "",  "",  "",  "",   // 部首画数12
			  "黜","點","黝","黠","黥",  "",  "",  "",  "",  "",
			  "黨","黯","黴","黶","黷",  "",  "",  "",  "",  "",
			  "黹","黻","黼","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "黽","鼇","鼈","皷","鼕",  "",  "",  "",  "",  "",   // 部首画数13
			  "鼡","鼬","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "鼾","齊","",  "",  "",    "",  "",  "",  "",  "",   // 部首画数14
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "齒","齔","齣","齟","齠",  "",  "",  "",  "",  "",   // 部首画数15
			  "齡","齦","齧","齬","齪",  "",  "",  "",  "",  "",
			  "齷","齲","齶","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "龕","龜","",  "",  "",    "",  "",  "",  "",  "",   // 部首画数16
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "龠","",  "",  "",  "",    "",  "",  "",  "",  "",   // 部首画数17
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
			[ "堯","槇","遙","瑤","凜",  "",  "",  "",  "",  "",   // 84区
			  "熙","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "戻る","決定"],
		];

	/* 한국어 문자판 */
	Window_NameInput.KOREAN2 = [...Window_NameInput.LATIN1]
	Window_NameInput.KOREAN2[88] = "분음";
	Window_NameInput.KOREAN2[89] = "결정";
	Window_NameInput.KOREAN3 = [...Window_NameInput.LATIN2]
	Window_NameInput.KOREAN3[88] = "한글";
	Window_NameInput.KOREAN3[89] = "결정";
	Window_NameInput.KOREAN1 =
		[ "ㄱ","ㄴ","ㄷ","ㄹ","ㅁ",  "ㄲ","ㄸ","ㅃ","ㅆ","ㅉ",
		  "ㅂ","ㅅ","ㅇ","ㅈ","ㅿ",  "ㅱ","ㅸ","ㅹ","ㆁ","ㆄ",
		  "ㅊ","ㅋ","ㅌ","ㅍ","ㅎ",  "ㅐ","ㅒ","ㅔ","ㅖ","ㆉ",
		  "ㅏ","ㅑ","ㅓ","ㅕ","ㅗ",  "ㅘ","ㅙ","ㅚ","ㆍ","ㆎ",
		  "ㅛ","ㅜ","ㅠ","ㅡ","ㅣ",  "ㅝ","ㅞ","ㅟ","ㅢ","ㆌ",
		  "ㄱ","ㄴ","ㄷ","ㄹ","ㅁ",  "ㄲ","ㄳ","ㄵ","ㄶ","ㅥ",
		  "ㅂ","ㅅ","ㅇ","ㅈ","ㆆ",  "ㄺ","ㄻ","ㄼ","ㄽ","ㄾ",
		  "ㅊ","ㅋ","ㅌ","ㅍ","ㅎ",  "ㄿ","ㅀ","ㅄ","ㅆ","♥",
		  "-","∼","·","=","☆",  "ㆀ", "ㆅ", " ", "영자","결정"];

	/* 中文 */
	Window_NameInput.CHINESE_PINYIN =
		[ "Ā","Ē","Ī","Ō","Ū",  "ā","ē","ī","ō","ū",
		  "Á","É","Í","Ó","Ú",  "á","é","í","ó","ú",
		  "Ǎ","Ě","Ǐ","Ǒ","Ǔ",  "ǎ","ě","ǐ","ǒ","ǔ",
		  "À","Ě","Ì","Ò","Ù",  "à","è","ì","ò","ù",
		  "Ü","Ǖ","Ǘ","Ǚ","Ǜ",  "ü","ǖ","ǘ","ǚ","ǜ",
		  "b","d","g","j","z",  "a","e","i","o","u",
		  "p","t","k","q","c",  "Ŋ","Ê","Ẑ","Ĉ","Ŝ",
		  "m","n","h","x","s",  "ŋ","ê","ẑ","ĉ","ŝ",
		  "f","l","y","w","r",  "ɑ","ɡ"," ","Page","OK" ];

	/* 繁體中文 */
	Window_NameInput.CHINESE_TRADITIONAL_LATIN1 = [...Window_NameInput.LATIN1]
	Window_NameInput.CHINESE_TRADITIONAL_LATIN1[88] = "讀音";
	Window_NameInput.CHINESE_TRADITIONAL_LATIN1[89] = "決定";
	Window_NameInput.CHINESE_TRADITIONAL_LATIN2 = [...Window_NameInput.LATIN2]
	Window_NameInput.CHINESE_TRADITIONAL_LATIN2[88] = "拼音";
	Window_NameInput.CHINESE_TRADITIONAL_LATIN2[89] = "決定";
	Window_NameInput.CHINESE_TRADITIONAL_LATIN3 = [...Window_NameInput.CHINESE_PINYIN]
	Window_NameInput.CHINESE_TRADITIONAL_LATIN3[88] = "漢字";
	Window_NameInput.CHINESE_TRADITIONAL_LATIN3[89] = "決定";
	Window_NameInput.CHINESE_TRADITIONAL_HANZI_INDEX =
		[ "ㄅ","ㄆ","ㄇ","ㄈ","",    "1劃", "2劃", "3劃", "4劃", "5劃",
		  "ㄉ","ㄊ","ㄋ","ㄌ","",    "6劃", "7劃", "8劃", "9劃", "10劃",
		  "ㄍ","ㄎ","ㄏ","",  "",    "11劃","12劃","13劃","14劃","15劃",
		  "ㄐ","ㄑ","ㄒ","",  "",    "16劃","17劃","18劃","19劃","20劃",
		  "ㄓ","ㄔ","ㄕ","ㄖ","",    "21劃","22劃","23劃","24劃","25劃",
		  "ㄗ","ㄘ","ㄙ","",  "",    "26劃","27劃","28劃","29劃","30劃",
		  "ㄚ","ㄛ","ㄜ","ㄝ","",    "",  "32劃",  "",  "",  "",
		  "ㄞ","ㄟ","ㄠ","ㄡ","",    "",  "",  "",  "",  "",
		  "ㄢ","ㄣ","ㄤ","ㄥ","ㄦ",  "ㄧ","ㄨ","ㄩ","羅馬字","決定"];
	Window_NameInput.CHINESE_TRADITIONAL_INDEX =
		[    4,   7,  10,  13,   3,    87,  88,  89,  90,  92,
		    15,  19,  22,  24,   3,    94,  97, 101, 106, 111,
		    29,  32,  34,   3,   3,   117, 123, 129, 134, 139,
		    37,  42,  45,   3,   3,   144, 148, 151, 153, 155,
		    49,  53,  56,  59,   3,   157, 158, 159, 160, 161,
		    60,  62,  64,   3,   3,   162, 163, 164, 165, 166,
		    66,  67,  68,  69,   3,     3, 167,   3,   3,   3,
		    70,  71,  72,  73,   3,     3,   3,   3,   3,   3,
		    74,  75,  76,  77,  78,    79,  83,  85,   3,   3 ];
	Window_NameInput.CHINESE_TRADITIONAL_ZHUYIN_INDEX =
		[
			[ "八","巴","叭","扒","吧",  "簸","擘","檗","蘗","卜", // ㄅ
			  "芭","疤","捌","笆","拔",  "擘","白","百","佰","柏",
			  "跋","把","靶","爸","耙",  "擺","襬","拜","敗","卑",
			  "罷","霸","壩","灞","吧",  "杯","陂","盃","悲","揹",
			  "波","玻","剝","缽","菠",  "碑","北","孛","貝","邶",
			  "撥","播","伯","帛","勃",  "背","倍","悖","狽","被",
			  "柏","亳","脖","舶","博",  "備","焙","蓓","輩","鋇",
			  "渤","搏","鈸","鉑","箔",  "憊","包","胞","苞","褒",
			  "膊","駁","蔔","薄","跛",  "雹","薄","保","下一頁","決定"],
			[ "堡","葆","飽","褓","寶",  "蚌","傍","棒","磅","謗",
			  "抱","豹","報","鉋","暴",  "鎊","崩","繃","甭","繃",
			  "鮑","爆","鑤","扳","班",  "泵","迸","蹦","逼","荸",
			  "般","斑","搬","頒","瘢",  "鼻","匕","比","妣","沘",
			  "阪","板","版","舨","鈑",  "彼","俾","筆","箄","鄙",
			  "闆","半","伴","扮","姅",  "必","庇","俾","陛","婢",
			  "拌","絆","辦","瓣","奔",  "敝","畢","閉","弼","愎",
			  "本","苯","畚","笨","邦",  "詖","賁","痺","鉍","嗶",
			  "梆","幫","綁","榜","膀",  "幣","弊","碧","下一頁","決定"],
			[ "裨","蔽","壁","篦","斃",  "彬","賓","儐","濱","豳",
			  "臂","薜","避","璧","蹕",  "檳","瀕","繽","殯","臏",
			  "襞","鱉","別","癟","彆",  "鬢","冰","兵","丙","秉",
			  "杓","彪","標","膘","鏢",  "柄","炳","摒","稟","鉼",
			  "驃","鑣","表","婊","錶",  "餅","并","並","併","病",
			  "鰾","砭","編","蝙","鞭",  "鈽","誧","卜","哺","捕",
			  "邊","扁","匾","貶","褊",  "補","不","布","佈","步",
			  "卞","弁","汴","釆","便",  "怖","埔","埠","部","簿",
			  "遍","辨","辮","辯","變",  "",  "",  "ㄅ","返回","決定"],
			[ "趴","啪","葩","杷","爬",  "咆","庖","匏","袍","跑", // ㄆ
			  "耙","琶","帕","怕","坡",  "泡","炮","皰","砲","剖",
			  "泊","頗","潑","婆","鄱",  "裒","潘","攀","槃","盤",
			  "叵","剖","頗","珀","迫",  "磐","蟠","蹣","判","拚",
			  "破","釙","粕","魄","醱",  "叛","盼","畔","噴","盆",
			  "拍","俳","徘","排","牌",  "乓","滂","旁","徬","螃",
			  "派","湃","呸","胚","培",  "龐","胖","抨","砰","烹",
			  "陪","裴","賠","沛","佩",  "澎","朋","彭","棚","硼",
			  "珮","配","轡","拋","刨",  "蓬","膨","篷","下一頁","決定"],
			[ "鵬","捧","碰","踫","丕",  "偏","篇","翩","胼","駢",
			  "批","披","紕","鈹","劈",  "片","騙","姘","拼","貧",
			  "霹","皮","枇","陂","毗",  "頻","嬪","顰","品","牝",
			  "疲","啤","埤","陴","琵",  "聘","乒","娉","平","坪",
			  "脾","鼙","匹","疋","仳",  "屏","枰","瓶","萍","評",
			  "痞","癖","屁","媲","睥",  "憑","蘋","仆","扑","噗",
			  "辟","僻","譬","闢","撇",  "撲","匍","脯","莆","菩",
			  "瞥","剽","飄","嫖","瓢",  "葡","僕","蒲","璞","濮",
			  "瞟","縹","票","剽","漂",  "朴","圃","浦","下一頁","決定"],
			[ "普","溥","樸","譜","蹼",  "",  "",  "",  "",  "",
			  "鋪","瀑","曝","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄆ","返回","決定"],
			[ "媽","嬤","麻","痲","蟆",  "沒","枚","玫","眉","梅", // ㄇ
			  "馬","瑪","碼","螞","罵",  "莓","媒","湄","楣","煤",
			  "嗎","嘛","摸","摩","摹",  "霉","黴","每","美","鎂",
			  "模","膜","磨","糢","謨",  "妹","沬","昧","袂","媚",
			  "蘑","魔","抹","末","歿",  "寐","魅","貓","兞","毛",
			  "沫","茉","陌","秣","莫",  "矛","茅","茆","髦","犛",
			  "貊","寞","漠","墨","默",  "錨","卯","泖","冒","茂",
			  "驀","么","麼","埋","霾",  "耄","帽","貿","瑁","貌",
			  "買","脈","麥","賣","邁",  "懋","牟","眸","下一頁","決定"],
			[ "謀","繆","某","瞞","蹣",  "懵","孟","夢","咪","瞇",
			  "饅","鰻","蠻","屘","滿",  "迷","彌","糜","謎","麋",
			  "曼","幔","慢","漫","蔓",  "靡","瀰","米","羋","弭",
			  "縵","鏝","門","們","捫",  "敉","糸","汨","泌","祕",
			  "悶","燜","懣","們","忙",  "秘","密","覓","蜜","冪",
			  "杗","芒","氓","盲","茫",  "謐","咩","滅","蔑","篾",
			  "莽","蟒","虻","萌","盟",  "苗","描","瞄","杪","眇",
			  "蒙","甍","濛","朦","檬",  "秒","渺","緲","藐","邈",
			  "矇","猛","艋","蜢","錳",  "妙","廟","謬","下一頁","決定"],
			[ "眠","棉","綿","免","沔",  "苜","募","睦","墓","幕",
			  "勉","娩","偭","冕","湎",  "慕","暮","穆","",  "",
			  "緬","澠","面","麵","民",  "",  "",  "",  "",  "",
			  "岷","皿","抿","泯","敏",  "",  "",  "",  "",  "",
			  "湣","閔","愍","閩","憫",  "",  "",  "",  "",  "",
			  "名","明","冥","茗","暝",  "",  "",  "",  "",  "",
			  "銘","鳴","瞑","螟","酩",  "",  "",  "",  "",  "",
			  "命","母","牡","姆","拇",  "",  "",  "",  "",  "",
			  "畝","木","目","沐","牧",  "",  "",  "ㄇ","返回","決定"],
			[ "發","醱","乏","伐","砝",  "墦","樊","繁","礬","反", // ㄈ
			  "筏","罰","閥","法","髮",  "返","釩","氾","犯","汎",
			  "琺","髮","妃","非","飛",  "泛","范","梵","販","飯",
			  "啡","扉","菲","霏","肥",  "範","兝","分","吩","氛",
			  "腓","匪","斐","翡","誹",  "芬","紛","棻","汾","焚",
			  "吠","沸","肺","芾","屝",  "墳","粉","份","忿","憤",
			  "費","痱","廢","缶","否",  "奮","糞","方","坊","枋",
			  "帆","番","幡","蕃","繙",  "芳","妨","防","房","肪",
			  "翻","藩","凡","帆","煩",  "仿","彷","倣","下一頁","決定"],
			[ "紡","舫","訪","放","丰",  "涪","符","紼","紱","幅",
			  "封","風","峰","烽","楓",  "菔","袱","福","蝠","輻",
			  "蜂","瘋","鋒","豐","逢",  "甫","府","斧","俯","釜",
			  "馮","諷","奉","俸","鳳",  "腑","腐","輔","撫","頫",
			  "諷","縫","夫","伕","趺",  "父","付","咐","阜","附",
			  "鈇","孵","敷","膚","麩",  "訃","負","赴","副","婦",
			  "弗","伏","佛","孚","扶",  "傅","富","復","腹","複",
			  "彿","怫","拂","服","芙",  "賦","駙","縛","賻","覆",
			  "芣","俘","氟","浮","匐",  "馥","",  "ㄈ","返回","決定"],
			[ "搭","褡","怛","答","達",  "燾","兡","兜","都","斗", // ㄉ
			  "靼","瘩","躂","韃","打",  "抖","枓","蚪","陡","斗",
			  "大","瘩","得","德","地",  "豆","鬥","脰","逗","痘",
			  "的","の","呆","歹","逮",  "竇","丹","耽","單","擔",
			  "代","岱","待","怠","殆",  "簞","疸","撢","膽","旦",
			  "玳","迨","帶","袋","貸",  "但","啖","啗","淡","蛋",
			  "戴","黛","刀","叨","島",  "氮","彈","憚","誕","澹",
			  "搗","導","蹈","禱","到",  "當","噹","襠","鐺","擋",
			  "倒","悼","盜","道","稻",  "黨","讜","儅","下一頁","決定"],
			[ "蕩","檔","盪","登","燈",  "諦","爹","跌","迭","喋",
			  "蹬","等","凳","嶝","鄧",  "絰","耋","跌","牒","碟",
			  "瞪","磴","蹬","氐","低",  "蝶","諜","疊","刁","叼",
			  "堤","隄","滴","狄","迪",  "凋","彫","貂","碉","雕",
			  "笛","荻","嘀","嫡","滌",  "鯛","弔","吊","掉","釣",
			  "翟","敵","鏑","底","抵",  "調","丟","甸","滇","顛",
			  "邸","柢","牴","砥","詆",  "巔","癲","典","碘","點",
			  "地","弟","的","帝","娣",  "佃","甸","店","玷","惦",
			  "第","棣","蒂","遞","締",  "奠","殿","電","下一頁","決定"],
			[ "墊","澱","靛","丁","仃",  "剁","舵","惰","跺","墮",
			  "叮","盯","酊","釘","頂",  "堆","兌","隊","碓","對",
			  "鼎","定","訂","錠","都",  "耑","端","短","段","緞",
			  "督","嘟","毒","獨","瀆",  "鍛","斷","惇","敦","墩",
			  "櫝","牘","犢","讀","髑",  "噸","蹲","盹","躉","囤",
			  "黷","堵","睹","賭","篤",  "沌","盾","鈍","遁","頓",
			  "妒","杜","肚","度","渡",  "燉","冬","咚","東","鼕",
			  "鍍","蠹","多","咄","奪",  "董","懂","峒","恫","洞",
			  "踱","鐸","朵","躲","綞",  "凍","胴","動","下一頁","決定"],
			[ "棟","湩","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄉ","返回","決定"],
			[ "他","它","她","牠","塌",  "偷","投","骰","頭","透", // ㄊ
			  "塔","獺","拓","榻","遢",  "坍","貪","攤","灘","癱",
			  "遝","踏","撻","蹋","特",  "覃","痰","潭","談","壇",
			  "慝","胎","台","抬","苔",  "曇","檀","罈","譚","坦",
			  "跆","臺","颱","檯","薹",  "袒","毯","炭","探","嘆",
			  "太","汰","泰","態","掏",  "碳","歎","湯","鏜","唐",
			  "滔","絛","濤","韜","饕",  "堂","棠","塘","搪","瑭",
			  "洮","桃","逃","啕","淘",  "膛","糖","螳","醣","帑",
			  "陶","萄","檮","討","套",  "倘","淌","躺","下一頁","決定"],
			[ "儻","趟","燙","疼","滕",  "田","恬","畋","甜","填",
			  "謄","藤","騰","籐","剔",  "鈿","闐","忝","腆","舔",
			  "梯","踢","啼","堤","提",  "靦","汀","听","聽","廳",
			  "隄","緹","銻","蹄","題",  "廷","亭","庭","停","婷",
			  "體","剃","悌","涕","屜",  "蜓","霆","挺","梃","艇",
			  "惕","逖","替","嚏","帖",  "凸","禿","突","徒","屠",
			  "貼","鐵","餮","佻","挑",  "荼","途","菟","塗","圖",
			  "迢","條","蜩","鯈","窕",  "酴","土","吐","兔","托",
			  "眺","覜","跳","天","添",  "拖","託","脫","下一頁","決定"],
			[ "佗","沱","陀","跎","馱",  "",  "",  "",  "",  "",
			  "駝","鴕","妥","橢","柝",  "",  "",  "",  "",  "",
			  "唾","推","頹","腿","退",  "",  "",  "",  "",  "",
			  "蛻","褪","湍","團","糰",  "",  "",  "",  "",  "",
			  "吞","屯","豚","飩","臀",  "",  "",  "",  "",  "",
			  "通","同","彤","桐","童",  "",  "",  "",  "",  "",
			  "僮","銅","潼","瞳","桶",  "",  "",  "",  "",  "",
			  "統","筒","痛","慟","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄊ","返回","決定"],
			[ "嗯","拿","哪","吶","那",  "你","旎","擬","逆","匿", // ㄋ
			  "娜","納","捺","鈉","訥",  "溺","睨","暱","膩","捏",
			  "呢","乃","奶","氖","妳",  "涅","臬","聶","鎳","孽",
			  "迺","奈","耐","餒","內",  "囁","齧","躡","鑷","鳥",
			  "呶","撓","蟯","鐃","惱",  "裊","嬝","尿","妞","牛",
			  "瑙","腦","鬧","耨","男",  "忸","扭","紐","鈕","拈",
			  "南","喃","楠","難","赧",  "年","黏","涊","捻","撚",
			  "嫩","囊","曩","能","妮",  "碾","輦","攆","廿","念",
			  "尼","怩","泥","倪","霓",  "唸","您","娘","下一頁","決定"],
			[ "孃","釀","苧","寧","凝",  "",  "",  "",  "",  "",
			  "嚀","擰","獰","檸","佞",  "",  "",  "",  "",  "",
			  "濘","奴","駑","努","弩",  "",  "",  "",  "",  "",
			  "怒","挪","諾","懦","糯",  "",  "",  "",  "",  "",
			  "暖","煖","農","儂","噥",  "",  "",  "",  "",  "",
			  "濃","膿","穠","弄","女",  "",  "",  "",  "",  "",
			  "虐","瘧","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄋ","返回","決定"],
			[ "垃","拉","邋","剌","喇",  "酪","婁","嘍","樓","螻", // ㄌ
			  "辣","臘","蠟","啦","肋",  "髏","摟","簍","陋","漏",
			  "叻","樂","來","徠","萊",  "瘺","鏤","婪","嵐","闌",
			  "睞","賴","瀨","癩","籟",  "藍","攔","瀾","籃","襤",
			  "勒","雷","嫘","擂","縲",  "斕","欄","蘭","籣","懶",
			  "羸","鐳","耒","磊","儡",  "覽","攬","欖","纜","濫",
			  "蕾","壘","淚","累","類",  "爛","郎","狼","琅","廊",
			  "撈","牢","勞","嘮","癆",  "榔","瑯","螂","朗","浪",
			  "老","佬","姥","潦","烙",  "楞","稜","冷","下一頁","決定"],
			[ "愣","哩","糎","狸","梨",  "莉","痢","慄","溧","蒞",
			  "犁","琍","喱","蜊","漓",  "厲","曆","歷","勵","隸",
			  "貍","璃","黎","罹","釐",  "癘","鎘","壢","瀝","麗",
			  "離","蠡","籬","驪","兣",  "礪","礫","儷","蠣","酈",
			  "李","里","俚","娌","浬",  "欐","靂","倆","咧","列",
			  "理","裡","鋰","澧","禮",  "劣","冽","洌","烈","捩",
			  "鯉","醴","邐","力","立",  "裂","獵","鬣","撩","聊",
			  "吏","利","例","戾","俐",  "僚","寥","嘹","寮","暸",
			  "栗","荔","唳","笠","粒",  "燎","遼","療","下一頁","決定"],
			[ "繚","了","瞭","料","廖",  "琳","痳","鄰","燐","璘",
			  "溜","流","琉","留","硫",  "遴","霖","磷","臨","轔",
			  "榴","遛","劉","瘤","瀏",  "鱗","麟","凜","懍","吝",
			  "柳","鉚","六","霤","餾",  "賃","藺","躪","良","梁",
			  "帘","連","廉","奩","漣",  "涼","粱","樑","糧","兩",
			  "憐","蓮","濂","聯","簾",  "魎","亮","晾","量","諒",
			  "鐮","鰱","斂","臉","楝",  "輛","伶","泠","昤","玲",
			  "煉","練","殮","鍊","鏈",  "苓","凌","羚","翎","聆",
			  "瀲","戀","拎","林","淋",  "蛉","陵","菱","下一頁","決定"],
			[ "鈴","零","綾","蔆","鴒",  "儸","騾","玀","蘿","邏",
			  "齡","櫺","靈","領","嶺",  "籮","鑼","裸","洛","珞",
			  "令","另","盧","廬","瀘",  "絡","落","漯","犖","鉻",
			  "爐","臚","蘆","鑪","顱",  "雒","駱","孿","巒","攣",
			  "鱸","鹵","虜","滷","魯",  "灤","鑾","鸞","卵","亂",
			  "擄","嚕","櫓","陸","鹿",  "掄","嗧","侖","倫","崙",
			  "僇","碌","祿","賂","路",  "淪","綸","輪","論","隆",
			  "戮","穋","錄","麓","露",  "龍","窿","嚨","朧","瓏",
			  "鷺","囉","螺","羅","鏍",  "矓","籠","聾","下一頁","決定"],
			[ "壟","攏","隴","閭","櫚",  "",  "",  "",  "",  "",
			  "驢","呂","侶","旅","屢",  "",  "",  "",  "",  "",
			  "膂","履","鋁","縷","褸",  "",  "",  "",  "",  "",
			  "律","率","氯","綠","慮",  "",  "",  "",  "",  "",
			  "濾","掠","略","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄌ","返回","決定"],
			[ "呷","嘎","噶","尬","戈",  "縞","告","誥","勾","佝", // ㄍ
			  "疙","咯","哥","胳","割",  "溝","鉤","狗","枸","苟",
			  "歌","擱","鴿","革","格",  "垢","夠","媾","搆","詬",
			  "鬲","葛","隔","膈","閣",  "雊","構","遘","購","甘",
			  "閤","骼","各","個","箇",  "杆","肝","坩","柑","竿",
			  "垓","該","賅","改","丐",  "疳","乾","尷","桿","敢",
			  "溉","鈣","概","蓋","給",  "稈","感","趕","橄","干",
			  "皋","羔","高","膏","篙",  "淦","幹","榦","贛","根",
			  "糕","杲","搞","槁","稿",  "跟","艮","亙","下一頁","決定"],
			[ "杠","肛","岡","缸","剛",  "雇","僱","錮","顧","瓜",
			  "釭","綱","鋼","崗","港",  "刮","聒","颳","寡","卦",
			  "槓","庚","耕","賡","羹",  "挂","掛","褂","郭","堝",
			  "哽","埂","耿","梗","更",  "蟈","鍋","國","幗","果",
			  "估","咕","呱","姑","孤",  "猓","裹","槨","過","乖",
			  "沽","蛄","菰","辜","鴣",  "摑","拐","枴","怪","圭",
			  "古","谷","股","牯","罟",  "皈","珪","規","傀","瑰",
			  "骨","詁","鈷","鼓","穀",  "閨","龜","鮭","歸","癸",
			  "轂","瞽","蠱","固","故",  "軌","鬼","晷","下一頁","決定"],
			[ "詭","桂","貴","跪","匱",  "恭","蚣","躬","龔","廾",
			  "劊","檜","櫃","鱖","官",  "汞","拱","鞏","共","貢",
			  "冠","倌","棺","關","鰥",  "",  "",  "",  "",  "",
			  "觀","莞","琯","管","館",  "",  "",  "",  "",  "",
			  "貫","慣","盥","灌","罐",  "",  "",  "",  "",  "",
			  "鸛","袞","滾","輥","鯀",  "",  "",  "",  "",  "",
			  "棍","光","洸","胱","廣",  "",  "",  "",  "",  "",
			  "獷","逛","工","弓","公",  "",  "",  "",  "",  "",
			  "功","攻","供","肱","宮",  "",  "",  "ㄍ","返回","決定"],
			[ "咖","喀","卡","柯","科",  "扣","寇","釦","刊","勘", // ㄎ
			  "苛","棵","軻","嗑","稞",  "堪","戡","坎","侃","砍",
			  "窠","瞌","磕","蝌","顆",  "檻","看","崁","瞰","肯",
			  "髁","殼","可","坷","渴",  "啃","墾","懇","齦","康",
			  "克","刻","剋","客","恪",  "慷","糠","扛","亢","伉",
			  "溘","緙","課","揩","開",  "抗","炕","吭","坑","阬",
			  "凱","剴","慨","愷","楷",  "鏗","枯","哭","窟","骷",
			  "愒","愾","考","拷","烤",  "苦","庫","酷","褲","夸",
			  "犒","銬","靠","口","叩",  "誇","垮","胯","下一頁","決定"],
			[ "跨","括","蛞","廓","闊",  "狂","誑","況","眶","壙",
			  "擴","快","塊","筷","儈",  "曠","礦","空","倥","崆",
			  "膾","盔","窺","虧","奎",  "硿","孔","恐","控","",
			  "揆","逵","葵","睽","魁",  "",  "",  "",  "",  "",
			  "夔","喟","愧","潰","簣",  "",  "",  "",  "",  "",
			  "餽","寬","髖","款","坤",  "",  "",  "",  "",  "",
			  "昆","崑","焜","琨","髡",  "",  "",  "",  "",  "",
			  "錕","捆","梱","綑","困",  "",  "",  "",  "",  "",
			  "睏","匡","劻","框","筐",  "",  "",  "ㄎ","返回","決定"],
			[ "哈","蛤","呵","喝","訶",  "嚎","壕","濠","蠔","好", // ㄏ
			  "禾","合","何","劾","和",  "郝","昊","浩","耗","皓",
			  "河","曷","紇","郃","核",  "號","鄗","鎬","顥","侯",
			  "盍","涸","盒","荷","蚵",  "喉","猴","篌","吼","后",
			  "頜","翮","闔","賀","赫",  "厚","後","候","逅","堠",
			  "褐","壑","鶴","咳","嗨",  "鱟","蚶","酣","鼾","含",
			  "孩","骸","還","海","亥",  "函","涵","寒","韓","罕",
			  "害","氦","駭","黑","嘿",  "喊","汗","旱","悍","捍",
			  "蒿","毫","嗥","貉","豪",  "焊","漢","銲","下一頁","決定"],
			[ "憾","撼","翰","頷","瀚",  "護","花","嘩","華","滑",
			  "痕","很","狠","恨","杭",  "猾","譁","化","划","畫",
			  "航","沆","亨","哼","恆",  "話","劃","樺","豁","活",
			  "桁","橫","衡","乎","呼",  "火","伙","夥","或","貨",
			  "忽","惚","囫","弧","狐",  "惑","禍","霍","濩","獲",
			  "胡","斛","壺","湖","瑚",  "穫","徊","淮","槐","踝",
			  "葫","糊","蝴","鵠","鬍",  "懷","坏","壞","灰","恢",
			  "虎","唬","琥","互","戶",  "虺","揮","暉","詼","輝",
			  "沍","扈","瓠","楛","滬",  "麾","徽","回","下一頁","決定"],
			[ "茴","迴","蛔","悔","毀",  "琿","魂","餛","混","肓",
			  "燬","卉","彗","晦","喙",  "荒","慌","皇","凰","徨",
			  "惠","匯","彙","會","賄",  "惶","湟","隍","黃","煌",
			  "誨","慧","蕙","諱","燴",  "遑","篁","蝗","璜","磺",
			  "穢","繪","歡","洹","桓",  "簧","韹","恍","晃","幌",
			  "寰","澴","環","鍰","緩",  "謊","哄","烘","薨","轟",
			  "幻","奐","宦","患","喚",  "弘","宏","泓","洪","紅",
			  "換","渙","煥","豢","瘓",  "虹","閎","鴻","黌","訌",
			  "昏","婚","葷","梡","渾",  "鬨","",  "ㄏ","返回","決定"],
			[ "乩","肌","圾","唧","姬",  "戢","極","楫","瘠","輯", // ㄐ
			  "屐","飢","基","嵇","犄",  "藉","籍","几","己","幾",
			  "勣","畸","跡","箕","嘰",  "戟","麂","擠","妓","忌",
			  "畿","稽","緝","機","激",  "技","季","芰","既","洎",
			  "璣","積","擊","磯","績",  "紀","計","記","寄","寂",
			  "蹟","雞","譏","饑","躋",  "悸","祭","暨","際","稷",
			  "羈","及","伋","吉","即",  "冀","劑","髻","濟","薊",
			  "岌","汲","亟","急","疾",  "覬","薺","繼","霽","驥",
			  "級","脊","棘","集","嫉",  "嗧","加","伽","下一頁","決定"],
			[ "夾","佳","茄","迦","家",  "竭","潔","羯","姐","解",
			  "浹","痂","袈","傢","葭",  "介","戒","屆","芥","界",
			  "嘉","豭","戛","莢","頰",  "疥","借","誡","交","姣",
			  "甲","胛","假","賈","鉀",  "郊","椒","焦","蛟","跤",
			  "架","嫁","價","稼","駕",  "嬌","澆","膠","蕉","礁",
			  "皆","接","揭","街","階",  "鮫","驕","角","狡","皎",
			  "嗟","孑","劫","杰","拮",  "絞","剿","腳","僥","鉸",
			  "桀","訐","捷","傑","結",  "餃","矯","繳","攪","叫",
			  "睫","節","詰","截","碣",  "教","窖","較","下一頁","決定"],
			[ "酵","轎","醮","究","糾",  "減","筧","儉","撿","檢",
			  "赳","啾","揪","鳩","九",  "瞼","簡","繭","鹼","件",
			  "久","灸","玖","韭","酒",  "見","建","荐","健","毽",
			  "臼","咎","疚","柩","救",  "腱","僭","漸","劍","澗",
			  "就","廄","舅","舊","奸",  "箭","賤","踐","諫","餞",
			  "尖","肩","姦","兼","堅",  "薦","鍵","濺","艦","鑑",
			  "湔","菅","間","煎","監",  "鑒","巾","今","斤","金",
			  "箋","緘","縑","艱","殲",  "津","矜","觔","筋","襟",
			  "韉","囝","柬","剪","揀",  "僅","盡","緊","下一頁","決定"],
			[ "瑾","儘","錦","謹","饉",  "驚","井","阱","景","憬",
			  "近","勁","晉","浸","進",  "璟","頸","警","徑","淨",
			  "禁","噤","縉","燼","覲",  "逕","竟","痙","敬","靖",
			  "江","姜","將","僵","漿",  "境","靜","鏡","競","居",
			  "薑","疆","韁","槳","獎",  "拘","狙","疽","砠","掬",
			  "蔣","講","匠","降","絳",  "駒","鞠","局","侷","桔",
			  "彊","醬","京","涇","荊",  "菊","跼","橘","咀","沮",
			  "旌","莖","晶","菁","睛",  "矩","莒","舉","齟","句",
			  "粳","經","兢","精","鯨",  "巨","具","拒","下一頁","決定"],
			[ "炬","苣","倨","俱","距",  "狷","眷","絹","雋","君",
			  "鉅","聚","劇","踞","據",  "均","軍","菌","鈞","俊",
			  "鋸","屨","遽","颶","懼",  "峻","浚","郡","竣","濬",
			  "孓","抉","決","玨","倔",  "駿","炯","迥","窘","囧",
			  "崛","掘","訣","厥","絕",  "",  "",  "",  "",  "",
			  "劂","獗","鴃","噱","蕨",  "",  "",  "",  "",  "",
			  "爵","譎","蹶","嚼","覺",  "",  "",  "",  "",  "",
			  "觼","攫","娟","捐","涓",  "",  "",  "",  "",  "",
			  "鵑","鐫","卷","捲","倦",  "",  "",  "ㄐ","返回","決定"],
			[ "七","妻","柒","悽","戚",  "汽","迄","泣","契","砌", // ㄑ
			  "淒","期","棲","欺","萋",  "氣","訖","棄","器","憩",
			  "漆","慼","槭","蹊","圻",  "磧","恰","洽","且","切",
			  "岐","其","奇","歧","祁",  "妾","怯","挈","愜","鍥",
			  "俟","祈","祇","耆","崎",  "竊","悄","敲","橇","鍬",
			  "淇","畦","棋","琪","琦",  "蹺","喬","僑","憔","橋",
			  "祺","旗","齊","錡","臍",  "樵","瞧","巧","愀","俏",
			  "騎","麒","鰭","乞","企",  "峭","誚","撬","鞘","竅",
			  "杞","豈","起","啟","綺",  "翹","譙","丘","下一頁","決定"],
			[ "邱","秋","蚯","鞦","鰍",  "侵","欽","嶔","親","芹",
			  "囚","求","泅","酋","梂",  "秦","琴","勤","禽","噙",
			  "毬","球","裘","兛","瓩",  "擒","寢","沁","撳","戕",
			  "千","仟","阡","牽","愆",  "羌","腔","嗆","槍","鎗",
			  "鉛","搴","遷","謙","簽",  "鏘","強","檣","牆","薔",
			  "騫","籤","韆","前","虔",  "搶","繈","青","卿","氫",
			  "鈐","鉗","箝","潛","錢",  "清","傾","蜻","輕","情",
			  "黔","淺","遣","譴","欠",  "晴","擎","檠","頃","請",
			  "倩","嵌","塹","歉","縴",  "慶","磬","罄","下一頁","決定"],
			[ "曲","屈","區","蛆","蛐",  "群","裙","穹","窮","瓊",
			  "嶇","趨","軀","麴","驅",  "",  "",  "",  "",  "",
			  "劬","渠","璩","瞿","衢",  "",  "",  "",  "",  "",
			  "取","娶","齲","去","趣",  "",  "",  "",  "",  "",
			  "缺","瘸","卻","雀","榷",  "",  "",  "",  "",  "",
			  "確","闋","闕","鵲","圈",  "",  "",  "",  "",  "",
			  "全","佺","泉","拳","荃",  "",  "",  "",  "",  "",
			  "痊","詮","蜷","銓","踡",  "",  "",  "",  "",  "",
			  "權","犬","畎","券","勸",  "",  "",  "ㄑ","返回","決定"],
			[ "夕","兮","汐","西","吸",  "禧","璽","系","矽","係", // ㄒ
			  "希","昔","析","唏","奚",  "細","隙","潟","戲","繫",
			  "息","悉","惜","晞","淅",  "煆","瞎","蝦","匣","狎",
			  "烯","晰","犀","稀","翕",  "俠","柙","峽","狹","暇",
			  "溪","僖","熙","熄","蜥",  "瑕","遐","轄","霞","黠",
			  "嘻","嬉","膝","熹","羲",  "下","夏","嚇","些","楔",
			  "錫","蟋","谿","譆","曦",  "歇","蠍","邪","協","挾",
			  "犧","席","習","媳","蓆",  "脅","偕","斜","勰","鞋",
			  "檄","襲","洗","徙","喜",  "頡","諧","擷","下一頁","決定"],
			[ "攜","寫","卸","泄","洩",  "修","羞","脩","朽","秀",
			  "屑","械","紲","榭","懈",  "岫","袖","嗅","溴","繡",
			  "燮","褻","謝","邂","瀉",  "鏽","仙","先","秈","祆",
			  "蟹","哮","宵","消","梟",  "掀","暹","鮮","纖","弦",
			  "逍","硝","嘐","銷","霄",  "咸","啣","涎","絃","舷",
			  "蕭","簫","瀟","囂","驍",  "閑","閒","嫌","銜","嫻",
			  "崤","淆","小","曉","篠",  "賢","鹹","銑","險","蘚",
			  "孝","肖","效","校","笑",  "顯","限","峴","現","莧",
			  "傚","詨","嘯","休","咻",  "陷","羨","腺","下一頁","決定"],
			[ "蜆","僩","線","憲","縣",  "惺","猩","腥","刑","行",
			  "餡","獻","心","辛","昕",  "形","邢","型","陘","硎",
			  "欣","芯","訢","新","鋅",  "醒","杏","姓","幸","性",
			  "薪","馨","信","釁","相",  "倖","悻","興","吁","戌",
			  "香","廂","湘","鄉","箱",  "胥","訏","虛","須","頊",
			  "襄","瓖","鑲","庠","祥",  "需","噓","墟","鬚","徐",
			  "翔","詳","享","想","餉",  "栩","許","旭","序","卹",
			  "響","饗","向","巷","象",  "恤","洫","敘","勗","酗",
			  "項","像","橡","嚮","星",  "婿","絮","煦","下一頁","決定"],
			[ "緒","蓄","續","蓿","削",  "汛","迅","徇","殉","訊",
			  "靴","薛","穴","學","雪",  "訓","巽","遜","潠","蕈",
			  "血","宣","軒","喧","暄",  "凶","兄","兇","匈","洶",
			  "萱","諼","玄","旋","漩",  "胸","雄","熊","",  "",
			  "璿","懸","晅","選","癬",  "",  "",  "",  "",  "",
			  "炫","眩","渲","絢","鉉",  "",  "",  "",  "",  "",
			  "勛","勳","壎","燻","薰",  "",  "",  "",  "",  "",
			  "醺","旬","巡","洵","荀",  "",  "",  "",  "",  "",
			  "尋","循","詢","馴","潯",  "",  "",  "ㄒ","返回","決定"],
			[ "之","の","支","卮","汁",  "秩","痔","窒","智","痣", // ㄓ
			  "吱","枝","泜","知","肢",  "蛭","稚","置","輊","雉",
			  "芝","胝","祗","脂","隻",  "滯","製","誌","幟","摯",
			  "梔","蜘","織","直","姪",  "緻","質","櫛","擲","躓",
			  "值","執","植","殖","摭",  "扎","吒","喳","渣","札",
			  "職","躑","止","只","旨",  "閘","眨","砟","乍","柞",
			  "址","芷","咫","指","祉",  "炸","蚱","詐","搾","榨",
			  "紙","衹","趾","至","志",  "蜇","遮","折","哲","摺",
			  "制","治","炙","峙","致",  "輒","謫","轍","下一頁","決定"],
			[ "者","赭","褶","浙","這",  "胄","晝","皺","縐","籀",
			  "蔗","鷓","著","摘","齋",  "驟","沾","詹","霑","氈",
			  "宅","窄","債","寨","招",  "瞻","譫","展","斬","盞",
			  "昭","釗","啁","爪","找",  "嶄","輾","占","佔","站",
			  "沼","召","兆","炤","棹",  "棧","湛","綻","戰","蘸",
			  "詔","照","罩","肇","趙",  "珍","貞","真","砧","針",
			  "櫂","州","舟","周","洲",  "偵","斟","楨","榛","甄",
			  "粥","週","妯","軸","肘",  "禎","箴","臻","枕","疹",
			  "帚","咒","宙","冑","紂",  "診","圳","甽","下一頁","決定"],
			[ "振","朕","陣","賑","震",  "幀","証","諍","鄭","證",
			  "鴆","鎮","張","章","彰",  "朱","侏","株","珠","茱",
			  "漳","獐","樟","璋","蟑",  "硃","蛛","誅","跦","銖",
			  "長","掌","漲","丈","仗",  "諸","豬","竹","竺","逐",
			  "杖","帳","脹","幛","障",  "築","燭","躅","主","拄",
			  "賬","瘴","征","怔","爭",  "渚","煮","囑","矚","住",
			  "崢","掙","猙","睜","箏",  "佇","助","杼","注","柱",
			  "蒸","徵","錚","鯖","癥",  "祝","蛀","筑","著","註",
			  "拯","整","正","政","症",  "貯","箸","駐","下一頁","決定"],
			[ "鑄","抓","卓","拙","捉",  "忠","盅","衷","終","鍾",
			  "桌","涿","灼","斫","茁",  "鐘","冢","塚","腫","種",
			  "酌","啄","濁","擢","濯",  "踵","仲","重","眾","",
			  "鐲","拽","隹","追","錐",  "",  "",  "",  "",  "",
			  "惴","綴","墜","贅","專",  "",  "",  "",  "",  "",
			  "磚","顓","轉","僎","撰",  "",  "",  "",  "",  "",
			  "篆","賺","囀","肫","諄",  "",  "",  "",  "",  "",
			  "准","準","妝","莊","裝",  "",  "",  "",  "",  "",
			  "樁","壯","狀","撞","中",  "",  "",  "ㄓ","返回","決定"],
			[ "吃","蚩","笞","喫","嗤",  "撤","澈","拆","釵","柴", // ㄔ
			  "痴","癡","魑","弛","池",  "豺","儕","齜","抄","超",
			  "持","匙","馳","墀","踟",  "鈔","勦","晁","巢","朝",
			  "遲","尺","呎","侈","恥",  "嘲","潮","吵","炒","抽",
			  "齒","褫","叱","斥","赤",  "仇","惆","愁","稠","酬",
			  "翅","敕","啻","飭","熾",  "綢","裯","儔","疇","籌",
			  "叉","差","插","查","茶",  "躊","丑","醜","臭","攙",
			  "搽","察","岔","差","詫",  "嬋","潺","澶","毚","禪",
			  "車","扯","坼","掣","徹",  "蟬","儳","蟾","下一頁","決定"],
			[ "巉","纏","讒","饞","產",  "廠","氅","倡","唱","悵",
			  "剷","諂","鏟","闡","懺",  "暢","稱","撐","瞠","丞",
			  "羼","顫","琛","瞋","縝",  "成","呈","承","城","乘",
			  "臣","忱","沈","沉","辰",  "程","誠","澄","橙","懲",
			  "宸","晨","陳","塵","諶",  "逞","騁","秤","出","初",
			  "疢","趁","櫬","襯","讖",  "齣","芻","除","廚","鋤",
			  "昌","倀","娼","猖","鯧",  "雛","櫥","躇","杵","楮",
			  "常","徜","萇","腸","嘗",  "楚","褚","儲","礎","怵",
			  "嫦","償","嚐","場","敞",  "畜","絀","處","下一頁","決定"],
			[ "歜","黜","觸","矗","戳",  "沖","舂","憧","衝","虫",
			  "綽","輟","齪","揣","啜",  "崇","蟲","寵","",  "",
			  "踹","吹","炊","垂","捶",  "",  "",  "",  "",  "",
			  "椎","陲","槌","箠","錘",  "",  "",  "",  "",  "",
			  "鎚","川","穿","船","傳",  "",  "",  "",  "",  "",
			  "舛","喘","串","釧","春",  "",  "",  "",  "",  "",
			  "唇","純","淳","脣","醇",  "",  "",  "",  "",  "",
			  "鶉","蠢","窗","瘡","床",  "",  "",  "",  "",  "",
			  "幢","闖","創","愴","充",  "",  "",  "ㄔ","返回","決定"],
			[ "尸","失","虱","屍","施",  "逝","視","勢","嗜","弒", // ㄕ
			  "師","溼","獅","詩","蝨",  "筮","試","軾","飾","誓",
			  "濕","十","石","拾","食",  "奭","適","噬","螫","識",
			  "時","塒","實","蝕","識",  "釋","匙","沙","剎","砂",
			  "兙","史","矢","豕","使",  "紗","殺","莎","煞","裟",
			  "始","屎","駛","士","氏",  "鯊","傻","廈","霎","奢",
			  "世","仕","市","示","式",  "賒","舌","蛇","舍","捨",
			  "似","事","侍","室","恃",  "社","舍","射","涉","設",
			  "拭","是","柿","舐","豉",  "赦","歙","懾","下一頁","決定"],
			[ "攝","麝","篩","晒","曬",  "汕","疝","扇","訕","善",
			  "捎","梢","稍","燒","勺",  "擅","膳","繕","贍","鱔",
			  "杓","芍","韶","少","邵",  "申","伸","身","呻","娠",
			  "哨","紹","收","手","守",  "砷","深","紳","莘","什",
			  "首","受","狩","售","授",  "甚","神","哂","審","嬸",
			  "壽","綬","瘦","獸","山",  "瀋","脤","腎","慎","蜃",
			  "刪","杉","姍","芟","柵",  "滲","商","傷","裳","殤",
			  "珊","舢","衫","跚","煽",  "觴","晌","賞","上","尚",
			  "潸","縿","羶","閃","陝",  "裳","升","生","下一頁","決定"],
			[ "昇","牲","陞","笙","甥",  "庶","術","墅","漱","數",
			  "聲","繩","省","盛","剩",  "豎","樹","刷","耍","說",
			  "勝","聖","賸","抒","叔",  "妁","朔","碩","爍","鑠",
			  "書","梳","殊","倏","淑",  "衰","摔","甩","帥","蟀",
			  "疏","舒","菽","樞","蔬",  "誰","誰","水","稅","睡",
			  "輸","橾","孰","塾","熟",  "拴","閂","栓","涮","吮",
			  "贖","暑","黍","署","蜀",  "舜","順","瞬","霜","雙",
			  "鼠","曙","薯","藷","屬",  "孀","爽","塽","",  "",
			  "朮","戍","束","述","恕",  "",  "",  "ㄕ","返回","決定"],
			[ "日","惹","熱","嬈","橈",  "儒","嚅","孺","濡","燸", // ㄖ
			  "饒","擾","繞","柔","揉",  "蠕","汝","乳","辱","入",
			  "蹂","鞣","肉","然","髯",  "褥","若","弱","偌","篛",
			  "燃","冉","染","苒","人",  "鶸","蕊","瑞","睿","銳",
			  "仁","壬","忍","荏","稔",  "阮","軟","閏","潤","茸",
			  "刃","仞","任","妊","紉",  "戎","容","絨","溶","榕",
			  "衽","軔","韌","飪","認",  "榮","熔","蓉","融","嶸",
			  "瓤","禳","嚷","壤","攘",  "鎔","冗","",  "",  "",
			  "讓","扔","仍","如","茹",  "",  "",  "ㄖ","返回","決定"],
			[ "孜","咨","姿","玆","茲",  "宰","再","在","載","賊", // ㄗ
			  "淄","孳","滋","訾","資",  "鯽","遭","糟","鑿","早",
			  "貲","緇","輜","諮","錙",  "蚤","棗","澡","藻","灶",
			  "髭","子","仔","姊","籽",  "皂","造","噪","燥","譟",
			  "梓","紫","滓","字","自",  "躁","陬","鄒","鄹","走",
			  "恣","漬","子","匝","紮",  "奏","揍","簪","咱","暫",
			  "臢","砸","偺","雜","咋",  "贊","鏨","瓚","讚","怎",
			  "則","笮","責","嘖","擇",  "臧","贓","髒","奘","葬",
			  "澤","仄","災","哉","栽",  "臟","增","憎","下一頁","決定"],
			[ "繒","贈","租","足","卒",  "",  "",  "",  "",  "",
			  "族","鏃","阻","俎","祖",  "",  "",  "",  "",  "",
			  "組","詛","昨","琢","左",  "",  "",  "",  "",  "",
			  "佐","作","坐","座","祚",  "",  "",  "",  "",  "",
			  "做","嘴","最","罪","醉",  "",  "",  "",  "",  "",
			  "蕞","鑽","纂","尊","樽",  "",  "",  "",  "",  "",
			  "遵","撙","宗","棕","綜",  "",  "",  "",  "",  "",
			  "蹤","鬃","傯","總","粽",  "",  "",  "",  "",  "",
			  "縱","",  "",  "",  "",    "",  "",  "ㄗ","返回","決定"],
			[ "疵","祠","茨","瓷","詞",  "餐","殘","慚","蠶","慘", // ㄔ
			  "慈","磁","雌","辭","此",  "孱","摻","燦","璨","岑",
			  "次","伺","刺","賜","擦",  "涔","倉","傖","滄","蒼",
			  "冊","側","廁","惻","測",  "艙","藏","曾","層","粗",
			  "策","猜","才","材","財",  "促","醋","簇","蹙","蹴",
			  "裁","纔","采","彩","採",  "搓","撮","磋","蹉","嵯",
			  "睬","綵","踩","菜","蔡",  "厝","挫","措","銼","錯",
			  "操","糙","曹","嘈","漕",  "崔","催","摧","璀","脆",
			  "槽","草","湊","輳","參",  "悴","淬","萃","下一頁","決定"],
			[ "瘁","粹","翠","篡","竄",  "",  "",  "",  "",  "",
			  "爨","村","皴","存","忖",  "",  "",  "",  "",  "",
			  "寸","吋","匆","囪","樅",  "",  "",  "",  "",  "",
			  "蔥","聰","從","淙","叢",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄔ","返回","決定"],
			[ "司","私","思","斯","絲",  "颼","叟","嗾","擻","藪", // ㄙ
			  "嘶","廝","撕","鷥","死",  "嗽","三","傘","糝","霰",
			  "巳","四","寺","兕","姒",  "散","森","桑","嗓","喪",
			  "泗","祀","耜","嗣","肆",  "僧","甦","酥","穌","蘇",
			  "飼","駟","撒","灑","卅",  "囌","俗","夙","素","宿",
			  "颯","薩","色","嗇","瑟",  "速","粟","肅","訴","嗉",
			  "澀","穡","塞","腮","鰓",  "塑","溯","蓿","簌","唆",
			  "賽","搔","繅","騷","掃",  "娑","梭","嗦","蓑","簑",
			  "嫂","搜","蒐","艘","餿",  "縮","所","索","下一頁","決定"],
			[ "瑣","鎖","嗧","嗦","睢",  "",  "",  "",  "",  "",
			  "綏","雖","隋","隨","髓",  "",  "",  "",  "",  "",
			  "祟","歲","碎","遂","誶",  "",  "",  "",  "",  "",
			  "隧","燧","穗","邃","痠",  "",  "",  "",  "",  "",
			  "酸","算","蒜","孫","飧",  "",  "",  "",  "",  "",
			  "蓀","筍","損","榫","忪",  "",  "",  "",  "",  "",
			  "松","崧","淞","嵩","鬆",  "",  "",  "",  "",  "",
			  "悚","慫","聳","宋","送",  "",  "",  "",  "",  "",
			  "訟","頌","誦","",  "",    "",  "",  "ㄙ","返回","決定"],
			[ "阿","啊","",  "",  "",    "",  "",  "",  "",  "",   // ㄚ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄚ","返回","決定"],
			[ "喔","噢","哦","",  "",    "",  "",  "",  "",  "",   // ㄛ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄛ","返回","決定"],
			[ "婀","俄","娥","峨","訛",  "",  "",  "",  "",  "",   // ㄜ
			  "蛾","額","鵝","厄","呃",  "",  "",  "",  "",  "",
			  "扼","堊","軛","惡","愕",  "",  "",  "",  "",  "",
			  "鄂","萼","詻","遏","餓",  "",  "",  "",  "",  "",
			  "噩","鍔","顎","鱷","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄜ","返回","決定"],
			[ "",  "",  "",  "",  "",    "",  "",  "",  "",  "",   // ㄝ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄝ","返回","決定"],
			[ "哀","哎","唉","埃","挨",  "",  "",  "",  "",  "",   // ㄞ
			  "噯","捱","皚","癌","矮",  "",  "",  "",  "",  "",
			  "藹","靄","艾","愛","隘",  "",  "",  "",  "",  "",
			  "閡","曖","璦","礙","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄞ","返回","決定"],
			[ "",  "",  "",  "",  "",    "",  "",  "",  "",  "",   // ㄟ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄟ","返回","決定"],
			[ "凹","敖","嗷","熬","遨",  "",  "",  "",  "",  "",   // ㄠ
			  "翱","聱","鏖","鼇","拗",  "",  "",  "",  "",  "",
			  "媼","襖","傲","奧","懊",  "",  "",  "",  "",  "",
			  "澳","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄠ","返回","決定"],
			[ "歐","毆","甌","鷗","偶",  "",  "",  "",  "",  "",   // ㄡ
			  "嘔","耦","藕","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄡ","返回","決定"],
			[ "安","氨","庵","菴","鞍",  "",  "",  "",  "",  "",   // ㄢ
			  "諳","鵪","俺","銨","岸",  "",  "",  "",  "",  "",
			  "按","案","暗","黯","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄢ","返回","決定"],
			[ "恩","",  "",  "",  "",    "",  "",  "",  "",  "",   // ㄣ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄣ","返回","決定"],
			[ "骯","昂","盎","",  "",    "",  "",  "",  "",  "",   // ㄤ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄤ","返回","決定"],
			[ "",  "",  "",  "",  "",    "",  "",  "",  "",  "",   // ㄥ
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄥ","返回","決定"],
			[ "儿","而","兒","耳","洱",  "",  "",  "",  "",  "",   // ㄦ
			  "爾","餌","邇","二","貳",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "ㄦ","返回","決定"],
			[ "一","伊","衣","依","咿",  "役","抑","邑","佾","易", // ㄧ
			  "壹","揖","漪","噫","醫",  "奕","帟","弈","疫","羿",
			  "圯","夷","沂","迆","宜",  "浥","益","異","翌","軼",
			  "怡","咦","姨","迤","栘",  "逸","意","溢","睪","義",
			  "胰","訑","痍","移","貽",  "肄","裔","詣","蜴","億",
			  "飴","疑","儀","遺","頤",  "毅","誼","劓","憶","縊",
			  "彞","乙","已","以","矣",  "翳","翼","臆","鎰","繹",
			  "倚","偯","椅","旖","蟻",  "藝","議","譯","囈","懿",
			  "弋","刈","亦","屹","佚",  "驛","丫","呀","下一頁","決定"],
			[ "押","鴉","鴨","壓","牙",  "爻","肴","姚","堯","搖",
			  "芽","蚜","崖","涯","琊",  "榣","瑤","遙","窯","餚",
			  "衙","啞","雅","亞","軋",  "謠","杳","咬","窈","舀",
			  "訝","氬","呀","唷","喲",  "要","曜","藥","耀","鷂",
			  "掖","暍","椰","噎","耶",  "鑰","攸","幽","悠","憂",
			  "爺","也","冶","野","曳",  "優","尢","尤","由","油",
			  "夜","頁","液","腋","業",  "疣","游","猶","郵","猷",
			  "葉","曄","謁","鄴","靨",  "遊","鈾","魷","友","有",
			  "夭","吆","妖","腰","邀",  "酉","莠","牖","下一頁","決定"],
			[ "黝","又","右","幼","佑",  "縯","儼","鼴","魘","咽",
			  "侑","囿","宥","柚","祐",  "彥","唁","宴","晏","堰",
			  "釉","誘","鼬","胭","淹",  "焰","硯","雁","厭","燕",
			  "焉","湮","腌","菸","煙",  "燄","諺","嚥","贗","饜",
			  "嫣","醃","妍","言","岩",  "驗","艷","釅","豔","因",
			  "延","沿","炎","研","筵",  "姻","音","殷","氤","茵",
			  "閻","檐","顏","簷","嚴",  "陰","慇","蔭","吟","垠",
			  "巖","鹽","奄","兗","衍",  "寅","淫","夤","鄞","銀",
			  "偃","掩","眼","郾","演",  "霪","尹","引","下一頁","決定"],
			[ "蚓","飲","隱","癮","印",  "鸚","迎","盈","塋","楹",
			  "胤","央","泱","殃","秧",  "熒","瑩","嬴","縈","螢",
			  "鞅","鴦","羊","佯","徉",  "營","瀛","蠅","贏","郢",
			  "洋","烊","揚","陽","暘",  "影","穎","映","硬","",
			  "楊","煬","瘍","鍚","颺",  "",  "",  "",  "",  "",
			  "仰","氧","養","癢","怏",  "",  "",  "",  "",  "",
			  "恙","漾","樣","英","瑛",  "",  "",  "",  "",  "",
			  "嬰","應","膺","嚶","罌",  "",  "",  "",  "",  "",
			  "櫻","瓔","鶯","纓","鷹",  "",  "",  "ㄧ","返回","決定"],
			[ "圬","汙","污","巫","屋",  "娃","瓦","襪","哇","倭", // ㄨ
			  "烏","嗚","誣","鎢","毋",  "渦","萵","窩","蝸","撾",
			  "吾","吳","唔","梧","無",  "我","沃","臥","握","渥",
			  "蜈","蕪","鼯","五","午",  "斡","擭","齷","歪","崴",
			  "伍","武","侮","捂","舞",  "外","危","威","偎","萎",
			  "嫵","憮","鵡","兀","勿",  "逶","微","煨","薇","巍",
			  "戊","物","悟","務","晤",  "圩","韋","桅","唯","帷",
			  "塢","寤","誤","霧","騖",  "惟","圍","幃","違","維",
			  "哇","挖","媧","蛙","窪",  "濰","闈","尾","下一頁","決定"],
			[ "委","洧","娓","偽","偉",  "輓","腕","萬","塭","溫",
			  "猥","痿","葦","緯","諉",  "瘟","文","玟","紋","蚊",
			  "鮪","未","位","味","為",  "雯","聞","刎","吻","抆",
			  "畏","胃","尉","喂","渭",  "紊","穩","汶","問","汪",
			  "慰","蔚","衛","謂","褽",  "亡","王","往","枉","罔",
			  "餵","魏","剜","蜿","豌",  "惘","網","輞","魍","妄",
			  "彎","灣","丸","汍","完",  "忘","旺","望","翁","嗡",
			  "玩","頑","宛","挽","婉",  "蓊","甕","",  "",  "",
			  "惋","晚","皖","碗","綰",  "",  "",  "ㄨ","返回","決定"],
			[ "迂","紆","淤","瘀","于",  "嶼","齬","玉","聿","育", // ㄩ
			  "余","妤","於","盂","臾",  "芋","昱","郁","堉","峪",
			  "俞","禺","竽","娛","雩",  "浴","域","御","欲","喻",
			  "魚","愉","渝","腴","萸",  "寓","馭","愈","毓","煜",
			  "隅","愚","榆","瑜","虞",  "裕","遇","預","嫗","獄",
			  "逾","漁","蝓","褕","諛",  "瘉","慾","澦","禦","諭",
			  "餘","覦","輿","歟","予",  "豫","燠","癒","譽","鬱",
			  "宇","羽","雨","禹","圄",  "籲","曰","約","月","刖",
			  "圉","庾","敔","與","語",  "岳","玥","悅","下一頁","決定"],
			[ "軏","越","粵","閱","嶽",  "隕","孕","慍","運","熨",
			  "躍","籥","冤","淵","鳶",  "醞","韻","蘊","佣","邕",
			  "鴛","元","沅","垣","爰",  "庸","傭","雍","慵","鄘",
			  "原","員","袁","援","湲",  "壅","擁","臃","永","甬",
			  "園","圓","源","猿","緣",  "泳","俑","勇","涌","恿",
			  "轅","騵","遠","怨","苑",  "湧","詠","蛹","踴","用",
			  "院","媛","愿","願","暈",  "",  "",  "",  "",  "",
			  "氳","云","勻","昀","芸",  "",  "",  "",  "",  "",
			  "紜","耘","雲","筠","允",  "",  "",  "ㄩ","返回","決定"],
		];
	Window_NameInput.CHINESE_TRADITIONAL_STROKE_INDEX =
		[
			[ "一","乙","の","",  "",    "",  "",  "",  "",  "",   // 1劃
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "丁","七","乃","九","了",  "",  "",  "",  "",  "",   // 2劃
			  "二","人","儿","入","八",  "",  "",  "",  "",  "",
			  "几","刀","刁","力","匕",  "",  "",  "",  "",  "",
			  "十","卜","又","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "三","下","丈","上","丫",  "",  "",  "",  "",  "",   // 3劃
			  "丸","凡","久","么","也",  "",  "",  "",  "",  "",
			  "乞","于","亡","兀","刃",  "",  "",  "",  "",  "",
			  "勺","千","叉","口","土",  "",  "",  "",  "",  "",
			  "士","夕","大","女","子",  "",  "",  "",  "",  "",
			  "孑","孓","寸","小","尢",  "",  "",  "",  "",  "",
			  "尸","山","川","工","己",  "",  "",  "",  "",  "",
			  "已","巳","巾","干","廾",  "",  "",  "",  "",  "",
			  "弋","弓","才","之","及",  "",  "",  "",  "返回","決定"],
			[ "丑","丐","不","中","丰",  "壬","天","夫","太","夭", // 4劃
			  "丹","尹","予","云","井",  "孔","少","尤","尺","屯",
			  "互","五","亢","仁","什",  "巴","幻","廿","弔","引",
			  "仃","仆","仇","仍","今",  "心","戈","戶","手","扎",
			  "介","仄","元","允","內",  "支","文","斗","斤","方",
			  "六","兮","公","冗","凶",  "日","曰","月","木","欠",
			  "分","切","刈","勻","勾",  "止","歹","毋","比","毛",
			  "勿","化","匹","午","升",  "氏","水","火","爪","父",
			  "卅","卞","厄","友","反",  "爻","片","牙","下一頁","決定"],
			[ "牛","犬","王","乏","以",  "",  "",  "",  "",  "",
			  "巨","瓦","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "丙","世","丕","且","丘",  "叨","叼","司","叵","叫", // 5劃
			  "主","乍","乎","付","仔",  "另","只","史","叱","台",
			  "仕","他","仗","代","令",  "句","叭","叻","四","囚",
			  "仙","仞","兄","冉","冊",  "外","央","失","奴","奶",
			  "冬","凹","出","凸","刊",  "孕","它","尼","巧","左",
			  "加","功","包","匆","北",  "市","布","平","幼","弁",
			  "匝","仟","半","卉","卡",  "弘","弗","必","戊","打",
			  "占","卯","卮","去","可",  "扔","扒","扑","斥","旦",
			  "古","右","召","叮","叩",  "朮","本","未","下一頁","決定"],
			[ "末","札","正","母","民",  "",  "",  "",  "",  "",
			  "氐","永","汁","汀","氾",  "",  "",  "",  "",  "",
			  "犯","玄","玉","瓜","甘",  "",  "",  "",  "",  "",
			  "生","用","甩","田","由",  "",  "",  "",  "",  "",
			  "甲","申","疋","白","皮",  "",  "",  "",  "",  "",
			  "皿","目","矛","矢","石",  "",  "",  "",  "",  "",
			  "示","禾","穴","立","伋",  "",  "",  "",  "",  "",
			  "印","艾","阡","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "充","丞","丟","乒","乓",  "吏","同","吊","吐","吁", // 6劃
			  "乩","亙","交","亦","亥",  "吋","各","向","名","合",
			  "仿","伉","伙","伊","伕",  "吃","后","吆","吒","因",
			  "伍","伐","休","伏","仲",  "回","囝","圳","地","在",
			  "件","任","仰","仳","份",  "圭","圬","圯","圩","夙",
			  "企","光","兇","兆","先",  "多","夷","夸","妄","奸",
			  "全","共","再","冰","列",  "妃","好","她","如","妁",
			  "刑","划","刎","刖","劣",  "字","存","宇","守","宅",
			  "匈","匡","匠","危","吉",  "安","寺","尖","下一頁","決定"],
			[ "屹","州","帆","并","年",  "牝","百","竹","米","糸",
			  "式","弛","忙","忖","戎",  "缶","羊","羽","老","考",
			  "戌","戍","成","扣","扛",  "而","耒","耳","聿","肉",
			  "托","收","早","旨","旬",  "肋","肌","臣","自","至",
			  "旭","曲","曳","有","朽",  "臼","舌","舛","舟","艮",
			  "朴","朱","朵","次","此",  "色","虫","血","行","衣",
			  "死","氖","汝","汗","汙",  "西","似","吸","圾","岌",
			  "江","池","汐","汕","污",  "廷","汲","芒","芋","芍",
			  "汛","汍","汎","灰","牟",  "迂","迆","迅","下一頁","決定"],
			[ "迄","巡","邢","邪","邦",  "",  "",  "",  "",  "",
			  "那","防","阮","阱","阪",  "",  "",  "",  "",  "",
			  "阬","延","祁","芝","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "瓩","串","亨","位","住",  "匣","即","卵","吝","吭", // 7劃
			  "佇","佗","佞","伴","佛",  "吞","吾","否","呎","吧",
			  "何","估","佐","佑","伽",  "呆","呃","吳","呈","呂",
			  "伺","伸","佃","佔","但",  "君","吩","告","吹","吻",
			  "佣","作","你","伯","低",  "吮","吵","吶","吠","吼",
			  "伶","余","佝","佈","佚",  "呀","吱","含","吟","听",
			  "兌","克","免","兵","冶",  "囪","困","囤","囫","坊",
			  "冷","別","判","利","刪",  "坑","址","坍","均","坎",
			  "刨","劫","助","努","劬",  "坐","坏","圻","下一頁","決定"],
			[ "壯","夾","妝","妒","妨",  "快","忸","忪","戒","我",
			  "妞","妣","妙","妖","妍",  "抄","抗","抖","技","扶",
			  "妤","妓","妊","妥","孝",  "抉","扭","把","扼","找",
			  "孜","孚","孛","完","宋",  "批","扳","抒","扯","折",
			  "宏","尬","局","屁","尿",  "扮","投","抓","抑","抆",
			  "尾","岐","岑","岔","巫",  "改","攻","攸","旱","更",
			  "希","序","庇","床","弄",  "束","李","杏","材","村",
			  "弟","彤","形","彷","役",  "杜","杖","杞","杉","杆",
			  "忘","忌","志","忍","忱",  "杠","杓","杗","下一頁","決定"],
			[ "步","每","求","汞","沙",  "私","秀","禿","究","系",
			  "沁","沈","沉","沅","沛",  "罕","肖","肓","肝","肘",
			  "汪","決","沐","汰","沌",  "肛","肚","良","見","角",
			  "汨","沖","沒","汽","沃",  "言","谷","豆","豕","貝",
			  "汾","汴","沆","汶","沍",  "赤","走","足","身","車",
			  "沔","沘","沂","灶","灼",  "辛","辰","邑","酉","釆",
			  "災","灸","牢","牡","牠",  "里","兕","姊","姒","拒",
			  "狄","狂","玖","甬","甫",  "泛","社","祀","羌","芳",
			  "男","甸","皂","盯","矣",  "芙","芭","芽","下一頁","決定"],
			[ "芟","芹","花","芬","芥",  "",  "",  "",  "",  "",
			  "芯","芸","芣","芰","芾",  "",  "",  "",  "",  "",
			  "芷","初","迎","返","近",  "",  "",  "",  "",  "",
			  "邵","邸","邱","邶","陀",  "",  "",  "",  "",  "",
			  "阿","阻","附","陂","苣",  "",  "",  "",  "",  "",
			  "囧","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "育","並","乖","乳","事",  "劾","劻","卒","協","卓", // 8劃
			  "些","亞","享","京","佯",  "卑","卦","卷","卹","取",
			  "依","侍","佳","使","佬",  "叔","受","味","呵","咖",
			  "供","例","來","侃","佰",  "呸","咕","咀","呻","呷",
			  "併","侈","佩","佻","侖",  "咄","咒","咆","呼","咐",
			  "佾","侏","侑","佺","兔",  "呱","呶","和","咚","呢",
			  "兒","兩","具","其","典",  "周","咋","命","咎","固",
			  "冽","函","刻","券","刷",  "垃","坷","坪","坩","坡",
			  "刺","到","刮","制","剁",  "坦","坤","坼","下一頁","決定"],
			[ "夜","奉","奇","奈","奄",  "帑","幸","庚","店","府",
			  "奔","妾","妻","委","妹",  "底","庖","弦","弧","弩",
			  "妮","姑","姆","姐","姍",  "往","征","彿","彼","忝",
			  "始","姓","妯","妳","姅",  "忠","忽","念","忿","怏",
			  "孟","孤","季","宗","定",  "怔","怯","怵","怖","怪",
			  "官","宜","宙","宛","尚",  "怕","怡","性","怩","怫",
			  "屈","居","屆","岷","岡",  "怛","或","戕","房","戾",
			  "岸","岩","岫","岱","岳",  "所","承","拉","拌","拄",
			  "帘","帚","帖","帕","帛",  "抿","拂","抹","下一頁","決定"],
			[ "招","披","拓","拔","拋",  "杷","枇","枝","林","杯",
			  "拈","抨","抽","押","拐",  "杰","板","枉","松","析",
			  "拙","拇","拍","抵","拚",  "杵","枚","枓","杼","杪",
			  "抱","拘","拖","拗","拆",  "杲","欣","武","歧","歿",
			  "抬","拎","放","斧","於",  "氓","氛","泣","注","泳",
			  "旺","昔","易","昌","昆",  "沱","泌","泥","河","沽",
			  "昂","明","昀","昏","昕",  "沾","沼","波","沫","法",
			  "昊","昇","服","朋","杭",  "泓","沸","泄","油","況",
			  "枋","枕","東","果","杳",  "沮","泗","泅","下一頁","決定"],
			[ "泱","沿","治","泡","泊",  "竺","糾","罔","羋","者",
			  "沬","泯","泜","泖","泠",  "肺","肥","肢","肱","股",
			  "炕","炎","炒","炊","炙",  "肫","肩","肴","肪","肯",
			  "爬","爭","爸","版","牧",  "臥","臾","舍","虎","虱",
			  "物","狀","狎","狙","狗",  "表","軋","采","金","長",
			  "狐","玩","玨","玟","玫",  "門","阜","隹","雨","青",
			  "玥","甽","疝","疙","疚",  "非","亟","哎","垂","建",
			  "的","盂","盲","直","知",  "炬","祆","祉","祈","祇",
			  "矽","秉","秈","空","穹",  "耶","苧","茅","下一頁","決定"],
			[ "苛","苦","茄","若","茂",  "",  "",  "",  "",  "",
			  "茉","苒","苗","英","茁",  "",  "",  "",  "",  "",
			  "苜","苔","苑","苞","苓",  "",  "",  "",  "",  "",
			  "苟","苯","茆","衫","述",  "",  "",  "",  "",  "",
			  "迦","迢","迪","迥","迭",  "",  "",  "",  "",  "",
			  "迫","迤","迨","郊","郎",  "",  "",  "",  "",  "",
			  "郁","郃","限","陋","陌",  "",  "",  "",  "",  "",
			  "降","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "兙","卸","亭","亮","信",  "叛","咬","哀","咨","哉", // 9劃
			  "侵","侯","便","俠","俑",  "咸","咦","咳","哇","哂",
			  "俏","保","促","侶","俘",  "咽","咪","品","哄","哈",
			  "俟","俊","俗","侮","俐",  "咯","咫","咱","咻","咩",
			  "俄","係","俚","俎","俞",  "咧","咿","囿","型","垠",
			  "侷","兗","冒","冑","冠",  "垣","垢","城","垮","垓",
			  "剎","剃","削","前","剌",  "奕","契","奏","奎","奐",
			  "剋","則","勇","勉","勃",  "姜","姘","姿","姣","姨",
			  "勁","匍","南","卻","厚",  "娃","姥","姪","下一頁","決定"],
			[ "姚","姦","威","姻","孩",  "恃","恬","恫","恪","恤",
			  "宣","宦","室","客","宥",  "扁","拜","挖","按","拼",
			  "封","屎","屏","屍","屋",  "拭","持","拮","拽","指",
			  "峙","峒","巷","帝","帥",  "拱","拷","拯","括","拾",
			  "帟","幽","庠","度","弈",  "拴","挑","挂","政","故",
			  "弭","彥","很","待","徊",  "斫","施","既","春","昭",
			  "律","徇","後","徉","怒",  "映","昧","是","星","昨",
			  "思","怠","急","怎","怨",  "昱","昤","曷","柿","染",
			  "恍","恰","恨","恢","恆",  "柱","柔","某","下一頁","決定"],
			[ "柬","架","枯","柵","柩",  "洩","洮","洵","洎","洫",
			  "柯","柄","柑","枴","柚",  "炫","為","炳","炯","炭",
			  "查","枸","柏","柞","柳",  "炸","炮","炤","爰","牲",
			  "枰","柙","柢","柝","柒",  "牯","牴","狩","狠","狡",
			  "歪","殃","殆","段","毒",  "玷","珊","玻","玲","珍",
			  "毗","氟","泉","洋","洲",  "珀","玳","甚","甭","畏",
			  "洪","津","洌","洱","洞",  "界","畎","畋","疫","疤",
			  "洗","活","洽","派","洶",  "疥","疢","疣","癸","皆",
			  "洛","泵","洹","洧","洸",  "皇","皈","盈","下一頁","決定"],
			[ "盆","盃","盅","省","盹",  "胡","胛","胎","胞","胤",
			  "相","眉","看","盾","盼",  "胝","舢","范","虐","虹",
			  "眇","矜","砂","研","砌",  "虻","虺","衍","要","觔",
			  "砍","禹","禺","科","秒",  "計","訂","訃","貞","負",
			  "秋","穿","突","竿","竽",  "赴","赳","趴","軍","軌",
			  "籽","紂","紅","紀","紉",  "酋","酊","重","閂","面",
			  "紇","約","紆","缸","美",  "革","韋","韭","音","頁",
			  "羿","耐","耍","耑","胖",  "風","飛","食","首","香",
			  "胥","胚","胃","胄","背",  "修","叟","哪","下一頁","決定"],
			[ "娜","差","庭","挺","挪",  "逃","追","逅","迸","郡",
			  "眨","矩","砭","祕","祐",  "郝","郢","院","陣","陡",
			  "祠","祖","神","祝","祗",  "陛","陝","除","陘","陞",
			  "祚","級","茫","荒","荔",  "骨","鬼","涎","莒","",
			  "荊","茸","荐","草","茵",  "",  "",  "",  "",  "",
			  "茴","荏","茲","茹","茶",  "",  "",  "",  "",  "",
			  "茗","荀","茱","茨","荃",  "",  "",  "",  "",  "",
			  "蚤","袂","衽","衹","送",  "",  "",  "",  "",  "",
			  "逆","迷","退","迺","迴",  "",  "",  "",  "返回","決定"],
			[ "兛","流","致","乘","亳",  "剔","剛","剝","匪","卿", // 10劃
			  "倌","倍","倣","俯","倦",  "原","厝","哨","唐","唁",
			  "倥","俸","倩","倖","倆",  "哼","哥","哲","唆","哺",
			  "值","借","倚","倒","們",  "唔","哩","哭","員","唉",
			  "俺","倀","倔","倨","俱",  "哮","哦","唧","唇","哽",
			  "倡","個","候","倘","俳",  "唏","圃","圄","埂","埔",
			  "倭","倪","俾","倫","倉",  "埋","埃","夏","套","奘",
			  "兼","冤","冥","冢","凍",  "奚","娑","娘","娟","娛",
			  "凌","准","凋","剖","剜",  "娓","姬","娠","下一頁","決定"],
			[ "娣","娩","娥","娌","娉",  "悟","悚","悍","悔","悌",
			  "孫","屘","宰","害","家",  "悅","悖","扇","拳","挈",
			  "宴","宮","宵","容","宸",  "拿","捎","挾","振","捕",
			  "射","屑","展","屐","峭",  "捂","捆","捏","捉","捐",
			  "峽","峻","峪","峨","峰",  "挽","挫","挨","捍","捌",
			  "島","崁","峴","席","師",  "效","敉","料","旁","旅",
			  "庫","座","弱","徒","徑",  "時","晉","晏","晃","晒",
			  "徐","恙","恣","恥","恐",  "晌","晅","晁","書","朔",
			  "恕","恭","恩","息","悄",  "朕","朗","校","下一頁","決定"],
			[ "核","案","框","桓","根",  "浩","涌","涊","浹","涅",
			  "桂","桔","栩","栗","桌",  "浥","涔","烊","烘","烤",
			  "桑","栽","柴","桐","桀",  "烙","烈","烏","爹","特",
			  "格","桃","株","桅","栓",  "狼","狹","狽","狸","狷",
			  "栘","桁","殊","殉","殷",  "玆","班","珮","珠","珪",
			  "氣","氧","氨","氦","氤",  "珞","畔","畝","畜","畚",
			  "泰","浪","涕","消","涇",  "留","疾","病","症","疲",
			  "浦","浸","海","浙","涓",  "疳","疽","疼","疹","痂",
			  "浬","涉","浮","浚","浴",  "疸","皋","皰","下一頁","決定"],
			[ "益","盍","盎","眩","真",  "羔","翅","翁","耆","耄",
			  "眠","砰","砧","砸","砝",  "耘","耕","耙","耗","耽",
			  "破","砷","砥","砠","砟",  "耿","胱","脂","胰","脅",
			  "砲","祟","秤","秣","秧",  "胭","胴","脆","胸","胳",
			  "租","秦","秩","秘","窄",  "脈","能","脊","胼","胯",
			  "窈","站","笆","笑","粉",  "臭","臬","舀","舐","航",
			  "紡","紗","紋","紊","素",  "舫","舨","般","芻","虔",
			  "索","純","紐","紕","紜",  "蚊","蚪","蚓","蚩","蚌",
			  "納","紙","紛","缺","罟",  "蚣","蚜","衰","下一頁","決定"],
			[ "衷","袁","記","訐","討",  "啊","婀","敖","梃","梆",
			  "訌","訕","訊","託","訓",  "條","殺","琊","瓶","瓷",
			  "訖","訏","訑","豈","豺",  "畢","祥","羞","脩","莎",
			  "豹","財","貢","起","躬",  "莞","莘","荸","莢","莖",
			  "軒","軔","軏","辱","邕",  "莽","莫","莊","莓","莉",
			  "酒","配","酌","釘","針",  "莠","荷","荻","荼","莆",
			  "釗","釜","釙","閃","隻",  "莧","被","袒","袖","袍",
			  "飢","馬","高","鬥","鬲",  "這","逍","通","逗","連",
			  "偌","健","倏","務","匿",  "速","逝","逐","下一頁","決定"],
			[ "逕","逞","造","透","逢",  "",  "",  "",  "",  "",
			  "逖","逛","途","部","郭",  "",  "",  "",  "",  "",
			  "都","陪","陵","陳","陸",  "",  "",  "",  "",  "",
			  "陰","陴","陶","陷","陬",  "",  "",  "",  "",  "",
			  "華","郵","陲","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "兞","兝","唷","堉","梳",  "唱","啖","問","啕","唯", // 11劃
			  "琉","乾","偺","偽","停",  "啤","唸","售","啜","唬",
			  "假","偃","做","偉","偶",  "唳","啁","啗","圈","國",
			  "偎","偕","偵","側","偷",  "圉","域","堅","堊","堆",
			  "偏","偯","偭","兜","冕",  "埠","埤","基","堂","堵",
			  "凰","剪","副","勒","勘",  "執","培","夠","奢","娶",
			  "動","匐","匏","匙","區",  "婁","婉","婦","婪","娼",
			  "匾","參","曼","商","啪",  "婢","婚","婆","婊","孰",
			  "啦","啄","啞","啡","啃",  "寇","寅","寄","下一頁","決定"],
			[ "寂","宿","密","尉","專",  "患","悉","悠","您","惋",
			  "將","屠","屜","屝","崇",  "悴","惦","悽","情","悻",
			  "崆","崎","崛","崖","崢",  "悵","惜","悼","惘","惕",
			  "崑","崩","崔","崙","崤",  "惆","惟","悸","惚","惇",
			  "崧","崗","巢","常","帶",  "戚","戛","扈","掠","控",
			  "帳","帷","康","庸","庶",  "捲","掖","探","接","捷",
			  "庵","庾","張","強","彗",  "捧","掘","措","捱","掩",
			  "彬","彩","彫","得","徙",  "掉","掃","掛","捫","推",
			  "從","徘","徠","徜","恿",  "掄","授","掙","下一頁","決定"],
			[ "採","掬","排","掏","掀",  "梭","梅","梔","梨","梟",
			  "捻","捩","捨","捺","敝",  "梡","梂","欲","毫","毬",
			  "救","教","敗","啟","敏",  "氫","涼","淳","淙","液",
			  "敘","敕","敔","斜","斛",  "淡","淌","淤","添","淺",
			  "斬","族","旋","旌","旎",  "清","淇","淋","涯","淑",
			  "晝","晚","晤","晨","晦",  "涮","淞","淹","涸","混",
			  "晞","曹","勗","望","梁",  "淅","淒","渚","涵","淚",
			  "梯","梢","梓","梵","桿",  "淫","淘","淪","深","淮",
			  "桶","梱","梧","梗","械",  "淨","淆","淄","下一頁","決定"],
			[ "涪","淬","涿","淦","烹",  "硎","票","祭","移","窒",
			  "焉","焊","烽","烯","爽",  "窕","笠","笨","笛","第",
			  "牽","犁","猜","猛","猖",  "符","笙","笞","笮","粒",
			  "猓","猙","率","琅","球",  "粗","粕","絆","絃","紮",
			  "理","現","琍","瓠","甜",  "紹","紼","絀","細","紳",
			  "產","略","畦","異","痔",  "組","累","終","紲","紱",
			  "痕","疵","痊","痍","皎",  "缽","羚","翌","翎","習",
			  "盔","盒","盛","眷","眾",  "耜","聊","聆","脯","脖",
			  "眼","眶","眸","眺","硃",  "脣","脫","脰","下一頁","決定"],
			[ "脤","舂","舵","舷","舶",  "軛","軟","酗","野","釵",
			  "船","處","彪","蛇","蛀",  "釦","釣","釧","釭","釩",
			  "蚶","蛄","蚵","蛆","蛋",  "閉","雀","雪","雩","章",
			  "蚱","蚯","蛉","術","袞",  "竟","頂","頃","魚","鳥",
			  "袈","袋","覓","規","訪",  "鹵","鹿","麥","麻","傀",
			  "訝","訣","訥","許","設",  "唾","堝","媧","廊","描",
			  "訟","訛","訢","豉","豚",  "捶","敢","棻","渠","渦",
			  "販","責","貫","貨","貪",  "菩","萃","菸","萍","菠",
			  "貧","赧","赦","趾","趺",  "菅","萋","菁","下一頁","決定"],
			[ "菱","菴","著","萊","菰",  "",  "",  "",  "",  "",
			  "萌","菌","菽","菲","菊",  "",  "",  "",  "",  "",
			  "萸","萎","萄","菜","萇",  "",  "",  "",  "",  "",
			  "菔","菟","袱","視","象",  "",  "",  "",  "",  "",
			  "貶","距","逮","逵","週",  "",  "",  "",  "",  "",
			  "逸","進","逶","鄂","鄉",  "",  "",  "",  "",  "",
			  "郾","隊","階","隋","陽",  "",  "",  "",  "",  "",
			  "隅","隆","隍","隄","萵",  "",  "",  "",  "",  "",
			  "過","",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "啣","御","棄","淵","疏",  "喻","喬","喱","啾","喉", // 12劃
			  "硫","統","傢","傍","傅",  "喫","喙","圍","堯","堪",
			  "備","傑","傖","傘","傚",  "場","堤","堰","報","堡",
			  "最","凱","割","剴","創",  "堠","壹","壺","奠","婷",
			  "剩","勞","勝","勛","博",  "媚","婿","媒","媛","孳",
			  "厥","啻","喀","喧","啼",  "孱","寒","富","寓","寐",
			  "喊","喝","喘","喂","喜",  "尊","尋","就","嵌","嵐",
			  "喪","喔","喇","喋","喃",  "崴","嵇","巽","幅","帽",
			  "喳","單","喟","喲","喚",  "幀","幃","幾","下一頁","決定"],
			[ "廁","廂","廄","弼","彭",  "換","摒","揚","揹","敞",
			  "復","循","徨","惑","惡",  "敦","散","斑","斐","斯",
			  "悲","悶","惠","愜","愣",  "普","晰","晴","晶","景",
			  "惺","愕","惰","惻","惴",  "暑","智","晾","晷","曾",
			  "慨","惱","愎","惶","愉",  "替","期","朝","棺","棕",
			  "愀","愒","戟","扉","掣",  "棠","棘","棗","椅","棟",
			  "掌","揀","揩","揉","揆",  "棵","森","棧","棹","棒",
			  "揍","插","揣","提","握",  "棲","棣","棋","棍","植",
			  "揖","揭","揮","援","揪",  "椒","椎","棉","下一頁","決定"],
			[ "棚","楮","款","欺","欽",  "焙","焚","焦","焰","無",
			  "殘","殖","殼","毯","氮",  "然","煮","焜","牌","犄",
			  "氯","氬","港","游","湔",  "犀","猶","猥","猴","猩",
			  "渡","渲","湧","湊","渥",  "琺","琪","琳","琢","琥",
			  "渣","減","湛","湘","渤",  "琵","琶","琴","琯","琛",
			  "湖","湮","渭","湯","渴",  "琦","琨","甥","甦","畫",
			  "湍","渺","測","湃","渝",  "番","痢","痛","痣","痙",
			  "渾","滋","溉","渙","湎",  "痘","痞","痠","登","發",
			  "湣","湄","湲","湩","湟",  "皖","皓","皴","下一頁","決定"],
			[ "盜","睏","短","硝","硬",  "腕","腔","腋","腑","腎",
			  "硯","稍","稈","程","稅",  "脹","腆","脾","腌","腓",
			  "稀","窘","窗","窖","童",  "腴","舒","舜","虛","蛟",
			  "竣","等","策","筆","筐",  "蛙","蛭","蛔","蛛","蛤",
			  "筒","答","筍","筋","筏",  "蛐","蛞","街","裁","裂",
			  "筑","粟","粥","絞","結",  "覃","註","詠","評","詞",
			  "絨","絕","紫","絮","絲",  "証","詁","詔","詛","詐",
			  "絡","給","絢","絰","絳",  "詆","訴","診","訶","詖",
			  "善","翔","翕","耋","聒",  "貂","貯","貼","下一頁","決定"],
			[ "貳","貽","賁","費","賀",  "集","雇","雯","雲","韌",
			  "貴","買","貿","貸","越",  "項","順","須","飧","飪",
			  "超","趁","跎","跋","跚",  "飯","飩","飲","飭","馮",
			  "跑","跌","跛","跆","軻",  "馭","黃","黍","黑","傲",
			  "軸","軼","辜","酣","酥",  "募","嗟","塔","塭","塊",
			  "量","鈔","鈕","鈣","鈉",  "嫂","嵯","惹","慌","愧",
			  "鈞","鈍","鈐","鈇","鈑",  "戢","搓","搭","搽","搜",
			  "閔","閏","開","閑","間",  "搔","敬","榔","極","椰",
			  "閒","閎","雁","雅","雄",  "楛","毽","滑","下一頁","決定"],
			[ "爺","猾","瑯","瑛","祺",  "遑","逾","遁","鄒","鄗",
			  "祿","萬","禽","綁","絛",  "釉","鉅","隘","隔","隕",
			  "腱","艇","蒂","葷","落",  "雋","鼎","禍","筵","蒐",
			  "萱","葵","葦","葫","葉",  "隙","",  "",  "",  "",
			  "葬","葛","萼","葡","董",  "",  "",  "",  "",  "",
			  "葩","葭","葆","蜓","裙",  "",  "",  "",  "",  "",
			  "補","裡","裕","裒","運",  "",  "",  "",  "",  "",
			  "遊","道","遂","達","逼",  "",  "",  "",  "",  "",
			  "違","遐","遇","遏","遍",  "",  "",  "",  "返回","決定"],
			[ "兡","嗧","肅","亂","傭",  "填","塌","塢","塒","塋", // 13劃
			  "債","傳","僅","傾","催",  "奧","嫁","嫉","嫌","媾",
			  "傷","傻","傯","僇","剿",  "媽","媼","媳","媲","嵩",
			  "剷","剽","勦","勤","勢",  "幌","幹","廉","廈","弒",
			  "勣","匯","嗨","嗓","嗦",  "彙","徬","微","愚","意",
			  "嗎","嗜","嗇","嗑","嗣",  "慈","感","想","愛","愁",
			  "嗤","嗯","嗚","嗡","嗅",  "愈","慎","慄","慍","愾",
			  "嗆","嗥","嗉","園","圓",  "愴","愍","愆","愷","戡",
			  "塞","塑","塘","塗","塚",  "搾","搞","搪","下一頁","決定"],
			[ "搬","搏","損","搶","搖",  "滅","溥","溘","溼","溺",
			  "搗","搆","斟","新","暗",  "溫","準","溜","滄","滔",
			  "暉","暇","暈","暖","暄",  "溪","溧","溴","煎","煙",
			  "暘","暍","會","業","楚",  "煩","煤","煉","照","煜",
			  "楷","楠","楔","概","楊",  "煬","煦","煌","煥","煞",
			  "楨","楫","楞","楓","楹",  "煆","煨","煖","牒","猷",
			  "榆","楝","楣","歇","歲",  "獅","猿","瑚","瑕","瑟",
			  "毀","殿","溢","溯","滓",  "瑞","瑁","琿","瑙","瑜",
			  "溶","滂","源","溝","滇",  "當","畸","瘀","下一頁","決定"],
			[ "痰","瘁","痲","痱","痺",  "筮","筧","粱","粳","粵",
			  "痿","痴","痳","盞","盟",  "經","絹","綑","綏","置",
			  "睛","睫","睦","睞","督",  "罩","罪","署","義","羨",
			  "睹","睪","睬","睜","睥",  "群","聖","聘","肆","肄",
			  "睨","睢","矮","碎","碰",  "腰","腸","腥","腮","腳",
			  "碗","碘","碌","碉","硼",  "腫","腹","腺","腦","舅",
			  "碑","碓","硿","禁","稜",  "虞","虜","號","蛹","蜈",
			  "稚","稠","稔","稟","稞",  "蜇","蜀","蛾","蛻","蜂",
			  "窟","窠","筷","節","筠",  "蜃","蜆","蜊","下一頁","決定"],
			[ "衙","裟","裔","裘","裝",  "跪","跤","跦","躲","較",
			  "裊","覜","解","詫","該",  "載","軾","輊","辟","農",
			  "詳","試","詩","詰","誇",  "酬","酪","酩","鈷","鉗",
			  "詼","詣","誠","話","誅",  "鈸","鈽","鉀","鈾","鉛",
			  "詭","詢","詮","詬","詹",  "鉋","鉤","鉑","鈴","鉉",
			  "詻","訾","詨","豢","貊",  "鉍","鈹","鈿","鉚","閘",
			  "貉","賊","資","賈","賄",  "雍","雉","雊","雷","電",
			  "貲","賃","賂","賅","跡",  "雹","零","靖","靴","靶",
			  "跟","跨","路","跳","跺",  "預","頑","頓","下一頁","決定"],
			[ "頊","頒","頌","飼","飴",  "蒞","蒲","蒜","蓋","蒸",
			  "飽","飾","馳","馱","馴",  "蓀","蓓","蒼","蓑","蓊",
			  "髡","鳩","麂","鼓","鼠",  "褂","裸","裨","褚","裯",
			  "像","嗷","嘟","嗶","墓",  "遠","遘","遜","遣","遙",
			  "夢","寞","幕","廓","摸",  "遞","遢","遝","遛","鄙",
			  "槐","槌","漓","漠","漣",  "鄘","鄞","障","際","骯",
			  "滌","瑰","甄","瞄","睡",  "骰","魁","魂","嘩","蓮",
			  "禎","福","窩","腿","與",  "蔭","蓬","誕","諍","遨",
			  "蓉","蒿","蓆","蓄","蒙",  "",  "",  "",  "返回","決定"],
			[ "毓","僧","僮","僥","僖",  "嫡","嫦","嫩","嫗","嫖", // 14劃
			  "僭","僚","僕","僑","僱",  "嫘","嫣","孵","寧","寡",
			  "僎","僩","兢","凳","劃",  "寥","實","寨","寢","寤",
			  "劂","匱","厭","嗾","嘀",  "察","對","屢","嶄","嶇",
			  "嘛","嘗","嗽","嘔","嘆",  "幛","幣","幗","幔","廖",
			  "嘉","嘍","嘎","嘖","嘈",  "弊","彆","彰","慇","愿",
			  "嘐","團","圖","塵","塾",  "態","慷","慢","慣","慟",
			  "境","墊","塹","墅","塽",  "慚","慘","慵","截","撇",
			  "壽","夥","夤","奪","奩",  "摘","摔","摟","下一頁","決定"],
			[ "摺","摑","摧","搴","摭",  "漆","漱","漸","漲","漕",
			  "摻","敲","斡","旗","旖",  "漫","漯","漪","滬","漁",
			  "暢","暨","暝","榜","榨",  "滲","滷","熔","熙","煽",
			  "榕","槁","榮","槓","構",  "熊","熄","熒","爾","犒",
			  "榛","榷","榻","榫","榴",  "犖","獄","獐","瑤","瑣",
			  "槍","榭","榦","槃","榣",  "瑪","瑭","疑","瘧","瘍",
			  "歉","歌","氳","漳","演",  "瘋","瘉","瘓","盡","監",
			  "滾","滴","漩","漾","漬",  "睽","睿","磁","碟","碧",
			  "漏","漂","漢","滿","滯",  "碳","碩","碣","下一頁","決定"],
			[ "種","稱","窪","竭","端",  "膀","膏","膈","膊","膂",
			  "管","箕","箋","算","箝",  "臧","臺","舔","舞","艋",
			  "箔","箏","箸","箇","箄",  "蜿","蜜","蜻","蜢","蜥",
			  "粹","粽","精","綻","綰",  "蜴","蜘","蝕","蜷","蜩",
			  "綜","綽","綾","綠","緊",  "裳","裴","裹","製","誦",
			  "綴","網","綱","綺","綢",  "誌","語","誣","認","誡",
			  "綿","綵","綸","維","緒",  "誓","誤","說","誥","誨",
			  "緇","綬","罰","翠","翡",  "誘","誑","誚","誧","豪",
			  "翟","聞","聚","肇","腐",  "貍","貌","賓","下一頁","決定"],
			[ "賑","賒","赫","趙","趕",  "餌","餉","駁","髦","鳴",
			  "跼","輔","輒","輕","輓",  "鳶","鳳","麼","鼻","齊",
			  "辣","酵","酸","酷","酴",  "厲","墟","墜","墮","寬",
			  "鉸","銬","銀","銅","銘",  "廣","慝","慕","摹","暮",
			  "銖","鉻","銓","銜","銨",  "暱","槨","模","熬","璃",
			  "鉼","銑","閡","閨","閩",  "瘩","瘟","瘦","瞇","磋",
			  "閣","閥","閤","雌","雒",  "箠","綞","膜","蔗","蔽",
			  "需","靼","鞅","韶","頗",  "蔚","蔓","蔑","蔣","蔡",
			  "領","颯","颱","餃","餅",  "蔔","蔥","蓿","下一頁","決定"],
			[ "蔆","螂","蝸","褐","複",  "",  "",  "",  "",  "",
			  "褓","褕","褊","適","遮",  "",  "",  "",  "",  "",
			  "遭","鄰","鄭","鄧","鄱",  "",  "",  "",  "",  "",
			  "鋁","閭","霆","養","骷",  "",  "",  "",  "",  "",
			  "魅","魄","撾","曄","樺",  "",  "",  "",  "",  "",
			  "甍","褪","褡","錚","隧",  "",  "",  "",  "",  "",
			  "隨","",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "糎","徹","撤","澈","億",  "寫","層","履","嶝","嶔", // 15劃
			  "儀","僻","僵","價","儂",  "幢","幟","幡","廢","廚",
			  "儈","儉","儅","凜","劇",  "廟","廝","廠","彈","影",
			  "劈","劉","劍","劊","勰",  "德","徵","慶","慧","慮",
			  "嘮","嘻","嘹","嘲","嘿",  "憂","慼","慰","慫","慾",
			  "噓","噎","噗","噴","嘶",  "憧","憐","憫","憎","憬",
			  "嘰","墀","增","墳","墩",  "憚","憤","憔","憮","戮",
			  "墦","奭","嬉","嫻","嬋",  "摩","摯","撞","撲","撈",
			  "嫵","嬌","嬈","寮","審",  "撐","撰","撥","下一頁","決定"],
			[ "撓","撕","撩","撒","撮",  "潮","澎","潺","潰","潤",
			  "播","撫","撚","撬","撙",  "澗","潘","滕","潯","潠",
			  "撢","撳","敵","敷","數",  "潟","熟","熱","熨","牖",
			  "暫","暴","樣","樟","樁",  "犛","獎","獗","瑩","璋",
			  "樞","標","槽","樓","樊",  "瑾","璀","畿","瘠","瘤",
			  "槳","樂","樅","槭","樑",  "瘡","瘢","皚","皺","盤",
			  "歐","歎","殤","毅","毆",  "瞎","瞌","瞑","瞋","磅",
			  "漿","潼","澄","潑","潦",  "確","磊","碾","磕","碼",
			  "潔","澆","潭","潛","潸",  "磐","稿","稼","下一頁","決定"],
			[ "穀","稽","稷","稻","窯",  "蝙","蝗","蝌","蝓","衛",
			  "窮","箭","箱","範","箴",  "衝","褒","誼","諒","談",
			  "篆","篇","篁","篌","糊",  "諄","請","諸","課","諉",
			  "締","練","緯","緘","緬",  "諂","調","誰","論","誶",
			  "緝","編","緣","線","緞",  "誹","諛","豌","豎","豬",
			  "緩","緙","緲","緹","罵",  "賠","賞","賦","賤","賬",
			  "罷","羯","翩","耦","膛",  "賭","賢","賣","賜","質",
			  "膝","膠","膚","膘","蔬",  "賡","赭","趟","趣","踫",
			  "蝴","蝶","蝠","蝦","蝨",  "踐","踝","踢","下一頁","決定"],
			[ "踏","踩","踟","踡","踞",  "餘","駝","駐","駟","駛",
			  "躺","輝","輛","輟","輩",  "駑","駕","駒","駙","髮",
			  "輦","輪","輜","輞","輥",  "髯","鬧","魷","魯","鴆",
			  "遷","醇","醉","醋","醃",  "鴉","鴃","麩","麾","黎",
			  "鋅","銻","銷","鋪","鋤",  "墨","齒","冪","噙","噢",
			  "銳","銼","鋒","鋇","鋰",  "噶","導","懊","撻","擒",
			  "銲","閱","霄","震","霉",  "暹","橄","橢","橡","澳",
			  "靠","鞍","鞋","鞏","頡",  "璜","甌","艘","蕊","蕙",
			  "頫","頜","颳","餓","餒",  "蕈","蕨","蕩","下一頁","決定"],
			[ "蕃","蕉","蕪","蕞","褲",  "",  "",  "",  "",  "",
			  "褥","褫","諾","豫","貓",  "",  "",  "",  "",  "",
			  "遵","遴","選","遲","遼",  "",  "",  "",  "",  "",
			  "遺","鄴","險","骸","骼",  "",  "",  "",  "",  "",
			  "懂","邁","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "兣","嘴","嘯","緻","儒",  "擁","擋","撼","據","擄", // 16劃
			  "儘","儔","儐","儕","冀",  "擇","擂","操","撿","擔",
			  "凝","劑","劓","勳","噫",  "整","曆","曉","曇","暸",
			  "噹","噩","噤","噸","噪",  "樽","樸","橙","橫","橘",
			  "器","噥","噱","噯","噬",  "樹","橋","橇","樵","機",
			  "壁","墾","壇","壅","奮",  "橈","歙","歷","氅","濂",
			  "嬝","嬴","學","寰","彊",  "澱","澡","濃","澤","濁",
			  "憲","憑","憩","憊","懍",  "澧","激","澹","澶","澦",
			  "憶","憾","懈","戰","擅",  "澠","澴","熾","下一頁","決定"],
			[ "燉","燐","燒","燈","燕",  "糖","縊","縑","縈","縛",
			  "熹","燎","燙","燜","燃",  "縣","縞","縝","縉","縐",
			  "燄","獨","璣","璘","璟",  "罹","羲","翰","翱","翮",
			  "璞","瓢","瘴","瘸","瘺",  "耨","膳","膩","膨","臻",
			  "盧","盥","瞠","瞞","瞟",  "興","艙","蕭","螃","螟",
			  "瞥","磨","磚","磬","磧",  "螞","螢","融","衡","親",
			  "積","穎","穆","穌","穋",  "覦","諦","諺","諫","諱",
			  "窺","篙","簑","築","篤",  "謀","諜","諧","諮","謁",
			  "篛","篡","篩","篦","糕",  "謂","諷","諭","下一頁","決定"],
			[ "諳","諶","諼","豭","賴",  "頰","頸","頻","頷","頭",
			  "蹄","踱","踴","蹂","踹",  "頹","頤","餐","館","餞",
			  "踵","輻","輯","輸","輳",  "餛","餡","餚","駭","駢",
			  "辨","辦","醒","錠","錶",  "駱","髻","髭","鬨","鮑",
			  "鋸","錳","錯","錢","鋼",  "鴕","鴣","鴦","鴨","鴒",
			  "錫","錄","錐","錦","錡",  "鴛","默","黔","龍","勵",
			  "錕","錮","錙","閻","雕",  "嶼","擎","擭","檠","濛",
			  "霎","霑","霖","霍","霓",  "濩","燧","營","燠","獲",
			  "霏","靛","靜","靦","鞘",  "瞰","磺","禧","下一頁","決定"],
			[ "禪","窿","篷","篠","糢",  "",  "",  "",  "",  "",
			  "糙","縫","聱","舉","薪",  "",  "",  "",  "",  "",
			  "薄","蕾","薜","薑","薔",  "",  "",  "",  "",  "",
			  "薯","薛","薇","薨","薊",  "",  "",  "",  "",  "",
			  "薦","蟒","蟆","褶","褸",  "",  "",  "",  "",  "",
			  "謎","謊","蹉","避","遽",  "",  "",  "",  "",  "",
			  "還","邂","邀","鄹","醜",  "",  "",  "",  "",  "",
			  "錨","鍵","鍋","錘","隱",  "",  "",  "",  "",  "",
			  "薩","",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "禦","龜","優","償","儡",  "曖","檀","檔","檄","檢", // 17劃
			  "儲","嚎","嚀","嚐","嚅",  "檜","櫛","檣","橾","檗",
			  "嚇","嚏","壕","壓","壑",  "檐","歜","殮","毚","氈",
			  "壎","嬰","嬪","嬤","孺",  "濘","濱","濟","濠","濤",
			  "尷","屨","嶺","嶽","嶸",  "濫","濯","澀","濬","濡",
			  "幫","彌","徽","應","懇",  "濕","濮","濰","燮","燦",
			  "懦","懋","戲","戴","擊",  "燥","燭","燬","燴","爵",
			  "擘","擠","擰","擦","擬",  "牆","獰","璩","環","璦",
			  "擱","擢","斂","斃","曙",  "璨","癆","療","下一頁","決定"],
			[ "癌","盪","瞳","瞪","瞬",  "臆","臃","膺","臂","臀",
			  "瞧","瞭","矯","磷","磴",  "膿","膽","臉","膾","臨",
			  "磯","礁","穗","簇","簍",  "艱","虧","蟀","蟑","螳",
			  "篾","簌","糠","糜","糞",  "螫","螻","螺","蟈","蟋",
			  "糟","糝","縮","績","繆",  "褻","襄","褽","覬","謗",
			  "縷","縲","繃","總","縱",  "謙","講","謠","謝","謄",
			  "繅","繁","縴","縹","繈",  "謐","豁","谿","豳","賺",
			  "縵","縿","縯","罄","翳",  "賽","購","賸","賻","趨",
			  "翼","聲","聰","聯","聳",  "蹋","蹈","蹊","下一頁","決定"],
			[ "轄","輾","轂","轅","輿",  "鼾","齋","嚮","壙","擴",
			  "醣","醞","鍍","鎂","鍊",  "擲","朦","檬","歟","獷",
			  "鍥","鍾","鍬","鍛","鍰",  "甕","癘","禮","簧","舊",
			  "鍚","鍔","闊","闋","闌",  "藏","藍","藐","藉","薰",
			  "闈","闆","隸","雖","霜",  "薺","薹","謨","贅","蹕",
			  "霞","鞠","韓","顆","颶",  "邇","邃","邈","鎚","餿",
			  "餵","騁","駿","鮮","鮫",  "餽","髁","魏","魎","魍",
			  "鮪","鮭","鴻","鴿","麋",  "鯈","襖","譁","",  "",
			  "黏","點","黜","黝","黛",  "",  "",  "",  "返回","決定"],
			[ "叢","嚕","壘","嬸","彞",  "穢","穠","竄","竅","簪", // 18劃
			  "懣","戳","擾","攆","擺",  "簞","簣","簡","糧","織",
			  "擻","擷","斷","曜","檳",  "繕","繞","繚","繒","繙",
			  "櫃","檻","檸","櫂","檮",  "罈","翹","翻","職","聶",
			  "檯","歸","殯","瀉","瀋",  "臍","臏","蟯","蟬","蟲",
			  "濾","瀆","濺","瀑","瀏",  "蟠","覆","覲","觴","謹",
			  "燻","燼","燾","燸","獵",  "謬","謫","豐","蹙","蹣",
			  "璧","璿","癖","癒","瞽",  "蹦","蹤","蹟","軀","轉",
			  "瞿","瞻","瞼","礎","穡",  "醫","醬","釐","下一頁","決定"],
			[ "鎔","鎊","鎖","鎢","鎳",  "鼬","懵","曠","櫚","瓊",
			  "鎮","鎬","鎰","鎘","鎗",  "矇","禱","穫","繭","藩",
			  "闔","闖","闐","闕","離",  "藝","藪","藕","藤","藥",
			  "雜","雙","雛","雞","霤",  "藷","襠","襟","躇","邊",
			  "鞣","鞦","鞭","韹","額",  "邋","鏈","隴","霧","颼",
			  "顏","題","顎","顓","颺",  "",  "",  "",  "",  "",
			  "餾","餮","馥","騎","鬃",  "",  "",  "",  "",  "",
			  "鬆","鯊","鯉","鯽","鯀",  "",  "",  "",  "",  "",
			  "鵑","鵝","鵠","黠","鼕",  "",  "",  "",  "返回","決定"],
			[ "簫","繡","轍","儳","嚥",  "簽","簷","籀","繫","繹", // 19劃
			  "嚨","壞","壟","壢","寵",  "繩","繪","繳","羅","羶",
			  "龐","廬","懲","懷","懶",  "羹","羸","臘","蟻","蠅",
			  "攀","攏","曝","櫥","櫝",  "蠍","蟹","蟾","襞","譜",
			  "櫓","瀛","瀟","瀨","瀚",  "識","證","譚","譎","譏",
			  "瀝","瀕","瀘","爆","爍",  "譆","譙","贈","贊","蹼",
			  "牘","犢","獸","獺","璽",  "蹲","蹶","蹬","蹺","蹴",
			  "瓣","疇","疆","癟","癡",  "轔","轎","辭","醱","醮",
			  "礙","穩","簾","簿","簸",  "鏡","鏑","鏟","下一頁","決定"],
			[ "鏃","鏜","鏝","鏖","鏢",  "蘑","藺","蘆","蘋","蘇",
			  "鏍","鏘","鏤","鏗","鏨",  "蘊","襤","警","躉","躂",
			  "關","難","霪","靡","韜",  "騷","襪","魑","",  "",
			  "韻","類","願","顛","饅",  "",  "",  "",  "",  "",
			  "饉","騖","騙","鬍","鯨",  "",  "",  "",  "",  "",
			  "鯧","鯖","鯛","鶉","鵡",  "",  "",  "",  "",  "",
			  "鵲","鵪","鵬","麒","麗",  "",  "",  "",  "",  "",
			  "麓","麴","勸","嚴","孽",  "",  "",  "",  "",  "",
			  "癢","礦","礪","藻","藹",  "",  "",  "",  "返回","決定"],
			[ "嚷","嚶","嚼","壤","孀",  "譬","譯","譟","譫","贏", // 20劃
			  "孃","寶","巉","懸","懺",  "贍","躁","躅","醴","釋",
			  "攘","攔","攙","曦","朧",  "鐘","鐃","闡","霰","飄",
			  "櫬","瀾","瀰","瀲","爐",  "饒","饑","馨","騫","騰",
			  "獻","瓏","癥","礬","礫",  "騵","鰓","鰍","鹹","麵",
			  "竇","競","籌","籃","籍",  "黨","鼯","齟","齣","齡",
			  "糯","糰","辮","繽","繼",  "巍","灌","犧","蘗","蘭",
			  "纂","罌","耀","臚","艦",  "蘚","蠣","襬","譴","護",
			  "蠔","蠕","覺","觸","議",  "譽","鐫","響","下一頁","決定"],
			[ "饗","驀","髏","魔","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "鏽","儷","儸","囁","囀",  "霸","霹","露","顧","顥", // 21劃
			  "囂","夔","屬","懼","懾",  "驅","驃","騾","鰭","鰥",
			  "攝","攜","斕","曩","櫻",  "鶯","鶴","鷂","鶸","麝",
			  "欄","櫺","殲","爛","瓖",  "黯","鼙","齜","齦","齧",
			  "瓔","癩","矓","籐","纏",  "儼","囈","權","歡","癮",
			  "續","羼","蠢","蠡","蠟",  "禳","臟","襯","觼","躑",
			  "覽","贓","躊","躍","躋",  "酈","韃","髒","鰱","髓",
			  "轟","辯","醺","鐮","鐳",  "",  "",  "",  "",  "",
			  "鐵","鐺","鐸","鐲","闢",  "",  "",  "",  "返回","決定"],
			[ "儻","囊","囉","孿","巔",  "囌","巖","竊","蘸","蘿", // 22劃
			  "巒","彎","懿","攤","灑",  "邐","邏","驚","體","髑",
			  "灘","玀","瓤","疊","癬",  "",  "",  "",  "",  "",
			  "籠","籟","聾","聽","襲",  "",  "",  "",  "",  "",
			  "讀","贖","贗","躓","轡",  "",  "",  "",  "",  "",
			  "鑄","鑑","鑒","霽","霾",  "",  "",  "",  "",  "",
			  "韁","顫","饕","驕","驍",  "",  "",  "",  "",  "",
			  "鬚","鱉","鰾","鰻","鷓",  "",  "",  "",  "",  "",
			  "鷗","鼴","齬","齪","龔",  "",  "",  "",  "返回","決定"],
			[ "戀","攣","攫","攪","曬",  "",  "",  "",  "",  "",   // 23劃
			  "欐","瓚","籤","籣","籥",  "",  "",  "",  "",  "",
			  "纓","纖","纔","臢","蠱",  "",  "",  "",  "",  "",
			  "變","鑣","鑠","鑤","靨",  "",  "",  "",  "",  "",
			  "顯","饜","驛","驗","鱔",  "",  "",  "",  "",  "",
			  "鱗","鱖","鷥","麟","黴",  "",  "",  "",  "",  "",
			  "罐","魘","鼇","髖","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "囑","壩","攬","灞","癱",  "",  "",  "",  "",  "",   // 24劃
			  "癲","矗","羈","蠶","蠹",  "",  "",  "",  "",  "",
			  "衢","讓","讒","讖","艷",  "",  "",  "",  "",  "",
			  "贛","釀","鑪","靂","靈",  "",  "",  "",  "",  "",
			  "靄","韆","顰","驟","鬢",  "",  "",  "",  "",  "",
			  "鱟","鷹","鷺","鹼","鹽",  "",  "",  "",  "",  "",
			  "齷","齲","籬","觀","黌",  "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "廳","欖","灣","籮","蠻",  "",  "",  "",  "",  "",   // 25劃
			  "躡","鑲","鑰","顱","饞",  "",  "",  "",  "",  "",
			  "鬣","韉","",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "釁","灤","矚","讚","鑷",  "",  "",  "",  "",  "",   // 26劃
			  "驢","驥","躪","釅","",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "纜","讜","鑽","鑾","鑼",  "",  "",  "",  "",  "",   // 27劃
			  "鱷","鱸","黷","",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "豔","鑿","鸚","鸛","",    "",  "",  "",  "",  "",   // 28劃
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "驪","鬱","",  "",  "",    "",  "",  "",  "",  "",   // 29劃
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "爨","鸞","",  "",  "",    "",  "",  "",  "",  "",   // 30劃
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
			[ "籲","",  "",  "",  "",    "",  "",  "",  "",  "",   // 32劃
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "",  "",
			  "",  "",  "",  "",  "",    "",  "",  "",  "返回","決定"],
		];

	/* 拡張 */
	const orig_Window_NameInput_table = Window_NameInput.prototype.table;
	Window_NameInput.prototype.table = function() {
		if ($gameSystem.isChinese()) {
			return [
				Window_NameInput.CHINESE_TRADITIONAL_LATIN1,
				Window_NameInput.CHINESE_TRADITIONAL_LATIN2,
				Window_NameInput.CHINESE_TRADITIONAL_LATIN3,
				Window_NameInput.CHINESE_TRADITIONAL_HANZI_INDEX,
				...Window_NameInput.CHINESE_TRADITIONAL_ZHUYIN_INDEX,
				...Window_NameInput.CHINESE_TRADITIONAL_STROKE_INDEX,
			];
		} else if ($gameSystem.isKorean()) {
			return [
				Window_NameInput.KOREAN1,
				Window_NameInput.KOREAN2,
				Window_NameInput.KOREAN3
			];
		} else if ($gameSystem.isJapanese()) {
			return [
				Window_NameInput.JAPAN1,
				Window_NameInput.JAPAN2,
				Window_NameInput.JAPAN3,
				Window_NameInput.JAPAN4,
				...Window_NameInput.JAPAN_KANJI_LEVEL1,
				...Window_NameInput.JAPAN_KANJI_LEVEL2,
			];
		} else {
			return orig_Window_NameInput_table.call(this);
		}
	};

	const orig_Window_NameInput_cursorPagedown = Window_NameInput.prototype.cursorPagedown;
	Window_NameInput.prototype.cursorPagedown = function() {
		if ($gameSystem.isChinese() && this._page == (CharacterBoardPages - 1)) {
			this._page = -1;
		} else if ($gameSystem.isJapanese() && this._page == (CharacterBoardPages - 1)) {
			this._page = -1;
		} else if ($gameSystem.isChinese() && (this._page >= CharacterBoardPages) && (this.table()[this._page][88] == "返回")) {
			this._page = CharacterBoardPages - 2;
		} else if ($gameSystem.isJapanese() && (this._page >= CharacterBoardPages) && (this.table()[this._page][88] == "戻る")) {
			this._page = CharacterBoardPages - 2;
		}
		orig_Window_NameInput_cursorPagedown.call(this);
	};

	const orig_Window_NameInput_cursorPageup = Window_NameInput.prototype.cursorPageup;
	Window_NameInput.prototype.cursorPageup = function() {
		if ($gameSystem.isChinese() && (this._page == 0)) {
			this._page = CharacterBoardPages;
		} else if ($gameSystem.isJapanese() && (this._page == 0)) {
			this._page = CharacterBoardPages;
		} else if ($gameSystem.isChinese() && (this._page >= CharacterBoardPages) && (this.table()[this._page - 1][88] == "返回")) {
			this._page = CharacterBoardPages;
		} else if ($gameSystem.isJapanese() && (this._page >= CharacterBoardPages) && (this.table()[this._page - 1][88] == "戻る")) {
			this._page = CharacterBoardPages;
		}
		orig_Window_NameInput_cursorPageup.call(this);
	};

	const orig_Window_NameInput_processBack = Window_NameInput.prototype.processBack;
	Window_NameInput.prototype.processBack = function() {
		if (returnWithCancelButton && ($gameSystem.isChinese() || $gameSystem.isJapanese()) && this._page >= CharacterBoardPages) {
			this._page = CharacterBoardPages - 1;
			this.refresh();
			SoundManager.playCancel();
		} else {
			orig_Window_NameInput_processBack.call(this);
		}
	};

	const orig_Window_NameInput_processOk = Window_NameInput.prototype.processOk;
	Window_NameInput.prototype.processOk = function() {
		if (this.character() && $gameSystem.isChinese() && this._page == (CharacterBoardPages - 1)) {
			this._page = Window_NameInput.CHINESE_TRADITIONAL_INDEX[this._index];
			this.refresh();
			if (this._page == CharacterBoardPages - 1) {
				this.playBuzzerSound();
			} else {
				this.playOkSound();
			}
		} else if (this.character() && $gameSystem.isJapanese() && this._page == (CharacterBoardPages - 1)) {
			this._page = Window_NameInput.JAPAN_KANJI_INDEX[this._index];
			this.refresh();
			if (this._page == CharacterBoardPages - 1) {
				this.playBuzzerSound();
			} else {
				this.playOkSound();
			}
		} else {
			orig_Window_NameInput_processOk.call(this);
		}
	};

	/* ハングル字母合成 한글 자모 합성 */
	const koreanChoseong = {
		"ㄱ":  0, "ㄴ":  2, "ㄷ":  3, "ㄹ":  5, "ㅁ":  6,
		"ㅂ":  7, "ㅅ":  9, "ㅇ": 11, "ㅈ": 12,
		"ㅊ": 14, "ㅋ": 15, "ㅌ": 16, "ㅍ": 17, "ㅎ": 18,
		"ㄲ":  1, "ㄸ":  4, "ㅃ":  8, "ㅆ": 10, "ㅉ": 13
	};
	const koreanVowel = {
		"ㅏ":  0, "ㅑ":  2, "ㅓ":  4, "ㅕ":  6, "ㅗ":  8,
		"ㅛ": 12, "ㅜ": 13, "ㅠ": 17, "ㅡ": 18, "ㅣ": 20,
		"ㅐ":  1, "ㅒ":  3, "ㅔ":  5, "ㅖ":  7,
		"ㅘ":  9, "ㅙ": 10, "ㅚ": 11,
		"ㅝ": 14, "ㅞ": 15, "ㅟ": 16, "ㅢ": 19
	};
	const koreanJongseong = {
		"ㄱ":  1, "ㄴ":  4, "ㄷ":  7, "ㄹ":  8, "ㅁ": 16,
		"ㅂ": 17, "ㅅ": 19, "ㅇ": 21, "ㅈ": 22,
		"ㅊ": 23, "ㅋ": 24, "ㅌ": 25, "ㅍ": 26, "ㅎ": 27,
		"ㄲ":  2, "ㄳ":  3, "ㄵ":  5, "ㄶ":  6,
		"ㄺ":  9, "ㄻ": 10, "ㄼ": 11, "ㄽ": 12, "ㄾ": 13,
		"ㄿ": 14, "ㅀ": 15, "ㅄ": 18, "ㅆ": 20
	};
	const composeKorean = function(kor1, kor2) {
		if ((koreanChoseong[kor1] !== undefined) && (koreanVowel[kor2] !== undefined)) {
			return String.fromCodePoint(0xac00 + koreanChoseong[kor1] * 0x24c + koreanVowel[kor2] * 0x1c);
		} else if ((kor1.codePointAt(0) >= 0xac00) && (kor1.codePointAt(0) <= 0xd7a3) && ((kor1.codePointAt(0) - 0xac00) % 0x1c == 0) && (koreanJongseong[kor2] !== undefined)) {
			return String.fromCodePoint(kor1.codePointAt(0) + koreanJongseong[kor2]);
		} else {
			return "";
		}
	};

	const orig_Window_NameInput_onNameAdd = Window_NameInput.prototype.onNameAdd;
	Window_NameInput.prototype.onNameAdd = function() {
		const lastChar = this._editWindow.name().substr(-1, 1);
		if ($gameSystem.isKorean() && (this._index >= 20) && composeKorean(lastChar, this.character())) {
			this._editWindow.back();
			this._editWindow.add(composeKorean(lastChar, this.character()));
			this.playOkSound();
		} else {
			orig_Window_NameInput_onNameAdd.call(this);
		}
	};

})();
