//=============================================================================
// RPG Maker MZ - Chokuzen
//=============================================================================

/*:
 * @target MZ
 * @plugindesc Alternative save/load screen layout.
 * @author Yoji Ojima
 *
 * @help AltSaveScreen.js
 *
 * This plugin changes the layout of the save/load screen.
 * It puts the file list on the top and the details on the bottom.
 *
 * It does not provide plugin commands.
 */

/*:ja
 * @target MZ
 * @plugindesc セーブ／ロード画面のレイアウトを変更します。
 * @author Yoji Ojima
 *
 * @help AltSaveScreen.js
 *
 * このプラグインは、セーブ／ロード画面のレイアウトを変更します。
 * ファイル一覧を上側に、詳細を下側に配置します。
 *
 * プラグインコマンドはありません。
 */

(() => {
   "use strict";
const _Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
   _Game_Temp_initialize.call(this)
    this._lastSubject = null;
};

Game_Temp.prototype.setLastSubject = function(subject) {
   this._lastSubject = subject;
};

Game_Temp.prototype.lastSubject = function() {
   return this._lastSubject;
};

const _Game_Action_updateLastSubject = Game_Action.prototype.updateLastSubject;
Game_Action.prototype.updateLastSubject = function() {
   _Game_Action_updateLastSubject.call(this)
   $gameTemp.setLastSubject(this.subject());
};
})();