/*:
 * @plugindesc PicturePriorityCustomize（戦闘画面専用版）ピクチャ優先度調整プラグイン
 * @author 奥山たぬき
 *
 * @help
 * このバージョンは、マップ画面では一切動作せず、
 * 戦闘画面（Spriteset_Battle）でのみピクチャの優先度を調整します。
 *
 * 元プラグインで発生していた
 * 「picture.getPictureId is not a function」エラーを回避します。
 */

(function() {
    'use strict';
    const pluginName = 'PicturePriorityCustomize';

    // パラメータ取得
    const getParamString = function(paramNames) {
        if (!Array.isArray(paramNames)) paramNames = [paramNames];
        for (let i = 0; i < paramNames.length; i++) {
            const name = PluginManager.parameters(pluginName)[paramNames[i]];
            if (name) return name;
        }
        return '';
    };

    const getParamNumber = function(paramNames, min, max) {
        const value = getParamString(paramNames);
        if (arguments.length < 2) min = -Infinity;
        if (arguments.length < 3) max = Infinity;
        return (parseInt(value) || 0).clamp(min, max);
    };

    const param = {};
    param.upperPictureId      = getParamNumber(['UpperPictureId', '上層ピクチャ番号']);
    param.lowerPictureId      = getParamNumber(['LowerPictureId', '下層ピクチャ番号']);
    param.lowerPictureZ       = getParamNumber(['LowerPictureZ', '下層ピクチャZ座標']);
    param.lowerPictureBattleZ = getParam