/*:
 * @plugindesc Prevent SaveCommand from updating lastAccessedSavefileId when saving to shared slot.
 */

(function() {

  // 共有セーブのスロット番号（DarkPlasma_SharedSwitchVariable の savefileId と一致させる）
  const SHARED_SLOT = 30; // ←あなたの設定に合わせて変更

  const _DataManager_saveGame = DataManager.saveGame;
  DataManager.saveGame = function(savefileId) {

    // 共有セーブの場合は lastAccessedSavefileId を退避
    let last = DataManager._lastAccessedId;

    const result = _DataManager_saveGame.call(this, savefileId);

    // 共有セーブなら lastAccessedId を元に戻す
    if (savefileId === SHARED_SLOT) {
      DataManager._lastAccessedId = last;
    }

    return result;
  };

})();