/*:
 * @plugindesc Hide/Show AreaElement windows by saving/restoring original opacity during battle.
 * @author Tanuki Okuyama
 *
 * @help
 * Plugin Commands:
 *   AE_Hide   # Hide AreaElement windows (save current opacity -> 0)
 *   AE_Show   # Show AreaElement windows (restore saved opacity)
 */

(function() {

  var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);

    var cmd = (command || "").toLowerCase();

    if (!$gameParty.inBattle() && !$gameTroop.inBattle()) return;

    var scene = SceneManager._scene;
    if (!scene || !(scene instanceof Scene_Battle)) return;

    // ċAI opacity ۑ 0 ɂ
    function hideWithSave(obj) {
      if (!obj) return;
      // ̒lۑiłɕۑς݂Ȃ㏑Ȃj
      if (obj.__aeOrigOpacity === undefined) {
        obj.__aeOrigOpacity = obj.opacity;
      }
      obj.opacity = 0;
      if (obj.children && obj.children.length > 0) {
        obj.children.forEach(hideWithSave);
      }
    }

    // ċAIɕۑĂ opacity 𕜌
    function showWithRestore(obj) {
      if (!obj) return;
      if (obj.__aeOrigOpacity !== undefined) {
        obj.opacity = obj.__aeOrigOpacity;
      }
      if (obj.children && obj.children.length > 0) {
        obj.children.forEach(showWithRestore);
      }
    }

    if (cmd === "ae_hide") {
      hideWithSave(scene._aeWindow);
      hideWithSave(scene._staeWindow);
    }

    if (cmd === "ae_show") {
      showWithRestore(scene._aeWindow);
      showWithRestore(scene._staeWindow);
    }
  };

})();