//=============================================================================
// RPG Maker MZ -
//=============================================================================
/*:ja
 * @target MZ
 * @base PluginCommonBase
 * @plugindesc
 * @author 夜庭
 *
 * @help 処理の詰め合わせです。
 *・オリジナルキーコンフィグ
 *・CustomizeConfigDefault.js
 *・BugfixWindowWithBlend.js
 *
 * 
 * ==================================================
 * @param -> options <<<<<<<<<<<<<<<<<<<<<<<
 * @text オプションの初期設定
 * @desc
 * 
 * @param AlwaysDash
 * @text 常時ダッシュ
 * @desc 常にダッシュする。（Shiftキーを押している場合のみ歩行）(ON/OFF)
 * @default true
 * @type boolean
 * @parent -> options <<<<<<<<<<<<<<<<<<<<<<<
 *
 * @param CommandRemember
 * @text コマンド記憶
 * @desc 選択したコマンドを記憶する。（バトル限定機能）(ON/OFF)
 * @default false
 * @type boolean
 * @parent -> options <<<<<<<<<<<<<<<<<<<<<<<
 *
 * @param TouchUi
 * @text タッチUi
 * @desc タッチ用のボタン等をメニュー画面に表示する。(ON/OFF)
 * @default false
 * @type boolean
 * @parent -> options <<<<<<<<<<<<<<<<<<<<<<<
 *
 * @param BgmVolume
 * @text BGM音量
 * @desc BGMの音量。0-100
 * @default 30
 * @max 100
 * @type number
 * @parent -> options <<<<<<<<<<<<<<<<<<<<<<<
 * 
 * @param BgsVolume
 * @text BGS音量
 * @desc BGSの音量。0-100
 * @default 30
 * @max 100
 * @type number
 * @parent -> options <<<<<<<<<<<<<<<<<<<<<<<
 * 
 * @param MeVolume
 * @text ME音量
 * @desc MEの音量。0-100
 * @default 30
 * @max 100
 * @type number
 * @parent -> options <<<<<<<<<<<<<<<<<<<<<<<
 * 
 * @param SeVolume
 * @text SE音量
 * @desc SEの音量。0-100
 * @default 30
 * @max 100
 * @type number
 * @parent -> options <<<<<<<<<<<<<<<<<<<<<<<

 */

(() => {
  "use strict";
//rmmz_core 5683：Input.keyMapper = {
//MANO 3274：const KEYS = {参照
//変更後は「初期設定に戻す」をする必要がある
  Input.keyMapper[27] = 'cancel'; // escape
  Input.keyMapper[88] = 'menu'; // X
  Input.keyMapper[45] = 'cancel'; // insert
  Input.keyMapper[96] = 'menu'; // numpad 0

  Input.keyMapper[67]="cancel"; // C
  Input.keyMapper[110]="cancel"; // .


// CustomizeConfigDefaultの使うところだけ移設
  const script = document.currentScript;
  const param = PluginManagerEx.createParameter(script);

  const _ConfigManager_load = ConfigManager.load;
  ConfigManager.load = function () {
      this.applyDefault(); // For local.
      _ConfigManager_load.apply(this, arguments);
  }

  const _ConfigManager_applyData = ConfigManager.applyData;
  ConfigManager.applyData = function(config) {
      _ConfigManager_applyData.apply(this, arguments);
      if (Object.keys(config).length === 0) {
          this.applyDefault(); // For browser.
      }
  };

  ConfigManager.applyDefault = function () {
      this.alwaysDash = param.AlwaysDash;
      this.commandRemember = param.CommandRemember;
      this.touchUI = param.TouchUi;
      this.bgmVolume = param.BgmVolume;
      this.bgsVolume = param.BgsVolume;
      this.meVolume = param.MeVolume;
      this.seVolume = param.SeVolume;
  }


  /* BugfixWindowWithBlend.js
  * 特定の条件下でウィンドウ開閉時に白い物体が映り込む問題を修正します。
  * 以下の手順で再現する問題です。
  * 1. ピクチャを合成方法『通常』以外で表示
  * 2. 選択肢の表示を背景『透明』で表示
 */
  const _Window_drawShape = Window.prototype.drawShape;
  Window.prototype.drawShape = function(graphics) {
      if (this.opacity === 0) {
          return;
      }
      _Window_drawShape.apply(this, arguments);
  };



})();
