(() => {
    const fs = require("fs");
    const path = require("path");

    const FONT_DIR = "fonts/";
    const ENCRYPTED_FONT_NAME = "gamefont.rpgmvp"; // 暗号化後のファイル名
    const DECRYPTED_FONT_NAME = "decrypted_font.woff2"; // 復号後のファイル名
    const FONT_NAME = "EncryptedGameFont";

    function decryptFont() {
        if (!$dataSystem || !$dataSystem.encryptionKey) {
            console.error("Encryption key not found or $dataSystem is not initialized.");
            return;
        }

        const encryptedFontPath = path.join(FONT_DIR, ENCRYPTED_FONT_NAME);
        if (!fs.existsSync(encryptedFontPath)) {
            console.warn(`Font file not found: ${encryptedFontPath}`);
            return;
        }

        console.log(`Decrypting font: ${encryptedFontPath}`);

        const key = $dataSystem.encryptionKey;
        const fontData = fs.readFileSync(encryptedFontPath);
        const decryptedData = decryptArrayBuffer(fontData, key);
        fs.writeFileSync(path.join(FONT_DIR, DECRYPTED_FONT_NAME), Buffer.from(decryptedData));

        const font = new FontFace(FONT_NAME, `url('${FONT_DIR + DECRYPTED_FONT_NAME}')`);
        document.fonts.add(font);
        font.load().then(() => {
            console.log("Decrypted font loaded successfully.");
        }).catch(err => {
            console.error("Failed to load font:", err);
        });
    }

    function decryptArrayBuffer(buffer, key) {
        const view = new Uint8Array(buffer);
        const keyBytes = Buffer.from(key, "base64");
        const keyLength = keyBytes.length;

        for (let i = 0; i < view.length; i++) {
            view[i] ^= keyBytes[i % keyLength];
        }
        return view;
    }

    // ゲームのシステムデータがロードされた後に実行
    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function() {
        _Scene_Boot_start.call(this);
        decryptFont();
    };
})();
