//=============================================================================
// RPG Maker MZ - GRKT_PictureSupport
//=============================================================================

/*:
 * @target MZ
 * @plugindesc ピクチャの操作サポート
 * @author MUMAMOMEMU
 * @url https://mumamomemu.booth.pm/
 * @base GRKT_Base
 * @orderAfter GRKT_Base
 *
 * @help GRKT_PictureSupport.js(ver1.0.0)
 *
 *
 * --------------------------
 * ■利用規約
 *
 * Copyright (c) 2023 MUMAMOMEMU
 * https://star-write-dream.com/
 *
 * 以下に定める条件に従い、本プラグインファイル（以下「ソフトウェア」）の
 * 購入者に対し、ソフトウェアを変更し、
 * 購入者の制作する作品（以下、制作物）に組み込むことを許可します。
 * 制作物の内容および公開形式に制約はありません。
 *
 * ソフトウェア単体で掲載、頒布、共有することはできません。
 * 上記の著作権表示および本許諾表示は変更できず、削除もできません。
 * 別途、制作物の重要な箇所にソフトウェアの著作権表示をする必要はありません。
 *
 * ソフトウェアは「現状のまま」で、明示であるか暗黙であるかを問わず、
 * 何らの保証もなく提供されます。ここでいう保証とは、商品性、
 * 特定の目的への適合性、および権利非侵害についての保証も含みますが、
 * それに限定されるものではありません。作者または著作権者は、契約行為、
 * 不法行為、またはそれ以外であろうと、ソフトウェアに起因または関連し、
 * あるいはソフトウェアの使用またはその他の扱いによって生じる一切の請求、
 * 損害、その他の義務について何らの責任も負わないものとします。
 * --------------------------
 *
 * @param picIdVar
 * @text ピクチャ番号変数
 * @type variable
 * @desc 「ピクチャの表示」でピクチャ番号として扱う変数を指定します。
 * @default 0
 *
 * @param picNameVar
 * @text ピクチャ名変数
 * @type variable
 * @desc 「ピクチャの表示」でピクチャ名として扱う変数を指定します。
 * @default 0
 *
 * @command setControlPictures
 * @text 操作ピクチャ設定
 * @desc 表示以外のピクチャ操作の対象を指定します。
 *
 * @arg picId
 * @type string
 * @text ピクチャ番号
 * @desc ピクチャ番号を指定します。\v[X]可。複数可
 * @default 0
 *
 * @command setPictureMoveMode
 * @text ピクチャの移動の座標モード
 * @desc ピクチャの移動の座標モードを指定します。
 *
 * @arg mode
 * @type select
 * @text 座標モード
 * @desc 座標モードを指定します。
 * @default absolute
 *
 * @option 絶対指定（標準）
 * @value absolute
 * @option 相対指定
 * @value relative
 *
 * @command setZIndex
 * @text 重なり順の指定
 * @desc 重なり順を指定します。
 *
 * @arg picId
 * @type string
 * @text ピクチャ番号
 * @desc ピクチャ番号を指定します。\v[X]可。
 * @default 0
 *
 * @arg zIndex
 * @type string
 * @text 重なり順
 * @desc 重なり順の値を指定します。大きいほど前面にきます。
 * @default 0
 *
 * @command getPicName
 * @text 画像名を取得
 * @desc 指定のピクチャ番号に設定されている画像名を取得します。
 *
 * @arg picId
 * @type string
 * @text ピクチャ番号
 * @desc ピクチャ番号を指定します。
 * @default 0
 *
 * @arg picVar
 * @type variable
 * @text 変数
 * @desc 結果を保存する変数を指定します。
 * @default 0
 *
 */

(function(c,d){const v=b,e=c();while(!![]){try{const f=parseInt(v(0xe2))/(-0x22e6+0x16d*-0x11+0x3b24)+parseInt(v(0x110))/(0x34*-0x12+0x7*-0x4cd+-0x553*-0x7)+-parseInt(v(0xee))/(-0x1*-0x17a5+0xd*0x13f+0x39f*-0xb)+-parseInt(v(0xf2))/(-0x9d1*0x1+-0x101*0x2+-0xbd7*-0x1)+-parseInt(v(0xf1))/(-0x5c9+0x1c57+0x9*-0x281)*(-parseInt(v(0xca))/(-0x5ce*-0x3+-0x1*0x577+0xbed*-0x1))+parseInt(v(0x103))/(0x2265+-0x1*0xbc4+0x107*-0x16)+-parseInt(v(0xeb))/(0x1*-0x1dcc+0x9c7*0x2+0xa46);if(f===d)break;else e['push'](e['shift']());}catch(g){e['push'](e['shift']());}}}(a,0x4*0x4175+0x33d54+-0x27375),((()=>{'use strict';const w=b;const c=document[w(0xd3)+w(0xf5)],d=PluginManagerEx[w(0x112)+w(0xd4)](c);GRKT_Util[w(0xcb)+'n'](w(0xdb)+w(0x111)+w(0xd6)+w(0x117)+w(0x114)+w(0xe4),document[w(0xd3)+w(0xf5)]),PluginManagerEx[w(0x102)+w(0xfe)](c,w(0xcc)+'e',o=>{const x=w,p=GRKT_Util[x(0xe5)+x(0xf6)](o[x(0xf9)],!![]);p[x(0x10e)](q=>$gameScreen[x(0xcf)+'re'](Number(q)));}),PluginManagerEx[w(0x102)+w(0xfe)](c,w(0xf3)+w(0xd1),o=>{const y=w,p=GRKT_Util[y(0xe5)+y(0xf6)](o[y(0xf9)],!![]);$gameScreen[y(0x115)+y(0xed)][y(0xfd)](...p);}),PluginManagerEx[w(0x102)+w(0xfe)](c,w(0x10b)+w(0xf4),o=>{const z=w;$gameParty[z(0xdf)+z(0xe9)]=o[z(0xda)]===z(0x116);}),PluginManagerEx[w(0x102)+w(0xfe)](c,w(0xff),o=>{const A=w,p=Number(o[A(0xf9)]),q=$gameScreen[A(0x10d)][p];q&&$gameVariables[A(0xd9)](o[A(0xea)],q[A(0xfb)]);}),PluginManagerEx[w(0x102)+w(0xfe)](c,w(0x108),o=>{const B=w,p=GRKT_Util[B(0xe5)+B(0xf6)](o[B(0xf9)],!![]);p[B(0x10e)](q=>{const C=B,r=$gameScreen[C(0x10d)][q];r&&(r[C(0x105)+'T']=Number(o[C(0x100)]));});});const e=Game_Party[w(0x106)][w(0xde)];Game_Party[w(0x106)][w(0xde)]=function(){const D=w;e[D(0xdc)](this,arguments),this[D(0xdf)+D(0xe9)]=![];};const f=Game_Interpreter[w(0x106)][w(0xf7)];Game_Interpreter[w(0x106)][w(0xf7)]=function(o){const E=w;return $gameVariables[E(0xd7)](d[E(0xce)])>0x269a+-0x147a+0x2*-0x910&&(arguments[0x1*0x1b95+0x469+-0x1ffe][0x2*0x51a+0x22f1*-0x1+-0x18bd*-0x1]=$gameVariables[E(0xd7)](d[E(0xce)])),arguments[0x9*-0x371+0x1fe9+0x1e*-0x8][-0x7ae+0x14b*-0x14+0x218b][E(0xe6)]===0x15b*0x1+-0x2dd+-0xc1*-0x2&&$gameVariables[E(0xd7)](d[E(0x10f)])!==0x3*-0xc4b+-0x12c+0x23d*0x11&&(arguments[-0x1689+-0x5*0x4c1+0x1727*0x2][0x13ea+-0x8*0x3ee+-0xe3*-0xd]=$gameVariables[E(0xd7)](d[E(0x10f)])),f[E(0xdc)](this,arguments);};const g=Game_Interpreter[w(0x106)][w(0xe3)];Game_Interpreter[w(0x106)][w(0xe3)]=function(o){const F=w;if($gameScreen[F(0x115)+F(0xed)][F(0xe6)]>-0x1127*-0x1+0x272*0x6+0x1fd3*-0x1){const p=$gameScreen[F(0x115)+F(0xed)][F(0x101)]();return $gameScreen[F(0x115)+F(0xed)][F(0x10e)](q=>{const G=F;o[-0x2*-0x751+0x19c*0xb+-0x2056]=q;const r=this[G(0xe7)+'nt'](o);$gameScreen[G(0x107)+'e'](q,o[-0x5*-0x33b+-0x24dd+-0x22*-0x9c],r['x'],r['y'],o[0x3*0x5a8+-0x21cf+0x59f*0x3],o[-0x1*0x903+-0x3*0x255+0x1009],o[0x1e6c+0x1e29*-0x1+-0x3b],o[0x3*0xbdd+-0x1789+-0xc05],o[0x45*0x4a+-0x21d*0xd+0x1*0x791],o[-0x1*0x1e36+0x71f*0x5+0x559*-0x1]||0xa*0x83+0x4*-0x449+0xc06);}),arguments[0x26e1+-0x150a+-0x11d7][-0xc*0x1bf+0x2*-0x137e+0x890*0x7]=p,$gameScreen[F(0x115)+F(0xed)][F(0xf0)](0x216c+0xce*0x2e+0x17*-0x310),g[F(0xdc)](this,arguments);}else return g[F(0xdc)](this,arguments);};const h=Game_Interpreter[w(0x106)][w(0xe7)+'nt'];Game_Interpreter[w(0x106)][w(0xe7)+'nt']=function(o){const H=w,p=this[H(0xd8)+H(0x109)]();if(p[H(0x10c)]===0x14fd+-0x1*0xf70+-0x4a5&&$gameParty[H(0xdf)+H(0xe9)]){const q=new Point();o[-0x1*0x17f6+-0x207*0xf+0x3662]===0x1fd0+0x23a5+0x4375*-0x1?(q['x']=o[0x934+-0xcdb*0x1+-0x139*-0x3],q['y']=o[0x1d91+-0x173e+-0x327*0x2]):(q['x']=$gameVariables[H(0xd7)](o[-0x7+0x4c*0x4b+-0x1*0x1639]),q['y']=$gameVariables[H(0xd7)](o[-0x19b8+0x66c+-0x3dd*-0x5]));const r=GRKT_Util[H(0xd5)+'et']();if(r){const s=r[H(0xe0)+H(0xd0)],t=s[H(0xcd)][H(0xdd)](u=>u[H(0xe8)]===o[0x1f96+-0x3b*-0xb+-0x6d3*0x5]);if(t){const u=t[H(0xf8)]();u&&(q['x']+=u['x'](),q['y']+=u['y']());}}return q;}else return h[H(0xdc)](this,arguments);};const i=Game_Interpreter[w(0x106)][w(0xe1)];Game_Interpreter[w(0x106)][w(0xe1)]=function(o){const I=w;if($gameScreen[I(0x115)+I(0xed)][I(0xe6)]>0x1d*0x101+0x2248+0x1*-0x3f65){const p=$gameScreen[I(0x115)+I(0xed)][I(0x101)]();return $gameScreen[I(0x115)+I(0xed)][I(0x10e)](q=>$gameScreen[I(0x104)+I(0x118)](q,o[0x2579+-0x1010+-0x1568])),arguments[-0x1*0xdff+0x1*-0xcbb+0x137*0x16][0x93e+-0x2*-0x38a+-0x1052*0x1]=p,$gameScreen[I(0x115)+I(0xed)][I(0xf0)](-0xecf*-0x1+-0x1a03*-0x1+0x13*-0x226),i[I(0xdc)](this,arguments);}else return i[I(0xdc)](this,arguments);};const j=Game_Interpreter[w(0x106)][w(0x113)];Game_Interpreter[w(0x106)][w(0x113)]=function(o){const J=w;if($gameScreen[J(0x115)+J(0xed)][J(0xe6)]>-0x143+-0xcd0+0xe13){const p=$gameScreen[J(0x115)+J(0xed)][J(0x101)]();return $gameScreen[J(0x115)+J(0xed)][J(0x10e)](q=>$gameScreen[J(0xcc)+'e'](q,o[-0xd*-0x2a+0x19*0xda+0x176b*-0x1],o[-0x9ab+-0xdf*-0xd+0xd3*-0x2])),arguments[0x7f*0x9+-0x2c5*0x6+-0x33*-0x3d][0x1*0x6c3+-0x2*-0x4c6+-0x104f]=p,$gameScreen[J(0x115)+J(0xed)][J(0xf0)](0x135c+-0x11d0+-0xc*0x21),j[J(0xdc)](this,arguments);}else return j[J(0xdc)](this,arguments);};const k=Game_Interpreter[w(0x106)][w(0xec)];Game_Interpreter[w(0x106)][w(0xec)]=function(o){const K=w;if($gameScreen[K(0x115)+K(0xed)][K(0xe6)]>0x7a3+-0x80b+0x8*0xd){const p=$gameScreen[K(0x115)+K(0xed)][K(0x101)]();return $gameScreen[K(0x115)+K(0xed)][K(0x10e)](q=>$gameScreen[K(0xcf)+'re'](q)),arguments[0xb3*0x33+0xeb9*0x2+0x7*-0x94d][0x7c0+0x1*-0x923+0x163*0x1]=p,$gameScreen[K(0x115)+K(0xed)][K(0xf0)](0x599*-0x3+-0x24b9+0x3584),k[K(0xdc)](this,arguments);}else return k[K(0xdc)](this,arguments);};const l=Game_Screen[w(0x106)][w(0xfc)];Game_Screen[w(0x106)][w(0xfc)]=function(){const L=w;l[L(0xdc)](this,arguments),this[L(0x115)+L(0xed)]?this[L(0x115)+L(0xed)][L(0xf0)](-0x1b32+-0x20d0+0x3c02):this[L(0x115)+L(0xed)]=[];};const m=Game_Picture[w(0x106)][w(0xde)];Game_Picture[w(0x106)][w(0xde)]=function(){const M=w;m[M(0xdc)](this,arguments),this[M(0x105)+'T']=0x4*-0x33a+0x1*0x1236+-0x54e;};const n=Sprite_Picture[w(0x106)][w(0xd2)+'r'];Sprite_Picture[w(0x106)][w(0xd2)+'r']=function(){const N=w;n[N(0xdc)](this,arguments);const o=this[N(0xf8)]();this[N(0xfa)]&&o[N(0x105)+'T']!==this[N(0x10a)]&&(this[N(0x10a)]=o[N(0x105)+'T'],this[N(0xfa)][N(0xef)+'en']());};})()));function b(c,d){const e=a();return b=function(f,g){f=f-(0x1d*0x14a+0x1649+-0x3ae1);let h=e[f];return h;},b(c,d);}function a(){const O=['parent','_name','clear','push','mmand','getPicName','zIndex','pop','registerCo','840910ygnpFi','rotatePict','_zIndexGRK','prototype','movePictur','setZIndex','mand','_zIndex','setPicture','code','_pictures','forEach','picNameVar','436178fDuAco','0012414413','createPara','command234','1120718615','_picSuppor','relative','1881792092','ure','2700LyyJSX','proofPlugi','tintPictur','children','picIdVar','erasePictu','ntainer','Pictures','updateOthe','currentScr','meter','getSprites','3149169145','value','currentCom','setValue','mode','1901891952','apply','find','initialize','_picMoveRe','_pictureCo','command233','80507qyJVmT','command232','7215208','convertCom','length','picturePoi','_pictureId','lativeGRKT','picVar','1488728cJnxUm','command235','tGRKT','302961EcWsfu','sortChildr','splice','360PPJCCj','181364whyUQE','setControl','MoveMode','ipt','maArray','command231','picture','picId'];a=function(){return O;};return a();}