{"payload":{"allShortcutsEnabled":false,"fileTree":{"Formulas":{"items":[{"name":"MultiStackState.js","path":"Formulas/MultiStackState.js","contentType":"file"},{"name":"kz_EquipGenerator.js","path":"Formulas/kz_EquipGenerator.js","contentType":"file"},{"name":"kz_SelectiveSteal.js","path":"Formulas/kz_SelectiveSteal.js","contentType":"file"},{"name":"kz_StateRestrainedSkill.js","path":"Formulas/kz_StateRestrainedSkill.js","contentType":"file"},{"name":"kz_WorldState.js","path":"Formulas/kz_WorldState.js","contentType":"file"},{"name":"sharedStats.js","path":"Formulas/sharedStats.js","contentType":"file"},{"name":"stateformula.js","path":"Formulas/stateformula.js","contentType":"file"}],"totalCount":7},"":{"items":[{"name":"Barrier","path":"Barrier","contentType":"directory"},{"name":"BattleObjectForYEP","path":"BattleObjectForYEP","contentType":"directory"},{"name":"ChainSkill","path":"ChainSkill","contentType":"directory"},{"name":"Formulas","path":"Formulas","contentType":"directory"},{"name":"Pictures","path":"Pictures","contentType":"directory"},{"name":"Teleport","path":"Teleport","contentType":"directory"},{"name":"Utility","path":"Utility","contentType":"directory"},{"name":"README.md","path":"README.md","contentType":"file"}],"totalCount":8}},"fileTreeProcessingTime":3.0163059999999997,"foldersToFetch":[],"reducedMotionEnabled":null,"repo":{"id":88742173,"defaultBranch":"master","name":"RMP_kenzaki","ownerLogin":"kenzakis2","currentUserCanPush":false,"isFork":false,"isEmpty":false,"createdAt":"2017-04-19T12:28:14.000Z","ownerAvatar":"https://avatars.githubusercontent.com/u/27770077?v=4","public":true,"private":false,"isOrgOwned":false},"refInfo":{"name":"master","listCacheKey":"v0:1584328719.0","canEdit":false,"refType":"branch","currentOid":"0ad41b826e412bc6819fb97840eeb0a76972e2aa"},"path":"Formulas/MultiStackState.js","currentUser":null,"blob":{"rawBlob":"﻿//=============================================================================\n// MultiStackState.js\n//=============================================================================\n\n/*:en\n * @plugindesc Implementing Multi-stackable States\n * @author Souji Kenzaki\n *\n * \n *\n * @help \n * This is a plugin for implementing States which can be stacked multiple times.\n * in the memo section of state, write in format of <maxstack: [number of maximum stack of this state]>\n * such as <maxstack:2>. In this case, that state can be stacked 2 times max instead of 1.\n */\n\n/*:ja\n * @plugindesc ステート重複可能数拡張\n * @author 剣崎宗二\n *\n *\n * @help \n * タグのついたステートを、重複可能にするプラグインです。\n * ステートのメモに<maxstack:2> (数字は最大重複数）を入れると、その数までステートを重複して付与できるようになります。\n * 尚、可能な限り競合に対して防御策は施しましたが、ステート付与、除去系のプラグインとは依然相性が悪い事が予想されますので、\n * 使用時は十分にご注意ください。\n */\n\n\n\n(function() {\n\nGame_BattlerBase.prototype.countState = function(stateId) {\n    var stateCount = 0;\n    this._states.forEach(function(item)\n    {\n        if (item == stateId)\n        {\n            stateCount++;\n        }\n    });\n    return stateCount;\n}\n\nvar kz_Game_Battler_prototype_addState = Game_Battler.prototype.addState;\nGame_Battler.prototype.addState = function(stateId) {\n    var preCount = this.countState(stateId);\n    kz_Game_Battler_prototype_addState.call(this, stateId); \n    if ($dataStates[stateId])\n    {\n       var maxStack = $dataStates[stateId].meta.maxstack || 1;\n       var postCount = this.countState(stateId);\n       if (this.isStateAddable(stateId) && preCount == postCount && postCount < maxStack)\n       {\n          this.addNewState(stateId);\n       }\n    } \n};\n\nvar kz_Game_Battler_prototype_removeState = Game_Battler.prototype.removeState;\nGame_Battler.prototype.removeState = function(stateId) {\n    while (this.countState(stateId) > 0)\n    {\n        var lastCount = this.countState(stateId);\n        kz_Game_Battler_prototype_removeState.call(this, stateId);\n\n        //For certain plugins which creates non-removable state\n        if (lastCount == this.countState(stateId)) {break;}\n    }\n};\n\nvar kzk_Game_BattlerBase_prototype_updateStateTurns = Game_BattlerBase.prototype.updateStateTurns;\nGame_BattlerBase.prototype.updateStateTurns = function() {\n    var stateOriginal = this._states;\n    this._states = stateOriginal.filter(function (x, i, self) {\n       return self.indexOf(x) === i;\n    });\n    kzk_Game_BattlerBase_prototype_updateStateTurns.call(this);\n    this._states = stateOriginal;\n    console.log(this._stateTurns);\n};\n\n\n})();\n\n\n","colorizedLines":["﻿<span class=pl-c>//=============================================================================</span>","<span class=pl-c>// MultiStackState.js</span>","<span class=pl-c>//=============================================================================</span>","","<span class=pl-c>/*:en</span>","<span class=pl-c> * <span class=pl-k>@plugindesc</span> Implementing Multi-stackable States</span>","<span class=pl-c> * <span class=pl-k>@author</span> Souji Kenzaki</span>","<span class=pl-c> *</span>","<span class=pl-c> * </span>","<span class=pl-c> *</span>","<span class=pl-c> * <span class=pl-k>@help</span> </span>","<span class=pl-c> * This is a plugin for implementing States which can be stacked multiple times.</span>","<span class=pl-c> * in the memo section of state, write in format of &lt;maxstack: [number of maximum stack of this state]&gt;</span>","<span class=pl-c> * such as &lt;maxstack:2&gt;. In this case, that state can be stacked 2 times max instead of 1.</span>","<span class=pl-c> */</span>","","<span class=pl-c>/*:ja</span>","<span class=pl-c> * <span class=pl-k>@plugindesc</span> ステート重複可能数拡張</span>","<span class=pl-c> * <span class=pl-k>@author</span> 剣崎宗二</span>","<span class=pl-c> *</span>","<span class=pl-c> *</span>","<span class=pl-c> * <span class=pl-k>@help</span> </span>","<span class=pl-c> * タグのついたステートを、重複可能にするプラグインです。</span>","<span class=pl-c> * ステートのメモに&lt;maxstack:2&gt; (数字は最大重複数）を入れると、その数までステートを重複して付与できるようになります。</span>","<span class=pl-c> * 尚、可能な限り競合に対して防御策は施しましたが、ステート付与、除去系のプラグインとは依然相性が悪い事が予想されますので、</span>","<span class=pl-c> * 使用時は十分にご注意ください。</span>","<span class=pl-c> */</span>","","","","<span class=pl-kos>(</span><span class=pl-k>function</span><span class=pl-kos>(</span><span class=pl-kos>)</span> <span class=pl-kos>{</span>","","<span class=pl-v>Game_BattlerBase</span><span class=pl-kos>.</span><span class=pl-c1>prototype</span><span class=pl-kos>.</span><span class=pl-en>countState</span> <span class=pl-c1>=</span> <span class=pl-k>function</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span> <span class=pl-kos>{</span>","    <span class=pl-k>var</span> <span class=pl-s1>stateCount</span> <span class=pl-c1>=</span> <span class=pl-c1>0</span><span class=pl-kos>;</span>","    <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-c1>_states</span><span class=pl-kos>.</span><span class=pl-en>forEach</span><span class=pl-kos>(</span><span class=pl-k>function</span><span class=pl-kos>(</span><span class=pl-s1>item</span><span class=pl-kos>)</span>","    <span class=pl-kos>{</span>","        <span class=pl-k>if</span> <span class=pl-kos>(</span><span class=pl-s1>item</span> <span class=pl-c1>==</span> <span class=pl-s1>stateId</span><span class=pl-kos>)</span>","        <span class=pl-kos>{</span>","            <span class=pl-s1>stateCount</span><span class=pl-c1>++</span><span class=pl-kos>;</span>","        <span class=pl-kos>}</span>","    <span class=pl-kos>}</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","    <span class=pl-k>return</span> <span class=pl-s1>stateCount</span><span class=pl-kos>;</span>","<span class=pl-kos>}</span>","","<span class=pl-k>var</span> <span class=pl-s1>kz_Game_Battler_prototype_addState</span> <span class=pl-c1>=</span> <span class=pl-v>Game_Battler</span><span class=pl-kos>.</span><span class=pl-c1>prototype</span><span class=pl-kos>.</span><span class=pl-c1>addState</span><span class=pl-kos>;</span>","<span class=pl-v>Game_Battler</span><span class=pl-kos>.</span><span class=pl-c1>prototype</span><span class=pl-kos>.</span><span class=pl-en>addState</span> <span class=pl-c1>=</span> <span class=pl-k>function</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span> <span class=pl-kos>{</span>","    <span class=pl-k>var</span> <span class=pl-s1>preCount</span> <span class=pl-c1>=</span> <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-en>countState</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","    <span class=pl-s1>kz_Game_Battler_prototype_addState</span><span class=pl-kos>.</span><span class=pl-en>call</span><span class=pl-kos>(</span><span class=pl-smi>this</span><span class=pl-kos>,</span> <span class=pl-s1>stateId</span><span class=pl-kos>)</span><span class=pl-kos>;</span> ","    <span class=pl-k>if</span> <span class=pl-kos>(</span><span class=pl-s1>$dataStates</span><span class=pl-kos>[</span><span class=pl-s1>stateId</span><span class=pl-kos>]</span><span class=pl-kos>)</span>","    <span class=pl-kos>{</span>","       <span class=pl-k>var</span> <span class=pl-s1>maxStack</span> <span class=pl-c1>=</span> <span class=pl-s1>$dataStates</span><span class=pl-kos>[</span><span class=pl-s1>stateId</span><span class=pl-kos>]</span><span class=pl-kos>.</span><span class=pl-c1>meta</span><span class=pl-kos>.</span><span class=pl-c1>maxstack</span> <span class=pl-c1>||</span> <span class=pl-c1>1</span><span class=pl-kos>;</span>","       <span class=pl-k>var</span> <span class=pl-s1>postCount</span> <span class=pl-c1>=</span> <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-en>countState</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","       <span class=pl-k>if</span> <span class=pl-kos>(</span><span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-en>isStateAddable</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span> <span class=pl-c1>&amp;&amp;</span> <span class=pl-s1>preCount</span> <span class=pl-c1>==</span> <span class=pl-s1>postCount</span> <span class=pl-c1>&amp;&amp;</span> <span class=pl-s1>postCount</span> <span class=pl-c1>&lt;</span> <span class=pl-s1>maxStack</span><span class=pl-kos>)</span>","       <span class=pl-kos>{</span>","          <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-en>addNewState</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","       <span class=pl-kos>}</span>","    <span class=pl-kos>}</span> ","<span class=pl-kos>}</span><span class=pl-kos>;</span>","","<span class=pl-k>var</span> <span class=pl-s1>kz_Game_Battler_prototype_removeState</span> <span class=pl-c1>=</span> <span class=pl-v>Game_Battler</span><span class=pl-kos>.</span><span class=pl-c1>prototype</span><span class=pl-kos>.</span><span class=pl-c1>removeState</span><span class=pl-kos>;</span>","<span class=pl-v>Game_Battler</span><span class=pl-kos>.</span><span class=pl-c1>prototype</span><span class=pl-kos>.</span><span class=pl-en>removeState</span> <span class=pl-c1>=</span> <span class=pl-k>function</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span> <span class=pl-kos>{</span>","    <span class=pl-k>while</span> <span class=pl-kos>(</span><span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-en>countState</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span> <span class=pl-c1>&gt;</span> <span class=pl-c1>0</span><span class=pl-kos>)</span>","    <span class=pl-kos>{</span>","        <span class=pl-k>var</span> <span class=pl-s1>lastCount</span> <span class=pl-c1>=</span> <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-en>countState</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","        <span class=pl-s1>kz_Game_Battler_prototype_removeState</span><span class=pl-kos>.</span><span class=pl-en>call</span><span class=pl-kos>(</span><span class=pl-smi>this</span><span class=pl-kos>,</span> <span class=pl-s1>stateId</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","","        <span class=pl-c>//For certain plugins which creates non-removable state</span>","        <span class=pl-k>if</span> <span class=pl-kos>(</span><span class=pl-s1>lastCount</span> <span class=pl-c1>==</span> <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-en>countState</span><span class=pl-kos>(</span><span class=pl-s1>stateId</span><span class=pl-kos>)</span><span class=pl-kos>)</span> <span class=pl-kos>{</span><span class=pl-k>break</span><span class=pl-kos>;</span><span class=pl-kos>}</span>","    <span class=pl-kos>}</span>","<span class=pl-kos>}</span><span class=pl-kos>;</span>","","<span class=pl-k>var</span> <span class=pl-s1>kzk_Game_BattlerBase_prototype_updateStateTurns</span> <span class=pl-c1>=</span> <span class=pl-v>Game_BattlerBase</span><span class=pl-kos>.</span><span class=pl-c1>prototype</span><span class=pl-kos>.</span><span class=pl-c1>updateStateTurns</span><span class=pl-kos>;</span>","<span class=pl-v>Game_BattlerBase</span><span class=pl-kos>.</span><span class=pl-c1>prototype</span><span class=pl-kos>.</span><span class=pl-en>updateStateTurns</span> <span class=pl-c1>=</span> <span class=pl-k>function</span><span class=pl-kos>(</span><span class=pl-kos>)</span> <span class=pl-kos>{</span>","    <span class=pl-k>var</span> <span class=pl-s1>stateOriginal</span> <span class=pl-c1>=</span> <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-c1>_states</span><span class=pl-kos>;</span>","    <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-c1>_states</span> <span class=pl-c1>=</span> <span class=pl-s1>stateOriginal</span><span class=pl-kos>.</span><span class=pl-en>filter</span><span class=pl-kos>(</span><span class=pl-k>function</span> <span class=pl-kos>(</span><span class=pl-s1>x</span><span class=pl-kos>,</span> <span class=pl-s1>i</span><span class=pl-kos>,</span> <span class=pl-s1>self</span><span class=pl-kos>)</span> <span class=pl-kos>{</span>","       <span class=pl-k>return</span> <span class=pl-s1>self</span><span class=pl-kos>.</span><span class=pl-en>indexOf</span><span class=pl-kos>(</span><span class=pl-s1>x</span><span class=pl-kos>)</span> <span class=pl-c1>===</span> <span class=pl-s1>i</span><span class=pl-kos>;</span>","    <span class=pl-kos>}</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","    <span class=pl-s1>kzk_Game_BattlerBase_prototype_updateStateTurns</span><span class=pl-kos>.</span><span class=pl-en>call</span><span class=pl-kos>(</span><span class=pl-smi>this</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","    <span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-c1>_states</span> <span class=pl-c1>=</span> <span class=pl-s1>stateOriginal</span><span class=pl-kos>;</span>","    <span class=pl-smi>console</span><span class=pl-kos>.</span><span class=pl-en>log</span><span class=pl-kos>(</span><span class=pl-smi>this</span><span class=pl-kos>.</span><span class=pl-c1>_stateTurns</span><span class=pl-kos>)</span><span class=pl-kos>;</span>","<span class=pl-kos>}</span><span class=pl-kos>;</span>","","","<span class=pl-kos>}</span><span class=pl-kos>)</span><span class=pl-kos>(</span><span class=pl-kos>)</span><span class=pl-kos>;</span>",""],"stylingDirectives":null,"csv":null,"csvError":null,"dependabotInfo":{"showConfigurationBanner":false,"configFilePath":null,"networkDependabotPath":"/kenzakis2/RMP_kenzaki/network/updates","dismissConfigurationNoticePath":"/settings/dismiss-notice/dependabot_configuration_notice","configurationNoticeDismissed":null,"repoAlertsPath":"/kenzakis2/RMP_kenzaki/security/dependabot","repoSecurityAndAnalysisPath":"/kenzakis2/RMP_kenzaki/settings/security_analysis","repoOwnerIsOrg":false,"currentUserCanAdminRepo":false},"displayName":"MultiStackState.js","displayUrl":"https://github.com/kenzakis2/RMP_kenzaki/blob/master/Formulas/MultiStackState.js?raw=true","headerInfo":{"blobSize":"2.77 KB","deleteInfo":{"deletePath":null,"deleteTooltip":"You must be signed in to make or propose changes"},"editInfo":{"editTooltip":"You must be signed in to make or propose changes"},"ghDesktopPath":"https://desktop.github.com","gitLfsPath":null,"onBranch":true,"shortPath":"8d50afc","siteNavLoginPath":"/login?return_to=https%3A%2F%2Fgithub.com%2Fkenzakis2%2FRMP_kenzaki%2Fblob%2Fmaster%2FFormulas%2FMultiStackState.js","isCSV":false,"isRichtext":false,"toc":null,"lineInfo":{"truncatedLoc":"86","truncatedSloc":"72"},"mode":"file"},"image":false,"isCodeownersFile":null,"isValidLegacyIssueTemplate":false,"issueTemplateHelpUrl":"https://docs.github.com/articles/about-issue-and-pull-request-templates","issueTemplate":null,"discussionTemplate":null,"language":"JavaScript","large":false,"loggedIn":false,"newDiscussionPath":"/kenzakis2/RMP_kenzaki/discussions/new","newIssuePath":"/kenzakis2/RMP_kenzaki/issues/new","planSupportInfo":{"repoIsFork":null,"repoOwnedByCurrentUser":null,"requestFullPath":"/kenzakis2/RMP_kenzaki/blob/master/Formulas/MultiStackState.js","showFreeOrgGatedFeatureMessage":null,"showPlanSupportBanner":null,"upgradeDataAttributes":null,"upgradePath":null},"publishBannersInfo":{"dismissActionNoticePath":"/settings/dismiss-notice/publish_action_from_dockerfile","dismissStackNoticePath":"/settings/dismiss-notice/publish_stack_from_file","releasePath":"/kenzakis2/RMP_kenzaki/releases/new?marketplace=true","showPublishActionBanner":false,"showPublishStackBanner":false},"renderImageOrRaw":false,"richText":null,"renderedFileInfo":null,"tabSize":8,"topBannersInfo":{"overridingGlobalFundingFile":false,"globalPreferredFundingPath":null,"repoOwner":"kenzakis2","repoName":"RMP_kenzaki","showInvalidCitationWarning":false,"citationHelpUrl":"https://docs.github.com/en/github/creating-cloning-and-archiving-repositories/creating-a-repository-on-github/about-citation-files","showDependabotConfigurationBanner":false,"actionsOnboardingTip":null},"truncated":false,"viewable":true,"workflowRedirectUrl":null,"symbols":{"timedOut":false,"notAnalyzed":false,"symbols":[{"name":"countState","kind":"function","identStart":1199,"identEnd":1209,"extentStart":1172,"extentEnd":1409,"fullyQualifiedName":"countState","identUtf16":{"start":{"lineNumber":32,"utf16Col":27},"end":{"lineNumber":32,"utf16Col":37}},"extentUtf16":{"start":{"lineNumber":32,"utf16Col":0},"end":{"lineNumber":42,"utf16Col":1}}},{"name":"addState","kind":"function","identStart":1508,"identEnd":1516,"extentStart":1485,"extentEnd":1946,"fullyQualifiedName":"addState","identUtf16":{"start":{"lineNumber":45,"utf16Col":23},"end":{"lineNumber":45,"utf16Col":31}},"extentUtf16":{"start":{"lineNumber":45,"utf16Col":0},"end":{"lineNumber":57,"utf16Col":1}}},{"name":"removeState","kind":"function","identStart":2052,"identEnd":2063,"extentStart":2029,"extentEnd":2382,"fullyQualifiedName":"removeState","identUtf16":{"start":{"lineNumber":60,"utf16Col":23},"end":{"lineNumber":60,"utf16Col":34}},"extentUtf16":{"start":{"lineNumber":60,"utf16Col":0},"end":{"lineNumber":69,"utf16Col":1}}},{"name":"updateStateTurns","kind":"function","identStart":2511,"identEnd":2527,"extentStart":2484,"extentEnd":2824,"fullyQualifiedName":"updateStateTurns","identUtf16":{"start":{"lineNumber":72,"utf16Col":27},"end":{"lineNumber":72,"utf16Col":43}},"extentUtf16":{"start":{"lineNumber":72,"utf16Col":0},"end":{"lineNumber":80,"utf16Col":1}}}]}},"copilotUserAccess":null,"csrf_tokens":{"/kenzakis2/RMP_kenzaki/branches":{"post":"GwMF3hvCXXsb1RJI2l5MJbBboH2-G0n-e1BbWVvGPw76Pod1cN6Ndip7II7A4Fq0ydQtLmbTCfO8Thn3_d16xw"}}},"title":"RMP_kenzaki/Formulas/MultiStackState.js at master · kenzakis2/RMP_kenzaki","locale":"en"}