/*:
 * @target MZ
 * @plugindesc アクティビティ
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        var Activity;
        (function (Activity) {
            Activity.Order = {
                PreUpdate: 1,
                UpdateNonmoving: 2,
                PostUpdate: 3,
            };
            class Holder {
                constructor() {
                    this.initialize();
                }
                get activities() {
                    return [...this._list.values()];
                }
                set(data, priority) {
                    this._list.set(priority, data);
                }
                sort() {
                    const entries = [...this._list.entries()];
                    this._list.clear();
                    entries
                        .sort((a, b) => a[0] - b[0])
                        .forEach((entry) => {
                        this.set(entry[1], entry[0]);
                    });
                }
                initialize() {
                    this._list = new Map();
                }
            }
            class Main {
                constructor() {
                    this.initialize();
                }
                get resultTag() {
                    return this._tag;
                }
                set(order, data, priority) {
                    const holder = this._lists.get(order);
                    if (!holder)
                        return;
                    holder.set(data, priority);
                }
                update(order) {
                    const holder = this._lists.get(order);
                    if (!holder)
                        return false;
                    let res = false;
                    const activities = holder.activities;
                    for (let i = 0; i < activities.length; i++) {
                        const activity = activities[i];
                        if (!activity.parallel && this._executeResult)
                            continue;
                        if (activity.parallel && activity.parallel_activities && this._executeResultName) {
                            if (!activity.parallel_activities.some((pa) => pa === this._executeResultName)) {
                                continue;
                            }
                        }
                        const result = activity.updater.run();
                        if (!result)
                            continue;
                        if (result) {
                            this._results.push(result);
                            if (!activity.parallel) {
                                this._executeResult = result;
                                this._executeResultName = activity.name;
                                res = result;
                            }
                            if (result.triggered) {
                                result.execute?.();
                            }
                            if (result.tags) {
                                if (result.tagTop) {
                                    this._tag.splice(0, 0, ...result.tags);
                                }
                                else {
                                    this._tag.push(...result.tags);
                                }
                            }
                            // console.log(`activity: ${activity.name()}`);
                        }
                    }
                    return res;
                }
                onFinish() {
                    this._executeResult = undefined;
                    this._executeResultName = "";
                    this._results = [];
                    this._tag = [];
                }
                initialize() {
                    this._lists = new Map();
                    this._lists.set(Activity.Order.PreUpdate, new Holder());
                    this._lists.set(Activity.Order.UpdateNonmoving, new Holder());
                    this._lists.set(Activity.Order.PostUpdate, new Holder());
                    this._executeResult = undefined;
                    this._executeResultName = "";
                    this._results = [];
                    this._tag = [];
                }
                sort() {
                    this._lists.forEach((holder) => {
                        holder.sort();
                    });
                }
            }
            Activity.Manager = new Main();
            function initialize() {
                Activity.Manager.initialize();
                //
                Activity.Manager.set(Activity.Order.PreUpdate, Activity.createHereEventActivity(), 1);
                Activity.Manager.set(Activity.Order.PreUpdate, Activity.createUpdateChargeTargetsActivity(), 5);
                // Manager.set(Order.PreUpdate, createPreActionActivity(), 10);
                //
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createFollowerActivity(), 10);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createNpcActivity(), 20);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createDairyActivity(), 30);
                // Manager.set(Order.UpdateNonmoving, createAutoFeederActivity(), 40);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createSprinklerActivity(), 50);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createPutSprinklerActivity(), 60);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createPutIncubatorActivity(), 70);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createIncubatorActivity(), 80);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createThereEventActivity(), 90);
                Activity.Manager.set(Activity.Order.UpdateNonmoving, Activity.createFarmLevelingActivity(), 100);
                //
                Activity.Manager.set(Activity.Order.PostUpdate, Activity.createConsumeItemActivity(), 1);
                Activity.Manager.set(Activity.Order.PostUpdate, Activity.createPreActionActivity(), 9);
                Activity.Manager.set(Activity.Order.PostUpdate, Activity.createActionActivity(), 10);
                Activity.Manager.sort();
            }
            Activity.initialize = initialize;
        })(Activity = Life.Activity || (Life.Activity = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Activity;
        (function (Activity) {
            function createUpdateChargeTargetsActivity() {
                return {
                    name: "UpdateChargeTargetsActivity",
                    parallel: true,
                    updater: new Activity.UpdateChargeTargetsUpdater(),
                };
            }
            Activity.createUpdateChargeTargetsActivity = createUpdateChargeTargetsActivity;
            function createHereEventActivity() {
                return {
                    name: "HereEventTagActivity",
                    parallel: false,
                    updater: new Activity.HereEventTagUpdater(),
                };
            }
            Activity.createHereEventActivity = createHereEventActivity;
            function createThereEventActivity() {
                return {
                    name: "ThereEventActivity",
                    parallel: false,
                    updater: new Activity.ThereEventUpdater(),
                };
            }
            Activity.createThereEventActivity = createThereEventActivity;
            function createFollowerActivity() {
                return {
                    name: "FollowerUpdater",
                    parallel: false,
                    updater: new Activity.FollowerUpdater(),
                };
            }
            Activity.createFollowerActivity = createFollowerActivity;
            function createNpcActivity() {
                return {
                    name: "NPCActivity",
                    parallel: false,
                    updater: new Activity.NpcUpdater(),
                };
            }
            Activity.createNpcActivity = createNpcActivity;
            function createDairyActivity() {
                return {
                    name: "DairyActivity",
                    parallel: false,
                    updater: new Activity.DairyUpdater(),
                };
            }
            Activity.createDairyActivity = createDairyActivity;
            function createAutoFeederActivity() {
                return {
                    name: "AutoFeederActivity",
                    parallel: false,
                    updater: new Activity.AutoFeederUpdater(),
                };
            }
            Activity.createAutoFeederActivity = createAutoFeederActivity;
            function createPutSprinklerActivity() {
                return {
                    name: "PutSprinklerActivity",
                    parallel: false,
                    updater: new Activity.PutSprinklerUpdater(),
                };
            }
            Activity.createPutSprinklerActivity = createPutSprinklerActivity;
            function createSprinklerActivity() {
                return {
                    name: "SprinklerActivity",
                    parallel: false,
                    updater: new Activity.SprinklerUpdater(),
                };
            }
            Activity.createSprinklerActivity = createSprinklerActivity;
            function createPutIncubatorActivity() {
                return {
                    name: "PutIncubatorActivity",
                    parallel: false,
                    updater: new Activity.PutIncubatorUpdater(),
                };
            }
            Activity.createPutIncubatorActivity = createPutIncubatorActivity;
            function createIncubatorActivity() {
                return {
                    name: "IncubatorActivity",
                    parallel: false,
                    updater: new Activity.IncubatorUpdater(),
                };
            }
            Activity.createIncubatorActivity = createIncubatorActivity;
            function createConsumeItemActivity() {
                return {
                    name: "ConsumeItemActivity",
                    parallel: true,
                    // HereEventおよびThereEventとは並列で実行可
                    parallel_activities: ["HereEventTagActivity", "ThereEventActivity"],
                    updater: new Activity.ConsumeItemUpdater(),
                };
            }
            Activity.createConsumeItemActivity = createConsumeItemActivity;
            function createFarmLevelingActivity() {
                return {
                    name: "FarmLevelingActivity",
                    parallel: false,
                    updater: new Activity.FarmLevelingUpdater(),
                };
            }
            Activity.createFarmLevelingActivity = createFarmLevelingActivity;
            function createPreActionActivity() {
                return {
                    name: "PreActionActivity",
                    parallel: false,
                    updater: new Activity.PreActionUpdater(),
                };
            }
            Activity.createPreActionActivity = createPreActionActivity;
            function createActionActivity() {
                return {
                    name: "ActionActivity",
                    parallel: true,
                    updater: new Activity.ActionUpdater(),
                };
            }
            Activity.createActionActivity = createActionActivity;
        })(Activity = Life.Activity || (Life.Activity = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Activity;
        (function (Activity) {
            function isTriggeredAction() {
                return Input.isTriggered(Iz.IO.KEY_NAME_OK) || Life.isTouchOk();
            }
            Activity.isTriggeredAction = isTriggeredAction;
            function isTriggeredSubAction(mouseOk = false) {
                return (Input.isTriggered(Iz.IO.KEY_NAME_SUB_ACTION) ||
                    (mouseOk ? Life.isTouchOk() : Life.isTouchCancel()));
            }
            Activity.isTriggeredSubAction = isTriggeredSubAction;
            function executableItem() {
                if (!Life.ItemSlot.active)
                    return false;
                if (!$dataItems[Life.ItemSlot.itemId])
                    return false;
                return true;
            }
            Activity.executableItem = executableItem;
            function getStoneTag(event) {
                const stoneId = Life.getStoneId(event);
                const data = $dataMiningStone[stoneId];
                if (!data)
                    return [];
                return [data.tag];
            }
            Activity.getStoneTag = getStoneTag;
            function mergeResult(list) {
                let result = list.find((data) => data);
                if (!result)
                    return false;
                const tags = [];
                for (let i = 0; i < list.length; i++) {
                    const data = list[i];
                    if (!data)
                        continue;
                    if (!result.triggered && data.triggered) {
                        result = data;
                    }
                    if (data.tags) {
                        tags.push(...data.tags);
                    }
                }
                result.tags = tags;
                return result;
            }
            Activity.mergeResult = mergeResult;
            function getHereEventTags() {
                const events = Life.getHereEvents(Life.EventPriotity.Below);
                if (events.length <= 0)
                    return false;
                let tags = undefined;
                for (let i = 0; i < events.length; i++) {
                    const e = events[i];
                    tags = Life.getEventTags(e);
                    if (tags)
                        break;
                }
                if (!tags || tags.length <= 0)
                    return false;
                return tags;
            }
            Activity.getHereEventTags = getHereEventTags;
            class ItemUpdater {
                get itemId() {
                    return Life.ItemSlot.itemId;
                }
                get item() {
                    return $dataItems[this.itemId];
                }
                triggered(isSub) {
                    if (isSub) {
                        return isTriggeredSubAction();
                    }
                    return isTriggeredAction();
                }
                run() {
                    if (!executableItem())
                        return false;
                    return this.runItem();
                }
            }
            Activity.ItemUpdater = ItemUpdater;
        })(Activity = Life.Activity || (Life.Activity = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 各アクティビティ定義
(function (Iz) {
    var Life;
    (function (Life) {
        var Activity;
        (function (Activity) {
            class ConsumeItemUpdater extends Activity.ItemUpdater {
                runItem() {
                    if ($gameMap.isEventRunning())
                        return false;
                    if ($gamePlayer.getActionController().currentAction)
                        return false;
                    if (!this.usableItem(this.itemId)) {
                        return false;
                    }
                    return {
                        triggered: Activity.isTriggeredSubAction(),
                        execute: () => {
                            // 満腹度チェック
                            const stuffedValue = Life.Status.getItemStuffed(this.itemId);
                            if (Life.Status.isStuffed() && stuffedValue > 0) {
                                Iz.System.notify(Iz.Text.get("SYSTEM_NOTIFY_STUFFED"));
                                return;
                            }
                            Activity.executeAction(Life.ActionType.ItemUse);
                        },
                        tags: [Life.IndicatorKey_ConsumeUse],
                        tagTop: true,
                    };
                }
                usableItem(itemId) {
                    if ($gameMap.isEventRunning())
                        return false;
                    if (Life.isKeyItem(this.itemId))
                        return false;
                    if (Life.isSeed(this.itemId))
                        return false;
                    if (Life.isSprinkler(this.itemId))
                        return false;
                    if (!$gameParty.leader().canUse(this.item))
                        return false;
                    return true;
                }
            }
            Activity.ConsumeItemUpdater = ConsumeItemUpdater;
            class FollowerUpdater {
                calcAngleDegrees(x, y) {
                    return (Math.atan2(y, x) * 180) / Math.PI;
                }
                checkDegree(d, deg) {
                    if (d === 6) {
                        return deg <= 45 && deg > -45;
                    }
                    if (d === 4) {
                        return (deg >= 135 && deg <= 180) || (deg < -135 && deg >= -180);
                    }
                    // y座標が反転しているので逆にする
                    if (d === 8) {
                        return deg >= -135 && deg <= -45;
                    }
                    if (d === 2) {
                        return deg >= 45 && deg <= 135;
                    }
                    return false;
                }
                run() {
                    const baseX = $gamePlayer.x;
                    const baseY = $gamePlayer.y;
                    const d = $gamePlayer.direction();
                    for (let i = 0; i < $gameParty._actors.length; i++) {
                        if (i === 0)
                            continue;
                        const f = $gamePlayer.followers().follower(i - 1);
                        if (!f.isVisible())
                            continue;
                        const vx = f.x - baseX;
                        const vy = f.y - baseY;
                        const deg = this.calcAngleDegrees(vx, vy);
                        // 半径2,90度の円弧
                        const radius = 2;
                        if (this.checkDegree(d, deg) &&
                            Math.pow(vx, 2) + Math.pow(vy, 2) < Math.pow(radius, 2)) {
                            const result = {
                                triggered: Activity.isTriggeredAction(),
                                execute: () => {
                                    if (Life.isInDate()) {
                                        const DateCommonEventId = 806;
                                        $gameTemp.reserveCommonEvent(DateCommonEventId);
                                        f.setDirection($gamePlayer.reverseDir(d));
                                    }
                                },
                                tags: [Life.IndicatorKey_Talk],
                            };
                            return result;
                        }
                    }
                    return false;
                }
            }
            Activity.FollowerUpdater = FollowerUpdater;
            class NpcUpdater {
                get itemId() {
                    return Life.ItemSlot.itemId;
                }
                run() {
                    if (!Life.isNpcCommu())
                        return false;
                    const list = [this.runGift(), this.runTalk()];
                    return Activity.mergeResult(list);
                }
                runTalk() {
                    const event = Iz.Life.getTalkEvent();
                    if (!Iz.GlobalMap.IsNPC(event))
                        return false;
                    const result = {
                        triggered: Activity.isTriggeredAction(),
                        execute: () => {
                            // Game_Player.prototype.triggerButtonAction()と同じように即実行する
                            if (!$gameMap.isEventRunning()) {
                                event.start();
                                $gameMap.setupStartingEvent();
                                Life.Stats.status.getActor(event.characterId)?.talk();
                            }
                        },
                        // transfer: true,
                        tags: [Life.IndicatorKey_Talk],
                    };
                    return result;
                }
                runGift() {
                    if (!Activity.executableItem())
                        return false;
                    if (!Life.canGiftItem(Life.ItemSlot.itemId))
                        return false;
                    const event = Iz.Life.getTalkEvent();
                    if (!Iz.GlobalMap.IsNPC(event))
                        return false;
                    const dataEvent = $globalMap.findEvent(event.name, Iz.Life.EventTag_Gift);
                    if (!dataEvent)
                        return false;
                    const result = {
                        triggered: Activity.isTriggeredSubAction(),
                        execute: () => {
                            if (!$gameMap.isEventRunning()) {
                                Iz.Life.tryGiveGift(this.itemId, event.characterId);
                                event.setEvent(dataEvent);
                                event.start();
                                $gameMap.setupStartingEvent();
                            }
                        },
                        tags: [Life.IndicatorKey_Gift],
                    };
                    return result;
                }
            }
            Activity.NpcUpdater = NpcUpdater;
            class DairyUpdater extends Activity.ItemUpdater {
                runItem() {
                    const brushingResult = this.runBrushing();
                    if (brushingResult)
                        return brushingResult;
                    const milkingResult = this.runMilking();
                    if (milkingResult)
                        return milkingResult;
                    const pregnantResult = this.runPregnant();
                    if (pregnantResult)
                        return pregnantResult;
                    return false;
                }
                runBrushing() {
                    if (!Iz.Life.isBrush(this.itemId))
                        return false;
                    const livestock = this.getLivestock();
                    if (!livestock)
                        return false;
                    if (!livestock.isAdult())
                        return false;
                    if (livestock.cared)
                        return false;
                    return {
                        triggered: this.triggered(true),
                        execute: () => {
                            Iz.Life.Dairy.care(livestock.index);
                            const HeartBalloon = 4;
                            const key = Life.getLivestockOverheadKey(livestock.index);
                            $gameMap.getOverhead().playOneshot(key, HeartBalloon);
                            const consumeHp = Iz.Life.getConsumeHp(1);
                            Iz.Life.consumeHP(consumeHp);
                            Iz.Life.Status.addWorkLevelExpDairy(Iz.Life.Status.WorkDairyType.Brushing);
                            Iz.Life.Stats.dairy.addBrushedCount(1);
                            Iz.System.notify(Iz.Text.get("SYSTEM_DAIRY_BRUSHING"));
                            Iz.System.playSe("farm/Brush");
                            Iz.Life.DairyTemp.cared(livestock.type);
                        },
                        tags: [Life.IndicatorKey_Brush],
                        transfer: true,
                    };
                }
                runMilking() {
                    if (!Iz.Life.isMilking(this.itemId))
                        return false;
                    const livestock = this.getLivestock();
                    if (!livestock)
                        return false;
                    if (livestock.type !== Life.Data.LivestockType.Cow)
                        return false;
                    if (!livestock.canProducted())
                        return false;
                    return {
                        triggered: this.triggered(true),
                        execute: () => {
                            // 乳しぼり
                            Iz.Life.pickItemFromLivestock(livestock.index, false);
                            const key = Life.getLivestockOverheadKey(livestock.index);
                            $gameMap.getOverhead().delete(key);
                            const consumeHp = Iz.Life.getConsumeHp(2);
                            Iz.Life.consumeHP(consumeHp);
                            Iz.System.notify(Iz.Text.get("SYSTEM_DAIRY_MILKING"));
                        },
                        tags: [Life.IndicatorKey_Milking],
                        transfer: true,
                    };
                }
                runPregnant() {
                    if (!Iz.Life.isPregnancy(this.itemId))
                        return false;
                    const livestock = this.getLivestock();
                    if (!livestock)
                        return false;
                    const canPregnant = Iz.Life.Dairy.ableToPregnant(livestock.index);
                    return {
                        triggered: this.triggered(true),
                        execute: () => {
                            if (canPregnant) {
                                Iz.Life.Dairy.becomePregnant(livestock.index);
                                const livestockName = Iz.Life.DairyUtil.getName(livestock.index);
                                Iz.System.notify(Iz.String.format(Iz.Text.get("DAIRY_PREGNANT"), livestockName));
                                const key = Life.getLivestockOverheadKey(livestock.index);
                                $gameMap.getOverhead().setParam(key, { balloonId: 0 });
                                $gameParty.loseItem($dataItems[this.itemId], 1, false);
                            }
                            else if (Life.Dairy.isFull(livestock.shedId)) {
                                const ShedFullCommonEventId = 1043;
                                $gameTemp.reserveCommonEvent(ShedFullCommonEventId);
                            }
                        },
                        tags: canPregnant ? [Life.IndicatorKey_Pregnancy] : [],
                        transfer: true,
                    };
                }
                getLivestock() {
                    const event = Iz.Life.getThereEvent();
                    if (!event)
                        return undefined;
                    const livestock = Iz.Life.Dairy.getLivestock(event.getLivestockIndex());
                    return livestock;
                }
            }
            Activity.DairyUpdater = DairyUpdater;
            class AutoFeederUpdater {
                run() {
                    const setAutoFeeder = this.runSetAutoFeeder();
                    if (setAutoFeeder)
                        return setAutoFeeder;
                    return false;
                }
                runSetAutoFeeder() {
                    if (!Life.ItemSlot.active)
                        return false;
                    const event = Iz.Life.getThereEvent();
                    if (!event)
                        return false;
                    if (!Life.isFeedBox(event))
                        return false;
                    const shed = Life.Dairy.livestockSheds.find((s) => s.id === Life.getLivestockShedId($gameMap.mapId()));
                    if (!shed)
                        return false;
                    const feedIndex = event.getLivestockFeedIndex();
                    const alreadyAutoFeed = shed.isAutoFeed(feedIndex);
                    const isAutoFeeder = Iz.Life.isAutoFeeder(Life.ItemSlot.itemId);
                    const isChargeItem = Life.isAutoFeederChargeItem(Life.ItemSlot.itemId);
                    const tags = [];
                    if (alreadyAutoFeed) {
                        if (isChargeItem) {
                            tags.push("autofeeder_recover");
                        }
                        else {
                            tags.push("autofeeder_remove");
                        }
                    }
                    else if (isAutoFeeder) {
                        tags.push("autofeeder_put");
                    }
                    tags.push("put_pick");
                    return {
                        triggered: Activity.isTriggeredSubAction(),
                        execute: () => {
                            if (alreadyAutoFeed) {
                                if (isChargeItem) {
                                    $gameTemp.reserveCommonEvent(1046);
                                }
                                else {
                                    $gameTemp.reserveCommonEvent(1045);
                                }
                                $gameVariables.setValue(1, feedIndex);
                            }
                            else if (isAutoFeeder) {
                                $gameTemp.reserveCommonEvent(1044);
                                $gameVariables.setValue(1, feedIndex);
                            }
                        },
                        tags: tags,
                        transfer: true,
                    };
                }
            }
            Activity.AutoFeederUpdater = AutoFeederUpdater;
            class PutSprinklerUpdater extends Activity.ItemUpdater {
                runItem() {
                    if ($gameTemp.actionType !== Life.ActionType.PutSprinkler)
                        return false;
                    const position = $gameTemp.chargeTargets[0];
                    if (!position)
                        return false;
                    return {
                        triggered: this.triggered(false),
                        execute: () => {
                            const sprinklerId = Iz.Life.getSprinkerId(this.itemId);
                            const data = {
                                x: position.x,
                                y: position.y,
                                mapId: $gameMap.mapId(),
                                sprinklerId: sprinklerId,
                            };
                            $gameFarm.setSprinkler(data);
                            $gameParty.loseItem($dataItems[this.itemId], 1, false);
                        },
                        tags: [Life.IndicatorKey_Sprinkler_Put],
                    };
                }
            }
            Activity.PutSprinklerUpdater = PutSprinklerUpdater;
            class SprinklerUpdater {
                run() {
                    if (!Life.ItemSlot.active)
                        return false;
                    const e = Life.getThereEvent();
                    if (!e)
                        return false;
                    if (e.eventType() !== Life.EventType.Sprinkler)
                        return false;
                    const list = [this.runPick()];
                    return Activity.mergeResult(list);
                }
                runPick() {
                    // NOTE:
                    // TriggerButtonExで任意のキーでイベントを起動できるようにしています
                    // ここではサブアクションでイベントを起動するように設定済み
                    return {
                        triggered: Activity.isTriggeredSubAction(),
                        tags: [Life.IndicatorKey_Sprinkler_Pick],
                        transfer: true,
                    };
                }
            }
            Activity.SprinklerUpdater = SprinklerUpdater;
            class PutIncubatorUpdater {
                run() {
                    // NOTE:
                    // ツール選択時にアイテムスロットが無効化するので、ここでは判定しない
                    // if (!ItemSlot.active) return false;
                    const e = Life.getThereEvent();
                    if (!e)
                        return false;
                    if (e.eventType() !== Life.EventType.Incubator)
                        return false;
                    const shedId = Life.getLivestockShedId($gameMap.mapId());
                    if (Life.Dairy.existIncubator(shedId, e.getIncubatorIndex()))
                        return false;
                    return {
                        triggered: Activity.isTriggeredAction(),
                        transfer: true,
                        tags: [Life.IndicatorKey_Incubator_Put],
                    };
                }
            }
            Activity.PutIncubatorUpdater = PutIncubatorUpdater;
            class IncubatorUpdater {
                run() {
                    if (!Life.ItemSlot.active)
                        return false;
                    const e = Life.getThereEvent();
                    if (!e)
                        return false;
                    if (e.eventType() !== Life.EventType.Incubator)
                        return false;
                    // タマゴが置いてある場合は撤去不可
                    const shedId = Life.getLivestockShedId($gameMap.mapId());
                    const incubatorIndex = e.getIncubatorIndex();
                    if (!Life.Dairy.existIncubator(shedId, incubatorIndex))
                        return false;
                    if (Life.Dairy.existEgg(shedId, incubatorIndex))
                        return false;
                    const putEgg = Activity.isTriggeredAction() && Life.DairyUtil.hasEgg();
                    const remove = Activity.isTriggeredSubAction();
                    const tags = [];
                    tags.push(Life.IndicatorKey_Incubator_Remove);
                    if (Life.DairyUtil.hasEgg()) {
                        tags.push(Life.IndicatorKey_Incubator_PutEgg);
                    }
                    return {
                        triggered: putEgg || remove,
                        execute: () => {
                            if (remove) {
                                Life.DairyUtil.setIncubator(e.eventId(), false);
                            }
                        },
                        transfer: putEgg || remove,
                        tags: tags,
                    };
                }
            }
            Activity.IncubatorUpdater = IncubatorUpdater;
            class FarmLevelingUpdater extends Activity.ItemUpdater {
                runItem() {
                    if ($gameTemp.actionType !== Life.ActionType.FarmLeveling)
                        return false;
                    const position = $gameTemp.chargeTargets[0];
                    if (!position)
                        return false;
                    return {
                        triggered: Activity.isTriggeredSubAction(),
                        execute: () => {
                            $gameFarm.leveling(position.x, position.y, $gameMap.mapId());
                        },
                        tags: [Life.IndicatorKey_FarmLeveling],
                    };
                }
            }
            Activity.FarmLevelingUpdater = FarmLevelingUpdater;
            class ThereEventUpdater {
                run() {
                    const event = Life.getThereEvent();
                    if (!event)
                        return false;
                    if (!event.isExecutable())
                        return false;
                    return {
                        triggered: false,
                        tags: Life.getEventTags(event),
                        transfer: true,
                    };
                }
            }
            Activity.ThereEventUpdater = ThereEventUpdater;
            class HereEventTagUpdater {
                run() {
                    const tags = Activity.getHereEventTags();
                    if (!tags)
                        return false;
                    return {
                        triggered: false,
                        tags: tags,
                        transfer: true,
                    };
                }
            }
            Activity.HereEventTagUpdater = HereEventTagUpdater;
            class UpdateChargeTargetsUpdater extends Activity.ItemUpdater {
                runItem() {
                    if ($gameMap.isEventRunning())
                        return false;
                    if ($gamePlayer.getActionController().currentAction)
                        return false;
                    this.updateCharge(this.itemId);
                    return false;
                }
                updateCharge(itemId) {
                    $gameTemp.chargeTargets = [];
                    $gameTemp.actionType = Life.ActionType.None;
                    if (Life.isHoe(itemId)) {
                        const event = Life.getThereEvent();
                        $gameTemp.chargeTargets = event ? [] : Life.getHoeTherePosition();
                        $gameTemp.actionType = Life.ActionType.Hoe;
                    }
                    else if (Life.isHammer(itemId)) {
                        const event = Life.getFarmLevelingEvent();
                        if (event) {
                            const crop = $gameFarm.getCrop(event.x, event.y, $gameMap.mapId());
                            if (crop && crop.plantItemId === 0) {
                                $gameTemp.chargeTargets = [{ x: event.x, y: event.y }];
                                $gameTemp.actionType = Life.ActionType.FarmLeveling;
                            }
                        }
                        else {
                            $gameTemp.chargeTargets = Iz.Life.getHammerTherePosition();
                            $gameTemp.actionType = Life.ActionType.Hammer;
                        }
                    }
                    else if (Life.isWaterPot(itemId)) {
                        const waterPos = Life.getTakeWaterPosition($gamePlayer);
                        // 前が水場
                        if (waterPos) {
                            const existEvent = !!Life.getThereEvent() || Life.getThereEvents(Life.EventPriotity.Below).length > 0;
                            $gameTemp.chargeTargets = existEvent ? [] : [waterPos];
                            $gameTemp.actionType = Life.ActionType.TakeWater;
                        }
                        else {
                            $gameTemp.chargeTargets = Life.getWaterPotTherePosition();
                            $gameTemp.actionType = Life.ActionType.WaterPot;
                        }
                    }
                    else if (Life.isSeed(itemId)) {
                        $gameTemp.chargeTargets = Iz.Life.getPlantTherePosition();
                        $gameTemp.actionType = Iz.Life.ActionType.Plant;
                    }
                    else if (Life.isAx(itemId)) {
                        $gameTemp.chargeTargets = Iz.Life.getAxTherePosition();
                        $gameTemp.actionType = Iz.Life.ActionType.Ax;
                    }
                    else if (Life.isFishingItem(itemId)) {
                        $gameTemp.actionType = Life.ActionType.Fishing;
                        if (Life.canFishing() && !Life.getThereEvent() && !Activity.getHereEventTags()) {
                            const p = Life.playerFishingPosition();
                            $gameTemp.chargeTargets = p ? [{ x: p.chargeX, y: p.chargeY }] : [];
                            Life.CurrentFishingPosition = p;
                        }
                    }
                    else if (Life.isSprinkler(itemId)) {
                        const event = Life.getThereEvent();
                        const position = Iz.Life.getHoeTherePosition(false)[0];
                        $gameTemp.chargeTargets =
                            !event &&
                                position &&
                                $gameFarm.settableSprinkler(position.x, position.y, $gameMap.mapId())
                                ? [position]
                                : [];
                        $gameTemp.actionType = Life.ActionType.PutSprinkler;
                    }
                }
            }
            Activity.UpdateChargeTargetsUpdater = UpdateChargeTargetsUpdater;
        })(Activity = Life.Activity || (Life.Activity = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// PreAction
(function (Iz) {
    var Life;
    (function (Life) {
        var Activity;
        (function (Activity) {
            function executeAction(actionType) {
                const scene = SceneManager._scene;
                if (!scene)
                    return;
                if (!(scene instanceof Scene_Map))
                    return;
                if (!scene.isPlayerActive())
                    return;
                const controller = $gamePlayer.getActionController();
                controller.requestAction(actionType);
            }
            Activity.executeAction = executeAction;
            function executeToolAction() {
                executeAction($gameTemp.actionType);
            }
            class HoeRunner {
                check() {
                    return true;
                }
                execute() {
                    executeToolAction();
                }
                tag() {
                    return [Life.IndicatorKey_Hoe];
                }
            }
            class HammerRunner {
                check() {
                    return true;
                }
                execute() {
                    executeToolAction();
                }
                tag() {
                    return Activity.getStoneTag(Life.getHammerThereEvent());
                }
            }
            class TakeWaterRunner {
                check() {
                    return true;
                }
                execute() {
                    const prevWater = $gameFarm.water;
                    $gameFarm.setWater(Iz.Life.getWaterLimit());
                    if ($gameFarm.water > prevWater) {
                        Iz.System.playSe("farm/DrawWater");
                    }
                    executeToolAction();
                }
                tag() {
                    return [Life.IndicatorKey_TakeWater];
                }
            }
            class WaterPotRunner {
                check() {
                    return true;
                }
                execute() {
                    executeToolAction();
                }
                tag() {
                    return [Life.IndicatorKey_WaterPot];
                }
            }
            class PlantRunner {
                check() {
                    return true;
                }
                execute() {
                    executeToolAction();
                }
                tag() {
                    return [Life.IndicatorKey_Plant];
                }
            }
            class AxRunner {
                check() {
                    return true;
                }
                execute() {
                    executeToolAction();
                }
                tag() {
                    return [Life.IndicatorKey_Ax];
                }
            }
            class FishingRunner {
                check() {
                    return Life.canFishing();
                }
                execute() {
                    // 釣りは釣果で消費HPが変わる
                    // HPが0の時は実行しない
                    if (Life.getHP() <= 0 && Iz.Life.isConsumeHp()) {
                        Iz.System.notifyDelay(Iz.Text.get("SYSTEM_HP_SHORTAGE"));
                        return;
                    }
                    executeToolAction();
                }
                tag() {
                    return [Life.IndicatorKey_Fishing];
                }
            }
            class PreActionUpdater extends Activity.ItemUpdater {
                constructor() {
                    super();
                    this._runners = new Map();
                    this.initialize();
                }
                initialize() {
                    this._runners.clear();
                    this._runners.set(Life.ActionType.Hoe, new HoeRunner());
                    this._runners.set(Life.ActionType.Hammer, new HammerRunner());
                    this._runners.set(Life.ActionType.TakeWater, new TakeWaterRunner());
                    this._runners.set(Life.ActionType.WaterPot, new WaterPotRunner());
                    this._runners.set(Life.ActionType.Plant, new PlantRunner());
                    this._runners.set(Life.ActionType.Ax, new AxRunner());
                    this._runners.set(Life.ActionType.Fishing, new FishingRunner());
                }
                runItem() {
                    if ($gameMap.isEventRunning())
                        return false;
                    if (Life.isToolForbidden($gameMap.mapId()))
                        return false;
                    if ($gamePlayer.getActionController().currentAction)
                        return false;
                    const runner = this._runners.get($gameTemp.actionType);
                    if (!runner?.check()) {
                        return false;
                    }
                    const enableTag = $gameTemp.chargeTargets.length > 0;
                    const triggered = this.triggered(false);
                    return {
                        triggered: triggered,
                        execute: () => {
                            runner.execute();
                        },
                        // NOTE:
                        // 押した瞬間にインジケータが被らないように
                        tags: enableTag && !triggered ? runner.tag() : undefined,
                    };
                }
            }
            Activity.PreActionUpdater = PreActionUpdater;
        })(Activity = Life.Activity || (Life.Activity = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// Action
(function (Iz) {
    var Life;
    (function (Life) {
        var Activity;
        (function (Activity) {
            class HoeRunner {
                run() {
                    const target = $gameTemp.chargeTargets.find((t) => $gameFarm.executableHoe(t.x, t.y, $gameMap.mapId()));
                    return {
                        triggered: false,
                        tags: target ? [Life.IndicatorKey_Hoe] : [],
                    };
                }
            }
            class HammerRunner {
                run() {
                    const tag = Activity.getStoneTag(Life.getHammerThereEvent());
                    return {
                        triggered: false,
                        tags: tag,
                    };
                }
            }
            class WaterPotRunner {
                run() {
                    const existTarget = $gameTemp.chargeTargets.find((t) => $gameFarm.executableWater(t.x, t.y, $gameMap.mapId()));
                    return {
                        triggered: false,
                        tags: existTarget ? [Life.IndicatorKey_WaterPot] : [],
                    };
                }
            }
            class PlantRunner {
                run() {
                    const existTarget = $gameTemp.chargeTargets.find((t) => $gameFarm.executablePlant(t.x, t.y, $gameMap.mapId(), Life.ItemSlot.itemId));
                    return {
                        triggered: false,
                        tags: existTarget ? [Life.IndicatorKey_Plant] : [],
                    };
                }
            }
            class AxRunner {
                run() {
                    const existTarget = $gameTemp.chargeTargets.length > 0;
                    return {
                        triggered: false,
                        tags: existTarget ? [Life.IndicatorKey_Ax] : [],
                    };
                }
            }
            class FishingRunner {
                run() {
                    const existTarget = $gameTemp.chargeTargets.length > 0;
                    return {
                        triggered: false,
                        tags: existTarget ? [Life.IndicatorKey_Fishing] : [],
                    };
                }
            }
            class ActionUpdater {
                constructor() {
                    this._runners = new Map();
                    this.initialize();
                }
                initialize() {
                    this._runners.clear();
                    this._runners.set(Life.ActionType.Hoe, new HoeRunner());
                    this._runners.set(Life.ActionType.Hammer, new HammerRunner());
                    this._runners.set(Life.ActionType.WaterPot, new WaterPotRunner());
                    this._runners.set(Life.ActionType.Plant, new PlantRunner());
                    this._runners.set(Life.ActionType.Ax, new AxRunner());
                    this._runners.set(Life.ActionType.Fishing, new FishingRunner());
                }
                run() {
                    if (!$gamePlayer.getActionController().currentAction)
                        return false;
                    $gamePlayer.getActionController().update();
                    const runner = this._runners.get($gameTemp.actionType);
                    if (!runner)
                        return false;
                    return runner.run();
                }
            }
            Activity.ActionUpdater = ActionUpdater;
        })(Activity = Life.Activity || (Life.Activity = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.Activity.initialize();
    };
    // NOTE:
    // updateVehicleがupdateNonmovingの直前にあるため、
    // この位置に挿入しています
    const _Game_Player_updateVehicle = Game_Player.prototype.updateVehicle;
    Game_Player.prototype.updateVehicle = function () {
        _Game_Player_updateVehicle.call(this);
        Iz.Life.Activity.Manager.update(Iz.Life.Activity.Order.PreUpdate);
    };
    const _Game_Player_updateNonmoving = Game_Player.prototype.updateNonmoving;
    Game_Player.prototype.updateNonmoving = function (wasMoving, sceneActive) {
        Iz.Life.Indicator.clear();
        _Game_Player_updateNonmoving.call(this, wasMoving, sceneActive);
    };
    const _Game_Player_triggerButtonAction = Game_Player.prototype.triggerButtonAction;
    Game_Player.prototype.triggerButtonAction = function () {
        const result = Iz.Life.Activity.Manager.update(Iz.Life.Activity.Order.UpdateNonmoving);
        if (result && !result.transfer) {
            return true;
        }
        return _Game_Player_triggerButtonAction.call(this);
    };
    const _Game_Player_update = Game_Player.prototype.update;
    Game_Player.prototype.update = function (sceneActive) {
        _Game_Player_update.call(this, sceneActive);
        if (sceneActive) {
            Iz.Life.Activity.Manager.update(Iz.Life.Activity.Order.PostUpdate);
        }
        Iz.Life.Indicator.setInfos(Iz.Life.Activity.Manager.resultTag);
        Iz.Life.Activity.Manager.onFinish();
    };
})();
//# sourceMappingURL=Activity.js.map