/*:
 * @target MZ
 * @plugindesc キャラクターアニメーション処理
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        var Chara2D;
        (function (Chara2D) {
            Chara2D.ConditionType = {
                None: 0,
                HoeExecutable: 1,
            };
            Chara2D.EventType = {
                None: 0,
                ChangeImage: 1,
                ResetImage: 2,
                EnableMove: 3,
                PlaySe: 11,
                CommonEvent: 101,
            };
            class EventRunner {
                constructor() {
                    this._eventMap = new Map();
                }
                clear() {
                    this._eventMap.clear();
                }
                setup(events) {
                    events.forEach((e) => {
                        let list = this._eventMap.get(e.frame);
                        if (!list) {
                            list = [];
                            this._eventMap.set(e.frame, list);
                        }
                        list.push(e);
                    });
                }
                run(frame) {
                    this._eventMap.get(frame)?.forEach((data) => {
                        if (!this.checkCondition(data.condition)) {
                            return;
                        }
                        const e = data.event;
                        if (e.type === Chara2D.EventType.None) {
                            return;
                        }
                        if (e.type === Chara2D.EventType.ChangeImage) {
                            this.runChangeImage(e);
                            return;
                        }
                        if (e.type === Chara2D.EventType.ResetImage) {
                            this.runResetImage(e);
                            return;
                        }
                        if (e.type === Chara2D.EventType.EnableMove) {
                            this.runEnableMove(e);
                            return;
                        }
                        if (e.type === Chara2D.EventType.PlaySe) {
                            this.runPlaySe(e);
                        }
                        if (e.type === Chara2D.EventType.CommonEvent) {
                            this.runCommonEvent(e);
                        }
                    });
                }
                checkCondition(condition) {
                    if (!condition)
                        return true;
                    if (condition.type === Chara2D.ConditionType.None) {
                        return true;
                    }
                    if (condition.type === Chara2D.ConditionType.HoeExecutable) {
                        // 目の前のマスのみチェック
                        return Life.executableHoeAction(1);
                    }
                    const _exhaustiveCheck = condition;
                    return true;
                }
                runChangeImage(e) {
                    const actor = $gameActors.actor(e.actor);
                    if (!actor)
                        return;
                    actor.setCharacterImage(e.characterImage, e.characterIndex);
                    $gamePlayer.refresh();
                }
                runResetImage(e) {
                    resetActor(e.actor);
                }
                runEnableMove(e) {
                    Iz.Life.EnablePlayerMove = e.enable;
                }
                runPlaySe(e) {
                    Iz.System.playSe(e.name);
                }
                runCommonEvent(e) {
                    $gameTemp.reserveCommonEvent(e.id);
                }
            }
            class Animation {
                constructor() {
                    this._data = undefined;
                    this._frame = 0;
                    this._maxFrames = 0;
                    this._enable = false;
                    this._eventRunner = new EventRunner();
                }
                get frame() {
                    return this._frame;
                }
                get clip() {
                    return this.getClip(this.frame);
                }
                get clips() {
                    if (!this._data)
                        return [];
                    return this._data.clips;
                }
                get playing() {
                    return this._enable;
                }
                get finished() {
                    return this._frame >= this._maxFrames;
                }
                get empty() {
                    return !this._data;
                }
                set(data) {
                    this._data = data;
                    this._frame = 0;
                    this._maxFrames = this.frames();
                    this._enable = false;
                    if (data.events) {
                        this._eventRunner.setup(data.events);
                    }
                }
                play() {
                    this._enable = true;
                }
                stop() {
                    this._enable = false;
                    this._frame = 0;
                    this._data = undefined;
                    this._eventRunner.clear();
                }
                update() {
                    if (!this._enable)
                        return;
                    if (this.finished)
                        return;
                    this._frame++;
                    this._eventRunner.run(this.frame);
                }
                frames() {
                    return this.clips.map((c) => c.frame).reduce((accu, current) => accu + current, 0);
                }
                getClip(frame) {
                    let total = 0;
                    const clips = this.clips;
                    for (let i = 0; i < clips.length; i++) {
                        const clip = clips[i];
                        if (frame > total && frame <= total + clip.frame) {
                            return clip;
                        }
                        total += clip.frame;
                    }
                    return undefined;
                }
            }
            class Animator {
                constructor() {
                    this._data = undefined;
                    this._animation = new Animation();
                    this._index = 0;
                }
                get data() {
                    return this._data;
                }
                get playing() {
                    return !!this._data;
                }
                get clip() {
                    return this._animation.clip;
                }
                get loop() {
                    return this._data?.loop;
                }
                play(data) {
                    this._animation.stop();
                    this._data = data;
                    this._index = 0;
                }
                update() {
                    if (!this._data)
                        return;
                    if (this._index >= this._data.list.length) {
                        if (this.loop) {
                            this._index = 0;
                        }
                        else {
                            this.finish();
                            return;
                        }
                    }
                    if (this._animation.empty) {
                        const next = this._data.list[this._index];
                        this._animation.set(next);
                        this._animation.play();
                    }
                    this._animation.update();
                    if (this._animation.finished) {
                        this._index++;
                        this._animation.stop();
                    }
                }
                stop() {
                    this._animation.stop();
                    this._data = undefined;
                    this._index = 0;
                }
                finish() {
                    this.stop();
                }
            }
            Chara2D.Animator = Animator;
            class Database {
                constructor() {
                    this._list = new Map();
                }
                register(name, data) {
                    this._list.set(name, data);
                }
                get(name) {
                    return this._list.get(name);
                }
            }
            class ImageDatabase {
                constructor() {
                    this._list = new Map();
                }
                register(name, data) {
                    this._list.set(name, data);
                }
                get(name) {
                    return this._list.get(name);
                }
                preload() {
                    this._list.forEach((data) => {
                        ImageManager.loadCharacter(data.name);
                    });
                }
            }
            Chara2D.AnimatorDatabase = new Database();
            Chara2D.AnimatorImageDatabase = new ImageDatabase();
            class AnimatorRunner {
                constructor() {
                    this._animators = new Map();
                }
                initialize() {
                    this._animators.clear();
                }
                register(id) {
                    this._animators.set(id, new Animator());
                }
                play(id, key) {
                    const data = Chara2D.AnimatorDatabase.get(key);
                    if (!data)
                        return;
                    this._animators.get(id)?.play(data);
                }
                stop(id) {
                    this._animators.get(id)?.stop();
                }
                isPlaying(id) {
                    return !!this._animators.get(id)?.playing;
                }
                getAnimator(id) {
                    return this._animators.get(id);
                }
                update() {
                    this._animators.forEach((a) => {
                        a.update();
                    });
                }
            }
            class ActorAnimatorProxy {
                constructor() {
                    this._runner = new AnimatorRunner();
                }
                initialize(actors) {
                    this._runner.initialize();
                    actors.forEach((actorId) => {
                        this._runner.register(this.getId(actorId));
                    });
                }
                play(actorId, animatorName) {
                    const key = getActorAnimatorName(actorId, animatorName);
                    this._runner.play(this.getId(actorId), key);
                }
                stop(actorId) {
                    this._runner.stop(this.getId(actorId));
                }
                isPlaying(actorId) {
                    return this._runner.isPlaying(this.getId(actorId));
                }
                getAnimator(actorId) {
                    return this._runner.getAnimator(this.getId(actorId));
                }
                update() {
                    this._runner.update();
                }
                getId(actorId) {
                    return `${actorId}`;
                }
            }
            Chara2D.ActorAnimator = new ActorAnimatorProxy();
            function getActorAnimatorName(actorId, name) {
                return `Actor${actorId}_${name}`;
            }
            Chara2D.getActorAnimatorName = getActorAnimatorName;
            function resetActor(actorId) {
                const actor = $gameActors.actor(actorId);
                if (!actor)
                    return;
                // TODO:
                // 現在の状態（衣装など？）を考慮するかも
                actor.setCharacterImage($dataActors[actorId].characterName, $dataActors[actorId].characterIndex);
                $gamePlayer.refresh();
            }
            Chara2D.resetActor = resetActor;
            function initialize() {
                // const actors: number[] = [];
                // NOTE:
                // 現在プレイヤーのみ
                const actors = [1];
                Chara2D.ActorAnimator.initialize(actors);
            }
            Chara2D.initialize = initialize;
        })(Chara2D = Life.Chara2D || (Life.Chara2D = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const fs = require("fs");
    {
        const json = JSON.parse(fs.readFileSync("data/ActorAnimation.json", "utf-8"));
        json.filter((data) => !!data).forEach((data) => {
            const animatorName = Iz.Life.Chara2D.getActorAnimatorName(data.actor, data.name);
            Iz.Life.Chara2D.AnimatorDatabase.register(animatorName, {
                name: data.name,
                list: data.list,
                loop: data.loop,
            });
        });
    }
    {
        const json = JSON.parse(fs.readFileSync("data/ActorAnimationImage.json", "utf-8"));
        json.filter((data) => !!data).forEach((data) => {
            Iz.Life.Chara2D.AnimatorImageDatabase.register(data.name, data);
        });
    }
})();
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.Chara2D.initialize();
    };
    const _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function () {
        _Scene_Map_updateMain.call(this);
        Iz.Life.Chara2D.ActorAnimator.update();
    };
    Game_Character.prototype.animatorPlaying = function () {
        return false;
    };
    Game_Character.prototype.animatorClip = function () {
        return undefined;
    };
    Game_Player.prototype.animatorPlaying = function () {
        return Iz.Life.Chara2D.ActorAnimator.isPlaying(1);
    };
    Game_Player.prototype.animatorClip = function () {
        return Iz.Life.Chara2D.ActorAnimator.getAnimator(1)?.clip;
    };
    const _Game_Player_characterName = Game_Player.prototype.characterName;
    Game_Player.prototype.characterName = function () {
        if (this.animatorPlaying()) {
            const clip = this.animatorClip();
            if (clip) {
                return clip.characterName;
            }
        }
        return _Game_Player_characterName.call(this);
    };
    const _Game_Player_pattern = Game_Player.prototype.pattern;
    Game_Player.prototype.pattern = function () {
        if (this.animatorPlaying()) {
            const clip = this.animatorClip();
            if (clip) {
                return clip.patternX;
            }
        }
        return _Game_Player_pattern.call(this);
    };
    const _Game_Player_screenX = Game_Player.prototype.screenX;
    Game_Player.prototype.screenX = function () {
        const data = Iz.Life.Chara2D.AnimatorImageDatabase.get(this.characterName());
        if (data?.offset) {
            return _Game_Player_screenX.call(this) + data.offset.x;
        }
        return _Game_Player_screenX.call(this);
    };
    const _Game_Player_screenY = Game_Player.prototype.screenY;
    Game_Player.prototype.screenY = function () {
        const data = Iz.Life.Chara2D.AnimatorImageDatabase.get(this.characterName());
        if (data?.offset) {
            return _Game_Player_screenY.call(this) + data.offset.y;
        }
        return _Game_Player_screenY.call(this);
    };
    const _Sprite_Character_characterBlockX = Sprite_Character.prototype.characterBlockX;
    Sprite_Character.prototype.characterBlockX = function () {
        if (this._character.animatorPlaying()) {
            return 0;
        }
        return _Sprite_Character_characterBlockX.call(this);
    };
    const _Sprite_Character_characterBlockY = Sprite_Character.prototype.characterBlockY;
    Sprite_Character.prototype.characterBlockY = function () {
        if (this._character.animatorPlaying()) {
            const clip = this._character.animatorClip();
            if (clip) {
                return clip.blockY;
            }
        }
        return _Sprite_Character_characterBlockY.call(this);
    };
    const _Sprite_Character_patternWidth = Sprite_Character.prototype.patternWidth;
    Sprite_Character.prototype.patternWidth = function () {
        if (this._character.animatorPlaying()) {
            // @ts-ignore
            const data = Iz.Life.Chara2D.AnimatorImageDatabase.get(this._characterName);
            if (data) {
                // @ts-ignore
                return this.bitmap.width / data.width;
            }
        }
        return _Sprite_Character_patternWidth.call(this);
    };
    const _Sprite_Character_patternHeight = Sprite_Character.prototype.patternHeight;
    Sprite_Character.prototype.patternHeight = function () {
        if (this._character.animatorPlaying()) {
            // @ts-ignore
            const data = Iz.Life.Chara2D.AnimatorImageDatabase.get(this._characterName);
            if (data) {
                // @ts-ignore
                return this.bitmap.height / data.height;
            }
        }
        return _Sprite_Character_patternHeight.call(this);
    };
})();
//# sourceMappingURL=CharacterAnimation.js.map