/*:
 * @target MZ
 * @plugindesc キャラクターに対する操作
 *
 * @help
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var GlobalMapUtil;
    (function (GlobalMapUtil) {
        function greet(actorId, disableNotify = false) {
            const npc = $globalMap.nonPlayer(actorId);
            if (!npc)
                return;
            if (!npc.getEventEnable(Iz.GlobalMap.EventTag_Greeting))
                return;
            const baseValue = $parameter.status.greet_likability;
            const likability = Iz.Life.Status.calcLikability(baseValue);
            npc.setEventEnable(Iz.GlobalMap.EventTag_Greeting, false);
            Iz.Life.Status.addLikability(actorId, likability);
            Iz.Life.Status.addGoddessPointTalk(actorId);
            Iz.Life.Status.setTalked(Iz.Life.Status.TalkType.Greeting, actorId, true);
            if (!disableNotify) {
                Iz.System.notifyChangeLikability(actorId, likability);
            }
        }
        GlobalMapUtil.greet = greet;
    })(GlobalMapUtil = Iz.GlobalMapUtil || (Iz.GlobalMapUtil = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=CharacterOperation.js.map