/*:
 * @target MZ
 * @plugindesc キャラクターのステータス関連
 *
 * @help
 *
 *
 *
 */
// 基本データ
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            class CharacterParam {
                initialize(capacity_, minValue_, maxValue_, allowClampAtChanged) {
                    this._capacity = Math.max(0, capacity_);
                    this._minValue = minValue_;
                    this._maxValue = maxValue_;
                    // this._values = Array(capacity_).fill(minValue_);
                    this._allowClampAtChanged = allowClampAtChanged;
                    this.clear();
                }
                get minValue() {
                    return this._minValue;
                }
                get maxValue() {
                    return this._maxValue;
                }
                isValidId(id) {
                    if (id < 0 || id >= this._capacity)
                        return false;
                    return true;
                }
                isValidValue(value) {
                    return value >= this._minValue && value <= this._maxValue;
                }
                getValue(id) {
                    return this.isValidId(id) ? this._values[id] : this._minValue;
                }
                getValues() {
                    return [...this._values];
                }
                setValue(id, value) {
                    if (!this.isValidId(id))
                        return;
                    if (!this.isValidValue(value) && !this._allowClampAtChanged)
                        return;
                    this._values[id] = Math.min(Math.max(value, this._minValue), this._maxValue);
                }
                addValue(id, value) {
                    if (!this.isValidId(id))
                        return;
                    if (!this.isValidValue(value) && !this._allowClampAtChanged)
                        return;
                    this._values[id] = Math.min(Math.max(this._values[id] + value, this._minValue), this._maxValue);
                }
                clear() {
                    this._values = Array(this._capacity).fill(this._minValue);
                }
            }
            Status.CharacterParam = CharacterParam;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 好感度関連
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            const LikabilityMin = 0;
            const likability = new Status.CharacterParam();
            function initializeLikability(capacity) {
                const max = $dataLikabilityLevel.filter((data) => data).sort((a, b) => b.id - a.id)[0];
                likability.initialize(capacity, LikabilityMin, max.exp, true);
            }
            Status.initializeLikability = initializeLikability;
            function getLikability(id) {
                return likability.getValue(id);
            }
            Status.getLikability = getLikability;
            function getLikabilities() {
                return likability.getValues();
            }
            Status.getLikabilities = getLikabilities;
            function setLikability(id, value) {
                likability.setValue(id, value);
            }
            Status.setLikability = setLikability;
            function addLikability(id, value) {
                likability.addValue(id, value);
            }
            Status.addLikability = addLikability;
            function getLikabilityLevel(id) {
                const dataLevel = $dataLikabilityLevel
                    .filter((data) => data)
                    .sort((a, b) => b.id - a.id)
                    .find((data) => getLikability(id) >= data.exp);
                return dataLevel?.id ?? 1;
            }
            Status.getLikabilityLevel = getLikabilityLevel;
            function getLikabilityLevelExp(level) {
                const dataLevel = $dataLikabilityLevel
                    .filter((data) => data)
                    .sort((a, b) => b.id - a.id)
                    .find((data) => level >= data.id);
                return dataLevel?.exp ?? 0;
            }
            Status.getLikabilityLevelExp = getLikabilityLevelExp;
            function getLikabilityLevelMax() {
                const max = $dataLikabilityLevel.filter((data) => data).sort((a, b) => b.id - a.id)[0];
                return max ? max.id : 1;
            }
            Status.getLikabilityLevelMax = getLikabilityLevelMax;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 関係値
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            const RelationShipMin = 0;
            const RelationShipMax = 2;
            const relationShip = new Status.CharacterParam();
            function initializeRelationShip(capacity) {
                relationShip.initialize(capacity, RelationShipMin, RelationShipMax, false);
            }
            Status.initializeRelationShip = initializeRelationShip;
            function getRelationShip(id) {
                return relationShip.getValue(id);
            }
            Status.getRelationShip = getRelationShip;
            function getRelationShips() {
                return relationShip.getValues();
            }
            Status.getRelationShips = getRelationShips;
            function setRelationShip(id, value) {
                relationShip.setValue(id, value);
            }
            Status.setRelationShip = setRelationShip;
            function getRelationshipName(relationship_) {
                return Iz.Text.get(`RELATIONSHIP_${relationship_}`);
            }
            Status.getRelationshipName = getRelationshipName;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var StatusUtil;
        (function (StatusUtil) {
            const PartnerRelationShip = 1;
            // パートナーが存在する
            function hasPartner(...excludeList) {
                const excludes = excludeList ? [...excludeList] : [];
                const targtes = Life.Status.getPartnerOptions().filter((partner) => {
                    return !excludes.includes(partner);
                });
                return !!targtes.find((target) => {
                    return Life.Status.getRelationShip(target) >= PartnerRelationShip;
                });
            }
            StatusUtil.hasPartner = hasPartner;
            function partner() {
                const partner = Life.Status.getPartnerOptions().find((partner) => Life.Status.getRelationShip(partner) >= PartnerRelationShip);
                return partner ?? 0;
            }
            StatusUtil.partner = partner;
        })(StatusUtil = Life.StatusUtil || (Life.StatusUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// プレゼント済み
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            Status.BeforeGift = 0;
            Status.AfterGift = 1;
            let _noLimitGifted = false;
            const gifted = new Status.CharacterParam();
            function initializeGifted(capacity) {
                gifted.initialize(capacity, Status.BeforeGift, Status.AfterGift, false);
                _noLimitGifted = false;
            }
            Status.initializeGifted = initializeGifted;
            function getGifted(id) {
                if (_noLimitGifted) {
                    return false;
                }
                return gifted.getValue(id) === Status.AfterGift;
            }
            Status.getGifted = getGifted;
            function getGifteds() {
                return gifted.getValues();
            }
            Status.getGifteds = getGifteds;
            function setGifted(id, value) {
                gifted.setValue(id, value ? Status.AfterGift : Status.BeforeGift);
            }
            Status.setGifted = setGifted;
            function newdayGifted() {
                gifted.clear();
            }
            Status.newdayGifted = newdayGifted;
            function setNoLimitGifted(value) {
                _noLimitGifted = value;
            }
            Status.setNoLimitGifted = setNoLimitGifted;
            function getNoLimitGifted() {
                return _noLimitGifted;
            }
            Status.getNoLimitGifted = getNoLimitGifted;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 作業レベル
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            Status.WorkFarmType = {
                Hoe: 1,
                WaterPot: 2,
                Harvest: 3,
            };
            Status.WorkDairyType = {
                Brushing: 1,
                Talk: 2,
                GetEgg: 3,
                Milking: 4,
                Hatch: 5, // 孵化
                Birth: 6, // 出産
            };
            const WorkTypeMax = 6;
            const ValueMin = 0;
            const ValueMax = 9999999999;
            const params = [];
            const BaseExpList = [0, 0, 0, 1, 1, 0, 1]; // 基本取得経験値
            const LevelUpSwitch = 1051;
            let levelUpInfo;
            function initializeWorkLevel() {
                for (let i = 0; i <= WorkTypeMax; ++i) {
                    params[i] = ValueMin;
                }
                levelUpInfo = {
                    workType: 0,
                    levelBefore: 0,
                    levelAfter: 0,
                    learnSkills: [],
                };
            }
            Status.initializeWorkLevel = initializeWorkLevel;
            function getWorkLevel(type) {
                const exp = params[type];
                const levelList = $dataWorkLevelExp.filter((data) => data).sort((a, b) => b.id - a.id);
                for (let i = 0; i < levelList.length; i++) {
                    if (exp >= levelList[i].exp_total) {
                        return levelList[i].id;
                    }
                }
                return 1;
            }
            Status.getWorkLevel = getWorkLevel;
            function getWorkLevelSum() {
                let level = 0;
                for (let i = 1; i <= WorkTypeMax; i++) {
                    if (i === Life.Data.WorkType.Felling) {
                        continue;
                    }
                    level += getWorkLevel(i);
                }
                return level;
            }
            Status.getWorkLevelSum = getWorkLevelSum;
            function addWorkLevelExp(type, value) {
                const levelBefore = getWorkLevel(type);
                const skillsBefore = Status.getWorkLevelTraits().filter((t) => {
                    const data = $dataTrait.get(t.id);
                    return data && data.type === Life.Data.TraitType.Skill;
                });
                setWorkLevelExp(type, params[type] + value);
                const levelAfter = getWorkLevel(type);
                const skillsAfter = Status.getWorkLevelTraits().filter((t) => {
                    const data = $dataTrait.get(t.id);
                    return data && data.type === Life.Data.TraitType.Skill;
                });
                if (levelAfter > levelBefore) {
                    // 覚えたスキルを記憶
                    const learnSkills = [];
                    if (skillsBefore.length !== skillsAfter.length) {
                        skillsAfter.forEach((t) => {
                            if (!skillsBefore.includes(t)) {
                                const traitSkillId = $dataTrait.get(t.id)?.type_id ?? 0;
                                const dataSkill = $dataTraitSkill.get(traitSkillId);
                                if (dataSkill) {
                                    learnSkills.push(dataSkill.skill_id);
                                }
                            }
                        });
                    }
                    levelUpInfo = {
                        workType: type,
                        levelBefore: levelBefore,
                        levelAfter: levelAfter,
                        learnSkills: learnSkills,
                    };
                    $gameSwitches.setValue(LevelUpSwitch, true);
                }
                Status.traits.refresh();
            }
            Status.addWorkLevelExp = addWorkLevelExp;
            function setWorkLevelExp(type, value) {
                params[type] = Math.floor(Math.min(Math.max(value, ValueMin), ValueMax));
                Status.traits.refresh();
            }
            Status.setWorkLevelExp = setWorkLevelExp;
            function getWorkLevelExp(type) {
                return params[type];
            }
            Status.getWorkLevelExp = getWorkLevelExp;
            function getWorkLevelExps() {
                return [...params];
            }
            Status.getWorkLevelExps = getWorkLevelExps;
            function getWorkLevelMax(type) {
                return $dataWorkLevel.filter((data) => data && data.type === type).length;
            }
            Status.getWorkLevelMax = getWorkLevelMax;
            function notifyWorkLevelUp() {
                const workTypeName = Life.getWorkTypeName(levelUpInfo.workType);
                const levelupText = Iz.String.format(Iz.Text.get("WORK_LEVELUP_NOTIFY"), workTypeName);
                Iz.System.notify(levelupText);
                // スキルを覚えてたら通知
                levelUpInfo.learnSkills.forEach((skill) => {
                    Iz.System.notify(Iz.String.format(Iz.Text.get("WORK_LEVEL_NOTIFY_SKILL"), $dataSkills[skill].name));
                });
            }
            Status.notifyWorkLevelUp = notifyWorkLevelUp;
            // 採掘用
            function addWorkLevelExpMining(itemId, num = 1) {
                let sum = 0;
                sum += BaseExpList[Life.Data.WorkType.Mining] ?? 0;
                for (let i = 0; i < num; i++) {
                    const exp = $dataWorkLevelExpMining[itemId]?.exp ?? 0;
                    sum += exp;
                }
                addWorkLevelExp(Life.Data.WorkType.Mining, sum);
            }
            Status.addWorkLevelExpMining = addWorkLevelExpMining;
            // 釣り用
            function addWorkLevelExpFishing(itemId) {
                // 個別設定がある場合はその値
                const base = BaseExpList[Life.Data.WorkType.Fishing] ?? 0;
                const dataFish = $dataFishingFish.get(itemId);
                if (dataFish?.enable_exp) {
                    // console.log(`[個別] ${dataFish.exp}`);
                    addWorkLevelExp(Life.Data.WorkType.Fishing, base + dataFish.exp);
                }
                else {
                    // ない場合はアイテムグループごとの設定値*魚種のレアリティ係数
                    const itemGroups = Iz.Life.getItemGroups(itemId);
                    const list = [...$dataFishingExpGroup.values()]
                        .filter((data) => data)
                        .sort((a, b) => a.exp - b.exp);
                    let dataExpGroup = list.find((data) => itemGroups.find((group) => group === data.id));
                    if (!dataExpGroup) {
                        // データ設定がなければ経験値が一番少ないデータを参照
                        dataExpGroup = list[0];
                    }
                    const groupExp = dataExpGroup?.exp ?? 0;
                    const rarityExpRate = $dataFishingRarity.get(dataFish?.rarity ?? 0)?.exp_rate ?? 1;
                    // console.log(`[グループ] groupExp:${groupExp} rarityExpRate:${rarityExpRate}`);
                    addWorkLevelExp(Life.Data.WorkType.Fishing, base + groupExp * rarityExpRate);
                }
            }
            Status.addWorkLevelExpFishing = addWorkLevelExpFishing;
            // 農作用
            function addWorkLevelExpFarm(workFarmType, itemId) {
                const base = BaseExpList[Life.Data.WorkType.Farm] ?? 0;
                let exp = 0;
                switch (workFarmType) {
                    case Status.WorkFarmType.Hoe:
                    case Status.WorkFarmType.WaterPot:
                        exp = $dataWorkLevelExpFarm[workFarmType]?.exp;
                        break;
                    case Status.WorkFarmType.Harvest:
                        if (itemId) {
                            // Cropsのデータを参照する
                            // 成長度/100を加算する
                            const growthMax = $dataCrops[itemId]?.growth_max ?? 0;
                            exp = Math.floor(Math.max(1, growthMax / 100));
                        }
                        break;
                }
                addWorkLevelExp(Life.Data.WorkType.Farm, base + exp);
            }
            Status.addWorkLevelExpFarm = addWorkLevelExpFarm;
            function addWorkLevelExpHarvest(itemId) {
                addWorkLevelExpFarm(Status.WorkFarmType.Harvest, itemId);
            }
            Status.addWorkLevelExpHarvest = addWorkLevelExpHarvest;
            // 伐採用
            function addWorkLevelExpFelling(woodNum) {
                const base = BaseExpList[Life.Data.WorkType.Felling] ?? 0;
                // 伐採は採集の経験値としてカウント
                addWorkLevelExp(Life.Data.WorkType.Pick, base + woodNum);
            }
            Status.addWorkLevelExpFelling = addWorkLevelExpFelling;
            // 採集用
            function addWorkLevelExpPick(itemId) {
                const base = BaseExpList[Life.Data.WorkType.Pick] ?? 0;
                const exp = $dataWorkLevelExpPick[itemId]?.exp ?? 0;
                addWorkLevelExp(Life.Data.WorkType.Pick, base + exp);
            }
            Status.addWorkLevelExpPick = addWorkLevelExpPick;
            // 酪農用
            function addWorkLevelExpDairy(workDairyType) {
                const base = BaseExpList[Life.Data.WorkType.Dairy] ?? 0;
                const exp = $dataWorkLevelExpDairy[workDairyType]?.exp ?? 0;
                addWorkLevelExp(Life.Data.WorkType.Dairy, base + exp);
            }
            Status.addWorkLevelExpDairy = addWorkLevelExpDairy;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var StatusUtil;
        (function (StatusUtil) {
            function addWorkLevelExp(type, value) {
                Life.Status.addWorkLevelExp(type, value);
            }
            StatusUtil.addWorkLevelExp = addWorkLevelExp;
        })(StatusUtil = Life.StatusUtil || (Life.StatusUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 疲労度
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            Status.FatigueMin = $parameter.status.fatigue.min;
            Status.FatigueMax = $parameter.status.fatigue.max;
            Status.ExhaustedThreshold = $parameter.status.fatigue.exhausted_threshold;
            const data = {
                value: Status.FatigueMin,
                overslept: false,
            };
            function getFatigue() {
                return data.value;
            }
            Status.getFatigue = getFatigue;
            function setFatigue(value) {
                const setValue = Math.floor(Math.min(Math.max(value, Status.FatigueMin), Status.FatigueMax));
                data.value = setValue;
            }
            Status.setFatigue = setFatigue;
            function addFatigue(value) {
                setFatigue(data.value + value);
            }
            Status.addFatigue = addFatigue;
            function overslept() {
                return data.overslept;
            }
            Status.overslept = overslept;
            function setOverslept(value) {
                data.overslept = value;
            }
            Status.setOverslept = setOverslept;
            function recoveredFatigue() {
                return data.value <= Status.FatigueMin;
            }
            Status.recoveredFatigue = recoveredFatigue;
            // 過労
            function exhausted() {
                return getFatigue() >= Status.ExhaustedThreshold;
            }
            Status.exhausted = exhausted;
            // 過労（倒れる）
            function overExhausted() {
                return getFatigue() >= Status.FatigueMax;
            }
            Status.overExhausted = overExhausted;
            function getFatigueData() {
                return data;
            }
            Status.getFatigueData = getFatigueData;
            function setFatigueData(data_) {
                Object.assign(data, data_);
            }
            Status.setFatigueData = setFatigueData;
            function initializeFatigue() {
                setFatigueData({
                    value: Status.FatigueMin,
                    overslept: false,
                });
            }
            Status.initializeFatigue = initializeFatigue;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            const RecoverPerMinute = $parameter.status.fatigue.recover_per_minute;
            const WakeupHour = $parameter.system.wakeup_hour;
            const EarlyWakeupOffsetHour = $parameter.system.early_wakeup_offset_hour;
            const SleepHourThreshold = $parameter.status.fatigue.sleep_hour_threshold;
            const LateNightBegin = $parameter.status.fatigue.late_night_begin;
            const WakeupHourVariableId = 1015;
            const WakeupMinuteVariableId = 1016;
            const ColdState = 11;
            function addFatigueIncludeStatus(value) {
                const add = Status.calcFatigue(value);
                Status.addFatigue(add);
            }
            function enableFatigue() {
                // NOTE:
                // [暫定]デート中は無効
                if (Life.isInDate()) {
                    return false;
                }
                // デート当日待機中は無効
                if (Life.isStandbyDate(true)) {
                    return false;
                }
                // 告白待機中は無効
                if (Life.isStandbyConfessing()) {
                    return false;
                }
                return true;
            }
            Status.enableFatigue = enableFatigue;
            function addFatigueByConsumeHp(consumeHp) {
                if (!enableFatigue())
                    return;
                let value = 0;
                // 雨の日
                if (Life.isRainy()) {
                    value += consumeHp * $parameter.status.fatigue.rate_rainy_for_consume_hp;
                }
                // 深夜帯(22:00~)
                const hour = Iz.System.getHour();
                if (hour < WakeupHour || hour >= LateNightBegin) {
                    value += consumeHp * $parameter.status.fatigue.rate_late_night_for_consume_hp;
                }
                // 屋内倍率
                if (!Life.isOutdoor($gameMap.mapId())) {
                    value *= $parameter.status.fatigue.rate_indoor;
                }
                value = Math.max(0, Math.floor(value));
                addFatigueIncludeStatus(value);
            }
            Status.addFatigueByConsumeHp = addFatigueByConsumeHp;
            function recoverFatigue(value) {
                Status.addFatigue(-value);
            }
            Status.recoverFatigue = recoverFatigue;
            function recoverFatigueMax() {
                recoverFatigue(Status.FatigueMax);
            }
            Status.recoverFatigueMax = recoverFatigueMax;
            function learnedEarly() {
                const EarlyWakeUpSkillId = 8;
                const learnedEarly = Status.getLearnedSkills().find((s) => s.id === EarlyWakeUpSkillId);
                return learnedEarly;
            }
            function defaultWakeupTime() {
                let beginHour = WakeupHour;
                if (!learnedEarly()) {
                    beginHour += EarlyWakeupOffsetHour;
                }
                const wakeupTime = Iz.System.toTime(beginHour, 0);
                return wakeupTime;
            }
            function recoverUntilWakeUpTime() {
                // 起床時間までに回復するか確認
                const wakeupTime = defaultWakeupTime();
                const hour = Iz.System.getHour();
                const minute = Iz.System.getMinute();
                const elapsedTime = Iz.System.getElapsedTime(Iz.System.toTime(hour, minute), wakeupTime);
                const recovableValue = RecoverPerMinute * elapsedTime;
                recoverFatigue(recovableValue);
                if (Status.recoveredFatigue()) {
                    const t = Iz.System.toHourAndMinute(wakeupTime);
                    $gameVariables.setValue(WakeupHourVariableId, t.hour);
                    $gameVariables.setValue(WakeupMinuteVariableId, t.minute);
                    return true;
                }
                return false;
            }
            function recoverUntilSleepHourThreshold() {
                // 睡眠時間の延長
                const fatigue = Status.getFatigue();
                const wakeUpTime = defaultWakeupTime();
                const duration = Iz.System.getElapsedTime(wakeUpTime, Iz.System.toTime(SleepHourThreshold, 0));
                recoverFatigue(RecoverPerMinute * duration);
                if (Status.recoveredFatigue()) {
                    const recoveredDuration = Math.ceil(fatigue / RecoverPerMinute);
                    const t = Iz.System.toHourAndMinute(wakeUpTime + recoveredDuration);
                    $gameVariables.setValue(WakeupHourVariableId, t.hour);
                    $gameVariables.setValue(WakeupMinuteVariableId, t.minute);
                    return true;
                }
                return false;
            }
            function catchCold() {
                // NOTE:
                // 起床時間は睡眠の上限値を設定しておく
                $gameActors.actor(1)?.addState(ColdState);
                $gameVariables.setValue(WakeupHourVariableId, SleepHourThreshold);
                $gameVariables.setValue(WakeupMinuteVariableId, 0);
                oversleep(true);
            }
            function oversleep(value) {
                Status.setOverslept(value);
                Life.Stats.status.oversleptCount++;
            }
            function sleep() {
                // NOTE:
                // 疲労度の残量に応じて起床時間が変化
                // 回復しきれない場合は風邪をひく
                $gameActors.actor(1)?.removeState(ColdState);
                let res = false;
                res = recoverUntilWakeUpTime();
                if (res) {
                    oversleep(false);
                    return;
                }
                res = recoverUntilSleepHourThreshold();
                if (res) {
                    oversleep(true);
                    return;
                }
                catchCold();
            }
            Status.sleep = sleep;
            function isFirstOverSlept() {
                return Status.overslept() && Life.Stats.status.oversleptCount === 1;
            }
            Status.isFirstOverSlept = isFirstOverSlept;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 満腹度
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            const data = {
                value: 0,
                lastTime: 0,
            };
            function getStuffedMin() {
                return $parameter.status.stuffed.min;
            }
            Status.getStuffedMin = getStuffedMin;
            function getStuffedMax() {
                return $parameter.status.stuffed.max;
            }
            Status.getStuffedMax = getStuffedMax;
            function getStuffedThreshold() {
                return $parameter.status.stuffed.threshold;
            }
            Status.getStuffedThreshold = getStuffedThreshold;
            function initializeStuffed() {
                data.value = 0;
                data.lastTime = 0;
            }
            Status.initializeStuffed = initializeStuffed;
            function setStuffed(value) {
                const StuffedMin = getStuffedMin();
                const StuffedMax = getStuffedMax();
                const stuffed = Math.floor(Math.min(Math.max(value, StuffedMin), StuffedMax));
                data.value = stuffed;
                data.lastTime = Iz.System.getTotalTime();
            }
            Status.setStuffed = setStuffed;
            function addStuffed(addValue) {
                setStuffed(data.value + addValue);
            }
            Status.addStuffed = addStuffed;
            function isStuffed() {
                return data.value >= getStuffedThreshold();
            }
            Status.isStuffed = isStuffed;
            function getStuffedData() {
                return data;
            }
            Status.getStuffedData = getStuffedData;
            function setStuffedData(data_) {
                Object.assign(data, data_);
            }
            Status.setStuffedData = setStuffedData;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 会話済み
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            Status.BeforeTalked = 0;
            Status.AfterTalked = 1;
            Status.TalkType = {
                Greeting: "greeting",
            };
            const talked = new Map();
            function getTalked(type, id) {
                return talked.get(type)?.getValue(id) === Status.AfterTalked;
            }
            Status.getTalked = getTalked;
            function setTalked(type, id, value) {
                const p = talked.get(type);
                if (!p)
                    return;
                p.setValue(id, value ? Status.AfterTalked : Status.BeforeTalked);
            }
            Status.setTalked = setTalked;
            function getTalkedData() {
                const param = {};
                talked.forEach((v, k) => {
                    param[k] = v.getValues();
                });
                const res = {
                    params: param,
                };
                return res;
            }
            Status.getTalkedData = getTalkedData;
            function setTalkedData(data) {
                const temp = getTalkedData();
                Iz.Obj.applyRecursive(temp, data);
                for (const key in temp.params) {
                    const params = talked.get(key);
                    if (!params)
                        continue;
                    temp.params[key].forEach((p, i) => {
                        params.setValue(i, p);
                    });
                }
            }
            Status.setTalkedData = setTalkedData;
            function newdayTalked() {
                talked.forEach((t) => {
                    t.clear();
                });
            }
            Status.newdayTalked = newdayTalked;
            function initializeTalked(capacity) {
                talked.clear();
                talked.set(Status.TalkType.Greeting, new Status.CharacterParam());
                talked.forEach((t) => {
                    t.initialize(capacity, Status.BeforeTalked, Status.AfterTalked, false);
                });
            }
            Status.initializeTalked = initializeTalked;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 女神ポイント
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            const Min = 0;
            const Max = 9999999;
            const data = {
                point: 0,
            };
            function getGoddessPoint() {
                return data.point;
            }
            Status.getGoddessPoint = getGoddessPoint;
            function setGoddessPoint(value) {
                data.point = Math.floor(Math.min(Math.max(value, Min), Max));
            }
            Status.setGoddessPoint = setGoddessPoint;
            function addGoddessPoint(value) {
                setGoddessPoint(data.point + value);
            }
            Status.addGoddessPoint = addGoddessPoint;
            function getGoddessData() {
                return data;
            }
            Status.getGoddessData = getGoddessData;
            function setGoddessData(data_) {
                Object.assign(data, data_);
            }
            Status.setGoddessData = setGoddessData;
            function initializeGoddess() {
                data.point = 0;
            }
            Status.initializeGoddess = initializeGoddess;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            // 住民との会話
            function addGoddessPointTalk(actorId) {
                if (Status.getTalked(Status.TalkType.Greeting, actorId))
                    return;
                Status.addGoddessPoint(1);
            }
            Status.addGoddessPointTalk = addGoddessPointTalk;
            // エロイベントを見る
            // export function addGoddessPointHEvent(likabilityLevel: number) {
            //     addGoddessPoint(likabilityLevel * 100);
            // }
            // 作物の成長
            function addGoddessPointCrops(itemId) {
                const rate = 2;
                const value = $dataCrops[itemId].days_min * rate;
                Status.addGoddessPoint(value);
            }
            Status.addGoddessPointCrops = addGoddessPointCrops;
            // 魚を釣る
            function addGoddessPointFishing(itemId) {
                const rarity = Life.getFishingRariry(itemId);
                const FishS = 4;
                const FishM = 5;
                const FishL = 6;
                const FishBig = 7;
                let base = 1;
                if (Life.includeGroup(itemId, FishBig)) {
                    base = 100;
                }
                else if (Life.includeGroup(itemId, FishL)) {
                    base = 3;
                }
                else if (Life.includeGroup(itemId, FishM)) {
                    base = 2;
                }
                else if (Life.includeGroup(itemId, FishS)) {
                    base = 1;
                }
                Status.addGoddessPoint(base * rarity);
            }
            Status.addGoddessPointFishing = addGoddessPointFishing;
            // タマゴの取得
            function addGoddessPointEgg(size) {
                let point = 1;
                if (size === Life.LivestockProductRank.L)
                    point = 10;
                if (size === Life.LivestockProductRank.M)
                    point = 5;
                if (size === Life.LivestockProductRank.S)
                    point = 1;
                Status.addGoddessPoint(point);
            }
            Status.addGoddessPointEgg = addGoddessPointEgg;
            // ミルクの取得
            function addGoddessPointMilk(size) {
                let point = 1;
                if (size === Life.LivestockProductRank.L)
                    point = 20;
                if (size === Life.LivestockProductRank.M)
                    point = 10;
                if (size === Life.LivestockProductRank.S)
                    point = 2;
                Status.addGoddessPoint(point);
            }
            Status.addGoddessPointMilk = addGoddessPointMilk;
            // 採取
            function addGoddessPointPickupItem(itemId) {
                const Min = 1;
                const Max = 9999999;
                const price = $dataItems[itemId]?.price ?? 0;
                const value = Math.floor(price / 100);
                const point = Math.floor(Math.min(Math.max(value, Min), Max));
                Status.addGoddessPoint(point);
            }
            Status.addGoddessPointPickupItem = addGoddessPointPickupItem;
            // 女神さまへのお供え
            function addGoddessPointOffering(itemId) {
                const GoddessActorId = 9;
                const reaction = Life.getReaction(itemId, GoddessActorId);
                let value = 1;
                switch (reaction) {
                    case Life.Data.ProfileReactionType.DisLike2:
                    case Life.Data.ProfileReactionType.DisLike:
                        value = 0;
                        break;
                    case Life.Data.ProfileReactionType.Default:
                        value = 10;
                        break;
                    case Life.Data.ProfileReactionType.Like:
                        value = 20;
                        break;
                    case Life.Data.ProfileReactionType.Favorite:
                        value = 50;
                        break;
                    case Life.Data.ProfileReactionType.Favorite2:
                        value = 100;
                        break;
                    case Life.Data.ProfileReactionType.Favorite3:
                        value = 200;
                        break;
                }
                Status.addGoddessPoint(value);
            }
            Status.addGoddessPointOffering = addGoddessPointOffering;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 基礎パラメータアップ系
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            class ParamStatus {
                constructor() {
                    this._enableItems = new Set();
                    this._items = new Map();
                }
                initialize() {
                    this._enableItems.clear();
                    $dataStatusParamItem
                        .filter((data) => data)
                        .forEach((data) => {
                        this._enableItems.add(data.item_id);
                    });
                    this._items.clear();
                }
                isEnableItem(itemId) {
                    return this._enableItems.has(itemId);
                }
                addItem(itemId, num) {
                    if (!this.isEnableItem(itemId))
                        return;
                    if (!this._items.has(itemId)) {
                        this._items.set(itemId, { itemId: itemId, num: 0 });
                    }
                    const data = this._items.get(itemId);
                    if (!data)
                        return;
                    data.num += num;
                }
                getItemNum(itemId) {
                    return this._items.get(itemId)?.num ?? 0;
                }
                getData() {
                    return {
                        items: [...this._items.values()].sort((a, b) => a.itemId - b.itemId),
                    };
                }
                setData(data) {
                    this.initialize();
                    data.items.forEach((item) => {
                        const newItemData = {
                            itemId: item.itemId,
                            num: item.num,
                        };
                        this._items.set(newItemData.itemId, newItemData);
                    });
                }
            }
            Status.param = new ParamStatus();
            function initializeParam() {
                Status.param.initialize();
            }
            Status.initializeParam = initializeParam;
            function getParameters() {
                const list = [0, 0, 0, 0, 0, 0, 0, 0];
                $dataStatusParamItem
                    .filter((data) => data)
                    .forEach((data) => {
                    const num = Math.floor(Status.param.getItemNum(data.item_id) / data.num);
                    list[data.param_id] += data.value * num;
                });
                return list;
            }
            Status.getParameters = getParameters;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const HandlerKey = "useItem";
    function onUseItem(itemId, result) {
        if (result) {
            Iz.Life.Status.param.addItem(itemId, 1);
            Iz.Life.Status.traits.refresh();
        }
    }
    const _Scene_Map_onMapLoaded = Scene_Map.prototype.onMapLoaded;
    Scene_Map.prototype.onMapLoaded = function () {
        _Scene_Map_onMapLoaded.call(this);
        Iz.Life.ItemSlot.handler.addUseFinishedListener(HandlerKey, onUseItem);
    };
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        _Scene_Map_terminate.call(this);
        Iz.Life.ItemSlot.handler.removeUseFinishedListener(HandlerKey);
    };
})();
// 全体統括
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function initialize() {
                const capacity = $dataActors.length;
                Status.initializeLikability(capacity);
                Status.initializeRelationShip(capacity);
                Status.initializeGifted(capacity);
                Status.initializeWorkLevel();
                Status.initializeFatigue();
                Status.initializeTraits();
                Status.initializeStuffed();
                Status.initializeTalked(capacity);
                Status.initializeParam();
            }
            Status.initialize = initialize;
            // 攻略対象か
            function isPartnerOption(actorId) {
                return $parameter.status.partners.includes(actorId);
            }
            Status.isPartnerOption = isPartnerOption;
            // 攻略対象候補一覧
            function getPartnerOptions() {
                return $parameter.status.partners;
            }
            Status.getPartnerOptions = getPartnerOptions;
            function preNewday() {
                Status.sleep();
            }
            Status.preNewday = preNewday;
            function newday() {
                Status.setStuffed(0);
                Status.traits.newday();
                Status.newdayGifted();
                Status.newdayTalked();
            }
            Status.newday = newday;
            function refresh() {
                Iz.Life.setHp(Iz.Life.getHP());
            }
            Status.refresh = refresh;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        Iz.Life.Status.initialize();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.life_characterStatus = {
            likabilities: Iz.Life.Status.getLikabilities(),
            relationShips: Iz.Life.Status.getRelationShips(),
            gifteds: Iz.Life.Status.getGifteds(),
            workLevelExps: Iz.Life.Status.getWorkLevelExps(),
            traits: Iz.Life.Status.traits.tempList,
            stuffed: Iz.Life.Status.getStuffedData(),
            fatigue: Iz.Life.Status.getFatigueData(),
            talked: Iz.Life.Status.getTalkedData(),
            goddess: Iz.Life.Status.getGoddessData(),
            param: Iz.Life.Status.param.getData(),
        };
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        contents.life_characterStatus.likabilities.forEach((value, i) => {
            Iz.Life.Status.setLikability(i, value);
        });
        contents.life_characterStatus.relationShips.forEach((value, i) => {
            Iz.Life.Status.setRelationShip(i, value);
        });
        contents.life_characterStatus.gifteds.forEach((value, i) => {
            Iz.Life.Status.setGifted(i, value === Iz.Life.Status.AfterGift);
        });
        contents.life_characterStatus.workLevelExps.forEach((value, i) => {
            Iz.Life.Status.setWorkLevelExp(i, value);
        });
        Iz.Life.Status.setTraits(contents.life_characterStatus.traits);
        Iz.Life.Status.setStuffedData(contents.life_characterStatus.stuffed);
        Iz.Life.Status.setFatigueData(contents.life_characterStatus.fatigue);
        Iz.Life.Status.setTalkedData(contents.life_characterStatus.talked);
        Iz.Life.Status.setGoddessData(contents.life_characterStatus.goddess);
        if (contents.life_characterStatus.param) {
            Iz.Life.Status.param.setData(contents.life_characterStatus.param);
        }
        Iz.Life.Status.traits.enableRefreshStatus = true;
        Iz.Life.Status.traits.refresh();
    };
    let beforeFatigue = 0;
    const _Scene_Map_updateMainMultiply = Scene_Map.prototype.updateMainMultiply;
    Scene_Map.prototype.updateMainMultiply = function () {
        beforeFatigue = Iz.Life.Status.getFatigue();
        _Scene_Map_updateMainMultiply.call(this);
    };
    // 過労倒れ
    const _Scene_Map_updateScene = Scene_Map.prototype.updateScene;
    Scene_Map.prototype.updateScene = function () {
        _Scene_Map_updateScene.call(this);
        if (!SceneManager.isSceneChanging()) {
            if (!$gameMap.isEventRunning()) {
                if (Iz.Life.Status.enableFatigue()) {
                    if (Iz.Life.Status.overExhausted()) {
                        const commonEventId = 1031;
                        $gameTemp.reserveCommonEvent(commonEventId);
                        Iz.Life.Stats.status.overExhaustedCount++;
                    }
                    else if (Iz.Life.Status.getFatigue() >= Iz.Life.Status.ExhaustedThreshold) {
                        if (beforeFatigue < Iz.Life.Status.ExhaustedThreshold) {
                            const commonEventId = 1032;
                            $gameTemp.reserveCommonEvent(commonEventId);
                        }
                    }
                }
            }
        }
    };
})();
//# sourceMappingURL=CharacterStatus.js.map