/*:
 * @target MZ
 * @plugindesc 能力値(特徴)関連
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            let TraitTempType;
            (function (TraitTempType) {
                TraitTempType[TraitTempType["Idle"] = 0] = "Idle";
                TraitTempType[TraitTempType["Duration"] = 1] = "Duration";
            })(TraitTempType || (TraitTempType = {}));
            function getTraitType(traitId) {
                return $dataTrait.get(traitId)?.type ?? Life.Data.TraitType.None;
            }
            class UpdaterBase {
                constructor(data) {
                    this._data = data;
                }
                data() {
                    return this._data;
                }
            }
            class UpdaterIdle extends UpdaterBase {
                update() {
                    return false;
                }
                remainingRate() {
                    return 1;
                }
            }
            class UpdaterDuration extends UpdaterBase {
                get basetime() {
                    return this.data().basetime;
                }
                update() {
                    return Iz.System.getTotalTime() >= this.basetime + this.data().duration;
                }
                remainingRate() {
                    const whole = this.data().duration;
                    const elapsed = Iz.System.getTotalTime() - this.basetime;
                    const elpasedRate = Math.min(Math.max(elapsed / whole, 0), 1);
                    return 1 - elpasedRate;
                }
            }
            class Traits {
                constructor() {
                    this._enableRefreshStatus = false;
                    this.clear();
                }
                get list() {
                    const list = [];
                    // 作業レベル分
                    list.push(...Status.getWorkLevelTraits());
                    // 一時リスト分
                    list.push(...this.tempList);
                    return list;
                }
                get tempList() {
                    return this._tempList.map((t) => t.data());
                }
                get tempUpdaters() {
                    return this._tempList;
                }
                // get workList() {
                //     return  getWorkLevelTraits();
                // }
                get paramPlus() {
                    return this._paramPlus;
                }
                get paramRate() {
                    return this._paramRate;
                }
                get enableRefreshStatus() {
                    return this._enableRefreshStatus;
                }
                set enableRefreshStatus(value) {
                    this._enableRefreshStatus = value;
                }
                add(option) {
                    const updater = this.createUpdater(option);
                    if (updater) {
                        // 同一の効果は重複不可. 新しい方を優先
                        this._tempList = this._tempList.filter((t) => {
                            if (getTraitType(t.data().id) !== getTraitType(option.id))
                                return true;
                            if (Status.getTraitOperator(t.data().id) !== Status.getTraitOperator(option.id))
                                return true;
                            return false;
                        });
                        this._tempList.push(updater);
                        this.refresh();
                    }
                }
                addDuration(traitId, duration) {
                    this.add({
                        type: TraitTempType.Duration,
                        id: traitId,
                        duration: duration,
                        basetime: Iz.System.getTotalTime(),
                    });
                }
                createUpdater(option) {
                    if (option.type === TraitTempType.Idle) {
                        return new UpdaterIdle(option);
                    }
                    if (option.type === TraitTempType.Duration) {
                        return new UpdaterDuration(option);
                    }
                    return undefined;
                }
                update() {
                    let updated = false;
                    const len = this._tempList.length;
                    for (let i = len - 1; i >= 0; i--) {
                        const updater = this._tempList[i];
                        if (updater.update()) {
                            this._tempList.splice(i, 1);
                            updated = true;
                        }
                    }
                    if (updated) {
                        this.refresh();
                    }
                }
                refresh() {
                    this.applyParams();
                    // 関連するUIの表示更新
                    if (this._enableRefreshStatus) {
                        Status.refresh();
                    }
                }
                applyParams() {
                    this.clearParams();
                    // 基礎パラメータ上昇
                    Status.getParameters().forEach((value, i) => {
                        this._paramPlus[i] += value;
                    });
                    // 特性分
                    const params = Status.getTraitParams(this.list);
                    params.forEach((p) => {
                        this._paramPlus[p.paramId] += p.plusValue;
                        this._paramRate[p.paramId] += p.rateValue / 100;
                    });
                }
                clear() {
                    this._tempList = [];
                    this.clearParams();
                }
                clearParams() {
                    this._paramPlus = [0, 0, 0, 0, 0, 0, 0, 0];
                    this._paramRate = [1, 1, 1, 1, 1, 1, 1, 1];
                }
                newday() {
                    this.clear();
                    this.refresh();
                }
            }
            Status.Traits = Traits;
            Status.traits = new Traits();
            function initializeTraits() {
                Status.traits.enableRefreshStatus = false;
                Status.traits.clear();
            }
            Status.initializeTraits = initializeTraits;
            function setTraits(list) {
                Status.traits.clear();
                list.forEach((t) => {
                    Status.traits.add(t);
                });
                Status.traits.refresh();
            }
            Status.setTraits = setTraits;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            // 特性を取得　重複含む
            function getWorkLevelTrait(type) {
                const list = [];
                const levels = $dataWorkLevel
                    .filter((data) => data && data.type === type)
                    .filter((data) => data.level <= Status.getWorkLevel(type));
                levels.forEach((level) => {
                    $dataWorkLevelTrait
                        .filter((data) => data && data.id === level.id)
                        .forEach((data) => {
                        const trait = $dataTrait.get(data.trait_id);
                        if (trait) {
                            list.push({ id: data.trait_id });
                        }
                    });
                });
                return list;
            }
            Status.getWorkLevelTrait = getWorkLevelTrait;
            // 全ての特性を取得　重複無し
            function getWorkLevelTraits() {
                const list = [];
                const skillset = new Set(); // スキルは重複不可
                // 作業レベル
                Object.values(Life.Data.WorkType).forEach((type) => {
                    const traits = getWorkLevelTrait(type);
                    traits.forEach((trait) => {
                        const data = $dataTrait.get(trait.id);
                        if (data) {
                            if (data.type === Life.Data.TraitType.Skill) {
                                skillset.add(trait.id);
                            }
                            else {
                                list.push(trait);
                            }
                        }
                    });
                });
                // 合計作業レベル
                const sum = Iz.Life.Status.getWorkLevelSum();
                $dataWorkLevelSum
                    .filter((data) => data)
                    .filter((data) => data.level <= sum)
                    .map((data) => data.trait_id)
                    .forEach((trait_id) => {
                    const trait = $dataTrait.get(trait_id);
                    if (trait) {
                        if (trait.type === Life.Data.TraitType.Skill) {
                            skillset.add(trait_id);
                        }
                        else {
                            list.push({ id: trait_id });
                        }
                    }
                });
                const skillList = [...skillset].map((trait_id) => {
                    return { id: trait_id };
                });
                list.push(...skillList);
                list.sort((a, b) => a.id - b.id);
                return list;
            }
            Status.getWorkLevelTraits = getWorkLevelTraits;
            function getDataTraits(list) {
                const res = [];
                list.forEach((data) => {
                    const t = $dataTrait.get(data.id);
                    if (t) {
                        res.push(t);
                    }
                });
                return res;
            }
            Status.getDataTraits = getDataTraits;
            function getLearnedSkills() {
                const actor = $gameActors.actor(1);
                if (actor) {
                    return actor.skills();
                }
                return [];
            }
            Status.getLearnedSkills = getLearnedSkills;
            function excludeDuplicateGroupSkills(skills) {
                const list = [];
                const map = new Map();
                skills.forEach((skill) => {
                    const data = $dataTraitSkillDuplicate.get(skill);
                    if (data) {
                        const existSkill = map.get(data.group);
                        if (existSkill) {
                            if (skill > existSkill) {
                                map.set(data.group, skill);
                            }
                        }
                        else {
                            map.set(data.group, skill);
                        }
                    }
                    else {
                        list.push(skill);
                    }
                });
                list.push(...map.values());
                list.sort();
                return new Set(list);
            }
            Status.excludeDuplicateGroupSkills = excludeDuplicateGroupSkills;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getTraitValues(list) {
                const res = {
                    constantValue: 0,
                    rateValue: 0,
                };
                list.forEach((data) => {
                    if (data.operator === Life.Data.TraitOperator.Add) {
                        res.constantValue += data.value;
                    }
                    if (data.operator === Life.Data.TraitOperator.AddRate) {
                        res.rateValue += data.value;
                    }
                });
                return res;
            }
            Status.getTraitValues = getTraitValues;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 各特性のパラメータ計算
// パラメータ
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitParams(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.Param) {
                        const t = $dataTraitParam.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitParams(list) {
                const params = new Map();
                getDataTraitParams(list).forEach((data) => {
                    let param = params.get(data.param_id);
                    if (!param) {
                        param = {
                            paramId: data.param_id,
                            plusValue: 0,
                            rateValue: 0,
                        };
                        params.set(param.paramId, param);
                    }
                    // TODO:
                    // 現状は固定値と割合加算の2種類
                    if (data.operator === Life.Data.TraitOperator.Add) {
                        param.plusValue += data.value;
                    }
                    if (data.operator === Life.Data.TraitOperator.AddRate) {
                        param.rateValue += data.value;
                    }
                });
                return params;
            }
            Status.getTraitParams = getTraitParams;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// スキル
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitSkills(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.Skill) {
                        const p = $dataTraitSkill.get(data.type_id);
                        if (p) {
                            res.push(p);
                        }
                    }
                });
                return res;
            }
            function getTraitSkills(list) {
                const skillset = new Set(); // スキルは重複不可
                getDataTraitSkills(list).forEach((data) => {
                    skillset.add(data.skill_id);
                });
                return Status.excludeDuplicateGroupSkills(skillset);
            }
            Status.getTraitSkills = getTraitSkills;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// なかよし度
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitLikabilities(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.Likability) {
                        const t = $dataTraitLikability.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            Status.getDataTraitLikabilities = getDataTraitLikabilities;
            function getTraitLikabilityAddPercents(list) {
                const addPercentSum = getDataTraitLikabilities(list)
                    .filter((data) => data.operator === Life.Data.TraitOperator.Add)
                    .map((data) => data.value)
                    .reduce((accu, value) => accu + value, 0);
                return addPercentSum;
            }
            Status.getTraitLikabilityAddPercents = getTraitLikabilityAddPercents;
            // 補正値込みでなかよし度を算出
            function calcLikability(baseValue) {
                const addPercentSum = getTraitLikabilityAddPercents(Status.traits.list);
                return baseValue + Math.floor(baseValue * (addPercentSum / 100));
            }
            Status.calcLikability = calcLikability;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 釣りヒット確率
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitFishingHit(list, isBigFish) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.FishingHit) {
                        const t = $dataTraitFishingHit.get(data.type_id);
                        if (t && t.for_bigfish === isBigFish) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            Status.getDataTraitFishingHit = getDataTraitFishingHit;
            function getTraitFishingHitAddPercents(list, isBigFish) {
                const addsum = getDataTraitFishingHit(list, isBigFish)
                    .filter((data) => data.operator === Life.Data.TraitOperator.Add)
                    .map((data) => data.value)
                    .reduce((accu, value) => accu + value, 0);
                // 小数点第二位まで表示
                return Iz.Maths.round(addsum, 3);
            }
            Status.getTraitFishingHitAddPercents = getTraitFishingHitAddPercents;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 魚種グループ確率
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitFishGroupRate(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.FishGroupRate) {
                        const t = $dataTraitFishGroupRate.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            Status.getDataTraitFishGroupRate = getDataTraitFishGroupRate;
            function getTraitFishGroupAddPercents(list, fishGroup) {
                // const list = traits.list;
                return getDataTraitFishGroupRate(list)
                    .filter((data) => data.fish_group === fishGroup)
                    .map((data) => data.value)
                    .reduce((accu, current) => accu + current, 0);
            }
            Status.getTraitFishGroupAddPercents = getTraitFishGroupAddPercents;
            function getFishGroups() {
                return [...$dataFishingFishGroup.keys()];
            }
            Status.getFishGroups = getFishGroups;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// ダメージアップ系
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitDamageAx(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.DamageAx) {
                        const t = $dataTraitDamageAx.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitDamageAx(list) {
                const sum = getDataTraitDamageAx(list)
                    .filter((data) => data.operator === Life.Data.TraitOperator.Add)
                    .map((data) => data.value)
                    .reduce((accu, value) => accu + value, 0);
                return sum;
            }
            Status.getTraitDamageAx = getTraitDamageAx;
            function getDamageAxAdd() {
                const sum = getTraitDamageAx(Status.traits.list);
                return sum;
            }
            Status.getDamageAxAdd = getDamageAxAdd;
            function getDataTraitDamageHammer(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.DamageHammer) {
                        const t = $dataTraitDamageHammer.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitDamageHammer(list) {
                const sum = getDataTraitDamageHammer(list)
                    .filter((data) => data.operator === Life.Data.TraitOperator.Add)
                    .map((data) => data.value)
                    .reduce((accu, value) => accu + value, 0);
                return sum;
            }
            Status.getTraitDamageHammer = getTraitDamageHammer;
            function getDamageHammerAdd() {
                const sum = getTraitDamageHammer(Status.traits.list);
                return sum;
            }
            Status.getDamageHammerAdd = getDamageHammerAdd;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 疲労耐性
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitFatigueResist(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.FatigueResist) {
                        const t = $dataTraitFatigueResist.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitFatigue(list) {
                let sumPercent = getDataTraitFatigueResist(list)
                    .map((data) => data.value)
                    .reduce((accu, value) => accu + value, 0);
                sumPercent = Math.min(Math.max(sumPercent, 0), 100);
                return sumPercent;
            }
            Status.getTraitFatigue = getTraitFatigue;
            function calcFatigue(value) {
                const sumPercent = getTraitFatigue(Status.traits.list);
                const decreaseValue = Math.floor((value * sumPercent) / 100);
                const res = Math.max(0, value - decreaseValue);
                return res;
            }
            Status.calcFatigue = calcFatigue;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 体力消費耐性
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitHpResist(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.HpResist) {
                        const t = $dataTraitHpResist.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitConsumeHp(list) {
                const values = Status.getTraitValues(getDataTraitHpResist(list));
                return values;
            }
            Status.getTraitConsumeHp = getTraitConsumeHp;
            function calcConsumeHp(consumeHp) {
                // 1は残るようにする
                // const values = getTraitValues(getDataTraitHpResist(traits.list));
                const values = getTraitConsumeHp(Status.traits.list);
                let res = consumeHp;
                res = Math.max(1, res - values.constantValue);
                const decrease = Math.floor(res * (values.rateValue / 100));
                res = Math.max(1, res - decrease);
                return res;
            }
            Status.calcConsumeHp = calcConsumeHp;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 収穫量アップ
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function calcProbabilityAmount(amount, sumPercent) {
                let res = amount;
                let percent = sumPercent;
                while (percent >= 100) {
                    res++;
                    percent -= 100;
                }
                // 確率(小数点1桁まで有効)
                if (Life.passLottery(percent * 10, 1000)) {
                    res++;
                }
                return res;
            }
            Status.calcProbabilityAmount = calcProbabilityAmount;
            function getDataTraitHarvest(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.Harvest) {
                        const t = $dataTraitHarvest.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitHarvest(list) {
                const sumPercent = getDataTraitHarvest(list)
                    .map((data) => data.probability)
                    .reduce((accu, value) => accu + value, 0);
                return sumPercent;
            }
            Status.getTraitHarvest = getTraitHarvest;
            function calcHarvestAmount(amount) {
                const sumPercent = getTraitHarvest(Status.traits.list);
                return calcProbabilityAmount(amount, sumPercent);
            }
            Status.calcHarvestAmount = calcHarvestAmount;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 鉱石入手量アップ
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitMining(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.Mining) {
                        const t = $dataTraitMining.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitMining(list) {
                const sumPercent = getDataTraitMining(list)
                    .map((data) => data.probability)
                    .reduce((accu, value) => accu + value, 0);
                return sumPercent;
            }
            Status.getTraitMining = getTraitMining;
            function calcMiningAmount(amount) {
                const sumPercent = getTraitMining(Status.traits.list);
                return Status.calcProbabilityAmount(amount, sumPercent);
            }
            Status.calcMiningAmount = calcMiningAmount;
            function addMiningItem(itemId, num = 1) {
                Status.addWorkLevelExpMining(itemId, num);
                const amount = calcMiningAmount(num);
                $gameParty.gainItem($dataItems[itemId], amount);
                Iz.System.notifyGainItem(itemId, amount);
                if (Life.inMine()) {
                    Life.Stats.mining.addMiningItem(itemId, amount);
                }
                else {
                    Life.Stats.mining.addItem(itemId, amount);
                }
            }
            Status.addMiningItem = addMiningItem;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 採取量アップ
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getDataTraitPickup(list) {
                const res = [];
                Status.getDataTraits(list).forEach((data) => {
                    if (data.type === Life.Data.TraitType.Pickup) {
                        const t = $dataTraitPickup.get(data.type_id);
                        if (t) {
                            res.push(t);
                        }
                    }
                });
                return res;
            }
            function getTraitPickup(list) {
                const sumPercent = getDataTraitPickup(list)
                    .map((data) => data.probability)
                    .reduce((accu, value) => accu + value, 0);
                return sumPercent;
            }
            Status.getTraitPickup = getTraitPickup;
            function calcPickupAmount(amount) {
                const sumPercent = getTraitPickup(Status.traits.list);
                return Status.calcProbabilityAmount(amount, sumPercent);
            }
            Status.calcPickupAmount = calcPickupAmount;
            function addPickupItem(itemId) {
                Status.addWorkLevelExpPick(itemId);
                const baseAmount = 1;
                const amount = calcPickupAmount(baseAmount);
                $gameParty.gainItem($dataItems[itemId], amount);
                Iz.System.notifyGainItem(itemId, amount);
                Status.addGoddessPointPickupItem(itemId);
                Life.Stats.pickup.addItem(itemId, amount);
                Life.Stats.pickup.addTotalCount(1);
            }
            Status.addPickupItem = addPickupItem;
            function addFellingItem(woodNum) {
                Status.addWorkLevelExpFelling(woodNum);
                const amount = calcPickupAmount(woodNum);
                const woodItemId = 140;
                $gameParty.gainItem($dataItems[woodItemId], amount);
                Iz.System.notifyGainItem(woodItemId, amount);
                Life.Stats.felling.addItem(woodItemId, amount);
                Life.Stats.felling.addTotalCount(1);
            }
            Status.addFellingItem = addFellingItem;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 特性、効果
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            function getItemEffect(itemId) {
                const itemEffect = $dataItemEffect.get(itemId);
                if (itemEffect) {
                    const traits = [];
                    $dataItemEffectContent
                        .filter((data) => data && data.id === itemId)
                        .map((data) => data.effect_id)
                        .forEach((effectId) => {
                        const list = getEffectTraits(effectId);
                        traits.push(...list);
                    });
                    return {
                        stuffed: itemEffect.stuffed_value,
                        traits: traits,
                    };
                }
                // 第3グループから参照していく
                const groups = Iz.Life.getItemGroups(itemId);
                for (let i = groups.length - 1; i >= 0; i--) {
                    const group = groups[i];
                    const groupEffect = $dataGroupEffect.get(group);
                    if (groupEffect) {
                        return {
                            stuffed: groupEffect.stuffed_value,
                            traits: getEffectTraits(groupEffect.effect_id),
                        };
                    }
                }
                return undefined;
            }
            Status.getItemEffect = getItemEffect;
            function getEffectTraits(effectId) {
                const effect = $dataEffect.get(effectId);
                if (!effect)
                    return [];
                const list = $dataEffectContent.filter((data) => data && data.id === effectId);
                const res = list.map((data) => {
                    return {
                        traitId: data.trait_id,
                        duration: effect.duration,
                    };
                });
                return res;
            }
            Status.getEffectTraits = getEffectTraits;
            function getItemStuffed(itemId) {
                const effect = Status.getItemEffect(itemId);
                if (effect) {
                    return effect.stuffed;
                }
                return 0;
            }
            Status.getItemStuffed = getItemStuffed;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 特性詳細
(function (Iz) {
    var Life;
    (function (Life) {
        var Status;
        (function (Status) {
            class TraitDetailParam {
                name(id) {
                    const data = $dataTraitParam.get(id);
                    if (!data)
                        return "";
                    return Iz.Text.get(`TRAIT_PARAM_${data.param_id}`);
                }
                desc(id) {
                    const data = $dataTraitParam.get(id);
                    if (!data)
                        return "";
                    if (data.operator === Life.Data.TraitOperator.AddRate) {
                        return `${getPercentText(this.name(id), data.value)}`;
                    }
                    if (data.operator === Life.Data.TraitOperator.Add) {
                        return `${getConstantText(this.name(id), data.value)}`;
                    }
                    return "";
                }
                operator(id) {
                    const data = $dataTraitParam.get(id);
                    return data?.operator ?? Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailLikability {
                name(id) {
                    return Iz.Text.get("TRAIT_LIKABILITY");
                }
                desc(id) {
                    const data = $dataTraitLikability.get(id);
                    if (!data)
                        return "";
                    return `${getPercentText(this.name(id), data.value)}`;
                }
                operator(id) {
                    const data = $dataTraitLikability.get(id);
                    return data?.operator ?? Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailFishingHit {
                name(id) {
                    const data = $dataTraitFishingHit.get(id);
                    if (!data)
                        return "";
                    if (data.for_bigfish)
                        return Iz.Text.get("TRAIT_FISHING_HIT_RATE_ADD_BIGFISH");
                    return Iz.Text.get("TRAIT_FISHING_HIT_RATE_ADD_NORMAL");
                }
                desc(id) {
                    const data = $dataTraitFishingHit.get(id);
                    if (!data)
                        return "";
                    return `${getPercentText(this.name(id), data.value)}`;
                }
                operator(id) {
                    const data = $dataTraitFishingHit.get(id);
                    return data?.operator ?? Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailFishGroupRate {
                name(id) {
                    const data = $dataTraitFishGroupRate.get(id);
                    if (!data)
                        return "";
                    return Iz.Text.get(`TRAIT_FISH_GROUP_${data.fish_group}_RATE`);
                }
                desc(id) {
                    const data = $dataTraitFishGroupRate.get(id);
                    if (!data)
                        return "";
                    return `${getPercentText(this.name(id), data.value)}`;
                }
                operator(id) {
                    const data = $dataTraitFishGroupRate.get(id);
                    return data?.operator ?? Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailSellPrice {
                name(id) {
                    return ""; // 販売価格上昇 ※未実装
                }
                desc(id) {
                    return "";
                }
                operator(id) {
                    return Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailSkill {
                name(id) {
                    return Iz.Text.get("TRAIT_ADD_SKILL");
                }
                desc(id) {
                    const data = $dataTraitSkill.get(id);
                    if (!data)
                        return "";
                    return $dataSkills[data.skill_id]?.name ?? "";
                }
                operator(id) {
                    return Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailDamageAx {
                name(id) {
                    return Iz.Text.get("TRAIT_DAMAGE_AX");
                }
                desc(id) {
                    const data = $dataTraitDamageAx.get(id);
                    if (!data)
                        return "";
                    return `${getConstantText(this.name(id), data.value)}`;
                }
                operator(id) {
                    const data = $dataTraitDamageAx.get(id);
                    return data?.operator ?? Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailDamageHammer {
                name(id) {
                    return Iz.Text.get("TRAIT_DAMAGE_HAMMER");
                }
                desc(id) {
                    const data = $dataTraitDamageHammer.get(id);
                    if (!data)
                        return "";
                    return `${getConstantText(this.name(id), data.value)}`;
                }
                operator(id) {
                    const data = $dataTraitDamageHammer.get(id);
                    return data?.operator ?? Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailFatigueResist {
                name(id) {
                    return Iz.Text.get("TRAIT_FATIGUE_RESIST");
                }
                desc(id) {
                    const data = $dataTraitFatigueResist.get(id);
                    if (!data)
                        return "";
                    return `${getPercentText(this.name(id), data.value)}`;
                }
                operator(id) {
                    return Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailHpResist {
                name(id) {
                    return Iz.Text.get("TRAIT_HP_RESIST");
                }
                desc(id) {
                    const data = $dataTraitHpResist.get(id);
                    if (!data)
                        return "";
                    if (data.operator === Life.Data.TraitOperator.AddRate) {
                        return `${getPercentText(this.name(id), data.value)}`;
                    }
                    if (data.operator === Life.Data.TraitOperator.Add) {
                        return `${getConstantText(this.name(id), data.value)}`;
                    }
                    return "";
                }
                operator(id) {
                    const data = $dataTraitHpResist.get(id);
                    return data?.operator ?? Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailHarvest {
                name(id) {
                    return Iz.Text.get("TRAIT_HARVEST");
                }
                desc(id) {
                    const data = $dataTraitHarvest.get(id);
                    if (!data)
                        return "";
                    return `${getPercentText(this.name(id), data.probability)}`;
                }
                operator(id) {
                    return Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailMining {
                name(id) {
                    return Iz.Text.get("TRAIT_MINING");
                }
                desc(id) {
                    const data = $dataTraitMining.get(id);
                    if (!data)
                        return "";
                    return `${getPercentText(this.name(id), data.probability)}`;
                }
                operator(id) {
                    return Life.Data.TraitOperator.None;
                }
            }
            class TraitDetailPickup {
                name(id) {
                    return Iz.Text.get("TRAIT_PICKUP");
                }
                desc(id) {
                    const data = $dataTraitPickup.get(id);
                    if (!data)
                        return "";
                    return `${getPercentText(this.name(id), data.probability)}`;
                }
                operator(id) {
                    return Life.Data.TraitOperator.None;
                }
            }
            const details = new Map();
            details.set(Life.Data.TraitType.Param, new TraitDetailParam());
            details.set(Life.Data.TraitType.Likability, new TraitDetailLikability());
            details.set(Life.Data.TraitType.FishingHit, new TraitDetailFishingHit());
            details.set(Life.Data.TraitType.FishGroupRate, new TraitDetailFishGroupRate());
            details.set(Life.Data.TraitType.SellPrice, new TraitDetailSellPrice());
            details.set(Life.Data.TraitType.Skill, new TraitDetailSkill());
            details.set(Life.Data.TraitType.DamageAx, new TraitDetailDamageAx());
            details.set(Life.Data.TraitType.DamageHammer, new TraitDetailDamageHammer());
            details.set(Life.Data.TraitType.FatigueResist, new TraitDetailFatigueResist());
            details.set(Life.Data.TraitType.HpResist, new TraitDetailHpResist());
            details.set(Life.Data.TraitType.Harvest, new TraitDetailHarvest());
            details.set(Life.Data.TraitType.Mining, new TraitDetailMining());
            details.set(Life.Data.TraitType.Pickup, new TraitDetailPickup());
            function getTraitName(traitId) {
                const data = $dataTrait.get(traitId);
                if (!data) {
                    return "";
                }
                return details.get(data.type)?.name(traitId) ?? "";
            }
            Status.getTraitName = getTraitName;
            function getTraitDesc(traitId) {
                const data = $dataTrait.get(traitId);
                if (!data) {
                    return "";
                }
                return details.get(data.type)?.desc(data.type_id) ?? "";
            }
            Status.getTraitDesc = getTraitDesc;
            function getTraitOperator(traitId) {
                const data = $dataTrait.get(traitId);
                if (!data) {
                    return Life.Data.TraitOperator.None;
                }
                return details.get(data.type)?.operator(data.type_id) ?? Life.Data.TraitOperator.None;
            }
            Status.getTraitOperator = getTraitOperator;
            function getConstantText(title, value) {
                return `${title} ${value >= 0 ? "+" : ""}${value}`;
            }
            Status.getConstantText = getConstantText;
            function getPercentText(title, value) {
                return `${title} ${value >= 0 ? "+" : ""}${value}%`;
            }
            Status.getPercentText = getPercentText;
        })(Status = Life.Status || (Life.Status = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const _Game_Actor_paramPlus = Game_Actor.prototype.paramPlus;
    Game_Actor.prototype.paramPlus = function (paramId) {
        let value = _Game_Actor_paramPlus.call(this, paramId);
        value += Iz.Life.Status.traits.paramPlus[paramId];
        return value;
    };
    const _Game_Actor_paramRate = Game_Actor.prototype.paramRate;
    Game_Actor.prototype.paramRate = function (paramId) {
        let rate = _Game_Actor_paramRate.call(this, paramId);
        rate *= Iz.Life.Status.traits.paramRate[paramId];
        return rate;
    };
    const _Game_Actor_addedSkills = Game_Actor.prototype.addedSkills;
    Game_Actor.prototype.addedSkills = function () {
        const skills = _Game_Actor_addedSkills.call(this);
        // 作業レベルで覚えるスキルを反映
        {
            const traitSkills = Iz.Life.Status.traits.list
                .filter((t) => $dataTrait.get(t.id)?.type === Iz.Life.Data.TraitType.Skill)
                .map((t) => $dataTrait.get(t.id)?.type_id ?? 0)
                .filter((id) => !!$dataTraitSkill.get(id))
                .map((id) => $dataTraitSkill.get(id)?.skill_id ?? 0);
            traitSkills.forEach((id) => {
                if (!skills.includes(id)) {
                    skills.push(id);
                }
            });
        }
        return skills;
    };
    const _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function () {
        _Scene_Map_updateMain.call(this);
        Iz.Life.Status.traits.update();
    };
})();
//# sourceMappingURL=CharacterTrait.js.map