var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const ChaserType = {
            Player: 10000,
            Follower: 20000,
            Event: 30000,
        };
        function getChaseId(character) {
            if (character instanceof Game_Player)
                return ChaserType.Player;
            if (character instanceof Game_Follower)
                return ChaserType.Follower + character._memberIndex;
            if (character instanceof Game_Event)
                return ChaserType.Event + character.eventId();
            return 0;
        }
        Life.getChaseId = getChaseId;
        function chaseCharacter(chaseId) {
            if (chaseId >= ChaserType.Event)
                return $gameMap._events[chaseId - ChaserType.Event];
            if (chaseId >= ChaserType.Follower)
                return $gamePlayer.followers().follower(chaseId - 1 - ChaserType.Follower);
            if (chaseId >= ChaserType.Player)
                return $gamePlayer;
            return undefined;
        }
        Life.chaseCharacter = chaseCharacter;
        function isInDistance(x1, y1, x2, y2, range) {
            const dx = Math.abs(x1 - x2);
            const dy = Math.abs(y1 - y2);
            return dx + dy <= range;
        }
        Life.isInDistance = isInDistance;
        function isChasable(chaser, target) {
            const c = chaseCharacter(chaser);
            const t = chaseCharacter(target);
            if (!c || !t)
                return false;
            return !isInDistance(c.x, c.y, t.x, t.y, 2);
        }
        Life.isChasable = isChasable;
        class Chaser {
            constructor(chaser, target) {
                this._chaser = chaser;
                this._target = target;
                this._routes = [];
                this._calc = false;
            }
            get isPause() {
                return this._pause;
            }
            set isPause(value) {
                this._pause = value;
            }
            get chaser() {
                return this._chaser;
            }
            get target() {
                return this._target;
            }
            get calc() {
                return this._calc;
            }
            set calc(value) {
                this._calc = value;
            }
            add(r) {
                this._routes.push(r);
            }
            nextRoute() {
                return this._routes[0];
            }
            shift() {
                return this._routes.shift();
            }
            clearRoutes() {
                this._routes = [];
                this._calc = false;
            }
            length() {
                return this._routes.length;
            }
            getData() {
                return {
                    chaser: this._chaser,
                    target: this._target,
                    routes: [...this._routes],
                };
            }
            setData(data) {
                this._chaser = data.chaser;
                this._target = data.target;
                this._routes = [...data.routes];
            }
        }
        class Main {
            constructor() {
                this._chasers = new Map();
            }
            chase(chaser, target) {
                const c = new Chaser(chaser, target);
                this._chasers.set(chaser, c);
            }
            cancel(chaser) {
                this._chasers.delete(chaser);
            }
            onMove(target, x, y) {
                this._chasers.forEach((c) => {
                    if (c.target !== target)
                        return;
                    const r = c.nextRoute();
                    const cc = chaseCharacter(c.chaser);
                    const tc = chaseCharacter(c.target);
                    if (cc && tc && r) {
                        const x1 = Math.pow(x - cc.x, 2);
                        const y1 = Math.pow(y - cc.y, 2);
                        const x2 = Math.pow(tc.getPrevX() - cc.x, 2);
                        const y2 = Math.pow(tc.getPrevY() - cc.y, 2);
                        // 近づいたら
                        if (x1 + y1 <= x2 + y2) {
                            c.clearRoutes();
                        }
                        // 同じ位置
                        if (x1 === 0 && y1 === 0) {
                            return;
                        }
                    }
                    c.add({ x: x, y: y });
                });
            }
            getChaser(chaseId) {
                return this._chasers.get(chaseId);
            }
            clearRoutes() {
                this._chasers.forEach((c) => {
                    c.clearRoutes();
                });
            }
            clear() {
                this._chasers.clear();
            }
            getData() {
                return {
                    chasers: [...this._chasers.values()].map((c) => c.getData()),
                };
            }
            setData(data) {
                data.chasers.forEach((chaserData) => {
                    const c = this.getChaser(chaserData.chaser);
                    if (c) {
                        c.setData(chaserData);
                    }
                    else {
                        const c = new Chaser(chaserData.chaser, chaserData.target);
                        c.setData(chaserData);
                        this._chasers.set(chaserData.chaser, c);
                    }
                });
            }
        }
        Life.Chase = new Main();
        function initializeChase() {
            Life.Chase.clear();
        }
        Life.initializeChase = initializeChase;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function chaseFollower(followerIndex) {
            const f = $gamePlayer.followers().follower(followerIndex);
            f.setThrough(false);
            f.setPosition($gamePlayer.x, $gamePlayer.y);
            Life.Chase.chase(Life.getChaseId(f), Life.getChaseId($gamePlayer));
        }
        Life.chaseFollower = chaseFollower;
        function cancelChaseFollower(followerIndex) {
            const f = $gamePlayer.followers().follower(followerIndex);
            f.setThrough(true);
            Life.Chase.cancel(Life.getChaseId(f));
        }
        Life.cancelChaseFollower = cancelChaseFollower;
        function setChasePause(followerIndex, pause) {
            const f = $gamePlayer.followers().follower(followerIndex);
            const c = Life.Chase.getChaser(Life.getChaseId(f));
            if (c) {
                c.isPause = pause;
            }
        }
        Life.setChasePause = setChasePause;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeChase();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.chase = Iz.Life.Chase.getData();
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.Life.Chase.setData(contents.chase);
    };
    const _Game_Followers_updateMove = Game_Followers.prototype.updateMove;
    Game_Followers.prototype.updateMove = function () {
        if (!this.areGathering())
            return;
        // _Game_Followers_updateMove.call(this);
        disableCollidedWithCharacters = true;
        for (let i = this._data.length - 1; i >= 0; i--) {
            const f = this._data[i];
            if (f.isMoving())
                continue;
            //
            const d = f.findDirectionTo($gamePlayer.x, $gamePlayer.y);
            if (d) {
                f.moveStraight(d);
            }
        }
        disableCollidedWithCharacters = false;
    };
    const _Game_Follower_isCollidedWithCharacters_1 = Game_Follower.prototype.isCollidedWithCharacters;
    Game_Follower.prototype.isCollidedWithCharacters = function (x, y) {
        return _Game_Follower_isCollidedWithCharacters_1.call(this, x, y);
    };
    let disableCollidedWithCharacters = false;
    const _Game_Follower_isCollidedWithCharacters_2 = Game_Follower.prototype.isCollidedWithCharacters;
    Game_Follower.prototype.isCollidedWithCharacters = function (x, y) {
        if (disableCollidedWithCharacters) {
            return false;
        }
        return _Game_Follower_isCollidedWithCharacters_2.call(this, x, y);
    };
    const _Game_Follower_distancePerFrame = Game_Follower.prototype.distancePerFrame;
    Game_Follower.prototype.distancePerFrame = function () {
        // HalfMove.jsで斜め移動時に0.8倍しているので
        const chaseId = Iz.Life.getChaseId(this);
        const c = Iz.Life.Chase.getChaser(chaseId);
        if (c) {
            const target = Iz.Life.chaseCharacter(c.target);
            const rate = target?.isMovingDiagonal() ? 0.8 : 1;
            return (Math.pow(2, this.realMoveSpeed()) / 256) * rate;
        }
        return _Game_Follower_distancePerFrame.call(this);
    };
    const _Game_Follower_updateStop = Game_Follower.prototype.updateStop;
    Game_Follower.prototype.updateStop = function () {
        _Game_Follower_updateStop.call(this);
        const chaseId = Iz.Life.getChaseId(this);
        const c = Iz.Life.Chase.getChaser(chaseId);
        if (!c)
            return;
        if (c.isPause)
            return;
        const tc = Iz.Life.chaseCharacter(c.target);
        if (!tc)
            return;
        const cc = Iz.Life.chaseCharacter(c.chaser);
        if (!cc)
            return;
        // 常に対象の方を向く
        const tsx = this.deltaXFrom(tc.x);
        const tsy = this.deltaYFrom(tc.y);
        if (Math.abs(tsx) > Math.abs(tsy)) {
            this.setDirection(tsx > 0 ? 4 : 6);
        }
        else if (Math.abs(tsy) > Math.abs(tsx)) {
            this.setDirection(tsy > 0 ? 8 : 2);
        }
        if (!Iz.Life.isChasable(c.chaser, c.target)) {
            return;
        }
        const r = c.nextRoute();
        if (!r)
            return;
        if (c.calc) {
            const d = this.findDirectionTo(r.x, r.y);
            this.moveStraight(d);
        }
        else {
            const sx = this.deltaXFrom(r.x);
            const sy = this.deltaYFrom(r.y);
            const dx = sx > 0 ? 4 : 6;
            const dy = sy > 0 ? 8 : 2;
            if (sx !== 0 && sy !== 0 && this.canPassDiagonally(this.x, this.y, dx, dy)) {
                this.moveDiagonally(dx, dy);
            }
            else if (sx !== 0 && this.canPass(this.x, this.y, dx)) {
                this.moveStraight(dx);
            }
            else if (sy !== 0 && this.canPass(this.x, this.y, dy)) {
                this.moveStraight(dy);
            }
            else {
                // 動けない場合はルート再計算
                c.calc = true;
            }
        }
        //
        if (r.x === this.x && r.y === this.y) {
            c.shift();
            c.calc = false;
        }
    };
    Game_Follower.prototype.isHalfMove = function () {
        // ルート計算がずれるので半歩強制
        return true;
    };
    const _Game_Player_moveStraight = Game_Player.prototype.moveStraight;
    Game_Player.prototype.moveStraight = function (d) {
        _Game_Player_moveStraight.call(this, d);
        if (this.isMovementSucceeded()) {
            if (!this.areFollowersGathering()) {
                const x = this.x;
                const y = this.y;
                Iz.Life.Chase.onMove(Iz.Life.getChaseId(this), x, y);
            }
        }
    };
    const _Game_Player_moveDiagonally = Game_Player.prototype.moveDiagonally;
    Game_Player.prototype.moveDiagonally = function (h, v) {
        _Game_Player_moveDiagonally.call(this, h, v);
        if (this.isMovementSucceeded()) {
            const x = this.x;
            const y = this.y;
            Iz.Life.Chase.onMove(Iz.Life.getChaseId(this), x, y);
        }
    };
    const _Game_Player_gatherFollowers = Game_Player.prototype.gatherFollowers;
    Game_Player.prototype.gatherFollowers = function () {
        _Game_Player_gatherFollowers.call(this);
        Iz.Life.Chase.clearRoutes();
    };
    const _Game_Player_showFollowers = Game_Player.prototype.showFollowers;
    Game_Player.prototype.showFollowers = function () {
        _Game_Player_showFollowers.call(this);
        this._followers.visibleFollowers().forEach((f) => {
            const chaser = Iz.Life.Chase.getChaser(Iz.Life.getChaseId(f));
            if (!chaser)
                return;
            const target = Iz.Life.chaseCharacter(chaser.target);
            if (!target)
                return;
            f.setPosition(target.x, target.y);
        });
    };
    const _Scene_Map_onMapLoaded = Scene_Map.prototype.onMapLoaded;
    Scene_Map.prototype.onMapLoaded = function () {
        _Scene_Map_onMapLoaded.call(this);
        Iz.Life.Chase.clearRoutes();
        disableCollidedWithCharacters = false;
    };
})();
//# sourceMappingURL=Chase.js.map