//===========================================================================
// CommonEventExtend.js
//===========================================================================
/*:
 * @target MZ
 * @plugindesc 引数付きのコモンイベントを提供します
 * @author Shun
 *
 * @help
 *
 * script で取得したい場合次のコードを使用します
 * this._arguments[index]
 * index は 0 から始まります
 *
 *
 * @param DefaultCommandOverride
 * @type boolean
 * @desc デフォルトのコモンイベントの呼び出しとイベントの中断コマンドを上書きし、引数や戻り値の設定を行います
 * @default true
 *
 * @param DefaultArguments
 * @type variable[]
 * @desc 変数を指定しないでコモンイベントを呼び出した際に引数として扱われる変数を指定します
 *
 * @param DefaultResults
 * @type variable[]
 * @desc 変数を指定しないでリターンコマンドを呼び出した際に戻り値として扱われる変数を指定します
 *
 * @command CallCommonEvent(int)
 * @text CallCommonEvent(int[])
 * @desc コモンイベントの呼び出し（整数）
 *
 * @arg commonEventId
 * @type common_event
 * @text commonEventId
 * @desc コモンID
 *
 * @arg numbers
 * @type number[]
 * @text arguments
 * @desc 引数
 *
 * @command CallCommonEvent(float)
 * @text CallCommonEvent(float[])
 * @desc コモンイベントの呼び出し（実数）
 *
 * @arg commonEventId
 * @type common_event
 * @text commonEventId
 * @desc コモンイベントのID
 *
 * @arg floats
 * @type string[]
 * @text arguments
 * @desc 引数
 *
 * @command CallCommonEvent(string)
 * @text CallCommonEvent(string[])
 * @desc コモンイベントの呼び出し（文字列）
 *
 * @arg commonEventId
 * @type common_event
 * @text commonEventId
 * @desc コモンイベントのID
 *
 * @arg strings
 * @type string[]
 * @text arguments
 * @desc 引数
 *
 * @command CallCommonEventVariables
 * @text CallCommonEventVariables
 * @desc コモンイベントの呼び出し（変数）
 *
 * @arg commonEventId
 * @type common_event
 * @text commonEventId
 * @desc コモンイベントのID
 *
 * @arg variables
 * @type variable[]
 * @text arguments
 * @desc 引数
 *
 * @command getArgumentAndSetToVariable
 * @text getArgumentAndSetToVariable
 * @desc 指定した番号の引数を指定した変数に格納する
 *
 * @arg variable
 * @type variable
 * @text variable
 * @desc 格納先の変数を指定します
 *
 * @arg argmentNumber
 * @type number
 * @text argmentNumber
 * @desc 引数の番号
 *
 * @command getArgumentAndSetToVariables
 * @text getArgumentAndSetToVariables
 * @desc 引数を指定した変数に格納する
 *
 * @arg variables
 * @type variable[]
 * @text variables
 * @desc 格納先の変数の配列を指定します
 *
 * @command return
 * @text return
 * @desc コモンイベントを中断し、戻り値を返す
 *
 * @arg variables
 * @type variable[]
 * @text variables
 * @desc 格納先の変数の配列を指定します
 *
 * @command getResultAndSetToVariables
 * @text getResultAndSetToVariables
 * @desc 戻り値を指定した変数に格納する
 *
 * @arg variables
 * @type variable[]
 * @text variables
 * @desc 格納先の変数の配列を指定します
 *
 */
(() => {
    "use strict";
    const pluginName = "CommonEventExtend";
    const parameters = PluginManager.parameters('CommonEventExtend');
    const DefaultCommandOverride = (strToBoolean(parameters.DefaultCommandOverride));
    if (DefaultCommandOverride) {
        Game_Interpreter.prototype.command115 = function () {
            const variables = (strToInts(parameters.DefaultResults));
            this.return(variables);
            return true;
        };
        Game_Interpreter.prototype.command117 = function (params) {
            const variables = (strToInts(parameters.DefaultArguments));
            this.callCommonEventVariables(params[0], variables);
            return true;
        };
    }
    PluginManager.registerCommand(pluginName, "CallCommonEvent(int)", args => {
        const commoEventId = strToInt(args.commonEventId);
        const numbers = strToInts(args.numbers);
        $gameMap._interpreter.mostDepthchild().callCommonEventAnys(commoEventId, numbers);
    });
    PluginManager.registerCommand(pluginName, "CallCommonEvent(float)", args => {
        const commoEventId = strToInt(args.commonEventId);
        const numbers = strToFloats(args.floats);
        $gameMap._interpreter.mostDepthchild().callCommonEventAnys(commoEventId, numbers);
    });
    PluginManager.registerCommand(pluginName, "CallCommonEvent(string)", args => {
        const commoEventId = strToInt(args.commonEventId);
        const strings = strToFloats(args.strings);
        $gameMap._interpreter.mostDepthchild().callCommonEventAnys(commoEventId, strings);
    });
    PluginManager.registerCommand(pluginName, "CallCommonEventVariables", args => {
        const commoEventId = strToInt(args.commonEventId);
        let variables = strToInts(args.variables);
        if (!variables.length) {
            variables = (strToInts(parameters.DefaultArguments));
        }
        $gameMap._interpreter.mostDepthchild().callCommonEventVariables(commoEventId, variables);
    });
    PluginManager.registerCommand(pluginName, "getArgumentAndSetToVariable", args => {
        const variable = strToInt(args.variable);
        const argmentNumber = strToInt(args.argmentNumber);
        $gameMap._interpreter.mostDepthchild().getArgumentAndSetToVariable(variable, argmentNumber);
    });
    PluginManager.registerCommand(pluginName, "getArgumentAndSetToVariables", args => {
        let variables = strToInts(args.variables);
        if (!variables.length) {
            variables = (strToInts(parameters.DefaultArguments));
        }
        $gameMap._interpreter.mostDepthchild().getArgumentAndSetToVariables(variables);
    });
    PluginManager.registerCommand(pluginName, "return", args => {
        let variables = strToInts(args.variables);
        if (!variables.length) {
            variables = (strToInts(parameters.DefaultResults));
        }
        $gameMap._interpreter.mostDepthchild().return(variables);
    });
    PluginManager.registerCommand(pluginName, "getResultAndSetToVariables", args => {
        let variables = strToInts(args.variables);
        if (!variables.length) {
            variables = (strToInts(parameters.DefaultArguments));
        }
        $gameMap._interpreter.mostDepthchild().getResultAndSetToVariables(variables);
    });
    function strToBoolean(intString) {
        if (intString === "true")
            return true;
        return false;
    }
    function strToInt(intString) {
        if (intString === true)
            return 0;
        const commoEventId = parseInt(intString);
        return commoEventId;
    }
    function strToInts(intArrayString) {
        if (intArrayString === true || intArrayString === "")
            return [];
        const variableIds = JSON.parse(intArrayString).map((value) => parseInt(value));
        return variableIds;
    }
    function strToFloats(floatArrayString) {
        if (floatArrayString === true || floatArrayString === "")
            return [];
        const variableIds = JSON.parse(floatArrayString).map((value) => parseFloat(value));
        return variableIds;
    }
    const _Game_InterpreterClear = Game_Interpreter.prototype.clear;
    Game_Interpreter.prototype.clear = function () {
        this._arguments = [];
        this._results = [];
        _Game_InterpreterClear.call(this);
    };
    // const _Game_InterpreterSetupChild = Game_Interpreter.prototype.setupChild;
    // Game_Interpreter.prototype.setupChild = function (list, eventId) {
    //     _Game_InterpreterSetupChild.call(this, list, eventId);
    //     this._childInterpreter?.setParent(this);
    // };
    Game_Interpreter.prototype.mostDepthchild = function () {
        if (this._childInterpreter) {
            return this._childInterpreter.mostDepthchild();
        }
        return this;
    };
    Game_Interpreter.prototype.callCommonEvent = function (commonEventId, args) {
        const commonEvent = $dataCommonEvents[commonEventId];
        if (commonEvent) {
            const eventId = this.isOnCurrentMap() ? this._eventId : 0;
            this.setupChild(commonEvent.list, eventId);
            this._childInterpreter?.setArguments(args);
        }
    };
    Game_Interpreter.prototype.callCommonEventAnys = function (commonEventId, numbers) {
        this.callCommonEvent(commonEventId, numbers);
    };
    Game_Interpreter.prototype.callCommonEventVariables = function (commonEventId, variableIds) {
        const values = variableIds.map(id => $gameVariables.value(id));
        this.callCommonEvent(commonEventId, values);
    };
    Game_Interpreter.prototype.setArguments = function (args) {
        this._arguments = args;
    };
    Game_Interpreter.prototype.getArgument = function (argumentNumber) {
        return this._arguments[argumentNumber];
    };
    Game_Interpreter.prototype.getArgumentAndSetToVariable = function (varableId, argumentNumber) {
        $gameVariables.setValue(varableId, this.getArgument(argumentNumber));
    };
    Game_Interpreter.prototype.getArgumentAndSetToVariables = function (varableIds) {
        varableIds.forEach((value, index) => this.getArgumentAndSetToVariable(value, index));
    };
    Game_Interpreter.prototype.return = function (variableIds) {
        if (this._list)
            this._index = this._list.length;
        // const values = variableIds.map(id => $gameVariables.value(id));
        // if(this._parentInterpreter){
        //     this._parentInterpreter.setResults(values);
        //     this.clearDefaultArguments();
        // }        
        this.clearDefaultArguments();
    };
    Game_Interpreter.prototype.getResultAndSetToVariable = function (varableId, argumentNumber) {
        $gameVariables.setValue(varableId, this.getResult(argumentNumber));
    };
    Game_Interpreter.prototype.getResultAndSetToVariables = function (varableIds) {
        varableIds.forEach((value, index) => this.getResultAndSetToVariable(value, index));
    };
    // Game_Interpreter.prototype.setParent = function (interpreter) {
    //     this._parentInterpreter = interpreter;
    // };
    Game_Interpreter.prototype.setResults = function (results) {
        this._results = results;
    };
    Game_Interpreter.prototype.getResult = function (argumentNumber) {
        return this._results[argumentNumber];
    };
    Game_Interpreter.prototype.clearDefaultArguments = function () {
        const varableIds = (strToInts(parameters.DefaultArguments));
        varableIds.forEach((value) => $gameVariables.setValue(value, 0));
    };
})();