/*:
 * @target MZ
 * @plugindesc 伐採
 * @author INAZUMA GAMES
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const AxesList = [];
        const AxTag = "ax";
        // チャージフレーム数設定
        const AxActionFrameList = [...$parameter.charge.felling_frames];
        // チャージ消費HP係数設定(Lv.1~Lv.5)
        const AxChargeHpRate = [...$parameter.charge.felling_consume_hp_rate];
        Life.WoodEventTag = "wood";
        const WoodHpKey = "hp";
        const WoodDamegedAnimationId = 4;
        const WoodBrokenAnimationId = 5;
        Life.AxActionKey = "ax";
        function initializeAx() {
            Iz.Life.getToolItems(AxTag).forEach((data) => {
                AxesList[data.level - 1] = data.id;
            });
        }
        Life.initializeAx = initializeAx;
        function isAx(itemId) {
            return AxesList.includes(itemId);
        }
        Life.isAx = isAx;
        function isFellingEvent(event) {
            if (!event)
                return false;
            return Object.hasOwn(event.event().meta, Iz.Life.WoodEventTag);
        }
        Life.isFellingEvent = isFellingEvent;
        function getFellingRequireLevel(event) {
            if (!event)
                return 0;
            const woodId = Number(event.event().meta[Life.WoodEventTag]);
            const data = $dataFellingWood[woodId];
            if (!data)
                return 0;
            return Math.max(0, data.require_tool_level);
        }
        Life.getFellingRequireLevel = getFellingRequireLevel;
        function axLevel() {
            return Iz.Life.calcToolLevel(AxesList);
        }
        Life.axLevel = axLevel;
        function axDamage(level) {
            const base = $parameter.charge.felling_damage_base;
            const traitAdd = Life.Status.getDamageAxAdd();
            const traitMul = 1;
            const index = Math.min(Math.max(level - 1, 0), $parameter.charge.felling_damage_rate.length - 1);
            const chargeRate = $parameter.charge.felling_damage_rate[index];
            const sum = (base + traitAdd) * traitMul * chargeRate;
            const MinDamage = 1;
            const MaxDamage = 9999999;
            return Math.min(Math.max(sum, MinDamage), MaxDamage);
        }
        Life.axDamage = axDamage;
        function getAxTherePosition() {
            const thereEvent = Iz.Life.getThereEvent();
            if (thereEvent && Iz.Life.isFellingEvent(thereEvent)) {
                return [{ x: thereEvent.x, y: thereEvent.y }];
            }
            return [];
        }
        Life.getAxTherePosition = getAxTherePosition;
        const AxAnimation = {
            begin: "ax_charging",
            exec: "ax_exec",
        };
        class AxAction extends Iz.Life.ChargeAction {
            constructor() {
                super(AxActionFrameList);
            }
            onExec() {
                const wood = Iz.Life.getThereEvent();
                if (!wood || !isFellingEvent(wood)) {
                    return false;
                }
                let woodHp = wood.getSelfVariable(WoodHpKey) ?? 0;
                if (woodHp <= 0)
                    return false;
                if (this.getToolLevel() < getFellingRequireLevel(wood)) {
                    Iz.System.notify(Iz.Text.get("WORK_FELLING_LEVEL_SHORTAGE"), false);
                    Iz.System.playSe("Sword2");
                    return false;
                }
                $gameTemp.clearObjHp();
                const WoodHpMax = 9999;
                const damage = Iz.Life.axDamage(this.getChargeLevel());
                woodHp = Math.min(Math.max(woodHp - damage, 0), WoodHpMax);
                Iz.System.notifyDamage(damage);
                if (woodHp > 0) {
                    $gameTemp.requestAnimation([wood], WoodDamegedAnimationId);
                    // maxhpが設定されていたら表示
                    const woodMaxHp = wood.getSelfVariable("maxhp") ?? 0;
                    if (woodMaxHp > 0) {
                        $gameTemp.startObjHpDraw(wood.eventId(), woodHp / woodMaxHp);
                    }
                }
                else {
                    $gameTemp.requestAnimation([wood], WoodBrokenAnimationId);
                }
                wood.controlSelfVariable(WoodHpKey, TR.OperationType.Set, woodHp, false);
                Life.Stats.felling.addTotalDamage(damage);
                return true;
            }
            getChargeType() {
                return Iz.Life.ActionType.Ax;
            }
            getToolLevel() {
                return Iz.Life.axLevel();
            }
            getPositionList(basePos, level) {
                return getAxTherePosition();
            }
            getConsumeToolHp() {
                const base = $parameter.charge.felling_consume_hp_base;
                const rate = AxChargeHpRate[this.getChargeLevel() - 1] ?? 1;
                return base * rate;
            }
            animation() {
                return AxAnimation;
            }
        }
        Life.AxAction = AxAction;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const _Game_Player_onRegistAction = Game_Player.prototype.onRegistAction;
    Game_Player.prototype.onRegistAction = function () {
        _Game_Player_onRegistAction.call(this);
        const controller = this.getActionController();
        const action = new Iz.Life.AxAction();
        controller.setAction(action, Iz.Life.AxActionKey);
    };
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeAx();
    };
})();
//# sourceMappingURL=Felling.js.map