/*:
 * @target MZ
 * @plugindesc 釣り
 *
 * @help
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const FishingList = [];
        const FishingTag = "fishing";
        Life.RegionVariableId = 20;
        Life.FishingPositionXVariableId = 31;
        Life.FishingPositionYVariableId = 32;
        Life.FishingDirectionVariableId = 33;
        Life.FishingRegions = [4, 5, 6, 7, 8];
        const FishingEndSound = "Water1";
        Life.BigFishGroup = 11;
        const FishingTutorialSwitchId = 303;
        const FishingTutorialCommonEventId = 303;
        Life._fishingWaitCount = 0; // 連続実行防止の待機フレーム数
        Life.FloatEventId = 0;
        const Failed = {
            notExistFish: false,
        };
        let Success = {
            fishGroup: 0,
            item: 0,
        };
        function isFishingItem(itemId) {
            return FishingList.includes(itemId);
        }
        Life.isFishingItem = isFishingItem;
        function fishingLevel() {
            return Iz.Life.calcToolLevel(FishingList);
        }
        Life.fishingLevel = fishingLevel;
        function isFishing() {
            return $gameVariables.value(FishingStateVariableId) > 0;
        }
        Life.isFishing = isFishing;
        function getFishingDepth(region) {
            let deep = Life.FishingRegions.findIndex((r) => r === region);
            deep = deep < 0 ? 0 : deep + 1;
            return deep;
        }
        Life.getFishingDepth = getFishingDepth;
        function getFishingRariry(itemId) {
            return $dataFishingFish.get(itemId)?.rarity ?? 1;
        }
        Life.getFishingRariry = getFishingRariry;
        function calcFishingPosition(x, y, d, chargeLevel) {
            const offset = { x: 0, y: 0 };
            const abs = Math.min(Math.max(chargeLevel + 1, 2), 6);
            switch (d) {
                case 2:
                    offset.y = abs;
                    break;
                case 4:
                    offset.x = -abs;
                    break;
                case 6:
                    offset.x = abs;
                    break;
                case 8:
                    offset.y = -abs;
                    break;
            }
            return { x: x + offset.x, y: y + offset.y };
        }
        function isFishingRegion(x, y) {
            if (x < 0 || x > $gameMap.width() - 1)
                return false;
            if (y < 0 || y > $gameMap.height() - 1)
                return false;
            return !!Life.FishingRegions.find((region) => Life.isRegion(x, y, region));
        }
        function isEnableFish(itemId) {
            // 1度きり設定
            const data = $dataFishingFish.get(itemId);
            if (!data)
                return false;
            if (data.only_once) {
                if (Life.Stats.fishing.getFishNum(itemId) > 0) {
                    return false;
                }
            }
            // 1日1回
            if ($dataFishingFish.get(itemId)?.only_once_day) {
                if (Life.Fishing.getCatchNum(itemId) > 0) {
                    return false;
                }
            }
            return true;
        }
        Life.isEnableFish = isEnableFish;
        function playerFishingPosition() {
            const dir = $gamePlayer.direction();
            const target = calcFishingPosition($gamePlayer.x, $gamePlayer.y, dir, $gameTemp.chargeLevel);
            const isHalfX = !Number.isInteger(target.x);
            const isHalfY = !Number.isInteger(target.y);
            if (isHalfX && isHalfY) {
                const leftX = Math.floor(target.x);
                const rightX = Math.ceil(target.x);
                const topY = Math.floor(target.y);
                const bottomY = Math.ceil(target.y);
                // 斜め４箇所をチェック
                if (!isFishingRegion(leftX, topY))
                    return undefined;
                if (!isFishingRegion(leftX, bottomY))
                    return undefined;
                if (!isFishingRegion(rightX, topY))
                    return undefined;
                if (!isFishingRegion(rightX, bottomY))
                    return undefined;
                // HalfMoveでは半歩位置の時に半歩左を参照するので同じようにする
                const RegionX = leftX;
                if (dir === 2) {
                    return { regionX: RegionX, regionY: topY, chargeX: target.x, chargeY: target.y };
                }
                if (dir === 8) {
                    return { regionX: RegionX, regionY: bottomY, chargeX: target.x, chargeY: target.y };
                }
                // HalfMoveでは半歩位置の時に半歩下を参照するので同じようにする
                const RegionY = bottomY;
                if (dir === 6) {
                    return { regionX: leftX, regionY: RegionY, chargeX: target.x, chargeY: target.y };
                }
                if (dir === 4) {
                    return { regionX: rightX, regionY: RegionY, chargeX: target.x, chargeY: target.y };
                }
                return undefined;
            }
            if (isHalfX) {
                // 左右をチェック
                const leftX = Math.floor(target.x);
                const rightX = Math.ceil(target.x);
                if (!isFishingRegion(leftX, target.y))
                    return undefined;
                if (!isFishingRegion(rightX, target.y))
                    return undefined;
                if (dir === 2 || dir === 8) {
                    // HalfMoveでは半歩位置の時に半歩左を参照するので同じようにする
                    const RegionX = leftX;
                    return {
                        regionX: RegionX,
                        regionY: target.y,
                        chargeX: target.x,
                        chargeY: target.y,
                    };
                }
                if (dir === 6) {
                    return { regionX: leftX, regionY: target.y, chargeX: target.x, chargeY: target.y };
                }
                if (dir === 4) {
                    return { regionX: rightX, regionY: target.y, chargeX: target.x, chargeY: target.y };
                }
                return undefined;
            }
            if (isHalfY) {
                // 上下をチェック
                const topY = Math.floor(target.y);
                const bottomY = Math.ceil(target.y);
                if (!isFishingRegion(target.x, topY))
                    return undefined;
                if (!isFishingRegion(target.x, bottomY))
                    return undefined;
                if (dir === 2) {
                    return { regionX: target.x, regionY: topY, chargeX: target.x, chargeY: target.y };
                }
                if (dir === 8) {
                    return {
                        regionX: target.x,
                        regionY: bottomY,
                        chargeX: target.x,
                        chargeY: target.y,
                    };
                }
                if (dir === 6 || dir === 4) {
                    // HalfMoveでは半歩位置の時に半歩下を参照するので同じようにする
                    const RegionY = bottomY;
                    return {
                        regionX: target.x,
                        regionY: RegionY,
                        chargeX: target.x,
                        chargeY: target.y,
                    };
                }
                return undefined;
            }
            if (isFishingRegion(target.x, target.y)) {
                return { regionX: target.x, regionY: target.y, chargeX: target.x, chargeY: target.y };
            }
            return undefined;
        }
        Life.playerFishingPosition = playerFishingPosition;
        function canFishing() {
            return !isFishing() && Life._fishingWaitCount <= 0;
        }
        Life.canFishing = canFishing;
        Life.FishingState = {
            None: 0,
            Starting: 1,
            Waiting: 2,
            Hitting: 3,
            CatchFish: 4,
            Canceling: 5,
        };
        const FishingStateVariableId = 38;
        function getFishingState() {
            const state = $gameVariables.value(FishingStateVariableId);
            return state;
        }
        Life.getFishingState = getFishingState;
        function setFishingState(state) {
            $gameVariables.setValue(FishingStateVariableId, state);
        }
        Life.setFishingState = setFishingState;
        function getKey(state) {
            return `fishing_${state}`;
        }
        function getFishingArea(mapId) {
            const area = $dataFishingMapArea.get(mapId)?.area ?? 0;
            return area;
        }
        Life.getFishingArea = getFishingArea;
        function isSuccessFishing(result) {
            // NOTE:
            // 複雑になりそうならタグ付きユニオン型にする
            return "item" in result;
        }
        Life.isSuccessFishing = isSuccessFishing;
        function isSuccessCatch() {
            const itemId = Success.item;
            if (!$dataItems[itemId]) {
                return false;
            }
            return true;
        }
        function gainFish() {
            const itemId = Success.item;
            if (!$dataItems[itemId]) {
                return false;
            }
            const num = 1;
            Life.Fishing.catch(itemId, num);
            $gameParty.gainItem($dataItems[itemId], num);
            Iz.Life.Status.addWorkLevelExpFishing(itemId);
            Iz.System.notifyGainItem(itemId, num);
            Iz.Life.Status.addGoddessPointFishing(itemId);
            Iz.Life.Stats.fishing.addFish(itemId, num);
            if (Success.fishGroup === Life.BigFishGroup) {
                Iz.Life.Stats.fishing.addBigFishNum(num);
            }
            else {
                Iz.Life.Stats.fishing.addNormalFishNum(num);
            }
            const groups = Life.getItemGroups(itemId);
            let data = [...$dataFishingConsumeHp.values()].find((data) => groups.includes(data.id));
            if (!data) {
                // 設定がない場合、最初のデータを参照
                data = [...$dataFishingConsumeHp.values()][0];
            }
            if (data) {
                const consumeHp = Iz.Life.getConsumeHp(data.consume_hp);
                Iz.Life.consumeHP(consumeHp);
            }
            Success = {
                fishGroup: 0,
                item: 0,
            };
            return true;
        }
        function sequenceFishCommon(option) {
            const { mapId, fishGroup, weather } = { ...option };
            const area = getFishingArea(mapId);
            if (!area)
                return Failed;
            const fishTableId = $dataFishingAreaTable.find((t) => t && t.id === area && t.fish_group === fishGroup)?.fish_table_id;
            if (!fishTableId)
                return Failed;
            const records = $dataFishingFishTable
                .filter((t) => t && t.id === fishTableId)
                .filter((t) => {
                const dataFish = $dataFishingFish.get(t.fish_id);
                if (!dataFish)
                    return false;
                // 天候指定がある場合
                const weathers = $dataFishingFishWeather.filter((w) => w && w.id === dataFish.id);
                if (weathers.length > 0) {
                    return weathers.some((w) => w.weather === weather);
                }
                return true;
            });
            const fishList = records.map((r) => r.fish_id).filter((fish) => option.isEnableFish(fish));
            if (fishList.length <= 0)
                return Failed;
            let fish = 0;
            if (fishGroup === Life.BigFishGroup) {
                fish = fishList[Math.randomInt(fishList.length)];
            }
            else {
                // レアリティによる抽選
                const rarities = [...$dataFishingRarity.values()]
                    .filter((data) => data)
                    .sort((a, b) => a.id - b.id);
                let index = Life.choiceLottery(rarities.map((data) => data.lottery_rate_in_table));
                while (index >= 0) {
                    const rarity = rarities[index].id;
                    // console.log(`rarity: ${rarity}`);
                    const list = fishList
                        .map((f) => $dataFishingFish.get(f))
                        .filter((data) => !!data)
                        .filter((data) => data.rarity === rarity);
                    if (list.length > 0) {
                        fish = list[Math.randomInt(list.length)].id;
                        break;
                    }
                    // 対象レアリティの魚種がいない場合、１つ下のレアリティから探していく
                    index--;
                }
            }
            if (!$dataItems[fish])
                return Failed;
            if (!$dataFishingFish.get(fish))
                return Failed;
            const result = {
                fishGroup: fishGroup,
                item: fish,
            };
            return result;
        }
        function sequenceBigFish(option) {
            if (!Life.isHitBigFish(option.depth, option.mapId, option.addFishingLevelRate))
                return Failed;
            return sequenceFishCommon(option);
        }
        Life.sequenceBigFish = sequenceBigFish;
        function sequenceNormalFish(option) {
            const { count, depth, fishGroup, hour, minute, addFishingLevelRate: addFihsingLevelRate, } = { ...option };
            if (!Life.isHitNormalFish(count, hour, minute, addFihsingLevelRate)) {
                return Failed;
            }
            const result = sequenceFishCommon(option);
            if (isSuccessFishing(result)) {
                return result;
            }
            // 釣れる魚が存在しないか判定
            const existFish = Life.getFishGroups(depth).some((group) => {
                if (group === fishGroup)
                    return false;
                const res = sequenceFishCommon(option);
                return isSuccessFishing(res);
            });
            const failed = {
                notExistFish: !existFish,
            };
            return failed;
        }
        Life.sequenceNormalFish = sequenceNormalFish;
        class SequenceFishRunner {
            constructor() {
                this._count = 0;
            }
            get count() {
                return this._count;
            }
            run(option) {
                let result = Failed;
                result = sequenceBigFish(option.bigfish);
                if (!isSuccessFishing(result)) {
                    result = sequenceNormalFish(option.normal);
                }
                this._count++;
                if (isSuccessFishing(result)) {
                    this._count = 0;
                }
                return result;
            }
            clear() {
                this._count = 0;
            }
        }
        Life.SequenceFishRunner = SequenceFishRunner;
        class FishingAction extends Iz.Life.ChargeAction {
            constructor() {
                super([...$parameter.charge.fishing_frames]);
            }
            onBegin() {
                super.onBegin();
                this._pos = undefined;
            }
            onExec() {
                const pos = playerFishingPosition();
                if (!pos)
                    return false;
                this._pos = pos;
                return true;
            }
            startFishing(pos) {
                $gameVariables.setValueFloat(Life.FishingPositionXVariableId, pos.chargeX);
                $gameVariables.setValueFloat(Life.FishingPositionYVariableId, pos.chargeY);
                $gameVariables.setValue(Life.FishingDirectionVariableId, $gamePlayer.direction());
                $gameVariables.setValue(Life.RegionVariableId, Life.getRegion(pos.regionX, pos.regionY));
                $gameSystem.disableMenu();
                $gamePlayer.setDirectionFix(true);
                Life.ItemSlot.active = false;
                Life.EnablePlayerMove = false;
                setFishingState(Life.FishingState.Starting);
            }
            onEnd() {
                super.onEnd();
                if (this._pos) {
                    this.startFishing(this._pos);
                    const controller = $gamePlayer.getActionController();
                    controller.requestAction(Iz.Life.ActionType.FishingSequence);
                }
                this._pos = undefined;
            }
            getChargeType() {
                return Iz.Life.ActionType.Fishing;
            }
            getToolLevel() {
                return fishingLevel();
            }
            getPositionList(basePos, level) {
                const target = playerFishingPosition();
                Life.CurrentFishingPosition = target;
                return target ? [{ x: target.chargeX, y: target.chargeY }] : [];
            }
            getConsumeToolHp() {
                return 0;
            }
            enableExecWait() {
                return false;
            }
            animation() {
                return {
                    begin: "fishing_charging",
                    exec: "",
                };
            }
        }
        Life.FishingAction = FishingAction;
        class BaseSequence {
            get currentSequence() {
                return getKey(getFishingState());
            }
        }
        class NoneSequence extends BaseSequence {
            get nextSequenceKey() {
                return getKey(Life.FishingState.Starting);
            }
            onStart(arg) { }
            onUpdate() {
                return this.currentSequence === this.nextSequenceKey;
            }
            onFinish() { }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this.nextSequenceKey,
                    output: {},
                };
            }
        }
        class StartingSequence extends BaseSequence {
            get nextSequenceKey() {
                return getKey(Life.FishingState.Waiting);
            }
            onStart(arg) {
                // 浮き生成
                // $gameTemp.reserveCommonEvent(FishingCreateFloatCommonEventId);
                Life.Chara2D.ActorAnimator.play(1, "fishing_cast");
            }
            onUpdate() {
                return this.currentSequence === this.nextSequenceKey;
            }
            onFinish() { }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this.nextSequenceKey,
                    output: {},
                };
            }
        }
        class WaitingSequence extends BaseSequence {
            constructor() {
                super();
                this._runner = new SequenceFishRunner();
            }
            onStart(arg) {
                this._frame = 0;
                this._runner.clear();
                Life.Chara2D.ActorAnimator.stop(1);
            }
            onUpdate() {
                this._frame++;
                const waitFrame = Life.enableOverrideWaitFrame() ? Life.getOverrideWaitFrame() : 30;
                if (this._frame >= waitFrame) {
                    const result = this._runner.run({
                        bigfish: this.createBigFishOption(),
                        normal: this.createNormalFishOption(this._runner.count),
                    });
                    if (isSuccessFishing(result)) {
                        setFishingState(Life.FishingState.Hitting);
                        Success = result;
                    }
                    else if (result.notExistFish) {
                        Iz.System.notify(Iz.Text.get("SYSTEM_FISHING_NOT_EXIST_FISH"));
                    }
                    this._frame = 0;
                }
                else if (Life.isInputOk() || Life.isInputCancel()) {
                    setFishingState(Life.FishingState.Canceling);
                }
                return this.currentSequence !== getKey(Life.FishingState.Waiting);
            }
            onFinish() {
                this._frame = 0;
                this._runner.clear();
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this.currentSequence,
                    output: {},
                };
            }
            createBigFishOption() {
                return {
                    addFishingLevelRate: Life.getFishingLevelHitRate(true),
                    fishGroup: Life.BigFishGroup,
                    mapId: $gameMap.mapId(),
                    weather: Iz.Life.getWeatherType(),
                    isEnableFish: isEnableFish,
                    depth: getFishingDepth($gameVariables.value(Life.RegionVariableId)),
                };
            }
            createNormalFishOption(count) {
                const depth = getFishingDepth($gameVariables.value(Life.RegionVariableId));
                return {
                    addFishingLevelRate: Life.getFishingLevelHitRate(false),
                    fishGroup: Life.lotteryFishGroup(depth),
                    mapId: $gameMap.mapId(),
                    weather: Iz.Life.getWeatherType(),
                    isEnableFish: isEnableFish,
                    depth: depth,
                    count: count,
                    hour: Iz.System.getHour(),
                    minute: Iz.System.getMinute(),
                };
            }
        }
        class HittingSequence extends BaseSequence {
            onStart(arg) {
                this._frame = 0;
                const ExclamationBalloonId = 1;
                $gameTemp.requestBalloon($gamePlayer, ExclamationBalloonId);
                this._hittingFrame = this.calcHittingFrame(Success);
                Life.Chara2D.ActorAnimator.play(1, "fishing_hitting");
                // console.log(`HittingFrame: ${this._hittingFrame}`);
            }
            onUpdate() {
                this._frame++;
                if (this._frame >= this._hittingFrame) {
                    setFishingState(Life.FishingState.Waiting);
                    Iz.System.notify(Iz.Text.get("SYSTEM_FISHING_FAILED"));
                }
                else if (Life.isInputOk()) {
                    const res = isSuccessCatch();
                    if (res) {
                        setFishingState(Life.FishingState.CatchFish);
                    }
                    else {
                        Iz.System.playSe(FishingEndSound);
                        setFishingState(Life.FishingState.None);
                    }
                }
                return this.currentSequence !== getKey(Life.FishingState.Hitting);
            }
            onFinish() {
                this._frame = 0;
                this._hittingFrame = 0;
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this.currentSequence,
                    output: {},
                };
            }
            // 猶予フレームの設定
            calcHittingFrame(result) {
                let frame = 0;
                frame += Life.getHittingBaseFrame(result.fishGroup);
                frame += Life.getHittingToolLevelFrame(fishingLevel());
                // チュートリアル・デバッグ用途
                if (Life.enableOverrideHittingFrame()) {
                    frame = Life.getOverrideHittingFrame();
                }
                return frame;
            }
        }
        class CatchFishSequence extends BaseSequence {
            get nextSequenceKey() {
                return getKey(Life.FishingState.None);
            }
            onStart(arg) {
                Life.Chara2D.ActorAnimator.play(1, "fishing_pullup");
            }
            onUpdate() {
                if (!Life.Chara2D.ActorAnimator.isPlaying(1)) {
                    setFishingState(Life.FishingState.None);
                }
                return this.currentSequence === this.nextSequenceKey;
            }
            onFinish() {
                gainFish();
                if ($gameSwitches.value(FishingTutorialSwitchId)) {
                    $gameTemp.reserveCommonEvent(FishingTutorialCommonEventId);
                }
                Iz.System.playSe(FishingEndSound);
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: getKey(Life.FishingState.None),
                    output: {},
                };
            }
        }
        class CancelingSequence extends BaseSequence {
            get nextSequenceKey() {
                return getKey(Life.FishingState.None);
            }
            onStart(arg) {
                Life.Chara2D.ActorAnimator.play(1, "fishing_canceling");
            }
            onUpdate() {
                if (!Life.Chara2D.ActorAnimator.isPlaying(1)) {
                    setFishingState(Life.FishingState.None);
                }
                return this.currentSequence === this.nextSequenceKey;
            }
            onFinish() {
                Iz.System.playSe(FishingEndSound);
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: getKey(Life.FishingState.None),
                    output: {},
                };
            }
        }
        class SequenceController {
            constructor() {
                this.initialize();
            }
            get currentSequence() {
                return this._behaviour.key;
            }
            initialize() {
                this.setupSequence();
            }
            setupSequence() {
                this._behaviour = new Iz.RootSequence();
                {
                    const sequence = new NoneSequence();
                    this._behaviour.set(getKey(Life.FishingState.None), sequence, [
                        { dstSequence: getKey(Life.FishingState.Starting) },
                    ]);
                }
                {
                    const sequence = new StartingSequence();
                    this._behaviour.set(getKey(Life.FishingState.Starting), sequence, [
                        { dstSequence: getKey(Life.FishingState.None) },
                        { dstSequence: getKey(Life.FishingState.Waiting) },
                    ]);
                }
                {
                    const sequence = new WaitingSequence();
                    this._behaviour.set(getKey(Life.FishingState.Waiting), sequence, [
                        { dstSequence: getKey(Life.FishingState.None) },
                        { dstSequence: getKey(Life.FishingState.Hitting) },
                        { dstSequence: getKey(Life.FishingState.Canceling) },
                    ]);
                }
                {
                    const sequence = new HittingSequence();
                    this._behaviour.set(getKey(Life.FishingState.Hitting), sequence, [
                        { dstSequence: getKey(Life.FishingState.None) },
                        { dstSequence: getKey(Life.FishingState.Waiting) },
                        { dstSequence: getKey(Life.FishingState.CatchFish) },
                    ]);
                }
                {
                    const sequence = new CatchFishSequence();
                    this._behaviour.set(getKey(Life.FishingState.CatchFish), sequence, [
                        { dstSequence: getKey(Life.FishingState.None) },
                    ]);
                }
                {
                    const sequence = new CancelingSequence();
                    this._behaviour.set(getKey(Life.FishingState.Canceling), sequence, [
                        { dstSequence: getKey(Life.FishingState.None) },
                    ]);
                }
                this._behaviour.start({});
            }
            update() {
                this._behaviour.update();
            }
            suspend() {
                this._behaviour.suspend();
            }
        }
        class FishingSequenceAction extends Iz.Action {
            constructor() {
                super();
                this._controller = new SequenceController();
                this._startTime = 0;
            }
            onBegin() {
                super.onBegin();
                this._startTime = Iz.System.getTotalTime();
            }
            onUpdate() {
                this._controller.update();
                return this._controller.currentSequence === getKey(Life.FishingState.None);
            }
            canInterrupt() {
                return true;
            }
            onInterrupt() {
                setFishingState(Life.FishingState.None);
                this._controller.suspend();
            }
            onEnd() {
                const e = $gameMap.event(Life.FloatEventId);
                if (e) {
                    $gameMap.eraseEvent(Life.FloatEventId);
                }
                Life.FloatEventId = 0;
                Life.Chara2D.ActorAnimator.stop(1);
                Life.Chara2D.resetActor(1);
                this.finishFishing();
            }
            finishFishing() {
                Iz.Life.ItemSlot.active = true;
                Iz.Life.EnablePlayerMove = true;
                $gameSystem.enableMenu();
                $gamePlayer.setDirectionFix(false);
                const WaitFrame = 3;
                Life._fishingWaitCount = WaitFrame;
                const duration = Iz.System.getTotalTime() - this._startTime;
                Life.Stats.fishing.addTotalTime(duration);
            }
        }
        Life.FishingSequenceAction = FishingSequenceAction;
        class FishingProxy {
            constructor() {
                this._catches = new Map();
            }
            initialize() {
                this._catches.clear();
            }
            getCatchNum(itemId) {
                return this._catches.get(itemId)?.num ?? 0;
            }
            catch(fish, num) {
                if (!this._catches.has(fish)) {
                    this._catches.set(fish, {
                        itemId: fish,
                        num: 0,
                    });
                }
                const data = this._catches.get(fish);
                if (!data)
                    return;
                data.num += num;
            }
            newday() {
                this._catches.clear();
            }
            getData() {
                return {
                    catches: [...this._catches.values()].sort((a, b) => a.itemId - b.itemId),
                };
            }
            setData(data) {
                this._catches.clear();
                data.catches.forEach((fishData) => {
                    const newData = {
                        itemId: 0,
                        num: 0,
                    };
                    Iz.Obj.applyRecursive(newData, fishData);
                    this._catches.set(fishData.itemId, fishData);
                });
            }
        }
        Life.Fishing = new FishingProxy();
        function initializeFishing() {
            Life.Fishing.initialize();
            Iz.Life.getToolItems(FishingTag).forEach((data) => {
                FishingList[data.level - 1] = data.id;
            });
            Life._fishingWaitCount = 0;
            Life.CurrentFishingPosition = undefined;
        }
        Life.initializeFishing = initializeFishing;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function setTutorialFishingSettings() {
            Iz.Life.setEnableOverrideWaitFrame(true);
            Iz.Life.setOverrideWaitFrame(120);
            Iz.Life.setEnableOverrideNormalFishPercent(true);
            Iz.Life.setOverrideNormalFishPercent(100);
            Iz.Life.setEnableOverrideHittingFrame(true);
            Iz.Life.setOverrideHittingFrame(120);
        }
        Life.setTutorialFishingSettings = setTutorialFishingSettings;
        function resetTutorialFishingSettings() {
            Iz.Life.setEnableOverrideWaitFrame(false);
            Iz.Life.setOverrideWaitFrame(0);
            Iz.Life.setEnableOverrideNormalFishPercent(false);
            Iz.Life.setOverrideNormalFishPercent(0);
            Iz.Life.setEnableOverrideHittingFrame(false);
            Iz.Life.setOverrideHittingFrame(0);
        }
        Life.resetTutorialFishingSettings = resetTutorialFishingSettings;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var FishingDebug;
        (function (FishingDebug) {
            class FishingStats {
                constructor(option) {
                    this._option = option;
                }
                get mapId() {
                    return this._option.mapId;
                }
                get weather() {
                    return this._option.weather;
                }
                get depth() {
                    return this._option.depth;
                }
                get hour() {
                    return this._option.hour;
                }
                get minute() {
                    return this._option.minute;
                }
                get results() {
                    return this._option.results;
                }
                getTotalRun() {
                    return this.results.length;
                }
                getTotalSuccess() {
                    return this.results.filter((r) => Life.isSuccessFishing(r)).length;
                }
                getFishes() {
                    const fishes = new Map();
                    this.results
                        .filter((r) => Life.isSuccessFishing(r))
                        .forEach((res) => {
                        const num = fishes.get(res.item) ?? 0;
                        fishes.set(res.item, num + 1);
                    });
                    const res = new Map();
                    [...fishes.entries()]
                        .sort((a, b) => a[0] - b[0])
                        .forEach((data) => {
                        res.set(data[0], data[1]);
                    });
                    return res;
                }
                print(sortPercent) {
                    let str = "【釣果】\n";
                    str += `マップ:${Iz.System.getMapName(this.mapId)} `;
                    str += `天候:${Life.getWeatherName(this.weather)} `;
                    str += `深度:${this.depth} `;
                    str += `時間:${this.hour}時${this.minute}分 `;
                    const totalCount = this.getTotalRun();
                    str += `\n実行回数:${totalCount}`;
                    const successCount = this.getTotalSuccess();
                    str += `\n成功回数:${successCount} 成功率:${Math.floor((successCount / totalCount) * 100 * 100) / 100}%`;
                    const entries = [...this.getFishes().entries()];
                    if (sortPercent) {
                        entries.sort((a, b) => {
                            const a1 = a[1];
                            const b1 = b[1];
                            if (a1 !== b1)
                                return b1 - a1;
                            return a[0] - b[0];
                        });
                    }
                    entries.forEach((entry) => {
                        const id = entry[0];
                        const num = entry[1];
                        const rate = Math.floor((num / successCount) * 100 * 100) / 100;
                        str += `\nid:${id} name:${$dataItems[id].name ?? ""} num:${num} rate:${rate}%`;
                    });
                    console.log(str);
                }
            }
            FishingDebug.FishingStats = FishingStats;
            function createDebugBigFishOption(depth) {
                return {
                    addFishingLevelRate: Life.getFishingLevelHitRate(true),
                    fishGroup: Life.BigFishGroup,
                    mapId: $gameMap.mapId(),
                    weather: Iz.Life.getWeatherType(),
                    isEnableFish: Life.isEnableFish,
                    depth: depth,
                };
            }
            FishingDebug.createDebugBigFishOption = createDebugBigFishOption;
            function createDebugNormalFishOption(depth, count) {
                return {
                    addFishingLevelRate: Life.getFishingLevelHitRate(false),
                    fishGroup: Life.lotteryFishGroup(depth),
                    mapId: $gameMap.mapId(),
                    weather: Iz.Life.getWeatherType(),
                    isEnableFish: Life.isEnableFish,
                    depth: depth,
                    count: count,
                    hour: Iz.System.getHour(),
                    minute: Iz.System.getMinute(),
                };
            }
            FishingDebug.createDebugNormalFishOption = createDebugNormalFishOption;
        })(FishingDebug = Life.FishingDebug || (Life.FishingDebug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 待ちフレーム
(function (Iz) {
    var Life;
    (function (Life) {
        let enableOverride = false;
        let waitFrame = 0;
        function enableOverrideWaitFrame() {
            return enableOverride;
        }
        Life.enableOverrideWaitFrame = enableOverrideWaitFrame;
        function setEnableOverrideWaitFrame(flg) {
            enableOverride = flg;
        }
        Life.setEnableOverrideWaitFrame = setEnableOverrideWaitFrame;
        function getOverrideWaitFrame() {
            return waitFrame;
        }
        Life.getOverrideWaitFrame = getOverrideWaitFrame;
        function setOverrideWaitFrame(value) {
            waitFrame = value;
        }
        Life.setOverrideWaitFrame = setOverrideWaitFrame;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 確率判定関連
(function (Iz) {
    var Life;
    (function (Life) {
        let enableOverride = false;
        let normalFishPercent = 0;
        function enableOverrideNormalFishPercent() {
            return enableOverride;
        }
        Life.enableOverrideNormalFishPercent = enableOverrideNormalFishPercent;
        function setEnableOverrideNormalFishPercent(flg) {
            enableOverride = flg;
        }
        Life.setEnableOverrideNormalFishPercent = setEnableOverrideNormalFishPercent;
        function getOverrideNormalFishPercent() {
            return normalFishPercent;
        }
        Life.getOverrideNormalFishPercent = getOverrideNormalFishPercent;
        function setOverrideNormalFishPercent(value) {
            normalFishPercent = value;
        }
        Life.setOverrideNormalFishPercent = setOverrideNormalFishPercent;
        function passLottery(numerator, denominator) {
            if (numerator <= 0)
                return false;
            const threshold = Math.random() * denominator;
            return threshold <= numerator;
        }
        Life.passLottery = passLottery;
        function passLotteryPercent(percent) {
            return passLottery(percent, 100);
        }
        Life.passLotteryPercent = passLotteryPercent;
        function choiceLottery(numerators_) {
            const numerators = numerators_.map((n) => Math.max(0, n)); // マイナスは0にして対象から除外
            const denomirator = numerators.reduce((prev, current) => prev + current, 0);
            let numeratorSum = 0;
            const threshold = Math.random() * denomirator;
            for (let i = 0; i < numerators.length; i++) {
                const numerator = numerators[i];
                if (numerator <= 0)
                    continue;
                numeratorSum += numerator;
                if (threshold <= numeratorSum) {
                    return i;
                }
            }
            return -1;
        }
        Life.choiceLottery = choiceLottery;
        function getTimeHitRate(hour, minute) {
            const target = [...$dataFishingHitRateTime.values()].find((data) => {
                const beginTime = Iz.System.toTime(data.begin_hour, data.begin_minute);
                const endTime = Iz.System.toTime(data.end_hour, data.end_minute);
                const time = Iz.System.toTime(hour, minute);
                return time >= beginTime && time < endTime;
            });
            return target ? 2 : 1;
        }
        function isHitBigFish(depth, mapId, addFishingLevelRate) {
            const area = Life.getFishingArea(mapId);
            const bigFishDepth = $dataFishingArea.get(area)?.big_fish_depth ?? Number.MAX_SAFE_INTEGER;
            if (depth < bigFishDepth) {
                return false;
            }
            // TODO:
            // ヌシの確率
            // 1日1回? 確率低下?
            let percent = 0;
            const base = $parameter.fishing.base_percent_big;
            percent += base;
            percent += addFishingLevelRate;
            return passLotteryPercent(percent);
        }
        Life.isHitBigFish = isHitBigFish;
        function isHitNormalFish(count, hour, minute, addFishingLevelRate) {
            let percent = 0;
            const base = $parameter.fishing.base_percent_normal;
            percent += base;
            const addCount = count * $parameter.fishing.add_percent_normal_unit_count;
            percent += addCount;
            // 釣りレベルによる上昇分の前に時間による補正をかける
            const timeHitRate = getTimeHitRate(hour, minute);
            percent *= timeHitRate;
            percent += addFishingLevelRate;
            // チュートリアル・デバッグ用途
            if (enableOverrideNormalFishPercent()) {
                percent = getOverrideNormalFishPercent();
            }
            // console.log(`percent: ${percent}`);
            return passLotteryPercent(percent);
        }
        Life.isHitNormalFish = isHitNormalFish;
        function getFishGroups(depth) {
            const list = $dataFishingDepthLotteryRate
                .filter((data) => !!data && data.id === depth)
                .map((data) => data.fish_group);
            return list;
        }
        Life.getFishGroups = getFishGroups;
        function lotteryFishGroup(depth) {
            const list = $dataFishingDepthLotteryRate
                .filter((data) => !!data && data.id === depth)
                .map((data) => {
                const addPercent = Life.Status.getTraitFishGroupAddPercents(Life.Status.traits.list, data.fish_group);
                const rate = Math.floor(data.rate + data.rate * (addPercent / 100));
                // console.log(`group:${data.fish_group}, baseRate:${data.rate} addPercent:${addPercent} -> rate:${rate}`);
                return {
                    group: data.fish_group,
                    rate: rate,
                };
            });
            const index = choiceLottery(list.map((data) => data.rate));
            if (index >= 0) {
                return list[index].group;
            }
            return -1;
        }
        Life.lotteryFishGroup = lotteryFishGroup;
        // 釣りレベル補正値
        function getFishingLevelHitRate(isBigFish) {
            const traits = Life.Status.getWorkLevelTrait(Life.Data.WorkType.Fishing);
            return Life.Status.getTraitFishingHitAddPercents(traits, isBigFish);
        }
        Life.getFishingLevelHitRate = getFishingLevelHitRate;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 猶予フレーム関連
(function (Iz) {
    var Life;
    (function (Life) {
        let enableOverride = false;
        Life.hittingFrame = 0;
        function enableOverrideHittingFrame() {
            return enableOverride;
        }
        Life.enableOverrideHittingFrame = enableOverrideHittingFrame;
        function setEnableOverrideHittingFrame(flg) {
            enableOverride = flg;
        }
        Life.setEnableOverrideHittingFrame = setEnableOverrideHittingFrame;
        function getOverrideHittingFrame() {
            return Life.hittingFrame;
        }
        Life.getOverrideHittingFrame = getOverrideHittingFrame;
        function setOverrideHittingFrame(value) {
            Life.hittingFrame = value;
        }
        Life.setOverrideHittingFrame = setOverrideHittingFrame;
        function getHittingBaseFrame(fishGroup) {
            const data = $dataFishingFishGroup.get(fishGroup);
            if (!data) {
                return 0;
            }
            const frame = Iz.Maths.getRandomInt(data.caught_lower_limit_frame, data.caught_upper_limit_frame + 1);
            return frame;
        }
        Life.getHittingBaseFrame = getHittingBaseFrame;
        function getHittingToolLevelFrame(toolLevel) {
            const data = $dataFishingTool.get(toolLevel);
            if (!data) {
                return 0;
            }
            const frame = Iz.Maths.getRandomInt(data.add_lower_limit_frame, data.add_upper_limit_frame + 1);
            return frame;
        }
        Life.getHittingToolLevelFrame = getHittingToolLevelFrame;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var FishingUtil;
        (function (FishingUtil) {
            function waiting() {
                Life.setFishingState(Life.FishingState.Waiting);
            }
            FishingUtil.waiting = waiting;
            function createFloat() {
                const FishingFloatEventId = 32;
                const x = $gameVariables.value(Life.FishingPositionXVariableId);
                const y = $gameVariables.value(Life.FishingPositionYVariableId);
                const e = $gameMap.spawnEventAndGet(FishingFloatEventId, x, y, true);
                Life.FloatEventId = e?.eventId() ?? 0;
            }
            FishingUtil.createFloat = createFloat;
            function newday() {
                Life.Fishing.newday();
            }
            FishingUtil.newday = newday;
        })(FishingUtil = Life.FishingUtil || (Life.FishingUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeFishing();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.fishing = Iz.Life.Fishing.getData();
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.Life.Fishing.setData(contents.fishing);
    };
    const _Game_Player_onRegistAction = Game_Player.prototype.onRegistAction;
    Game_Player.prototype.onRegistAction = function () {
        _Game_Player_onRegistAction.call(this);
        const controller = this.getActionController();
        controller.setAction(new Iz.Life.FishingAction(), Iz.Life.ActionType.Fishing);
        controller.setAction(new Iz.Life.FishingSequenceAction(), Iz.Life.ActionType.FishingSequence);
    };
    const _Game_Map_update = Game_Map.prototype.update;
    Game_Map.prototype.update = function (sceneActive) {
        _Game_Map_update.call(this, sceneActive);
        Iz.Life.CurrentFishingPosition = undefined;
        if (Iz.Life._fishingWaitCount > 0) {
            Iz.Life._fishingWaitCount--;
        }
    };
})();
(function (Iz) {
    var Life;
    (function (Life) {
        class SpriteFishingInfo extends Sprite {
            constructor() {
                const w = 48;
                const h = 24;
                super(new Bitmap(w, h));
                this.blendMode = 1;
                this.z = 10;
                this.scale.x = 1;
                this.scale.y = 1;
                this.create();
            }
            create() {
                this.createGaugeBg();
                this.createGauge();
            }
            createGaugeBg() {
                this._gaugeBg = new Sprite();
                this._gaugeBg.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_FISHING_BASE);
                this._gaugeBg.anchor.set(0, 1);
                this.addChild(this._gaugeBg);
            }
            createGauge() {
                this._gauge = new Sprite();
                this._gauge.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_FISHING_DEEP);
                this._gauge.anchor.set(0, 1);
                this.addChild(this._gauge);
            }
            setDeep(region) {
                const depth = Life.getFishingDepth(region);
                const f = Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_FISHING_DEEP);
                const blockHeight = Math.floor(f.height / Life.FishingRegions.length);
                const height = blockHeight * depth;
                const y = f.y + blockHeight * (Life.FishingRegions.length - depth);
                this._gauge.setFrame(f.x, y, f.width, height);
            }
        }
        Life.SpriteFishingInfo = SpriteFishingInfo;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Spriteset_Map_CreateLowerLayer = Spriteset_Map.prototype.createLowerLayer;
    Spriteset_Map.prototype.createLowerLayer = function () {
        _Spriteset_Map_CreateLowerLayer.call(this);
        this._fishingInfoSprite = new Iz.Life.SpriteFishingInfo();
        this._fishingInfoSprite.visible = false;
        this._tilemap.addChild(this._fishingInfoSprite);
    };
    const _Spriteset_Map_update = Spriteset_Map.prototype.update;
    Spriteset_Map.prototype.update = function () {
        _Spriteset_Map_update.call(this);
        if (!Iz.Life.CurrentFishingPosition || !$gameTemp.chargeTargets[0]) {
            this._fishingInfoSprite.visible = false;
            return;
        }
        this._fishingInfoSprite.visible = true;
        const target = $gameTemp.chargeTargets[0];
        const tileWidth = $gameMap.tileWidth();
        const tileHeight = $gameMap.tileHeight();
        this._fishingInfoSprite.x = $gameMap.adjustX(target.x) * tileWidth + tileWidth + 2;
        this._fishingInfoSprite.y = $gameMap.adjustY(target.y) * tileHeight + tileHeight - 2;
        // regionから判定
        const region = Iz.Life.getRegion(Iz.Life.CurrentFishingPosition.regionX, Iz.Life.CurrentFishingPosition.regionY);
        this._fishingInfoSprite.setDeep(region);
    };
})();
//# sourceMappingURL=Fishing.js.map