/*:
 * @target MZ
 * @plugindesc 贈り物
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.EventTag_Gift = "gift";
        // 渡す（未確定）
        function tryGiveGift(itemId, actorId) {
            if (actorId <= 1)
                return;
            // 渡すアイテムのIDと反応を保存
            $gameVariables.setValue($parameter.gift.itemIdVariable, itemId);
            $gameVariables.setValue($parameter.gift.reactionVariable, Life.getReaction(itemId, actorId));
            $gameSwitches.setValue($parameter.gift.isAlreadySwitch, Iz.Life.Status.getGifted(actorId));
        }
        Life.tryGiveGift = tryGiveGift;
        // 渡す（確定）
        function gaveGift(itemId, actorId, disableConsume = false) {
            Iz.Life.Status.setGifted(actorId, true);
            const result = Life.getReactionResult(itemId, actorId);
            const reaction = result.reaction;
            const likability = calcGiftLilability(itemId, actorId, reaction);
            Iz.Life.Status.addLikability(actorId, likability);
            if (!disableConsume) {
                $gameParty.gainItem($dataItems[itemId], -1);
            }
            // 好物解放
            Life.Profile.setItemFlag(actorId, itemId, true);
            Life.getItemGroups(itemId).forEach((groupId) => {
                Life.Profile.setGroupFlag(actorId, groupId, true);
            });
            // 通知
            Iz.System.notifyChangeLikability(actorId, likability);
            // 初回ボーナス
            if (isFirstBonus(itemId, actorId, result)) {
                const base = getReactionLikability(reaction);
                const firstBonus = calcFirstBonus(base);
                Iz.Life.Status.addLikability(actorId, firstBonus);
                Iz.System.notifyFirstBonusLikability(actorId, firstBonus);
            }
            Life.Stats.gift.add(actorId, itemId, 1);
        }
        Life.gaveGift = gaveGift;
        function calcGiftLilability(itemId, actorId, reaction) {
            let likability = getReactionLikability(reaction);
            // 特性
            likability = Life.Status.calcLikability(likability);
            // GiftBonus
            // アイテム->グループの順で調べる
            const list = $dataGiftBonus
                .filter((data) => data && data.id === actorId)
                .sort((a, b) => a.type - b.type);
            for (let i = 0; i < list.length; i++) {
                const data = list[i];
                if (data.type === Life.Data.ProfileItemType.Item && data.type_id === itemId) {
                    likability *= data.rate;
                    break;
                }
                if (data.type === Life.Data.ProfileItemType.ItemGroup) {
                    if (Life.includeGroup(itemId, data.type_id)) {
                        likability *= data.rate;
                        break;
                    }
                }
            }
            // 誕生日
            if (Life.ProfileUtil.isBirthday(actorId)) {
                likability *= $parameter.gift.birthday_rate;
            }
            return Math.floor(likability);
        }
        function getReactionLikability(reaction) {
            return $dataReaction.find((data) => data && data.reaction === reaction)?.value ?? 0;
        }
        function isFirstBonus(itemId, actorId, result) {
            if (!result.isItemReaction)
                return false;
            if (!$parameter.gift.first_bonus_reactions.includes(result.reaction))
                return false;
            const actor = Life.Stats.gift.getActor(actorId);
            if (!actor)
                return false;
            const num = actor.getItem(itemId)?.num ?? 0;
            return num <= 0;
        }
        function calcFirstBonus(base) {
            return Math.round(base * $parameter.gift.first_bonus_add_rate);
        }
        function setupExcludeChoiceItemGift() {
            const excludeItems = $dataItemAttribute
                .filter((data) => data?.disable_gift)
                .map((data) => data.id);
            $gameMessage.setupExcludeChoiceItems(excludeItems);
        }
        Life.setupExcludeChoiceItemGift = setupExcludeChoiceItemGift;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=Gift.js.map