/*:
 * @target MZ
 * @plugindesc HUD
 * @author INAZUMA GAMES
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        class GaugeHp extends Sprite {
            constructor() {
                super();
                this.create();
                this.setHp(Iz.Life.getHP());
            }
            create() {
                this.createBackground();
                this.createGauge();
                this.createGaugeFrame();
                this.createText();
            }
            createBackground() {
                this._background = new Sprite();
                this._background.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_GAUGE_HP);
                this.addChild(this._background);
                this.setFrame(0, 0, this._background.width, this._background.height);
            }
            createGauge() {
                this._gauge = new Sprite();
                this._gauge.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_BAR_HP);
                this._gauge.x = 34;
                this._gauge.y = 8;
                this.addChild(this._gauge);
            }
            createGaugeFrame() {
                this._gaugeFrame = new Sprite();
                this._gaugeFrame.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_GAUGE_FRAME);
                this.addChild(this._gaugeFrame);
            }
            createText() {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_BAR_HP);
                this._text = new Sprite_Text(frame.width, frame.height);
                this._text.x = 24;
                this._text.y = 9;
                this._text.setAlign("right");
                this._text.setFontSetting(Life.FONT_KEY_HUD_GAUGE);
                this._text.setText("", true);
                this.addChild(this._text);
            }
            update() {
                super.update();
                this.refresh();
            }
            refresh() {
                const hp = Iz.Life.getHP();
                const maxHp = Iz.Life.getMaxHp();
                if (this._prevHp !== hp || this._prevMaxHp !== maxHp) {
                    this.setHp(hp);
                }
            }
            setHp(hp) {
                this.setValue(Iz.Life.getHpRate());
                this._text.setText(`${hp}/${Iz.Life.getMaxHp()}`);
                this._prevHp = hp;
                this._prevMaxHp = Iz.Life.getMaxHp();
            }
            setValue(value) {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_BAR_HP);
                const rate = Math.min(Math.max(value, 0), 1);
                this._gauge.setFrame(frame.x, frame.y, rate * frame.width, frame.height);
            }
        }
        class GaugeWp extends Sprite {
            constructor() {
                super();
                this.create();
                this.setWp($gameFarm.water);
            }
            create() {
                this.createBackground();
                this.createGauge();
                this.createGaugeFrame();
                this.createText();
            }
            createBackground() {
                this._background = new Sprite();
                this._background.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_GAUGE_WP);
                this.addChild(this._background);
            }
            createGauge() {
                this._gauge = new Sprite();
                this._gauge.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_BAR_WP);
                this._gauge.x = 34;
                this._gauge.y = 7;
                this.addChild(this._gauge);
            }
            createGaugeFrame() {
                this._gaugeFrame = new Sprite();
                this._gaugeFrame.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_GAUGE_FRAME);
                this.addChild(this._gaugeFrame);
            }
            createText() {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_BAR_WP);
                this._text = new Sprite_Text(frame.width, frame.height);
                this._text.x = 24;
                this._text.y = 9;
                this._text.setAlign("right");
                this._text.setFontSetting(Life.FONT_KEY_HUD_GAUGE);
                this._text.setText("", true);
                this.addChild(this._text);
            }
            update() {
                super.update();
                this.refresh();
            }
            refresh() {
                const wp = $gameFarm.water;
                const maxWp = Iz.Life.getWaterLimit();
                if (this._prevWp !== wp || this._prevMaxWp !== maxWp) {
                    this.setWp(wp);
                }
            }
            setWp(wp) {
                const maxWp = Iz.Life.getWaterLimit();
                this.setValue(wp / maxWp);
                this._text.setText(`${wp}/${maxWp}`);
                this._prevWp = wp;
                this._prevMaxWp = maxWp;
            }
            setValue(value) {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_BAR_WP);
                const rate = Math.min(Math.max(value, 0), 1);
                this._gauge.setFrame(frame.x, frame.y, rate * frame.width, frame.height);
            }
        }
        class TraitIcon extends Sprite {
            constructor() {
                super();
                this.anchor.set(0, 1);
                this._normalSprite = new Sprite();
                this._normalSprite.anchor.set(this.anchor.x, this.anchor.y);
                this._normalSprite.setColorTone([-96, -96, -96, 0]);
                this.addChild(this._normalSprite);
                this._remainSprite = new Sprite();
                this._remainSprite.anchor.set(this.anchor.x, this.anchor.y);
                this.addChild(this._remainSprite);
            }
            set(traitId, remainingRate) {
                const icon = $dataTrait.get(traitId)?.icon ?? "";
                this.setIcon(icon, remainingRate);
            }
            setIcon(traitIconId, remainingRate) {
                const name = `icon${traitIconId}`;
                this._normalSprite.setAtlas(Life.ATLAS_KEY_TRAIT, name);
                this.setRemainSprite(name, remainingRate);
            }
            setRemainSprite(name, remainingRate) {
                this._remainSprite.setAtlas(Life.ATLAS_KEY_TRAIT, name);
                const f = Iz.Atlas.getAtlas(Life.ATLAS_KEY_TRAIT).getFrame(name);
                const h = Math.floor(f.height * remainingRate);
                this._remainSprite.setFrame(f.x, f.y + f.height - h, f.width, h);
            }
        }
        class StuffedIcon extends Sprite {
            constructor() {
                super();
                this.anchor.set(0, 1);
                this._normalSprite = new Sprite();
                this._normalSprite.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_STUFFED_A);
                this._normalSprite.anchor.set(this.anchor.x, this.anchor.y);
                this._normalSprite.setColorTone([-96, -96, -96, 0]);
                this.addChild(this._normalSprite);
                this._remainSprite = new Sprite();
                this._remainSprite.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_STUFFED_A);
                this._remainSprite.anchor.set(this.anchor.x, this.anchor.y);
                this.addChild(this._remainSprite);
            }
            get atlasFrame() {
                return Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_STUFFED_A);
            }
            set(remainingRate) {
                const f = this.atlasFrame;
                const h = Math.floor(f.height * remainingRate);
                this._remainSprite.setFrame(f.x, f.y + f.height - h, f.width, h);
            }
        }
        const DisplayTraitIconMax = 10;
        class HudGaugeWindow extends Window_Base {
            constructor() {
                const rect = new Rectangle(0, 0, 191, 72);
                super(rect);
                this.create();
            }
            get gaugeHp() {
                return this._gaugeHp;
            }
            get gaugeWp() {
                return this._gaugeWp;
            }
            create() {
                this.createGaugeHp();
                this.createGaugeWp();
                this.createStuffed();
                this.createTraits();
                this._container.alpha = 0; // Window_Baseの枠は使わない
            }
            createGaugeHp() {
                this._gaugeHp = new GaugeHp();
                this.addChild(this._gaugeHp);
            }
            createGaugeWp() {
                this._gaugeWp = new GaugeWp();
                this._gaugeWp.y = 30;
                this.addChild(this._gaugeWp);
            }
            createStuffed() {
                this._stuffed = new StuffedIcon();
                this._stuffed.anchor.set(0, 1);
                this._stuffed.x = this._gaugeHp.width + 16;
                this._stuffed.y = 32;
                this.addChild(this._stuffed);
                this.updateStuffed();
            }
            createTraits() {
                this._traitsRoot = new Sprite();
                this._traitsRoot.anchor.set(0, 0.5);
                this._traitsRoot.x = this._stuffed.x + 48;
                this._traitsRoot.y = 32;
                this.addChild(this._traitsRoot);
                this._traits = [];
                for (let i = 0; i < DisplayTraitIconMax; i++) {
                    const icon = new TraitIcon();
                    icon.x = i * 40;
                    this._traits.push(icon);
                    this._traitsRoot.addChild(icon);
                }
            }
            update() {
                super.update();
                this.updateStuffed();
                this.updateTraits();
            }
            updateStuffed() {
                const maxValue = Life.Status.getStuffedThreshold();
                const value = Math.min(Life.Status.getStuffedData().value, maxValue);
                if (value > 0) {
                    this._stuffed.set(value / maxValue);
                    this._stuffed.visible = true;
                }
                else {
                    this._stuffed.visible = false;
                }
            }
            updateTraits() {
                const list = Life.Status.traits.tempUpdaters;
                for (let i = 0; i < DisplayTraitIconMax; i++) {
                    const icon = this._traits[i];
                    if (i < list.length) {
                        icon.visible = true;
                        icon.set(list[i].data().id, list[i].remainingRate());
                    }
                    else {
                        icon.visible = false;
                    }
                }
            }
        }
        Life.HudGaugeWindow = HudGaugeWindow;
        class ShortCutButton extends Sprite_Clickable {
            onClick() {
                this._handler?.();
            }
            setHandler(handler) {
                this._handler = handler;
            }
        }
        Life.ShortCutButton = ShortCutButton;
        class FooterWindow extends Window_Base {
            constructor() {
                const rect = new Rectangle(0, 0, 210, 70);
                super(rect);
                // const bitmap = new Bitmap(210,70);
                // bitmap.fillAll("red");
                // super(bitmap);
                this.create();
                this._container.alpha = 0; // Window_Baseの枠は使わない
            }
            get mapButton() {
                return this._mapButton;
            }
            get optionButton() {
                return this._optionButton;
            }
            get bagButton() {
                return this._bagButton;
            }
            create() {
                this.createMap();
                this.createOption();
                this.createBag();
                this.createInputSprites();
            }
            createMap() {
                this._mapButton = new ShortCutButton();
                this._mapButton.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_SHORTCUTICON_MAP);
                this._mapButton.x = 0;
                this.addChild(this._mapButton);
            }
            createOption() {
                this._optionButton = new ShortCutButton();
                this._optionButton.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_SHORTCUTICON_OPTION);
                this._optionButton.x = 70;
                this.addChild(this._optionButton);
            }
            createBag() {
                this._bagButton = new ShortCutButton();
                this._bagButton.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_SHORTCUTICON_ITEMBAG);
                this._bagButton.x = 140;
                this.addChild(this._bagButton);
            }
            // NOTE:
            // ボタンの子にするとテクスチャの切り替えがそれぞれ発生するので、まとめて生成する
            createInputSprites() {
                // option
                const option = new Life.InputSprite();
                option.set([
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_ESC },
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_PAD_START },
                ]);
                option.x = 40;
                option.y = 40;
                option.refresh();
                this._optionButton.addChild(option);
                // map
                const map = new Life.InputSprite();
                map.set([
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_M },
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_PAD_SELECT },
                ]);
                map.x = 40;
                map.y = 40;
                map.refresh();
                this._mapButton.addChild(map);
                // bag
                const bag = new Life.InputSprite();
                bag.set([
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_B },
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_PAD_Y },
                ]);
                bag.x = 40;
                bag.y = 40;
                bag.refresh();
                this._bagButton.addChild(bag);
            }
        }
        Life.FooterWindow = FooterWindow;
        class MoneyWindow extends Window_Base {
            constructor() {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_GOLDFRAME);
                const rect = new Rectangle(0, 0, frame.width, frame.height);
                super(rect);
                this.create();
                this._container.alpha = 0;
                this._money = 0;
                this.refresh();
            }
            create() {
                const s = new Sprite();
                s.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_GOLDFRAME);
                this.addChild(s);
                this.createText();
            }
            createText() {
                this._moneyText = new Sprite_Text(this.width, this.height);
                this._moneyText.setAlign("right");
                this._moneyText.setFontSize(18);
                this._moneyText.x -= 38;
                this.addChild(this._moneyText);
            }
            refresh() {
                this._money = $gameParty.gold();
                this._moneyText.setText(`${this._money}`);
            }
            update() {
                super.update();
                this.updateMoney();
            }
            updateMoney() {
                if (this._money !== $gameParty.gold()) {
                    this.refresh();
                }
            }
        }
        Life.MoneyWindow = MoneyWindow;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function () {
        _Scene_Map_createAllWindows.call(this);
        const win = new Iz.Life.HudGaugeWindow();
        win.x = 16;
        win.y = 12;
        this.addWindow(win);
        this._hudWindow = win;
        const footer = new Iz.Life.FooterWindow();
        footer.mapButton.setHandler(() => {
            this.onClickShortCutMiniMap();
        });
        footer.optionButton.setHandler(() => {
            this.onClickShortCutOptionMenu();
        });
        footer.bagButton.setHandler(() => {
            this.onClickShortCutBag();
        });
        footer.x = Graphics.width - footer.width - 8;
        footer.y = Graphics.height - footer.height - 16;
        this.addWindow(footer);
        this._footerWindow = footer;
        this._moneyWindow = new Iz.Life.MoneyWindow();
        this._moneyWindow.x = Graphics.width - this._moneyWindow.width - 8;
        this._moneyWindow.y = 56;
        this._moneyWindow.refresh();
        this.addChild(this._moneyWindow);
        // チラつき防止
        this.updateHud();
    };
    const SwitchId_Hud = 1030;
    const SwitchId_GaugeHp = 1031;
    const SwitchId_GaugeWp = 1032;
    const SwitchId_Money = 1034;
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        _Scene_Map_update.call(this);
        this.updateHud();
    };
    const _Scene_Map_updateScene = Scene_Map.prototype.updateScene;
    Scene_Map.prototype.updateScene = function () {
        _Scene_Map_updateScene.call(this);
        if (SceneManager.isSceneChanging())
            return;
        if (Iz.Life.isEnableMenuPage()) {
            if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_PAGE_MINIMAP)) {
                this.onClickShortCutMiniMap();
            }
            else if (Input.isTriggered(Iz.IO.KEY_NAME_OPTIONMENU)) {
                this.onClickShortCutOptionMenu();
            }
            else if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_PAGE_ITEMSLOT)) {
                this.onClickShortCutBag();
            }
        }
    };
    Scene_Map.prototype.onClickShortCutMiniMap = function () {
        const res = this.callMenuPage(Iz.Life.MenuPage.Minimap);
        if (res) {
            SoundManager.playOk();
        }
    };
    Scene_Map.prototype.onClickShortCutOptionMenu = function () {
        const res = this.callOptionMenu();
        if (res) {
            SoundManager.playOk();
        }
    };
    Scene_Map.prototype.onClickShortCutBag = function () {
        const res = this.callMenuPage(Iz.Life.MenuPage.ItemSlot);
        if (res) {
            SoundManager.playOk();
        }
    };
    Scene_Map.prototype.updateHud = function () {
        const eventRunning = $gameMap.isEventRunning();
        const switchHudVisible = $gameSwitches.value(SwitchId_Hud);
        if (this._hudWindow.visible !== switchHudVisible) {
            this._hudWindow.visible = switchHudVisible;
        }
        const switchVisibleHp = $gameSwitches.value(SwitchId_GaugeHp);
        if (this._hudWindow.gaugeHp.visible !== switchVisibleHp) {
            this._hudWindow.gaugeHp.visible = switchVisibleHp;
        }
        const switchVisibleWp = $gameSwitches.value(SwitchId_GaugeWp);
        if (this._hudWindow.gaugeWp.visible !== switchVisibleWp) {
            this._hudWindow.gaugeWp.visible = switchVisibleWp;
        }
        const switchVisibleShortCutMenu = Iz.Life.isEnableMenuPage() && !$gameMessage.isBusy();
        if (this._footerWindow.visible !== switchVisibleShortCutMenu) {
            this._footerWindow.visible = switchVisibleShortCutMenu;
        }
        const switchVisibleMoney = $gameSwitches.value(SwitchId_Money);
        if (this._moneyWindow.visible !== switchVisibleMoney) {
            this._moneyWindow.visible = switchVisibleMoney;
            if (this._moneyWindow.visible) {
                this._moneyWindow.refresh();
            }
        }
        checkWaterGauge();
    };
    function checkWaterGauge() {
        const isWaterPot = Iz.Life.isWaterPot(Iz.Life.ItemSlot.itemId);
        $gameSwitches.setValueIfChanged(SwitchId_GaugeWp, isWaterPot);
    }
})();
//# sourceMappingURL=Hud.js.map