/*:
 * @target MZ
 * @plugindesc イベント起動除外設定
 *
 * @help
 * 注釈コマンドしかないイベントは起動しないようにします
 *
 *
 */
(() => {
    const _Game_Event_start = Game_Event.prototype.start;
    Game_Event.prototype.start = function () {
        this._executingStartFunction = true;
        _Game_Event_start.call(this);
        this._executingStartFunction = false;
    };
    const _Game_Event_list = Game_Event.prototype.list;
    Game_Event.prototype.list = function () {
        const commands = this.page().list;
        if (this._executingStartFunction && commands && commands.length > 1) {
            let commentOnly = true;
            for (let i = 0; i < commands.length; i++) {
                if (commands[i].code === 0)
                    continue;
                if (commands[i].code === 108)
                    continue;
                if (commands[i].code === 408)
                    continue;
                commentOnly = false;
            }
            if (commentOnly) {
                return [];
            }
        }
        return _Game_Event_list.call(this);
    };
    Game_Event.prototype.isIgnoreEvent = function (list) {
        if (list && list.length > 1) {
            return !list.some((c) => c.code !== 0 && c.code !== 108 && c.code !== 408);
        }
        return true;
    };
})();
//# sourceMappingURL=IgnoreCommentEvent.js.map