// 単体用
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        class ImageListProxy {
            constructor(list) {
                this._list = new Map();
                list.forEach((data) => {
                    this._list.set(data.key, data.path);
                });
            }
            get(key) {
                const data = this._list.get(key);
                if (data)
                    return data;
                return this._ref.get(key);
            }
            setImageListRef(ref) {
                this._ref = ref;
            }
        }
        Life.ImageListProxy = ImageListProxy;
        // const PATH_KEYBOARD_Z = "img/system/indicator/z";
        // const PATH_KEYBOARD_X = "img/system/indicator/x";
        // const PATH_GAMEPAD_A = "img/system/indicator/pad/A";
        // const PATH_GAMEPAD_B = "img/system/indicator/pad/B";
        class InputImageListProxy {
            constructor() {
                this.setup();
            }
            setup() {
                this._keyboardList = [
                // { key: Iz.IO.KEY_NAME_ACTION, path: PATH_KEYBOARD_Z },
                // { key: Iz.IO.KEY_NAME_SUB_ACTION, path: PATH_KEYBOARD_X },
                // { key: Iz.IO.KEY_NAME_OK, path: PATH_KEYBOARD_Z },
                // { key: Iz.IO.KEY_NAME_CANCEL, path: PATH_KEYBOARD_X },
                ];
                this._padList = [
                // { key: Iz.IO.KEY_NAME_ACTION, path: PATH_GAMEPAD_A },
                // { key: Iz.IO.KEY_NAME_SUB_ACTION, path: PATH_GAMEPAD_B },
                // { key: Iz.IO.KEY_NAME_OK, path: PATH_GAMEPAD_A },
                // { key: Iz.IO.KEY_NAME_CANCEL, path: PATH_GAMEPAD_B },
                ];
            }
            get(key) {
                const data = this.getList().find((data) => data.key === key);
                return data ? data.path : undefined;
            }
            getList() {
                if (this.isKeyboard()) {
                    return this._keyboardList;
                }
                return this._padList;
            }
            isKeyboard() {
                return Iz.IO.getLastInputType() === Iz.IO.InputType.Keyboard;
            }
        }
        Life.ImageList = new ImageListProxy([]);
        Life.InputImageList = new InputImageListProxy();
        Life.ImageList.setImageListRef(Life.InputImageList);
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// アトラス用
(function (Iz) {
    var Life;
    (function (Life) {
        class AtlasImageListProxy {
            constructor() {
                this._list = new Map();
            }
            get(key) {
                const data = this._list.get(key);
                if (data)
                    return data;
                return this._ref.get(key);
            }
            setList(list) {
                this._list.clear();
                list.forEach((data) => {
                    this._list.set(data.key, data);
                });
            }
            setImageListRef(ref) {
                this._ref = ref;
            }
        }
        Life.AtlasImageListProxy = AtlasImageListProxy;
        class AtlasInputImageListProxy {
            constructor() {
                this.setup();
            }
            setup() {
                // TODO:
                // キーコンフィグで設定を変えられる必要がある
                this.setupKeyboard();
                this.setupPad();
            }
            setupKeyboard() {
                const keyboardList = [
                    {
                        key: Iz.IO.KEY_NAME_ACTION,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_Z,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SUB_ACTION,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_X,
                    },
                    {
                        key: Iz.IO.KEY_NAME_OK,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_Z,
                    },
                    {
                        key: Iz.IO.KEY_NAME_CANCEL,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_X,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SLOT_LEFT,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_Q,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SLOT_RIGHT,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_E,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SHIFT,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_SHIFT,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MENU_SUBMENU,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_C,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_AUTO,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_C,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_SKIP,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_CTRL,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_CONFIG,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_ESC,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_SCREEN,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_X,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SAVE_CHANGE_LOCK,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_C,
                    },
                ];
                this._keyboardList = new Map();
                keyboardList.forEach((data) => {
                    this._keyboardList.set(data.key, data);
                });
            }
            setupPad() {
                const padList = [
                    {
                        key: Iz.IO.KEY_NAME_ACTION,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_A,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SUB_ACTION,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_B,
                    },
                    {
                        key: Iz.IO.KEY_NAME_OK,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_A,
                    },
                    {
                        key: Iz.IO.KEY_NAME_CANCEL,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_B,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SLOT_LEFT,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_LB,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SLOT_RIGHT,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_RB,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SHIFT,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_X,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MENU_SUBMENU,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_Y,
                    },
                    {
                        key: Iz.IO.PAD_NAME_X,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_X,
                    },
                    {
                        key: Iz.IO.PAD_NAME_Y,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_Y,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_AUTO,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_Y,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_SKIP,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_RT,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_CONFIG,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_START,
                    },
                    {
                        key: Iz.IO.KEY_NAME_MESSAGE_SCREEN,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_X,
                    },
                    {
                        key: Iz.IO.KEY_NAME_SAVE_CHANGE_LOCK,
                        atlasKey: Life.ATLAS_KEY_COMMON,
                        frameKey: Life.FRAME_KEY_COMMON_PAD_Y,
                    },
                ];
                this._padList = new Map();
                padList.forEach((data) => {
                    this._padList.set(data.key, data);
                });
            }
            get(key) {
                return this.getList().get(key);
            }
            getList() {
                if (this.isKeyboard()) {
                    return this._keyboardList;
                }
                return this._padList;
            }
            isKeyboard() {
                return Iz.IO.getLastInputType() === Iz.IO.InputType.Keyboard;
            }
        }
        Life.AtlasImageList = new AtlasImageListProxy();
        Life.AtlasInputImageList = new AtlasInputImageListProxy();
        Life.AtlasImageList.setImageListRef(Life.AtlasInputImageList);
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Scene_Boot_onDatabaseLoaded = Scene_Boot.prototype.onDatabaseLoaded;
    Scene_Boot.prototype.onDatabaseLoaded = function () {
        _Scene_Boot_onDatabaseLoaded.call(this);
        // NOTE:
        // マスターデータを参照するのでこのタイミングで行う
        const images = [];
        for (let i = 1; i <= Iz.Life.Status.getLikabilityLevelMax(); i++) {
            images.push({
                key: `likability${i}`,
                atlasKey: Iz.Life.ATLAS_KEY_MENU_EVENTLIST,
                frameKey: `heart_${i}`,
            });
        }
        Iz.Life.AtlasImageList.setList(images);
    };
})();
//# sourceMappingURL=ImageSet.js.map