var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        function preloadAtlas() {
            // 事前読み込み
            Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_COMMON).getBitmap();
            Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT).getBitmap();
            Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_MINIMAP).getBitmap();
            Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_RESIDENTS).getBitmap();
            Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_EVENTLIST).getBitmap();
            Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SKILL).getBitmap();
            Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SHED).getBitmap();
        }
        Life.preloadAtlas = preloadAtlas;
        function settingFontSizeForLang() {
            // NOTE:
            // 特定の言語だけフォントサイズ調整する
            // 言語ごとにマスターデータの入れ替えをする仕組みを入れたい
            const quest = $dataFontSetting.find((data) => data && data.id === Iz.Life.FONT_KEY_MENU_QUEST_DESC);
            if (quest) {
                // @ts-ignore
                quest.size_default = quest.size;
                Object.defineProperty(quest, "size", {
                    get: function () {
                        if (Iz.System.i18n.lang === Iz.System.Lang.EN) {
                            return 18;
                        }
                        return this.size_default;
                    },
                    configurable: true,
                });
            }
        }
        Life.settingFontSizeForLang = settingFontSizeForLang;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Scene_Boot_onDatabaseLoaded = Scene_Boot.prototype.onDatabaseLoaded;
    Scene_Boot.prototype.onDatabaseLoaded = function () {
        _Scene_Boot_onDatabaseLoaded.call(this);
        Iz.Life.preloadAtlas();
        Iz.Life.settingFontSizeForLang();
        Iz.Life.Chara2D.AnimatorImageDatabase.preload();
    };
})();
// WebGL debug.
(function (Iz) {
    var Debug;
    (function (Debug) {
        function logWebGLMemory() {
            // @ts-ignore
            const ext = gl.getExtension("GMAN_webgl_memory");
            if (ext) {
                // memory info
                const info = ext.getMemoryInfo();
                // every texture, it's size, a stack of where it was created and a stack of where it was last updated.
                const textures = ext.getResourcesInfo(WebGLTexture);
                // every buffer, it's size, a stack of where it was created and a stack of where it was last updated.
                const buffers = ext.getResourcesInfo(WebGLBuffer);
                console.log(info);
                console.log(textures);
                console.log(buffers);
            }
        }
        Debug.logWebGLMemory = logWebGLMemory;
        function bytesToMB(bytes) {
            return Math.floor((bytes / (1024 * 1024)) * 100) / 100;
        }
        function webglInfoTexts() {
            const list = [];
            // @ts-ignore
            const ext = gl.getExtension("GMAN_webgl_memory");
            if (ext) {
                // memory info
                const info = ext.getMemoryInfo();
                const memory = info.memory;
                list.push(`texture = ${bytesToMB(memory.texture)} MB`);
                list.push(`total = ${bytesToMB(memory.total)} MB`);
                const resources = info.resources;
                Object.keys(resources).forEach((key) => {
                    list.push(`${key}: ${resources[key]}`);
                });
                ext.get;
            }
            return list;
        }
        class WebGLInfo {
            constructor() {
                this.createElement();
            }
            createElement() {
                const root = document.createElement("div");
                const area = document.createElement("textarea");
                area.id = "webglInfoBox";
                area.disabled = true;
                root.appendChild(area);
                document.body.appendChild(root);
                this._textArea = area;
            }
            refresh() {
                this._textArea.textContent = webglInfoTexts().join("\n");
            }
        }
        Debug.WebGLInfo = WebGLInfo;
    })(Debug = Iz.Debug || (Iz.Debug = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    if (!Iz.System.isWebGLDebug())
        return;
    function createSpector() {
        const element = document.createElement("script");
        element.src = "https://cdn.jsdelivr.net/npm/spectorjs@0.9.30/dist/spector.bundle.js";
        element.onload = () => {
            // @ts-ignore
            const spector = new SPECTOR.Spector();
            spector.displayUI();
        };
        document.body.appendChild(element);
    }
    function createWebGLMemory() {
        const css = document.createElement("link");
        css.rel = "stylesheet";
        css.type = "text/css";
        css.href = "./css/life.css";
        const b_top = document.getElementsByTagName("head")[0];
        b_top.appendChild(css);
        const element = document.createElement("script");
        element.src = "https://greggman.github.io/webgl-memory/webgl-memory.js";
        element.crossOrigin = "";
        document.body.appendChild(element);
    }
    const _Graphics_createAllElements = Graphics._createAllElements;
    Graphics._createAllElements = function () {
        _Graphics_createAllElements.call(this);
        this._webglInfo = new Iz.Debug.WebGLInfo();
        setInterval(() => {
            this._webglInfo.refresh();
        }, 1000);
    };
    createSpector();
    createWebGLMemory();
})();
//# sourceMappingURL=Initializer.js.map