//
// slowlifeのNPCに関する処理
//
// 脱衣所関連
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const DressingRoomPositions = [
            { mapId: 21, x: 4, y: 16, d: 8 },
            { mapId: 21, x: 5, y: 16, d: 8 },
            { mapId: 21, x: 4, y: 18.5, d: 2 },
            { mapId: 21, x: 5, y: 18.5, d: 2 },
            { mapId: 21, x: 6, y: 18.5, d: 2 },
        ];
        function selectPosition(positions) {
            const getNpcNum = (p) => {
                const sameNpcPositions = $globalMap.nonPlayers().filter((npc) => {
                    const d = npc.destination;
                    if (d.mapId === p.mapId && d.x === p.x && d.y === p.y)
                        return true;
                    if (npc.mapId() === p.mapId && npc.x === p.x && npc.y === p.y)
                        return true;
                    return false;
                });
                return sameNpcPositions.length;
            };
            const list = positions
                .map((p) => Object.assign({}, p))
                .sort((a, b) => {
                return getNpcNum(a) - getNpcNum(b);
            });
            return list[0] ?? undefined;
        }
        function moveDressingRoomPosition(npc) {
            if (npc.hasDestinationStack)
                return;
            const p = selectPosition(DressingRoomPositions);
            if (!p)
                return;
            npc.interrupt(p.mapId, p.x, p.y, p.d);
        }
        Life.moveDressingRoomPosition = moveDressingRoomPosition;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
})();
// コミュ禁止
(function (Iz) {
    var Life;
    (function (Life) {
        let disableCommu = false;
        function setNpcCommu(flg) {
            disableCommu = !flg;
            $globalMap.nonPlayers().forEach((npc) => {
                npc.setThrough(!flg);
            });
        }
        Life.setNpcCommu = setNpcCommu;
        function isNpcCommu() {
            return !disableCommu;
        }
        Life.isNpcCommu = isNpcCommu;
        const _createGameObjects = DataManager.createGameObjects;
        DataManager.createGameObjects = function () {
            _createGameObjects.call(this);
            disableCommu = false;
        };
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 統計処理
(() => {
    "use strict";
    const _Scene_Map_create = Scene_Map.prototype.create;
    Scene_Map.prototype.create = function () {
        _Scene_Map_create.call(this);
        $globalMap.setMessageHandler((msg) => {
            if (msg.type === Iz.GlobalMap.MessageType.CollidePlayer) {
                const id = msg.character;
                const npc = Iz.Life.Stats.globalMap.getNpc(id);
                if (!npc)
                    return;
                npc.collidedCount++;
                return;
            }
            if (msg.type === Iz.GlobalMap.MessageType.Happening) {
                const id = msg.character;
                const npc = Iz.Life.Stats.globalMap.getNpc(id);
                if (!npc)
                    return;
                npc.happeningCount++;
                return;
            }
        });
    };
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        _Scene_Map_terminate.call(this);
        $globalMap.setMessageHandler(undefined);
    };
})();
//# sourceMappingURL=LifeNpc.js.map