/*:
 * @target MZ
 * @plugindesc ウィンドウ共通処理
 *
 * @help
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        function makeCursorAlpha(count, baseOpacity = 255) {
            const blinkCount = count % 40;
            const baseAlpha = baseOpacity / 255;
            if (blinkCount < 20) {
                return baseAlpha - blinkCount / 32;
            }
            return baseAlpha - (40 - blinkCount) / 32;
        }
        Life.makeCursorAlpha = makeCursorAlpha;
        function createMenuItemSlotBg() {
            const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT);
            const frame = atlas.getFrame(Life.FRAME_KEY_MENU_ITEMSLOT_WINDOW_BG);
            const sprite = new NineSliceSprite(atlas.getBitmap());
            sprite.setSlice(8, 8, 8, 8);
            sprite.setBitmapRect(frame.x, frame.y, frame.width, frame.height);
            return sprite;
        }
        Life.createMenuItemSlotBg = createMenuItemSlotBg;
        function createWindow(atlasKey, frameKey) {
            const atlas = Iz.Atlas.getAtlas(atlasKey);
            const frame = atlas.getFrame(frameKey);
            const window = new Iz.WindowBase(new Rectangle(0, 0, frame.width, frame.height), new Iz.EasingOpenness(Iz.Easing.easeOutBack, Iz.Easing.easeOutQuint));
            window.setAtlas(atlasKey, frameKey);
            window.opennessData.closeOffset *= 1.25;
            window.anchor.set(0.5, 0.5);
            window.position.set(Math.floor(Graphics.width / 2), Math.floor(Graphics.height / 2));
            return window;
        }
        Life.createWindow = createWindow;
        function createMenuWindow() {
            return createWindow(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_WINDOW_BASE);
        }
        Life.createMenuWindow = createMenuWindow;
        function createCommonWindowNiceSlice(w, h) {
            const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_COMMON);
            const frame = atlas.getFrame(Life.FRAME_KEY_COMMON_FRAME);
            const sprite = new NineSliceSprite(atlas.getBitmap());
            sprite.setSlice(32, 32, 32, 32);
            sprite.setBitmapRect(frame.x, frame.y, frame.width, frame.height);
            sprite.setSize(w, h);
            return sprite;
        }
        Life.createCommonWindowNiceSlice = createCommonWindowNiceSlice;
        class CommonGridElement extends Sprite {
            constructor(w, h) {
                super();
                this.createCursor(w, h);
                this.createText(w, h);
                this.setFrame(0, 0, w, h);
                this.select(false);
            }
            get cursorSprite() {
                return this._cursor;
            }
            createText(w, h) {
                this._text = new Sprite_Text(w, h);
                this._text.setAlign("center");
                this._text.setText("", true);
                this.addChild(this._text);
            }
            createCursor(w, h) {
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_COMMON);
                const frame = atlas.getFrame(Life.FRAME_KEY_COMMON_BUTTON2);
                const sprite = new NineSliceSprite(atlas.getBitmap());
                sprite.setSlice(8, 8, 8, 8);
                sprite.setBitmapRect(frame.x, frame.y, frame.width, frame.height);
                sprite.setSize(w, h);
                this.addChild(sprite);
                this._cursor = sprite;
            }
            select(flg) {
                this._cursor.visible = flg;
            }
            set(text) {
                this._text.setText(text, true);
            }
        }
        Life.CommonGridElement = CommonGridElement;
        class CommonGridWindow extends Sprite {
            constructor(option) {
                super();
                this._animationCount = 0;
                option.padding = { left: 16, right: 16, top: 14, bottom: 14 };
                option.spacing = { top: 2, bottom: 2 };
                this.createGrid(option);
                const w = this._grid.width;
                const h = this._grid.height;
                this.createBg(w, h);
                this.setFrame(0, 0, w, h);
                this._grid.refresh();
            }
            get grid() {
                return this._grid;
            }
            get cursorAlpha() {
                return makeCursorAlpha(this._animationCount, this.opacity);
            }
            createGrid(option) {
                this._grid = new Life.SelectableGrid(option);
                this.addChild(this._grid);
            }
            createBg(w, h) {
                this._bg = createCommonWindowNiceSlice(w, h);
                this.addChildAt(this._bg, 0);
            }
            update() {
                super.update();
                this._grid.updateMain();
                if (this.isActive()) {
                    this._animationCount++;
                }
            }
            activate() {
                this._grid.activate();
            }
            deactivate() {
                this._grid.deactivate();
            }
            isActive() {
                return this._grid.isActive();
            }
        }
        Life.CommonGridWindow = CommonGridWindow;
        function createCommonGridWindow(option) {
            const win = new CommonGridWindow(option);
            return win;
        }
        Life.createCommonGridWindow = createCommonGridWindow;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    class SceneGrid extends Scene_Base {
        create() {
            super.create();
            this.createBg();
            this.createGrid();
        }
        createBg() {
            this._bg = new Sprite(SceneManager.backgroundBitmap());
            this._bg.filters = [new PIXI.filters.BlurFilter()];
            this.addChild(this._bg);
        }
        createGrid() {
            const frameWidth = 480;
            const frameHeight = 64;
            const option = {
                emptyCellCreator: () => {
                    return new Iz.Life.CommonGridElement(frameWidth, frameHeight);
                },
                cellUpdater: (cell, index) => {
                    cell.set(`index:${index}`);
                },
                maxItems: 10,
                frameWidth: frameWidth,
                frameHeight: frameHeight,
                col: 1,
                row: 3,
            };
            const w = Iz.Life.createCommonGridWindow(option);
            w.activate();
            this.addChild(w);
        }
        update() {
            super.update();
            if (Input.isTriggered("cancel")) {
                this.popScene();
            }
        }
    }
    if (Utils.isOptionValid("test_menu")) {
        const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
        Window_MenuCommand.prototype.addOriginalCommands = function () {
            _Window_MenuCommand_addOriginalCommands.call(this);
            this.addCommand("グリッド", "gridgrid", true);
        };
        const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
        Scene_Menu.prototype.createCommandWindow = function () {
            _Scene_Menu_createCommandWindow.call(this);
            this._commandWindow.setHandler("gridgrid", () => SceneManager.push(SceneGrid));
        };
    }
})();
//
(() => {
    class ScrollWindow extends Window_Selectable {
        initialize(rect, ...args) {
            super.initialize(rect, ...args);
            this._items = [1, 2, 3, 5, 8];
        }
        maxItems() {
            return this._items.length;
        }
        numVisibleRows() {
            return 3;
        }
        itemHeight() {
            return Math.floor(this.innerHeight / this.numVisibleRows()) - 20;
        }
        drawItem(index) {
            const rect = this.itemRectWithPadding(index);
            this.drawText(`index: ${index}`, rect.x, rect.y);
            this.drawText(`value: ${this._items[index]}`, rect.x, rect.y + 32);
        }
        _makeCursorAlpha() {
            return 0;
        }
    }
    class SceneScroll extends Scene_Base {
        create() {
            super.create();
            this.createBg();
            this.createScroll();
        }
        createBg() {
            this._bg = new Sprite(SceneManager.backgroundBitmap());
            this._bg.filters = [new PIXI.filters.BlurFilter()];
            this.addChild(this._bg);
        }
        createScroll() {
            this._scroll = new ScrollWindow(new Rectangle(0, 0, 320, 480));
            this._scroll.activate();
            this._scroll.refresh();
            this._scroll.opacity = 0;
            this.addChild(this._scroll);
        }
        update() {
            super.update();
            if (Input.isTriggered("cancel")) {
                this.popScene();
            }
        }
    }
    if (Utils.isOptionValid("test_menu")) {
        const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
        Window_MenuCommand.prototype.addOriginalCommands = function () {
            _Window_MenuCommand_addOriginalCommands.call(this);
            this.addCommand("scoll", "scroll", true);
        };
        const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
        Scene_Menu.prototype.createCommandWindow = function () {
            _Scene_Menu_createCommandWindow.call(this);
            this._commandWindow.setHandler("scroll", () => SceneManager.push(SceneScroll));
        };
    }
})();
//# sourceMappingURL=LifeWindow.js.map