/*:
 * @target MZ
 * @plugindesc マップオブジェクト管理
 *
 *
 * @help
 * ※このプラグインはSpawnObjectに依存します
 *
 * マップオブジェクトに対する処理を提供します
 * マップオブジェクトとは木や石などの永続的に存在するイベントのことです
 *
 * イベントの生成・管理はSpawnObjectを用いて行うため、
 * このプラグインはSpawnObjectより下に設定してください
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const MapObjectLabel = "mapobject";
        function getPrefab(mapObjectId) {
            const mapObject = $dataMapObject.get(mapObjectId);
            if (!mapObject)
                return undefined;
            const prefab = $dataMapObjectPrefab.get(mapObject.prefab_id);
            return prefab;
        }
        class MapObjectProxy {
            constructor() {
                this.initialize();
            }
            initialize() { }
            isMapObject(o) {
                return o.includeLabel(MapObjectLabel);
            }
            getMapObjectId(o) {
                return Number(o.labels[MapObjectLabel]) ?? 0;
            }
            getObjects() {
                const list = [];
                Life.Spawn.objects.forEach((o, i) => {
                    if (this.isMapObject(o)) {
                        list.push({ id: this.getMapObjectId(o), spawnIndex: i, spawn: o });
                    }
                });
                return list;
            }
            createAll() {
                //
                $dataMapObject.forEach((mapObject) => {
                    if (this.getObjects().some((o) => o.id === mapObject.id))
                        return;
                    const prefab = $dataMapObjectPrefab.get(mapObject.prefab_id);
                    if (!prefab) {
                        return;
                    }
                    const templateId = TR.getTemplateId(prefab.template_id);
                    const data = {
                        mapId: mapObject.map,
                        x: mapObject.x,
                        y: mapObject.y,
                        templateId: templateId,
                        // アップデートなどで既存のマップオブジェクトを
                        // 変更・削除できるようにタグ付けして判別する
                        labels: {
                            [MapObjectLabel]: mapObject.id,
                        },
                        spawnDataOnly: true,
                    };
                    const res = Iz.Life.Spawn.createObject(data);
                    this.onCreate(res);
                });
            }
            onCreate(res) {
                if (!res.success)
                    return;
                const spawn = Life.Spawn.objects[res.index];
                const mapObjectId = this.getMapObjectId(spawn);
                if (mapObjectId <= 0)
                    return;
                const spanwMapObject = {
                    id: mapObjectId,
                    spawnIndex: res.index,
                    spawn: Life.Spawn.objects[res.index],
                };
                // 初期値
                const code = "grow";
                this.controlVariableByLabel(spanwMapObject, "wood", code, TR.OperationType.Set, 6);
                this.controlVariableByLabel(spanwMapObject, "stone", code, TR.OperationType.Set, 1);
            }
            removeInvalidData() {
                const removeList = [];
                this.getObjects().forEach((o) => {
                    const id = this.getMapObjectId(o.spawn);
                    if (!id)
                        return;
                    const data = $dataMapObject.get(id);
                    if (data) {
                        let changed = false;
                        if (o.spawn.mapId !== data.map)
                            changed = true;
                        if (o.spawn.x !== data.x)
                            changed = true;
                        if (o.spawn.y !== data.y)
                            changed = true;
                        const templateId = getPrefab(id)?.template_id ?? 0;
                        if (o.spawn.templateId !== templateId)
                            changed = true;
                        if (changed) {
                            removeList.push(o.spawnIndex);
                        }
                    }
                    else {
                        removeList.push(o.spawnIndex);
                    }
                });
                removeList.forEach((index) => {
                    Life.Spawn.removeObject(index);
                });
            }
            controlVariableByLabel(o, label, code, type, value) {
                const data = $dataMapObject.get(o.id);
                if (!data)
                    return;
                const include = $dataMapObjectPrefabLabel.some((l) => l && l.id === data.prefab_id && l.label === label);
                if (include) {
                    Life.Spawn.operateVariable(o.spawnIndex, code, type, value, false);
                }
            }
            onLoad() {
                // NOTE:
                // アップデート対策
                // 変更されたデータは削除して作り直し
                this.removeInvalidData();
                this.createAll();
            }
        }
        Life.MapObject = new MapObjectProxy();
        function initializeMapObject() {
            Life.MapObject.initialize();
        }
        Life.initializeMapObject = initializeMapObject;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var MapObjectUtil;
        (function (MapObjectUtil) {
            function createAll() {
                Life.MapObject.createAll();
            }
            MapObjectUtil.createAll = createAll;
            function controlVariableByLabel(label, code, type, value) {
                Life.MapObject.getObjects().forEach((o) => {
                    Life.MapObject.controlVariableByLabel(o, label, code, type, value);
                });
            }
            MapObjectUtil.controlVariableByLabel = controlVariableByLabel;
        })(MapObjectUtil = Life.MapObjectUtil || (Life.MapObjectUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        Iz.Life.initializeMapObject();
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.Life.MapObject.onLoad();
    };
})();
//# sourceMappingURL=MapObject.js.map