/*:
 * @target MZ
 * @plugindesc 回想
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        let MemoryType;
        (function (MemoryType) {
            MemoryType["None"] = "";
            MemoryType["Quest"] = "quest";
        })(MemoryType = Life.MemoryType || (Life.MemoryType = {}));
        Life.MemoryModeSwitchId = 1004;
        Life.MemorySceneSwitchId = 1054;
        const MemoryRoomEnterCommonEvent = 1056;
        const SplitCharacter = ":";
        function getMemoryKey(sceneId, type) {
            return `${type}${SplitCharacter}${sceneId}`;
        }
        Life.getMemoryKey = getMemoryKey;
        function getMemoryKeyData(key) {
            const splits = key.split(SplitCharacter);
            return {
                type: (splits[0] ?? ""),
                sceneId: splits[1] ?? "",
            };
        }
        Life.getMemoryKeyData = getMemoryKeyData;
        class Save {
            constructor() {
                this._scenes = new Map();
                this.initialize();
            }
            get unlockAll() {
                return this._unlockAll;
            }
            set unlockAll(value) {
                this._unlockAll = value;
            }
            initialize() {
                this._scenes.clear();
                this._unlockAll = false;
            }
            isEnableScene(key) {
                return !!this._scenes.get(key)?.enable;
            }
            setScene(key, enable) {
                let scene = this._scenes.get(key);
                if (!scene) {
                    scene = {
                        key: key,
                        enable: enable,
                    };
                }
                scene.enable = enable;
                this._scenes.set(key, scene);
            }
            getMemoryData() {
                const memory = {
                    unlockAll: this._unlockAll,
                    scenes: [...this._scenes.values()],
                };
                return memory;
            }
            setMemoryData(data) {
                this._unlockAll = !!data.unlockAll;
                data.scenes.forEach((scene) => {
                    this._scenes.set(scene.key, scene);
                });
            }
        }
        class MemoryProxy {
            constructor() {
                this._save = new Save();
                this.initialize();
            }
            get save() {
                return this._save;
            }
            get requestMemoryScene() {
                return this._requestMemoryScene;
            }
            get requestBack() {
                return this._requestBack;
            }
            get backMapScene() {
                return this._backMapScene;
            }
            set backMapScene(value) {
                this._backMapScene = value;
            }
            initialize() {
                this._storeData = "";
                this._requestMemoryScene = false;
                this._requestBack = false;
                this._backMapScene = false;
            }
            update() {
                if (this._requestBack) {
                    SceneManager.goto(StoreScene);
                    this._requestBack = false;
                    return;
                }
            }
            requestScene() {
                this._requestMemoryScene = true;
            }
            requestBackScene() {
                this._requestBack = true;
            }
            store() {
                try {
                    this._storeData = JsonEx.stringify(DataManager.makeSaveContents());
                    return true;
                }
                catch (e) {
                    return false;
                }
            }
            load() {
                try {
                    const data = JsonEx.parse(this._storeData);
                    DataManager.createGameObjects();
                    DataManager.extractSaveContents(data);
                    return true;
                }
                catch (e) {
                    return false;
                }
                finally {
                    this._storeData = "";
                }
            }
        }
        Life.Memory = new MemoryProxy();
        function initializeMemory() {
            Life.Memory.initialize();
            Iz.MeetCondition.register("memory", onMeetCondition);
            $gameSwitches.setValue(Life.MemorySceneSwitchId, false);
        }
        Life.initializeMemory = initializeMemory;
        function onMeetCondition(data) {
            return Life.MemoryUtil.unlocked(global.String(data.id), data.type);
        }
        // 回想前に退避したデータを読み込むためのシーン
        class StoreScene extends Scene_Base {
            constructor() {
                super();
                this._back = false;
            }
            prepare(...args) {
                const s = args[0];
                if (s instanceof Sprite) {
                    this._fadeOutSprite = s;
                }
            }
            create() {
                super.create();
                if (this._fadeOutSprite) {
                    this.addChild(this._fadeOutSprite);
                }
            }
            update() {
                super.update();
                if (this._back)
                    return;
                if (!this.updateFadeoutSprite())
                    return;
                this._back = true;
                const res = Life.Memory.load();
                this.fadeOutAll();
                Life.initializeSystemParameter();
                if (res) {
                    SceneManager.goto(Scene_Map);
                    // start()時以降のインタプリタが実行されないように
                    $gameMap.interpreter()?.clear();
                    $gameTemp.reserveCommonEvent(MemoryRoomEnterCommonEvent);
                    Life.Memory.backMapScene = true;
                }
                else {
                    SceneManager.goto(Scene_Title);
                }
            }
            updateFadeoutSprite() {
                if (!this._fadeOutSprite)
                    return true;
                this._fadeOutSprite.opacity -= 4;
                return this._fadeOutSprite.opacity <= 0;
            }
            terminate() {
                super.terminate();
            }
        }
        Life.StoreScene = StoreScene;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var MemoryUtil;
        (function (MemoryUtil) {
            function start() {
                Life.Memory.store();
                $gameSwitches.setValue(Life.MemorySceneSwitchId, true);
            }
            MemoryUtil.start = start;
            function back() {
                Life.Memory.requestBackScene();
                $gameSwitches.setValue(Life.MemorySceneSwitchId, false);
            }
            MemoryUtil.back = back;
            function unlocked(sceneId, type) {
                if (Life.Memory.save.unlockAll) {
                    return true;
                }
                const key = Life.getMemoryKey(sceneId, type);
                return Life.Memory.save.isEnableScene(key);
            }
            MemoryUtil.unlocked = unlocked;
            function setUnlock(sceneId, value, type) {
                const key = Life.getMemoryKey(sceneId, type);
                Life.Memory.save.setScene(key, value);
            }
            function unlockedQuest(questId) {
                return unlocked(questId.toString(), Life.MemoryType.Quest);
            }
            MemoryUtil.unlockedQuest = unlockedQuest;
            function setUnlockQuest(questId, value) {
                setUnlock(questId.toString(), value, Life.MemoryType.Quest);
            }
            MemoryUtil.setUnlockQuest = setUnlockQuest;
            async function unlockAll() {
                Life.Memory.save.unlockAll = true;
                /*
                let option: CreateDialogOption | undefined = undefined;
                // TODO:
                // 成功、失敗のダイアログ表示する？
                if (res) {
                    option = createDialogOption("save_override");
                } else {
        
                }
                if(option) {
                    await Dialog.openAsync(option);
                }
                */
            }
            MemoryUtil.unlockAll = unlockAll;
            // 回想モード中(回想部屋含む)
            function isMemoryMode() {
                return $gameSwitches.value(Life.MemoryModeSwitchId);
            }
            MemoryUtil.isMemoryMode = isMemoryMode;
            // 回想シーン中
            function isMemoryScene() {
                return $gameSwitches.value(Life.MemorySceneSwitchId);
            }
            MemoryUtil.isMemoryScene = isMemoryScene;
        })(MemoryUtil = Life.MemoryUtil || (Life.MemoryUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeMemory();
    };
    const _Scene_Boot_initialize = Scene_Boot.prototype.initialize;
    Scene_Boot.prototype.initialize = function (...args) {
        _Scene_Boot_initialize.call(this, ...args);
        Iz.Life.addLoadSystemDataHandler((data) => {
            Iz.Life.Memory.save.setMemoryData(data.memory);
        });
    };
    const _Scene_Map_needsFadeIn = Scene_Map.prototype.needsFadeIn;
    Scene_Map.prototype.needsFadeIn = function () {
        if (Iz.Life.Memory.backMapScene) {
            return true;
        }
        return _Scene_Map_needsFadeIn.call(this);
    };
    const _Scene_Map_updateScene = Scene_Map.prototype.updateScene;
    Scene_Map.prototype.updateScene = function () {
        _Scene_Map_updateScene.call(this);
        if (!SceneManager.isSceneChanging()) {
            Iz.Life.Memory.update();
        }
    };
})();
//# sourceMappingURL=Memory.js.map