/*:
 * @target MZ
 * @plugindesc メッセージの制御
 * @help
 *
 * [機能]
 * ・文章の表示中にInterpreterを中断
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        var Message;
        (function (Message) {
            let _enableSuspend = false;
            let _suspened = false;
            function setEnableSuspend(flg) {
                _enableSuspend = flg;
            }
            Message.setEnableSuspend = setEnableSuspend;
            function enableSuspend() {
                return _enableSuspend;
            }
            Message.enableSuspend = enableSuspend;
            function suspended() {
                return _suspened;
            }
            Message.suspended = suspended;
            function setSuspended(value) {
                _suspened = value;
            }
            Message.setSuspended = setSuspended;
            function initialize() {
                _enableSuspend = false;
            }
            Message.initialize = initialize;
        })(Message = Life.Message || (Life.Message = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.Message.initialize();
    };
    const _Window_Message_newPage = Window_Message.prototype.newPage;
    Window_Message.prototype.newPage = function (textState) {
        _Window_Message_newPage.call(this, textState);
        this._enableSuspendWindow = false;
    };
    const _Window_Message_terminateMessage = Window_Message.prototype.terminateMessage;
    Window_Message.prototype.terminateMessage = function () {
        _Window_Message_terminateMessage.call(this);
        this._enableSuspendWindow = false;
    };
    const _Window_Message_startPause = Window_Message.prototype.startPause;
    Window_Message.prototype.startPause = function () {
        _Window_Message_startPause.call(this);
        this._enableSuspendWindow = true;
    };
    const _Window_Message_updateInput = Window_Message.prototype.updateInput;
    Window_Message.prototype.updateInput = function () {
        if (this.pause &&
            !this.suspend &&
            Iz.Life.Message.enableSuspend() &&
            this._enableSuspendWindow) {
            if (Input.isTriggeredOneshot(Iz.IO.KEY_NAME_MESSAGE_INTERRUPT) ||
                this._interruptSprite.isTriggeredTouch()) {
                const suspended = Iz.Life.Message.suspended();
                if (suspended) {
                    SoundManager.playCancel();
                }
                else {
                    Iz.System.playSe("system/interrupt");
                }
                Iz.Life.Message.setSuspended(!suspended);
                return true;
            }
        }
        return _Window_Message_updateInput.call(this);
    };
    Game_Interpreter.prototype.isSuspended = function () {
        return Iz.Life.Message.suspended();
    };
    const _Game_Map_updateInterpreter = Game_Map.prototype.updateInterpreter;
    Game_Map.prototype.updateInterpreter = function () {
        _Game_Map_updateInterpreter.call(this);
        if (!this._interpreter.isRunning()) {
            Iz.Life.Message.setSuspended(false);
        }
    };
    const _Game_Map_setupStartingEvent = Game_Map.prototype.setupStartingEvent;
    Game_Map.prototype.setupStartingEvent = function () {
        const res = _Game_Map_setupStartingEvent.call(this);
        if (res) {
            Iz.Life.Message.setSuspended(false);
        }
        return res;
    };
})();
//# sourceMappingURL=MessageControl.js.map