/*:
 * @target MZ
 * @plugindesc 文章中表示画像
 *
 * @help
 *
 * 文章の表示中に制御文字ILで任意の画像を表示します
 * 画像リストにキー「target」で登録した画像を表示するには以下のようにします
 * \IL[target]
 *
 *
 * Input.is〇〇〇で使用する一部の入力キーが予め登録されています
 * 以下のキーは登録なしで使用可能です
 * action,subaction,ok,cancel
 *
 *
 *
 * @param imageList
 * @text imageList
 * @desc 画像リスト
 * @type struct<ImageData>[]
 *
 * @param atlasImageList
 * @text atlasImageList
 * @desc 画像リスト（アトラス用）
 * @type struct<AtlasImageData>[]
 *
 */
/*~struct~ImageData:
 * @param key
 * @text key
 * @desc キー
 *
 * @param path
 * @text path
 * @desc 画像パス(拡張子不要)
 *
 */
/*~struct~AtlasImageData:
 * @param key
 * @text key
 * @desc キー
 *
 * @param atlasKey
 * @text atlasKey
 * @desc アトラスキー
 *
 * @param frameKey
 * @text frameKey
 * @desc フレームキー
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const params = PluginManagerEx.createParameter(document.currentScript);
        Life.MessageImageList = new Life.ImageListProxy(params.imageList);
        Life.MessageImageList.setImageListRef(Life.ImageList);
        Life.MessageAtlasImageList = new Life.AtlasImageListProxy();
        Life.MessageAtlasImageList.setList(params.atlasImageList);
        Life.MessageAtlasImageList.setImageListRef(Life.AtlasImageList);
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const PreLoadWaitModeName = "image_pre_message";
    function getBitmap(key) {
        const path = Iz.Life.MessageImageList.get(key);
        return ImageManager.loadBitmapFromUrl(`${path}.png`);
    }
    function isAtlas(key) {
        return !!Iz.Life.MessageAtlasImageList.get(key);
    }
    function getAtlasBitmap(key) {
        const data = Iz.Life.MessageAtlasImageList.get(key);
        return Iz.Atlas.getAtlas(data.atlasKey).getBitmap();
    }
    function getAtlasFrame(key) {
        const data = Iz.Life.MessageAtlasImageList.get(key);
        return Iz.Atlas.getAtlas(data.atlasKey).getFrame(data.frameKey);
    }
    function obtainEscapeKey(textState) {
        const keyList = getKeyList(textState.text.slice(textState.index - 3), 0);
        if (keyList[0]) {
            textState.index += keyList[0].length + 2;
            return keyList[0];
        }
        return "";
    }
    function getKeyList(text, startIndex) {
        const list = [];
        let index = startIndex;
        for (;;) {
            let startIL = text.indexOf("\\IL", index);
            if (startIL < 0) {
                startIL = text.indexOf("\x1bIL", index);
                if (startIL < 0) {
                    break;
                }
            }
            const endIL = text.indexOf("]", startIL);
            if (endIL < 0) {
                break;
            }
            list.push(text.slice(startIL + 4, endIL));
            index = endIL + 1;
        }
        return list;
    }
    function drawImageList(key, target, x, y) {
        if (isAtlas(key)) {
            const bitmap = getAtlasBitmap(key);
            const frame = getAtlasFrame(key);
            target.blt(bitmap, frame.x, frame.y, frame.width, frame.height, x, y);
        }
        else {
            const bitmap = getBitmap(key);
            target.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y);
        }
    }
    function processDrawImageList(key, target, textState) {
        if (key) {
            if (textState.drawing) {
                drawImageList(key, target, textState.x + 2, textState.y + 2);
            }
            if (isAtlas(key)) {
                const frame = getAtlasFrame(key);
                // NOTE:
                // 4にしているが調整できるようにする？
                textState.x += frame.width + 4;
            }
            else {
                const bitmap = getBitmap(key);
                textState.x += bitmap.width + 4;
            }
        }
    }
    const _Window_Base_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
    Window_Base.prototype.processEscapeCharacter = function (code, textState) {
        _Window_Base_processEscapeCharacter.call(this, code, textState);
        switch (code) {
            case "IL":
                processDrawImageList(obtainEscapeKey(textState), this.contents, textState);
                break;
        }
    };
    let messageParams = undefined;
    const _Game_Interpreter_command101 = Game_Interpreter.prototype.command101;
    Game_Interpreter.prototype.command101 = function (params) {
        const textList = [];
        let index = this._index;
        const list = this._list;
        for (;;) {
            const command = list[index + 1];
            if (command && command.code === 401) {
                textList.push(command.parameters[0]);
                index++;
                continue;
            }
            break;
        }
        const keySet = new Set();
        textList.forEach((text) => {
            getKeyList(text, 0).forEach((key) => keySet.add(key));
        });
        // 画像の事前読み込み
        let loaded = true;
        keySet.forEach((key) => {
            if (isAtlas(key)) {
                if (!getAtlasBitmap(key).isReady()) {
                    loaded = false;
                }
            }
            else {
                if (!getBitmap(key).isReady()) {
                    loaded = false;
                }
            }
        });
        if (!loaded) {
            this.setWaitMode(PreLoadWaitModeName);
            messageParams = params;
            return false;
        }
        return _Game_Interpreter_command101.call(this, params);
    };
    const _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function () {
        if (this._waitMode === PreLoadWaitModeName) {
            if (!ImageManager.isReady()) {
                return true;
            }
            const params = messageParams;
            messageParams = undefined;
            this.command101(params);
        }
        return _Game_Interpreter_updateWaitMode.call(this);
    };
    // for Sprite_TextEx
    const _Sprite_TextEx_processEscapeCharacter = Sprite_TextEx.prototype.processEscapeCharacter;
    Sprite_TextEx.prototype.processEscapeCharacter = function (code, textState) {
        _Sprite_TextEx_processEscapeCharacter.call(this, code, textState);
        switch (code) {
            case "IL":
                processDrawImageList(obtainEscapeKey(textState), this.bitmap, textState);
                break;
        }
    };
})();
//# sourceMappingURL=MessageImage.js.map