/*:
 * @target MZ
 * @plugindesc オブジェクト間通信
 *
 * @help
 *
 *
 *
 *
 */
var Iz;
(function (Iz) {
    class Subject {
        constructor() {
            this._observers = [];
        }
        addObserver(observer) {
            this._observers.push(observer);
        }
        removeObserver(observer) {
            this._observers.remove(observer);
        }
        notify(e, ...params) {
            this._observers.forEach((observer) => observer.onNotify(e, ...params));
        }
    }
    Iz.Subject = Subject;
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        Life.LifeEvent = {
            None: 0,
            ObjectBroken: 101,
        };
        function eventNone() { }
        function eventObjectBroken(...params) {
            // TODO:
            // 型、値チェックしたい
            $gameFarm.removeObject(params[0]);
        }
        const eventFunctions = [];
        eventFunctions[Life.LifeEvent.None] = eventNone;
        eventFunctions[Life.LifeEvent.ObjectBroken] = eventObjectBroken;
        class LifeEventProxy {
            onNotify(e, ...params) {
                eventFunctions[e](...params);
            }
        }
        Life.EventProxy = new LifeEventProxy();
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=Messenger.js.map