/*:
 * @target MZ
 * @plugindesc 旧ミニマップ（デバッグ用）
 *
 *
 * @help
 *
 *
 *
 *
 */
(() => {
    "use strict";
    class NPCLocationSprite extends Sprite {
        constructor(id) {
            const bitmap = new Bitmap(1024, 36);
            bitmap.fillAll("grey");
            super(bitmap);
            this._id = id;
            this.createText(id);
        }
        createText(id) {
            this._text = new Sprite_Text(1024, 36);
            this._text.setText("");
            this.addChild(this._text);
        }
        update() {
            super.update();
            this.updateText();
        }
        updateText() {
            const character = $globalMap.nonPlayer(this._id);
            if (character) {
                if (!character.validity) {
                    this._text.setText(`id:${this._id} name:${$gameActors.actor(this._id)?.name()} 配置されていません`);
                }
                else if (Iz.System.getMapName(character.mapId())) {
                    const mapName = Iz.System.getMapName(character.mapId());
                    this._text.setText(`id:${this._id} name:${$gameActors.actor(this._id)?.name()} map:${character.mapId()} mapName:${mapName}`);
                }
                else {
                    this._text.setText(`id:${this._id} name:${$gameActors.actor(this._id)?.name()} map:${character.mapId()} mapName:???`);
                }
            }
            else {
                this._text.setText(`id:${this._id} nothing`);
            }
        }
    }
    class MiniMapScene extends Scene_Base {
        create() {
            super.create();
            this.createBg();
            this.createNPCLocations();
        }
        createBg() {
            this._bg = new Sprite(SceneManager.backgroundBitmap());
            this._bg.filters = [new PIXI.filters.BlurFilter()];
            this.addChild(this._bg);
        }
        createNPCLocations() {
            this._sprites = [];
            $dataNonPlayers
                .filter((data) => !!data)
                .forEach((data) => this.createNPCLocationSprite(data.id));
        }
        createNPCLocationSprite(id) {
            this._sprites[id] = new NPCLocationSprite(id);
            this._sprites[id].position.set(16, -64 + id * 48);
            this.addChild(this._sprites[id]);
        }
        update() {
            super.update();
            if (Input.isTriggered("cancel")) {
                this.popScene();
            }
        }
    }
    const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
    Window_MenuCommand.prototype.addOriginalCommands = function () {
        _Window_MenuCommand_addOriginalCommands.call(this);
        this.addCommand("ミニマップ(debug)", "minimap", true);
    };
    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function () {
        _Scene_Menu_createCommandWindow.call(this);
        this._commandWindow.setHandler("minimap", () => SceneManager.push(MiniMapScene));
    };
})();
//# sourceMappingURL=MiniMap.js.map