/*:
 * @target MZ
 * @plugindesc 採掘
 * @author INAZUMA GAMES
 *
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const HammerList = [];
        const HammerTag = "hammer";
        // チャージフレーム数設定
        const HammerActionFrameList = [...$parameter.charge.mining_frames];
        // チャージ消費HP係数設定(Lv.1~Lv.5)
        const MiningChargeHpRate = [...$parameter.charge.mining_consume_hp_rate];
        Life.StoneEventTag = "stone";
        const StoneHpKey = "hp";
        const StoneDamegedAnimationId = 2;
        const StoneBrokenAnimationId = 3;
        Life.HammerActionKey = "hammer";
        const InMineSwitchId = 53;
        function initializeHammer() {
            Iz.Life.getToolItems(HammerTag).forEach((data) => {
                HammerList[data.level - 1] = data.id;
            });
        }
        Life.initializeHammer = initializeHammer;
        function isHammer(itemId) {
            return HammerList.includes(itemId);
        }
        Life.isHammer = isHammer;
        function isMiningEvent(event) {
            if (!event)
                return false;
            return Object.hasOwn(event.event().meta, Life.StoneEventTag);
        }
        Life.isMiningEvent = isMiningEvent;
        function getStoneId(event) {
            if (!event)
                return 0;
            const stoneId = Number(event.event().meta[Life.StoneEventTag]);
            return stoneId ? stoneId : 0;
        }
        Life.getStoneId = getStoneId;
        function getMiningRequireLevel(event) {
            const stoneId = getStoneId(event);
            const data = $dataMiningStone[stoneId];
            if (!data)
                return 0;
            return Math.max(0, data.require_tool_level);
        }
        Life.getMiningRequireLevel = getMiningRequireLevel;
        function hammerLevel() {
            return Iz.Life.calcToolLevel(HammerList);
        }
        Life.hammerLevel = hammerLevel;
        function hammerDamage(level) {
            const base = $parameter.charge.mining_damage_base;
            const traitAdd = Life.Status.getDamageHammerAdd();
            const traitMul = 1;
            const index = Math.min(Math.max(level - 1, 0), $parameter.charge.mining_damage_rate.length - 1);
            const chargeRate = $parameter.charge.mining_damage_rate[index];
            const sum = (base + traitAdd) * traitMul * chargeRate;
            const MinDamage = 1;
            const MaxDamage = 9999999;
            return Math.min(Math.max(sum, MinDamage), MaxDamage);
        }
        Life.hammerDamage = hammerDamage;
        function inMine() {
            return $gameSwitches.value(InMineSwitchId);
        }
        Life.inMine = inMine;
        function getHammerThereEvent() {
            const thereEvent = Life.getThereEvent();
            return thereEvent;
        }
        Life.getHammerThereEvent = getHammerThereEvent;
        function getHammerTherePosition() {
            const thereEvent = getHammerThereEvent();
            if (!thereEvent)
                return [];
            if (!Iz.Life.isMiningEvent(thereEvent))
                return [];
            return [{ x: thereEvent.x, y: thereEvent.y }];
        }
        Life.getHammerTherePosition = getHammerTherePosition;
        const HammerAnimation = {
            begin: "hammer_charging",
            exec: "hammer_exec",
        };
        class HammerAction extends Iz.Life.ChargeAction {
            constructor() {
                super(HammerActionFrameList);
            }
            onExec() {
                const stone = Iz.Life.getThereEvent();
                if (!stone || !isMiningEvent(stone)) {
                    return false;
                }
                let stoneHp = stone.getSelfVariable(StoneHpKey) ?? 0;
                if (stoneHp <= 0)
                    return false;
                if (this.getToolLevel() < getMiningRequireLevel(stone)) {
                    Iz.System.notify(Iz.Text.get("WORK_MINING_LEVEL_SHORTAGE"), false);
                    Iz.System.playSe("Sword2");
                    return false;
                }
                $gameTemp.clearObjHp();
                const StoneHpMax = 9999;
                const damage = Iz.Life.hammerDamage(this.getChargeLevel());
                stoneHp = Math.min(Math.max(stoneHp - damage, 0), StoneHpMax);
                Iz.System.notifyDamage(damage);
                if (stoneHp > 0) {
                    $gameTemp.requestAnimation([stone], StoneDamegedAnimationId);
                    // maxhpが設定されていたら表示
                    const stoneMaxHp = stone.getSelfVariable("maxhp") ?? 0;
                    if (stoneMaxHp > 0) {
                        $gameTemp.startObjHpDraw(stone.eventId(), stoneHp / stoneMaxHp);
                    }
                }
                else {
                    $gameTemp.requestAnimation([stone], StoneBrokenAnimationId);
                }
                stone.controlSelfVariable(StoneHpKey, TR.OperationType.Set, stoneHp, false);
                Life.Stats.mining.addTotalDamage(damage);
                // Status.addWorkLevelExp(Status.WorkType.Mining, this.getConsumeHp());
                return true;
            }
            getChargeType() {
                return Iz.Life.ActionType.Hammer;
            }
            getToolLevel() {
                return Iz.Life.hammerLevel();
            }
            getPositionList(basePos, level) {
                return getHammerTherePosition();
            }
            getConsumeToolHp() {
                const base = $parameter.charge.mining_consume_hp_base;
                const rate = MiningChargeHpRate[this.getChargeLevel() - 1] ?? 1;
                return base * rate;
            }
            animation() {
                return HammerAnimation;
            }
        }
        Life.HammerAction = HammerAction;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function onAutoAddTime(addtime) {
            if (!Life.inMine())
                return;
            Life.Stats.mining.addTimeInMine(addtime);
        }
        Iz.System.addAutoAddTimeHandler(onAutoAddTime);
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Game_Player_onRegistAction = Game_Player.prototype.onRegistAction;
    Game_Player.prototype.onRegistAction = function () {
        _Game_Player_onRegistAction.call(this);
        const controller = this.getActionController();
        controller.setAction(new Iz.Life.HammerAction(), Iz.Life.HammerActionKey);
    };
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeHammer();
    };
})();
//# sourceMappingURL=Mining.js.map