/*:
 * @target MZ
 * @plugindesc PlayerAction
 *
 * @help
 *
 *
 *
 *
 */
var Iz;
(function (Iz) {
    // export const ActionType = {
    //     Idle: 0,
    //     Charge: 1,
    // } as const;
    // export type ActionType = typeof ActionType[keyof typeof ActionType];
    class Action {
        onBegin() { }
        onUpdate() {
            return true;
        }
        onInterrupt() { }
        onEnd() { }
        canInterrupt() {
            return false;
        }
    }
    Iz.Action = Action;
    class IdleAction extends Iz.Action {
        onUpdate() {
            return false;
        }
        canInterrupt() {
            return true;
        }
    }
    Iz.IdleAction = IdleAction;
    // const NullAction = new IdleAction();
    class ActionController {
        constructor(character) {
            this._character = character;
            this._actions = {};
            this._actionKey = "";
        }
        update() {
            // 現在イベント中なら中断
            // $gameMap.isEventRunning()だとGame_Event.start()が呼ばれた瞬間も含まれてしまうため、
            // インタプリタが実行されているかどうかで判断する
            if (this.currentAction && $gameMap._interpreter.isRunning()) {
                this.interrupt("");
            }
            const action = this.currentAction;
            if (action) {
                const finished = action.onUpdate();
                if (finished) {
                    this._actionKey = "";
                    action.onEnd();
                }
            }
        }
        requestAction(key) {
            if (!this._actions[key])
                return;
            if (this.currentAction && !this.currentAction.canInterrupt())
                return;
            this.interrupt(key);
            this.currentAction.onBegin();
        }
        setAction(action, key) {
            this._actions[key] = action;
        }
        interrupt(key) {
            this.currentAction?.onInterrupt();
            this.currentAction?.onEnd();
            this._actionKey = key;
        }
        get actionKey() {
            return this._actionKey;
        }
        get currentAction() {
            return this._actions[this._actionKey];
        }
        get character() {
            return this._character;
        }
    }
    Iz.ActionController = ActionController;
    class ActionManager {
        constructor() {
            this.clear();
        }
        regist(character) {
            const controller = this.getController(character);
            if (!controller) {
                this._controllers.push(new ActionController(character));
            }
        }
        getController(character) {
            const res = this._controllers.find((value) => value.character === character);
            return res;
        }
        clear() {
            this._controllers = [];
        }
    }
    Iz.ActionManager = ActionManager;
    Iz.actionManager = new ActionManager();
})(Iz || (Iz = {}));
(() => {
    const _Game_Player_initMembers = Game_Player.prototype.initMembers;
    Game_Player.prototype.initMembers = function () {
        _Game_Player_initMembers.call(this);
        Iz.actionManager.regist(this);
        this.onRegistAction();
    };
    Game_Player.prototype.stopAction = function () {
        this.getActionController().interrupt("");
    };
    Game_Character.prototype.getActionController = function () {
        return Iz.actionManager.getController(this);
    };
    Game_Player.prototype.onRegistAction = function () { };
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        // NOTe:
        // ActionControllerをGame_Event等に持たせる場合、
        // マップ遷移などでGame_EventのActionControllerを消去する必要がある
        Iz.actionManager.clear();
        _DataManager_createGameObjects.call(this);
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.actionManager.clear();
        Iz.actionManager.regist($gamePlayer);
        $gamePlayer.onRegistAction();
    };
    const _Scene_Map_stop = Scene_Map.prototype.stop;
    Scene_Map.prototype.stop = function () {
        _Scene_Map_stop.call(this);
        // NOTE:
        // プレイヤー以外もActionControllerがあれば対応
        $gamePlayer.getActionController().interrupt("");
    };
    const _Scene_Map_setPause = Scene_Map.prototype.setPause;
    Scene_Map.prototype.setPause = function (flg) {
        _Scene_Map_setPause.call(this, flg);
        if (flg) {
            $gamePlayer.getActionController().interrupt("");
        }
    };
})();
(() => {
    "use strict";
    class ItemUseAction extends Iz.Action {
        onBegin() {
            this._frame = 0;
            $gameTemp.itemUseRate = 0;
            Iz.Life.ItemSlot.operator.setActive(false, true);
        }
        onUpdate() {
            if (Input.isReleased(Iz.IO.KEY_NAME_SUB_ACTION) || TouchInput.isCancelReleased()) {
                return true;
            }
            const maxFrame = 40;
            if (this._frame < maxFrame) {
                this._frame++;
            }
            $gameTemp.itemUseRate = Math.min(Math.max(this._frame / maxFrame, 0), 1);
            if (this._frame >= maxFrame) {
                Iz.Life.ItemSlot.useItemSlot(Iz.Life.ItemSlot.itemId);
                return true;
            }
            return false;
        }
        canInterrupt() {
            return true;
        }
        onEnd() {
            this._frame = 0;
            $gameTemp.itemUseRate = 0;
            Iz.Life.ItemSlot.operator.setActive(true, false);
        }
    }
    const _Spriteset_Map_CreateLowerLayer = Spriteset_Map.prototype.createLowerLayer;
    Spriteset_Map.prototype.createLowerLayer = function () {
        _Spriteset_Map_CreateLowerLayer.call(this);
        $gameTemp.itemUseRate = 0;
        const target = this._characterSprites.find((s) => s.checkCharacter($gamePlayer));
        const gauge = new Iz.Life.ItemUseGauge(target);
        gauge.visible = false;
        this._tilemap.addChild(gauge);
    };
    const _Game_Player_onRegistAction = Game_Player.prototype.onRegistAction;
    Game_Player.prototype.onRegistAction = function () {
        _Game_Player_onRegistAction.call(this);
        const controller = this.getActionController();
        controller.setAction(new ItemUseAction(), Iz.Life.ActionType.ItemUse);
    };
})();
//# sourceMappingURL=PlayerAction.js.map