//
(() => {
    "use strict";
    const _Game_Player_moveStraight = Game_Player.prototype.moveStraight;
    Game_Player.prototype.moveStraight = function (d) {
        //
        const events = $gameMap
            .events()
            .filter((e) => e._throughOnPlayerMove)
            .map((e) => {
            return {
                id: e.eventId(),
                through: e.isThrough(),
            };
        });
        events.forEach((e) => {
            $gameMap.event(e.id)?.setThrough(true);
        });
        _Game_Player_moveStraight.call(this, d);
        events.forEach((e) => {
            $gameMap.event(e.id)?.setThrough(e.through);
        });
    };
    const _Game_Player_moveByInput = Game_Player.prototype.moveByInput;
    Game_Player.prototype.moveByInput = function () {
        this._executedMove = false;
        _Game_Player_moveByInput.call(this);
    };
    const _Game_Player_executeMove = Game_Player.prototype.executeMove;
    Game_Player.prototype.executeMove = function (direction) {
        _Game_Player_executeMove.call(this, direction);
        this._executedMove = true;
    };
    const _Game_Player_update = Game_Player.prototype.update;
    Game_Player.prototype.update = function (sceneActive) {
        _Game_Player_update.call(this, sceneActive);
        if (!this._executedMove)
            return;
        const data = Iz.Life.getThereEvent()?.getPushMoveData();
        if (data?.enable) {
            data.increment = true;
            data.dir = this.direction();
        }
    };
    const _Game_Player_checkEventTriggerHere = Game_Player.prototype.checkEventTriggerHere;
    Game_Player.prototype.checkEventTriggerHere = function (triggers) {
        _Game_Player_checkEventTriggerHere.call(this, triggers);
        if (this.canStartLocalEvents()) {
            if (!$gameMap.isEventRunning()) {
                for (const event of $gameMap.eventsXy(this.x, this.y)) {
                    if (!event._throughOnPlayerMove)
                        continue;
                    if (!event.isTriggerIn(triggers))
                        continue;
                    event.start();
                    break;
                }
            }
        }
    };
    const _Game_Event_initMembers = Game_Event.prototype.initMembers;
    Game_Event.prototype.initMembers = function () {
        _Game_Event_initMembers.call(this);
        this._pushMoveData = {
            enable: false,
            increment: false,
            count: 0,
            dir: 0,
        };
    };
    const _Game_Event_update = Game_Event.prototype.update;
    Game_Event.prototype.update = function () {
        _Game_Event_update.call(this);
        if (!this._pushMoveData.enable)
            return;
        if (this.isStopping() && this._pushMoveData.increment) {
            this._pushMoveData.count++;
            if (this._pushMoveData.count >= 30) {
                this.moveStraight(this._pushMoveData.dir);
                this._pushMoveData.count = 0;
                this._pushMoveData.dir = 0;
            }
        }
        else {
            this._pushMoveData.count = 0;
            this._pushMoveData.dir = 0;
        }
        this._pushMoveData.increment = false;
    };
    Game_Event.prototype.getPushMoveData = function () {
        return this._pushMoveData;
    };
})();
//# sourceMappingURL=PlayerCollide.js.map