/*:
 * @target MZ
 * @plugindesc イベント確認ユーティリティ
 *
 * @help
 * [機能]
 * ・checkEventTriggerThereの事前判定
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.EventPriotity = {
            Below: 0,
            Normal: 1,
            Above: 2,
        };
        Life.EventCheckLocation = {
            Here: 0,
            There: 1,
            Talk: 2,
        };
        class EventCheckerProxy {
            constructor() {
                this.clear();
            }
            set(index, eventIds) {
                this._eventIds[index] = eventIds;
            }
            get(index) {
                return this._eventIds[index];
            }
            clear() {
                this._eventIds = [];
                this._eventIds[Life.EventCheckLocation.Here] = [];
                this._eventIds[Life.EventCheckLocation.There] = [];
                this._eventIds[Life.EventCheckLocation.Talk] = [];
            }
        }
        Life.EventCheckerProxy = EventCheckerProxy;
        Life.EventChecker = new EventCheckerProxy();
        function getHereEvent() {
            return getHereEvents(Life.EventPriotity.Below)[1];
        }
        Life.getHereEvent = getHereEvent;
        function getHereEvents(priority) {
            const hereEventIds = Life.EventChecker.get(Life.EventCheckLocation.Here);
            return hereEventIds
                .map((eventId) => $gameMap._events[eventId])
                .filter((e) => {
                return !!e && e._priorityType === priority;
            });
        }
        Life.getHereEvents = getHereEvents;
        function getThereEvent() {
            return getThereEvents(Life.EventPriotity.Normal)[0];
        }
        Life.getThereEvent = getThereEvent;
        function getThereEvents(priority) {
            const thereEventIds = Life.EventChecker.get(Life.EventCheckLocation.There);
            return thereEventIds
                .map((eventId) => $gameMap._events[eventId])
                .filter((e) => {
                return !!e && e._priorityType === priority;
            });
        }
        Life.getThereEvents = getThereEvents;
        function getTalkEvent() {
            const events = Life.EventChecker.get(Life.EventCheckLocation.Talk).map((n) => $gameMap._events[n]);
            return events[0];
        }
        Life.getTalkEvent = getTalkEvent;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Game_Event_start = Game_Event.prototype.start;
    Game_Event.prototype.start = function () {
        if ($gameMap._canStartEventOnlyHere || $gameMap._canStartEventOnlyThere) {
            this._canStart = true;
        }
        else {
            _Game_Event_start.call(this);
        }
    };
    Game_Event.prototype.isExecutable = function () {
        if (this.getPageIndex() < 0)
            return false;
        if (this.isIgnoreEvent(this.list()))
            return false;
        const key = [this.mapId(), this.eventId(), "D"];
        if ($gameSelfSwitches.value(key))
            return false;
        return true;
    };
    const _Game_Event_isNormalPriority = Game_Event.prototype.isNormalPriority;
    Game_Event.prototype.isNormalPriority = function () {
        if ($gameMap._canStartEventOnlyHere) {
            return false;
        }
        if ($gameMap._canStartEventOnlyThere) {
            return true;
        }
        return _Game_Event_isNormalPriority.call(this);
    };
    Game_Player.prototype.checkEventTriggerHerePrev = function (triggers) {
        $gameMap._canStartEventOnlyHere = true;
        this.checkEventTriggerHere(triggers);
        const events = $gameMap.events().filter((e) => e._canStart);
        $gameMap._canStartEventOnlyHere = false;
        $gameMap.events().forEach((e) => {
            e._canStart = false;
        });
        return events;
    };
    Game_Player.prototype.checkEventTriggerTherePrev = function (triggers) {
        $gameMap._canStartEventOnlyThere = true;
        this.checkEventTriggerThere(triggers);
        const events = $gameMap.events().filter((e) => e._canStart);
        $gameMap._canStartEventOnlyThere = false;
        $gameMap.events().forEach((e) => {
            e._canStart = false;
        });
        return events;
    };
    Game_Player.prototype.checkEventTriggerTalkPrev = function () {
        const tileUnit = 0.5;
        const px = $gamePlayer.x;
        const py = $gamePlayer.y;
        const radius = 1.3;
        const events = $gameMap
            .events()
            .filter((e) => Iz.GlobalMap.IsNPC(e))
            .filter((e) => {
            const d = $gamePlayer.direction();
            if (d === 4 || d === 6) {
                if (e.y < py - tileUnit || e.y > py + tileUnit) {
                    return false;
                }
                if (d === 4) {
                    if (px - e.x < 0) {
                        return false;
                    }
                }
                if (d === 6) {
                    if (e.x - px < 0) {
                        return false;
                    }
                }
            }
            if (d === 2 || d === 8) {
                if (e.x < px - tileUnit || e.x > px + tileUnit) {
                    return false;
                }
                if (d === 2) {
                    if (e.y - py < 0) {
                        return false;
                    }
                }
                if (d === 8) {
                    if (py - e.y < 0) {
                        return false;
                    }
                }
            }
            const dx = px - e.x;
            const dy = py - e.y;
            return dx * dx + dy * dy <= radius * radius;
        });
        return events;
    };
    const _Game_Player_updateVehicle = Game_Player.prototype.updateVehicle;
    Game_Player.prototype.updateVehicle = function () {
        _Game_Player_updateVehicle.call(this);
        if (this.canStartLocalEvents() && !$gameMap.isEventRunning()) {
            const ConfirmButtonTrigger = 0;
            // NOTE: 事前チェックの処理は重いので改善したい
            {
                const events = this.checkEventTriggerHerePrev([ConfirmButtonTrigger]);
                Iz.Life.EventChecker.set(Iz.Life.EventCheckLocation.Here, events.map((e) => e.eventId()));
            }
            {
                const events = this.checkEventTriggerTherePrev([ConfirmButtonTrigger]);
                Iz.Life.EventChecker.set(Iz.Life.EventCheckLocation.There, events.map((e) => e.eventId()));
            }
            {
                const events = this.checkEventTriggerTalkPrev();
                // console.log(events.length > 0 ? "in" : "out");
                Iz.Life.EventChecker.set(Iz.Life.EventCheckLocation.Talk, events.map((e) => e.eventId()));
            }
        }
    };
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        _Scene_Map_terminate.call(this);
        Iz.Life.EventChecker.clear();
    };
})();
//# sourceMappingURL=PlayerEventChecker.js.map