/*:
 * @target MZ
 * @plugindesc プレイヤー移動関係
 *
 * @param AddDashSpeed
 * @text ダッシュ速度補正
 * @desc プレイヤーのダッシュ時の移動速度を補正します　2の指定した数値乗増やします
 * @default 1
 *
 *
 * @help
 *
 * [機能]
 * ・移動速度補正
 * ・ダッシュをデフォルトの動作とし、Shift押下時は通常移動
 * ・歩き時は向き固定
 * ・所持アイテムがアイテムスロットの上限を超えたら移動速度低下
 * ・丸め誤差を考慮
 *
 */
var Iz;
(function (Iz) {
    let _dashDisabled = false;
    function setDashDisabled(value) {
        _dashDisabled = value;
    }
    Iz.setDashDisabled = setDashDisabled;
    function isDashDisabled() {
        return _dashDisabled;
    }
    Iz.isDashDisabled = isDashDisabled;
})(Iz || (Iz = {}));
(() => {
    const parameterName = "PlayerMoveEx";
    const parameters = PluginManager.parameters(parameterName);
    const playerAddDashSpeed = Number(parameters.AddDashSpeed || "1");
    const _Game_Player_initMembers = Game_Player.prototype.initMembers;
    Game_Player.prototype.initMembers = function () {
        _Game_Player_initMembers.call(this);
        this._moveDownCount = 0;
    };
    const _Game_Player_performTransfer = Game_Player.prototype.performTransfer;
    Game_Player.prototype.performTransfer = function () {
        _Game_Player_performTransfer.call(this);
        this._moveDownCount = 0;
    };
    Game_Player.prototype.realMoveSpeed = function () {
        let speed = this._moveSpeed + (this.isDashing() ? playerAddDashSpeed : 0);
        if (Iz.Life.isMoveSpeedDown()) {
            speed = Math.max(0, speed - 1);
        }
        return speed;
    };
    Game_Player.prototype.updateDashing = function () {
        if (this.isMoving()) {
            return;
        }
        if (this.canMove() && !this.isInVehicle() && !$gameMap.isDashDisabled()) {
            this._dashing = !this.isDashButtonPressed() || $gameTemp.isDestinationValid();
        }
        else {
            this._dashing = false;
        }
    };
    const _Game_Player_update = Game_Player.prototype.update;
    Game_Player.prototype.update = function (sceneActive) {
        _Game_Player_update.call(this, sceneActive);
        if (this._moveDownCount > 0) {
            this._moveDownCount++;
            if (this._moveDownCount >= 60) {
                this._moveDownCount = 0;
            }
        }
    };
    function roundPosition(data, digit) {
        return Math.round(data * Math.pow(10, digit)) / Math.pow(10, digit);
    }
    const _Game_Player_updateMove = Game_Player.prototype.updateMove;
    Game_Player.prototype.updateMove = function () {
        _Game_Player_updateMove.call(this);
        const digit = 10;
        this._realX = roundPosition(this._realX, digit);
        this._realY = roundPosition(this._realY, digit);
    };
    const _Game_Player_executeMove = Game_Player.prototype.executeMove;
    Game_Player.prototype.executeMove = function (direction) {
        _Game_Player_executeMove.call(this, direction);
        if (this._moveDownCount === 0 && Iz.Life.isMoveSpeedDown()) {
            const SweatAnimationId = 8;
            this.requestAnimation(SweatAnimationId);
            this._moveDownCount = 1;
        }
    };
    const _Game_Player_setDirection = Game_Player.prototype.setDirection;
    Game_Player.prototype.setDirection = function (d) {
        if (!this.isDashing() && this.isDashButtonPressed() && !$gameMap.isEventRunning()) {
            return;
        }
        _Game_Player_setDirection.call(this, d);
    };
    const _Game_Map_isDashDisabled = Game_Map.prototype.isDashDisabled;
    Game_Map.prototype.isDashDisabled = function () {
        if (Iz.isDashDisabled()) {
            return true;
        }
        return _Game_Map_isDashDisabled.call(this);
    };
})();
//# sourceMappingURL=PlayerMoveEx.js.map