/*:
 * @target MZ
 * @plugindesc プレイヤー操作に関する処理
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var IO;
    (function (IO) {
        IO.KEY_NAME_SLOT_LEFT = "slotleft";
        IO.KEY_NAME_SLOT_RIGHT = "slotright";
        IO.KEY_NAME_SLOT_UP = "slotup";
        IO.KEY_NAME_SLOT_DOWN = "slotdown";
        IO.KEY_NAME_SUB_ACTION = "subaction";
        IO.KEY_NAME_ACTION = "action";
        IO.KEY_NAME_MENU_PAGE_EVENTLIST = "menu_page_eventlist";
        IO.KEY_NAME_MENU_PAGE_ITEMSLOT = "menu_page_itemslot";
        IO.KEY_NAME_MENU_PAGE_RESIDENTS = "menu_page_residents";
        IO.KEY_NAME_MENU_PAGE_MINIMAP = "menu_page_minimap";
        IO.KEY_NAME_MENU_PAGE_SKILL = "menu_page_skill";
        IO.KEY_NAME_ALL_SELECT = "all_select";
        IO.KEY_NAME_MENU_SUBMENU = "menu_submenu";
        IO.KEY_NAME_OPTIONMENU = "optionmenu";
        IO.KEY_NAME_MESSAGE_WINDOW = "message_window";
        IO.KEY_NAME_MESSAGE_INTERRUPT = "message_interrupt";
        IO.KEY_NAME_MESSAGE_WINDOW_OPTION = "message_window_option";
        IO.KEY_NAME_MESSAGE_AUTO = "message_auto";
        IO.KEY_NAME_MESSAGE_SKIP = "message_skip";
        IO.KEY_NAME_MESSAGE_CONFIG = "message_config";
        IO.KEY_NAME_MESSAGE_SCREEN = "message_screen";
        IO.KEY_NAME_SAVE_CHANGE_LOCK = "save_change_lock";
        IO.KEY_NAME_DEBUG_BACKUP_DATA = "debug_backup_data";
        IO.KEY_NAME_SLOT_1 = "slot_num_1";
        IO.KEY_NAME_SLOT_2 = "slot_num_2";
        IO.KEY_NAME_SLOT_3 = "slot_num_3";
        IO.KEY_NAME_SLOT_4 = "slot_num_4";
        IO.KEY_NAME_SLOT_5 = "slot_num_5";
        IO.KEY_NAME_SLOT_6 = "slot_num_6";
        IO.KEY_NAME_SLOT_7 = "slot_num_7";
        IO.KEY_NAME_SLOT_8 = "slot_num_8";
        IO.KEY_NAME_SLOT_9 = "slot_num_9";
        IO.KEY_NAME_SLOT_10 = "slot_num_10";
    })(IO = Iz.IO || (Iz.IO = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        // biome-ignore lint:
        Life.EnablePlayerMove = true;
        Life.IndicatorImageset_Keyboard = "keyboard";
        Life.IndicatorImageset_Pad = "pad";
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        Life.InputMapperKey = {
            Default: "Default",
            Event: "Event",
            Map: "Map",
            Menu: "Menu",
            Warehouse: "Warehouse",
            MessageWindow: "MessageWindow",
            Choice: "Choice",
            OptionMenu: "OptionMenu",
            SaveFile: "SaveFile",
            ItemSelectWindow: "ItemSelectWindow",
        };
        function commonInputMapper(wasd) {
            const mapper = [];
            mapper.push({
                key: Iz.IO.KEY_NAME_OK,
                codeList: [Iz.IO.KEY_CODE_Z, Iz.IO.KEY_CODE_ENTER, Iz.IO.KEY_CODE_SPACE],
            });
            mapper.push({
                key: Iz.IO.KEY_NAME_ESCAPE,
                codeList: [
                    Iz.IO.KEY_CODE_ESCAPE,
                    Iz.IO.KEY_CODE_X,
                    Iz.IO.KEY_CODE_INSERT,
                    Iz.IO.KEY_CODE_NUMPAD_0,
                ],
            });
            // 移動・アイテムスロット操作
            mapper.push({
                key: Iz.IO.KEY_NAME_LEFT,
                codeList: wasd ? [Iz.IO.KEY_CODE_A] : [Iz.IO.KEY_CODE_LEFT_ARROW],
            });
            mapper.push({
                key: Iz.IO.KEY_NAME_RIGHT,
                codeList: wasd ? [Iz.IO.KEY_CODE_D] : [Iz.IO.KEY_CODE_RIGHT_ARROW],
            });
            mapper.push({
                key: Iz.IO.KEY_NAME_UP,
                codeList: wasd ? [Iz.IO.KEY_CODE_W] : [Iz.IO.KEY_CODE_UP_ARROW],
            });
            mapper.push({
                key: Iz.IO.KEY_NAME_DOWN,
                codeList: wasd ? [Iz.IO.KEY_CODE_S] : [Iz.IO.KEY_CODE_DOWN_ARROW],
            });
            const slotLeftCodeList = wasd ? [Iz.IO.KEY_CODE_LEFT_ARROW] : [Iz.IO.KEY_CODE_A];
            slotLeftCodeList.push(Iz.IO.KEY_CODE_Q, Iz.IO.KEY_CODE_HOME, Iz.IO.KEY_CODE_BRACKETLEFT);
            mapper.push({ key: Iz.IO.KEY_NAME_SLOT_LEFT, codeList: slotLeftCodeList });
            const slotRightCodeList = wasd
                ? [Iz.IO.KEY_CODE_RIGHT_ARROW]
                : [Iz.IO.KEY_CODE_D];
            slotRightCodeList.push(Iz.IO.KEY_CODE_E, Iz.IO.KEY_CODE_END, Iz.IO.KEY_CODE_BRACKETRIGHT);
            mapper.push({ key: Iz.IO.KEY_NAME_SLOT_RIGHT, codeList: slotRightCodeList });
            mapper.push({
                key: Iz.IO.KEY_NAME_SLOT_UP,
                codeList: wasd ? [Iz.IO.KEY_CODE_UP_ARROW] : [Iz.IO.KEY_CODE_W],
            });
            mapper.push({
                key: Iz.IO.KEY_NAME_SLOT_DOWN,
                codeList: wasd ? [Iz.IO.KEY_CODE_DOWN_ARROW] : [Iz.IO.KEY_CODE_S],
            });
            mapper.push({ key: Iz.IO.KEY_NAME_SHIFT, codeList: [Iz.IO.KEY_CODE_SHIFT] });
            return mapper;
        }
        function commonInputPadMapper() {
            const mapper = [];
            mapper.push({ key: Iz.IO.KEY_NAME_OK, codeList: [Iz.IO.PAD_A] });
            mapper.push({ key: Iz.IO.KEY_NAME_CANCEL, codeList: [Iz.IO.PAD_B] });
            mapper.push({ key: Iz.IO.KEY_NAME_SHIFT, codeList: [Iz.IO.PAD_X] });
            mapper.push({ key: Iz.IO.KEY_NAME_MENU, codeList: [Iz.IO.PAD_Y] });
            mapper.push({ key: Iz.IO.KEY_NAME_LEFT, codeList: [Iz.IO.PAD_LEFT] });
            mapper.push({ key: Iz.IO.KEY_NAME_RIGHT, codeList: [Iz.IO.PAD_RIGHT] });
            mapper.push({ key: Iz.IO.KEY_NAME_UP, codeList: [Iz.IO.PAD_UP] });
            mapper.push({ key: Iz.IO.KEY_NAME_DOWN, codeList: [Iz.IO.PAD_DOWN] });
            mapper.push({ key: Iz.IO.KEY_NAME_SLOT_LEFT, codeList: [Iz.IO.PAD_LB] });
            mapper.push({ key: Iz.IO.KEY_NAME_SLOT_RIGHT, codeList: [Iz.IO.PAD_RB] });
            mapper.push({ key: Iz.IO.KEY_NAME_SLOT_UP, codeList: [Iz.IO.PAD_LT] });
            mapper.push({ key: Iz.IO.KEY_NAME_SLOT_DOWN, codeList: [Iz.IO.PAD_RT] });
            return mapper;
        }
        function createKeyMapper(mapper) {
            const keyMapper = {};
            mapper.forEach((data) => {
                data.codeList.forEach((code) => {
                    keyMapper[code] = data.key;
                });
            });
            return keyMapper;
        }
        function pressedMZDefaultMessageSkipButton() {
            return Iz.IO.KEY_NAME_OK;
        }
        function toolButtons() {
            return [
                pressedMZDefaultMessageSkipButton(),
                Iz.IO.KEY_NAME_LEFT,
                Iz.IO.KEY_NAME_RIGHT,
                Iz.IO.KEY_NAME_UP,
                Iz.IO.KEY_NAME_DOWN,
            ];
        }
        class CreateMapperDefault {
            create(wasd) {
                return commonInputMapper(wasd);
            }
            createPad() {
                return commonInputPadMapper();
            }
            createClearKeyListOnEnd() {
                // スキップの押下状態が残らないようにする
                return [Iz.IO.KEY_NAME_MESSAGE_SKIP];
            }
            createExcludeLatestButtonClear() {
                // NOTE:
                // okを初期化するとメッセージスキップが効かなくなるので対象外にする
                return [pressedMZDefaultMessageSkipButton()];
            }
        }
        class CreateMapperEvent extends CreateMapperDefault {
            create(wasd) {
                const mapper = super.create(wasd);
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_SKIP, codeList: [Iz.IO.KEY_CODE_CTRL] });
                return mapper;
            }
            createPad() {
                const mapper = super.createPad();
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_SKIP, codeList: [Iz.IO.PAD_RT] });
                return mapper;
            }
            createExcludeLatestButtonClear() {
                return toolButtons();
            }
        }
        class CreateMapperMap extends CreateMapperDefault {
            create(wasd) {
                const mapper = super.create(wasd);
                mapper.push({
                    key: Iz.IO.KEY_NAME_SUB_ACTION,
                    codeList: [Iz.IO.KEY_CODE_X, Iz.IO.KEY_CODE_BACKSPACE, Iz.IO.KEY_CODE_DELETE],
                });
                mapper.push({ key: Iz.IO.KEY_NAME_MENU_PAGE_EVENTLIST, codeList: [Iz.IO.KEY_CODE_V] });
                mapper.push({ key: Iz.IO.KEY_NAME_MENU_PAGE_ITEMSLOT, codeList: [Iz.IO.KEY_CODE_B] });
                mapper.push({ key: Iz.IO.KEY_NAME_MENU_PAGE_RESIDENTS, codeList: [Iz.IO.KEY_CODE_N] });
                mapper.push({ key: Iz.IO.KEY_NAME_MENU_PAGE_MINIMAP, codeList: [Iz.IO.KEY_CODE_M] });
                mapper.push({
                    key: Iz.IO.KEY_NAME_MENU_PAGE_SKILL,
                    codeList: [Iz.IO.KEY_CODE_SMALLER],
                });
                mapper.push({ key: Iz.IO.KEY_NAME_SHIFT, codeList: [Iz.IO.KEY_CODE_SHIFT] });
                mapper.push({
                    key: Iz.IO.KEY_NAME_ESCAPE,
                    codeList: [Iz.IO.KEY_CODE_C, Iz.IO.KEY_CODE_INSERT, Iz.IO.KEY_CODE_NUMPAD_0],
                });
                mapper.push({ key: Iz.IO.KEY_NAME_OPTIONMENU, codeList: [Iz.IO.KEY_CODE_ESCAPE] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_1, codeList: [Iz.IO.KEY_CODE_DIGIT_1] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_2, codeList: [Iz.IO.KEY_CODE_DIGIT_2] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_3, codeList: [Iz.IO.KEY_CODE_DIGIT_3] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_4, codeList: [Iz.IO.KEY_CODE_DIGIT_4] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_5, codeList: [Iz.IO.KEY_CODE_DIGIT_5] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_6, codeList: [Iz.IO.KEY_CODE_DIGIT_6] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_7, codeList: [Iz.IO.KEY_CODE_DIGIT_7] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_8, codeList: [Iz.IO.KEY_CODE_DIGIT_8] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_9, codeList: [Iz.IO.KEY_CODE_DIGIT_9] });
                mapper.push({ key: Iz.IO.KEY_NAME_SLOT_10, codeList: [Iz.IO.KEY_CODE_DIGIT_0] });
                return mapper;
            }
            createPad() {
                const mapper = super.createPad();
                mapper.push({ key: Iz.IO.KEY_NAME_SUB_ACTION, codeList: [Iz.IO.PAD_B] });
                mapper.push({ key: Iz.IO.KEY_NAME_MENU_PAGE_MINIMAP, codeList: [Iz.IO.PAD_BACK] });
                mapper.push({ key: Iz.IO.KEY_NAME_OPTIONMENU, codeList: [Iz.IO.PAD_START] });
                return mapper;
            }
            createClearKeyListOnEnd() {
                return [Iz.IO.KEY_NAME_SHIFT];
            }
            createExcludeLatestButtonClear() {
                return toolButtons();
            }
        }
        class CreateMapperMenu extends CreateMapperDefault {
            create(wasd) {
                const mapper = super.create(wasd);
                mapper.push({ key: Iz.IO.KEY_NAME_SHIFT, codeList: [Iz.IO.KEY_CODE_SHIFT] });
                mapper.push({
                    key: Iz.IO.KEY_NAME_ESCAPE,
                    codeList: [Iz.IO.KEY_CODE_ESCAPE, Iz.IO.KEY_CODE_X],
                });
                mapper.push({ key: Iz.IO.KEY_NAME_MENU_SUBMENU, codeList: [Iz.IO.KEY_CODE_C] });
                return mapper;
            }
            createPad() {
                const mapper = super.createPad();
                mapper.push({ key: Iz.IO.KEY_NAME_MENU_SUBMENU, codeList: [Iz.IO.PAD_Y] });
                return mapper;
            }
        }
        class CreateMapperWarehouse extends CreateMapperDefault {
            create(wasd) {
                const mapper = super.create(wasd);
                mapper.push({ key: Iz.IO.KEY_NAME_ALL_SELECT, codeList: [Iz.IO.KEY_CODE_SHIFT] });
                return mapper;
            }
            createPad() {
                const mapper = super.createPad();
                mapper.push({ key: Iz.IO.KEY_NAME_ALL_SELECT, codeList: [Iz.IO.PAD_X] });
                return mapper;
            }
        }
        class CreateMessageWindow extends CreateMapperDefault {
            create(wasd) {
                const mapper = super.create(wasd);
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_WINDOW, codeList: [Iz.IO.KEY_CODE_X] });
                mapper.push({
                    key: Iz.IO.KEY_NAME_MESSAGE_INTERRUPT,
                    codeList: [Iz.IO.KEY_CODE_Q, Iz.IO.KEY_CODE_HOME],
                });
                mapper.push({
                    key: Iz.IO.KEY_NAME_MESSAGE_INTERRUPT,
                    codeList: [Iz.IO.KEY_CODE_E, Iz.IO.KEY_CODE_END],
                });
                mapper.push({
                    key: Iz.IO.KEY_NAME_MESSAGE_WINDOW_OPTION,
                    codeList: [Iz.IO.KEY_CODE_ESCAPE],
                });
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_AUTO, codeList: [Iz.IO.KEY_CODE_C] });
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_SKIP, codeList: [Iz.IO.KEY_CODE_CTRL] });
                return mapper;
            }
            createPad() {
                const mapper = super.createPad();
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_WINDOW, codeList: [Iz.IO.PAD_X] });
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_INTERRUPT, codeList: [Iz.IO.PAD_LB] });
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_INTERRUPT, codeList: [Iz.IO.PAD_RB] });
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_WINDOW_OPTION, codeList: [Iz.IO.PAD_START] });
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_AUTO, codeList: [Iz.IO.PAD_Y] });
                mapper.push({ key: Iz.IO.KEY_NAME_MESSAGE_SKIP, codeList: [Iz.IO.PAD_RT] });
                return mapper;
            }
        }
        class CreateChoice extends CreateMapperDefault {
        }
        class CreateMapperOptionMenu extends CreateMapperDefault {
            createPad() {
                const mapper = super.createPad();
                const cancel = mapper.find((data) => data.key === Iz.IO.KEY_NAME_CANCEL);
                if (cancel) {
                    cancel.codeList.push(Iz.IO.PAD_START);
                }
                return mapper;
            }
        }
        class CreateMapperSaveFile extends CreateMapperDefault {
            create(wasd) {
                const mapper = super.create(wasd);
                mapper.push({ key: Iz.IO.KEY_NAME_SAVE_CHANGE_LOCK, codeList: [Iz.IO.KEY_CODE_C] });
                mapper.push({ key: Iz.IO.KEY_NAME_DEBUG_BACKUP_DATA, codeList: [Iz.IO.KEY_CODE_B] });
                return mapper;
            }
            createPad() {
                const mapper = super.createPad();
                mapper.push({ key: Iz.IO.KEY_NAME_SAVE_CHANGE_LOCK, codeList: [Iz.IO.PAD_Y] });
                return mapper;
            }
        }
        class CreateMapperItemSelectWindow extends CreateMapperDefault {
        }
        class CreateMapperHolder {
            constructor() {
                this._list = new Map();
            }
            set(key, creator) {
                this._list.set(key, creator);
            }
            create(key, wasd) {
                const creator = this._list.get(key);
                if (creator) {
                    return createKeyMapper(creator.create(wasd));
                }
                return {};
            }
            createPad(key) {
                const creator = this._list.get(key);
                if (creator) {
                    return createKeyMapper(creator.createPad());
                }
                return {};
            }
            createClearKeyListOnEnd(key) {
                const creator = this._list.get(key);
                if (!creator) {
                    return [];
                }
                return creator.createClearKeyListOnEnd() ?? [];
            }
            createExcludeLatestButtonClear(key) {
                const creator = this._list.get(key);
                if (!creator) {
                    return [];
                }
                return creator.createExcludeLatestButtonClear();
            }
        }
        const holder = new CreateMapperHolder();
        holder.set(Life.InputMapperKey.Default, new CreateMapperDefault());
        holder.set(Life.InputMapperKey.Event, new CreateMapperEvent());
        holder.set(Life.InputMapperKey.Map, new CreateMapperMap());
        holder.set(Life.InputMapperKey.Menu, new CreateMapperMenu());
        holder.set(Life.InputMapperKey.Warehouse, new CreateMapperWarehouse());
        holder.set(Life.InputMapperKey.MessageWindow, new CreateMessageWindow());
        holder.set(Life.InputMapperKey.Choice, new CreateChoice());
        holder.set(Life.InputMapperKey.OptionMenu, new CreateMapperOptionMenu());
        holder.set(Life.InputMapperKey.SaveFile, new CreateMapperSaveFile());
        holder.set(Life.InputMapperKey.ItemSelectWindow, new CreateMapperDefault());
        let currentKey = "";
        function setInputMapper(key) {
            const wasd = Iz.System.isWASD();
            const nextKey = `${key}${wasd ? "_wasd" : ""}`;
            if (currentKey === nextKey) {
                return;
            }
            Iz.IO.checkDisableKeyCode();
            if (Input._latestButton &&
                !holder.createExcludeLatestButtonClear(key).includes(Input._latestButton)) {
                Input._currentState[Input._latestButton] = false;
                Input._latestButton = null;
            }
            holder.createClearKeyListOnEnd(key).forEach((inputKey) => {
                Input._currentState[inputKey] = false;
                Input._previousState[inputKey] = false;
            });
            // console.log(`${currentKey} -> ${nextKey}`);
            currentKey = nextKey;
            const mapper = holder.create(key, wasd);
            Iz.IO.setInputKeyMapper(mapper);
            const padMapper = holder.createPad(key);
            Iz.IO.setInputPadMapper(padMapper);
        }
        Life.setInputMapper = setInputMapper;
        function currentInputMapperKey() {
            return currentKey;
        }
        Life.currentInputMapperKey = currentInputMapperKey;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function initKeyState(key) {
            delete Input._currentState[key];
            delete Input._previousState[key];
            Input._gamepadStates = [];
        }
        function initKeyList(exclude) {
            const excludeList = exclude ?? [];
            [
                Iz.IO.KEY_NAME_OK,
                Iz.IO.KEY_NAME_ESCAPE,
                Iz.IO.KEY_NAME_SHIFT,
                Iz.IO.KEY_NAME_TAB,
                Iz.IO.KEY_NAME_LEFT,
                Iz.IO.KEY_NAME_UP,
                Iz.IO.KEY_NAME_RIGHT,
                Iz.IO.KEY_NAME_DOWN,
                Iz.IO.KEY_NAME_MENU,
                Iz.IO.KEY_NAME_CANCEL,
                Iz.IO.KEY_NAME_SLOT_LEFT,
                Iz.IO.KEY_NAME_SLOT_UP,
                Iz.IO.KEY_NAME_SLOT_RIGHT,
                Iz.IO.KEY_NAME_SLOT_DOWN,
                Iz.IO.KEY_NAME_SUB_ACTION,
                Iz.IO.KEY_NAME_ACTION,
                Iz.IO.KEY_NAME_MENU_PAGE_EVENTLIST,
                Iz.IO.KEY_NAME_MENU_PAGE_ITEMSLOT,
                Iz.IO.KEY_NAME_MENU_PAGE_RESIDENTS,
                Iz.IO.KEY_NAME_MENU_PAGE_MINIMAP,
                Iz.IO.KEY_NAME_MENU_PAGE_SKILL,
                Iz.IO.KEY_NAME_ALL_SELECT,
                Iz.IO.KEY_NAME_MENU_SUBMENU,
                Iz.IO.KEY_NAME_OPTIONMENU,
                Iz.IO.KEY_NAME_MESSAGE_WINDOW,
                Iz.IO.KEY_NAME_MESSAGE_INTERRUPT,
                Iz.IO.KEY_NAME_MESSAGE_WINDOW_OPTION,
                Iz.IO.KEY_NAME_MESSAGE_AUTO,
                Iz.IO.KEY_NAME_MESSAGE_SKIP,
                Iz.IO.KEY_NAME_MESSAGE_CONFIG,
                Iz.IO.KEY_NAME_MESSAGE_SCREEN,
                Iz.IO.KEY_NAME_SAVE_CHANGE_LOCK,
                Iz.IO.KEY_NAME_DEBUG_BACKUP_DATA,
            ]
                .filter((key) => !excludeList.find((data) => data === key))
                .forEach((key) => {
                initKeyState(key);
            });
        }
        Life.initKeyList = initKeyList;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    function isExcludeInitKeyListScene(scene) {
        if (scene instanceof Scene_Options)
            return true;
        if (scene instanceof Scene_Save)
            return true;
        if (scene instanceof Scene_Load)
            return true;
        return false;
    }
    const _SceneManager_onSceneCreate = SceneManager.onSceneCreate;
    SceneManager.onSceneCreate = function () {
        _SceneManager_onSceneCreate.call(this);
        let key = "";
        if (this._scene instanceof Scene_Map) {
            key = Iz.Life.InputMapperKey.Map;
        }
        else if (this._scene instanceof Iz.Life.MenuScene) {
            key = Iz.Life.InputMapperKey.Menu;
        }
        else if (this._scene instanceof Scene_Warehouse) {
            key = Iz.Life.InputMapperKey.Warehouse;
        }
        else if (this._scene instanceof Scene_File) {
            key = Iz.Life.InputMapperKey.SaveFile;
        }
        else {
            key = Iz.Life.InputMapperKey.Default;
        }
        Iz.Life.setInputMapper(key);
        const isMapScene = this._scene instanceof Scene_Map;
        const isMapScenePrev = this._previousScene instanceof Scene_Map;
        if (isMapScene !== isMapScenePrev) {
            const exclude = [];
            if (isExcludeInitKeyListScene(this._scene)) {
                exclude.push(Iz.IO.KEY_NAME_OK);
            }
            Iz.Life.initKeyList(exclude);
        }
    };
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        _Scene_Map_update.call(this);
        this.updateInputMapper();
    };
    Scene_Map.prototype.updateInputMapper = function () {
        if (this.isEnableOptionMenu()) {
            Iz.Life.setInputMapper(Iz.Life.InputMapperKey.OptionMenu);
        }
        else if (this._choiceListWindow.active) {
            Iz.Life.setInputMapper(Iz.Life.InputMapperKey.Choice);
        }
        else if ($gameMessage.isBusy()) {
            if ($gameMessage.isItemChoice()) {
                Iz.Life.setInputMapper(Iz.Life.InputMapperKey.ItemSelectWindow);
            }
            else {
                Iz.Life.setInputMapper(Iz.Life.InputMapperKey.MessageWindow);
            }
        }
        else if ($gameMap.isEventRunning()) {
            Iz.Life.setInputMapper(Iz.Life.InputMapperKey.Event);
        }
        else {
            Iz.Life.setInputMapper(Iz.Life.InputMapperKey.Map);
        }
    };
    const _Game_Player_canMove = Game_Player.prototype.canMove;
    Game_Player.prototype.canMove = function () {
        if (!Iz.Life.EnablePlayerMove)
            return false;
        return _Game_Player_canMove.call(this);
    };
})();
//# sourceMappingURL=PlayerOperation.js.map