/*:
 * @target MZ
 * @plugindesc セーブデータ関連
 * @help
 *
 *
 *
 * @command Save
 * @text Save
 * @desc セーブ
 *
 * @arg savefileId
 * @text savefileId
 * @desc セーブファイルの番号 オートセーブは0を指定します
 *
 *
 */
// セーブ・ロード画面関連
var Iz;
(function (Iz) {
    var System;
    (function (System) {
        System.SaveFileMaxPerPage = 20;
        System.SaveFilePageMax = 8;
        System.SaveFileMax = System.SaveFileMaxPerPage * System.SaveFilePageMax;
        class SaveLeftPageSprite extends Sprite {
            constructor(x, y) {
                super();
                this.create();
                this._degree = 0;
                this._baseX = x;
                this._baseY = y;
            }
            create() {
                this.setAtlas(Iz.Life.ATLAS_KEY_COMMON, Iz.Life.FRAME_KEY_COMMON_TARGET_LEFT);
            }
            update() {
                super.update();
                this._degree += 8;
                const radian = this._degree * (Math.PI / 180);
                this.x = this._baseX + Math.sin(radian);
                this.y = this._baseY;
            }
        }
        System.SaveLeftPageSprite = SaveLeftPageSprite;
        class SaveRightPageSprite extends Sprite {
            constructor(x, y) {
                super();
                this.create();
                this._degree = 0;
                this._baseX = x;
                this._baseY = y;
            }
            create() {
                this.setAtlas(Iz.Life.ATLAS_KEY_COMMON, Iz.Life.FRAME_KEY_COMMON_TARGET_RIGHT);
            }
            update() {
                super.update();
                this._degree -= 8;
                const radian = this._degree * (Math.PI / 180);
                this.x = this._baseX + Math.sin(radian);
                this.y = this._baseY;
            }
        }
        System.SaveRightPageSprite = SaveRightPageSprite;
        class Sprite_SavePageButton extends Sprite_Clickable {
            setOnClick(click) {
                this._onClick = click;
            }
            onClick() {
                this?._onClick();
            }
        }
        System.Sprite_SavePageButton = Sprite_SavePageButton;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Scene_File_create = Scene_File.prototype.create;
    Scene_File.prototype.create = function () {
        _Scene_File_create.call(this);
        this.createFooter();
        this.createArrows();
        const r = this._listWindow.itemRectWithPadding(0);
        this._listWindow.addOverrideTouchArea({
            id: "lock",
            rect: new Rectangle(r.width - 16, 0, 32, 32),
            handler: () => {
                const index = this._listWindow.indexInAll();
                this.changeLock(index);
            },
        });
    };
    Scene_File.prototype.createArrows = function () {
        this._leftArrow = new Iz.System.SaveLeftPageSprite(20, Graphics.height / 2);
        this._leftArrow.anchor.set(0.5, 0.5);
        this._leftArrow.visible = false;
        this.addChild(this._leftArrow);
        this._rightArrow = new Iz.System.SaveRightPageSprite(Graphics.width - 20, Graphics.height / 2);
        this._rightArrow.anchor.set(0.5, 0.5);
        this._rightArrow.visible = false;
        this.addChild(this._rightArrow);
        //
        {
            const bitmap = new Bitmap(40, this._listWindow.height);
            const button = new Iz.System.Sprite_SavePageButton();
            button.bitmap = bitmap;
            button.x = 0;
            button.y = this._listWindow.y;
            button.setOnClick(() => {
                this._listWindow.prevPage();
            });
            this._leftArrowButton = button;
            this.addChild(button);
        }
        {
            const bitmap = new Bitmap(40, this._listWindow.height);
            const button = new Iz.System.Sprite_SavePageButton();
            button.bitmap = bitmap;
            button.x = this._listWindow.x + this._listWindow.width;
            button.y = this._listWindow.y;
            button.setOnClick(() => {
                this._listWindow.nextPage();
            });
            this._rightArrowButton = button;
            this.addChild(button);
        }
    };
    Scene_File.prototype.listWindowRect = function () {
        const offset = 32;
        const wx = offset;
        const wy = this.mainAreaTop() + this._helpWindow.height;
        const ww = Graphics.boxWidth - offset * 2;
        const wh = this.mainAreaHeight() - this._helpWindow.height;
        return new Rectangle(wx, wy, ww, wh);
    };
    Scene_File.prototype.createFooter = function () {
        this._footer = Iz.Life.createUIFooter();
        this.updateFooter();
        this.addChild(this._footer);
        this._footer.update();
    };
    const _Scene_File_start = Scene_File.prototype.start;
    Scene_File.prototype.start = function () {
        _Scene_File_start.call(this);
        this.createDialogUI();
    };
    const _Scene_File_update = Scene_File.prototype.update;
    Scene_File.prototype.update = function () {
        _Scene_File_update.call(this);
        if (this.isActive() && !Iz.Life.Dialog.isBusy()) {
            if (Input.isRepeated(Iz.IO.KEY_NAME_SLOT_RIGHT)) {
                const res = this._listWindow.nextPage();
                if (res) {
                    SoundManager.playCursor();
                }
            }
            else if (Input.isRepeated(Iz.IO.KEY_NAME_SLOT_LEFT)) {
                const res = this._listWindow.prevPage();
                if (res) {
                    SoundManager.playCursor();
                }
            }
            this.updateLock();
            this.updateArrows();
        }
        this.updateFooter();
    };
    Scene_File.prototype.updateFooter = function () {
        const text = Iz.Text.get("SAVE_SCENE_FOOTER");
        this._footer.text.setText(text);
    };
    Scene_File.prototype.updateLock = function () {
        if (Input.isTriggered(Iz.IO.KEY_NAME_SAVE_CHANGE_LOCK)) {
            const index = this._listWindow.indexInAll();
            this.changeLock(index);
        }
    };
    Scene_File.prototype.updateArrows = function () {
        const pageMax = this._listWindow.pageMax();
        const enableLeft = pageMax > 1 && this._listWindow.pageIndex() > 0;
        this._leftArrow.visible = enableLeft;
        this._leftArrowButton.visible = enableLeft;
        const enableRight = pageMax > 1 && this._listWindow.pageIndex() < pageMax - 1;
        this._rightArrow.visible = enableRight;
        this._rightArrowButton.visible = enableRight;
    };
    Scene_File.prototype.changeLock = function (index) {
        // オートセーブは対象外
        if (index === 0)
            return;
        const info = DataManager.savefileInfo(index);
        if (!info)
            return;
        info.life.lock = !info.life.lock;
        this._listWindow.refresh();
        this._changeLock = true;
    };
    Scene_File.prototype.mainAreaTop = function () {
        return 0;
    };
    const _Scene_File_terminate = Scene_File.prototype.terminate;
    Scene_File.prototype.terminate = function () {
        _Scene_File_terminate.call(this);
        if (this._changeLock) {
            DataManager.saveGlobalInfo();
        }
    };
    const _Scene_Save_createListWindow = Scene_Save.prototype.createListWindow;
    Scene_Save.prototype.createListWindow = function () {
        _Scene_Save_createListWindow.call(this);
        this._listWindow.setHandler("cancel", this.onCancel.bind(this));
    };
    Scene_Save.prototype.onCancel = function () {
        if (!Iz.System.isEnableSaveDialog()) {
            this.popScene();
            return;
        }
        const option = Iz.Life.createDialogOption("save_close");
        if (!option) {
            this.popScene();
            return;
        }
        option.yesHandler = () => {
            this.popScene();
        };
        option.noHandler = () => {
            this.activateListWindow();
        };
        Iz.Life.Dialog.open(option);
    };
    const _Scene_Save_onSavefileOk = Scene_Save.prototype.onSavefileOk;
    Scene_Save.prototype.onSavefileOk = function () {
        if (Iz.System.isEnableSaveDialog()) {
            const savefileId = this.savefileId();
            if (this.isSavefileEnabled(savefileId)) {
                const info = DataManager.savefileInfo(savefileId);
                const option = Iz.Life.createDialogOption("save_override");
                if (info && option) {
                    option.yesHandler = () => {
                        _Scene_Save_onSavefileOk.call(this);
                    };
                    option.noHandler = () => {
                        this.activateListWindow();
                    };
                    Iz.Life.Dialog.open(option);
                    return;
                }
            }
        }
        _Scene_Save_onSavefileOk.call(this);
    };
    const _Window_SavefileList_initialize = Window_SavefileList.prototype.initialize;
    Window_SavefileList.prototype.initialize = function (rect, ...args) {
        _Window_SavefileList_initialize.call(this, rect, ...args);
        this._pageIndex = 0;
    };
    const _Window_SavefileList_drawItem = Window_SavefileList.prototype.drawItem;
    Window_SavefileList.prototype.drawItem = function (index) {
        _Window_SavefileList_drawItem.call(this, index);
        const savefileId = this.indexToSavefileId(index);
        const info = DataManager.savefileInfo(savefileId);
        if (!info)
            return;
        const life = info.life;
        this.drawPlayerInfo(index, life);
        this.drawLock(index, life.lock);
        this.drawVersion(index, life.version, life.trial);
    };
    Window_SavefileList.prototype.drawPlayerInfo = function (index, life) {
        const rect = this.itemRectWithPadding(index);
        let text = life.player.name;
        if (life.partner) {
            const actor = $gameActors.actor(life.partner.id);
            if (actor) {
                const partnerText = `${Iz.Life.Status.getRelationshipName(life.partner.relationship)}(${actor.name()})`;
                text += "    ";
                text += partnerText;
            }
        }
        this.drawTextEx(text, rect.x + 180, rect.y + 4, 512);
    };
    const _Window_SavefileList_drawPlaytime = Window_SavefileList.prototype.drawPlaytime;
    Window_SavefileList.prototype.drawPlaytime = function (info, x, y, width) {
        let text = "";
        text += `${Iz.String.format(Iz.Text.get("CHRONUS_YEARS"), info.life.date.year)}`;
        text += `  ${Iz.System.getDaysText(info.life.date.month, info.life.date.day)}`;
        text += `  ${info.playtime}`;
        this.drawText(text, x, y, width, "right");
        return;
    };
    Window_SavefileList.prototype.drawLock = function (index, lock) {
        const rect = this.itemRectWithPadding(index);
        const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_COMMON);
        const bitmap = atlas.getBitmap();
        let f = atlas.getFrame(Iz.Life.FRAME_KEY_COMMON_LOCK_0);
        if (lock) {
            f = atlas.getFrame(Iz.Life.FRAME_KEY_COMMON_LOCK_1);
        }
        this.contents.blt(bitmap, f.x, f.y, f.width, f.height, rect.width - 16, rect.y);
    };
    Window_SavefileList.prototype.drawVersion = function (index, version, trial) {
        const rect = this.itemRectWithPadding(index);
        const text = `ver. ${version}${trial ? " (trial)" : ""}`;
        this.drawText(text, rect.x, rect.y + 50, rect.width, "right");
    };
    const _Window_SavefileList_isEnable = Window_SavefileList.prototype.isEnabled;
    Window_SavefileList.prototype.isEnabled = function (savefileId) {
        if (this._mode === "save") {
            if (DataManager.savefileInfo(savefileId)?.life.lock) {
                return false;
            }
        }
        return _Window_SavefileList_isEnable.call(this, savefileId);
    };
    Window_SavefileList.prototype.selectSavefile = function (savefileId) {
        const index = Math.max(0, this.savefileIdToIndex(savefileId));
        const listIndex = (index % Iz.System.SaveFileMaxPerPage) - (this._autosave ? 0 : 1);
        const pageIndex = Math.floor(index / Iz.System.SaveFileMaxPerPage);
        this.setPage(pageIndex);
        this.select(listIndex);
        this.setTopRow(listIndex - 2);
    };
    Window_SavefileList.prototype.maxItems = function () {
        return Iz.System.SaveFileMaxPerPage - (this._autosave ? 0 : 1);
    };
    Window_SavefileList.prototype.indexToSavefileId = function (index) {
        const add = this._pageIndex * Iz.System.SaveFileMaxPerPage;
        return add + index + (this._autosave ? 0 : 1);
    };
    Window_SavefileList.prototype.nextPage = function () {
        const p = this._pageIndex;
        const pageIndex = Math.min(p + 1, Iz.System.SaveFilePageMax - 1);
        this.setPage(pageIndex);
        return p !== this._pageIndex;
    };
    Window_SavefileList.prototype.prevPage = function () {
        const p = this._pageIndex;
        const pageIndex = Math.max(p - 1, 0);
        this.setPage(pageIndex);
        return p !== this._pageIndex;
    };
    Window_SavefileList.prototype.setPage = function (pageIndex) {
        this._pageIndex = pageIndex;
        this.refresh();
    };
    Window_SavefileList.prototype.pageIndex = function () {
        return this._pageIndex;
    };
    Window_SavefileList.prototype.pageMax = function () {
        return Iz.System.SaveFilePageMax;
    };
    Window_SavefileList.prototype.indexInAll = function () {
        const res = this.pageIndex() * Iz.System.SaveFileMaxPerPage + this.index();
        return res;
    };
    const _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo;
    DataManager.makeSavefileInfo = function () {
        const info = _DataManager_makeSavefileInfo.call(this);
        const partner = Iz.Life.StatusUtil.partner();
        const relationShip = Iz.Life.Status.getRelationShip(partner);
        info.life = {
            version: Iz.Life.env.version,
            trial: !!Iz.Life.isTrial(),
            player: {
                name: $gameActors.actor(1)?.name() ?? "",
            },
            partner: {
                id: partner,
                relationship: relationShip,
            },
            date: {
                year: Iz.System.getYear(),
                month: Iz.System.getMonth(),
                day: Iz.System.getDay(),
            },
            lock: false, // セーブ時しか呼べないのでfalse
            comment: "",
        };
        return info;
    };
    DataManager.maxSavefiles = function () {
        return Iz.System.SaveFileMax;
    };
})();
// セーブ処理関連
(function (Iz) {
    var System;
    (function (System) {
        class RetryPromise {
            get isRunning() {
                return this._running;
            }
            constructor() {
                this._running = false;
            }
            async exec(option) {
                const execMax = option?.retry !== undefined ? option.retry + 1 : 3;
                let current = 0;
                while (current < execMax) {
                    this._running = true;
                    current++;
                    try {
                        await option?.promise;
                        break;
                    }
                    catch (e) {
                        if (current >= execMax) {
                            throw e;
                        }
                    }
                    finally {
                        this._running = false;
                    }
                }
            }
        }
        System.RetryPromise = RetryPromise;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var System;
    (function (System) {
        function isValidSavefile(savefileId) {
            return savefileId >= 0 && savefileId < DataManager.maxSavefiles();
        }
        function isAutoSavefile(savefileId) {
            return savefileId === 0;
        }
        System.isAutoSavefile = isAutoSavefile;
        async function asyncSave(savefileId, includeBaclup) {
            if (!isValidSavefile(savefileId)) {
                throw new Error(`invalid savefileId: ${savefileId}`);
            }
            const contents = Iz.System.Save.createSaveContents(includeBaclup);
            const saveName = DataManager.makeSavename(savefileId);
            await StorageManager.saveObject(saveName, contents);
            await asyncSaveInfo(savefileId);
        }
        System.asyncSave = asyncSave;
        async function asyncSaveInfo(savefileId) {
            if (!isValidSavefile(savefileId)) {
                throw new Error(`invalid savefileId: ${savefileId}`);
            }
            const info = DataManager.makeSavefileInfo();
            // @ts-ignore
            const infos = DataManager._globalInfo;
            infos[savefileId] = info;
            await StorageManager.saveObject("global", infos);
        }
        System.asyncSaveInfo = asyncSaveInfo;
        class SaveOperator {
            constructor() {
                this._asyncPromise = new System.RetryPromise();
                this._backupData = "";
                this.clearMode();
            }
            get isRunnning() {
                return this._type.mode !== "none";
            }
            get backupData() {
                return this._backupData;
            }
            set backupData(value) {
                this._backupData = value;
            }
            update() {
                if (this._type.mode === "none") {
                    this.updateNone(this._type);
                    return;
                }
                if (this._type.mode === "scene") {
                    this.updateScene(this._type);
                    return;
                }
                if (this._type.mode === "async") {
                    this.updateAsync(this._type);
                    return;
                }
                if (this._type.mode === "async_wait") {
                    this.updateAsyncWait(this._type);
                    return;
                }
                const s = this._type;
            }
            updateNone(type) { }
            updateScene(type) {
                SceneManager.push(Scene_Save);
                this.clearMode();
            }
            async asyncSaveFile(savefileId) {
                if (isAutoSavefile(savefileId)) {
                    const res = await StorageManager.objectToJson(DataManager.makeSaveContents());
                    this._backupData = res;
                }
                await asyncSave(savefileId, true);
            }
            updateAsync(type) {
                if (!isAutoSavefile(type.savefileId)) {
                    $gameSystem.setSavefileId(type.savefileId);
                }
                $gameSystem.onBeforeSave();
                this._asyncPromise
                    .exec({ promise: this.asyncSaveFile(type.savefileId) })
                    // NOTE:
                    // 何かするかも
                    .then(() => {
                    // console.log(`savefileId:${type.savefileId} complete.`);
                })
                    .catch((e) => {
                    // console.error(`savefileId:${type.savefileId} error. ${e}`);
                });
                this._type = {
                    mode: "async_wait",
                    savefileId: type.savefileId,
                };
            }
            updateAsyncWait(type) {
                if (this._asyncPromise.isRunning)
                    return;
                this.clearMode();
            }
            setType(type) {
                if (this.isRunnning)
                    return;
                this._type = type;
            }
            clearMode() {
                this._type = {
                    mode: "none",
                };
            }
            createSaveContents(includeBackup) {
                const contents = DataManager.makeSaveContents();
                if (includeBackup && this._backupData) {
                    contents.backup.data = this._backupData;
                }
                return contents;
            }
        }
        System.SaveOperator = SaveOperator;
        System.Save = new SaveOperator();
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var System;
    (function (System) {
        // このバージョン未満からロードした時にバックアップを利用する
        System.UseBackupVersions = [
        // "0.4.0"
        ];
        function shouldUseBackup(versionText) {
            const a = Iz.convertVersion(versionText);
            return System.UseBackupVersions.some((v) => {
                const b = Iz.convertVersion(v);
                return Iz.compareVersion(a, b) < 0;
            });
        }
        System.shouldUseBackup = shouldUseBackup;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const SaveModeName = "save";
    const script = document.currentScript;
    PluginManagerEx.registerCommand(script, "Save", function (args) {
        if (Iz.System.Save.isRunnning)
            return;
        // @ts-ignore
        const interpreter = this;
        Iz.System.Save.setType({
            mode: "async",
            savefileId: args.savefileId,
        });
        interpreter.setWaitMode(SaveModeName);
    });
    const _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function () {
        if (this._waitMode === SaveModeName) {
            const waiting = Iz.System.Save.isRunnning;
            if (!waiting) {
                this._waitMode = "";
            }
            return waiting;
        }
        return _Game_Interpreter_updateWaitMode.call(this);
    };
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        _Scene_Map_update.call(this);
        Iz.System.Save.update();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.backup = {
            data: "",
        };
        return contents;
    };
    async function saveSystemAndGlobal(savefileId) {
        await Iz.Life.saveSystemData();
        // @ts-ignore
        DataManager._globalInfo[savefileId] = DataManager.makeSavefileInfo();
        DataManager.saveGlobalInfo();
    }
    DataManager.saveGame = function (savefileId) {
        const contents = Iz.System.Save.createSaveContents(true);
        const saveName = this.makeSavename(savefileId);
        return StorageManager.saveObject(saveName, contents).then(() => {
            saveSystemAndGlobal(savefileId);
            return 0;
        });
    };
    DataManager.loadGame = function (savefileId, loadBackup = false) {
        const saveName = this.makeSavename(savefileId);
        return StorageManager.loadObject(saveName)
            .then((contents) => {
            const c = contents;
            // NOTE:
            // オートセーブ時のデータを読み込む
            // 既存のデータがそのままでは使えないケースを想定
            if (loadBackup) {
                if (!c.backup.data) {
                    throw new Error("empty backup data.");
                }
                return StorageManager.jsonToObject(c.backup.data).then((object) => {
                    const autoC = object;
                    return autoC;
                });
            }
            return c;
        })
            .then((contents) => {
            this.createGameObjects();
            this.extractSaveContents(contents);
            this.correctDataErrors();
            if (contents.backup.data) {
                Iz.System.Save.backupData = contents.backup.data;
            }
            else {
                Iz.System.Save.backupData = "";
            }
            return 0;
        });
    };
    Scene_Load.prototype.executeLoad = function (savefileId) {
        const info = DataManager.savefileInfo(savefileId);
        if (!info) {
            this.onLoadFailure();
            return;
        }
        let loadbackup = false;
        if (Iz.System.shouldUseBackup(info.life.version)) {
            loadbackup = true;
        }
        if (Iz.System.isTestMode()) {
            // デバッグ用
            if (Input.isPressed(Iz.IO.KEY_NAME_DEBUG_BACKUP_DATA)) {
                loadbackup = true;
            }
        }
        // console.log(`loadbackup -> ${loadbackup}`);
        const loadGame = () => {
            DataManager.loadGame(savefileId, loadbackup)
                .then(() => this.onLoadSuccess())
                .catch(() => this.onLoadFailure());
        };
        if (loadbackup) {
            const option = Iz.Life.createDialogOption("save_load_backup");
            if (option) {
                option.yesHandler = () => {
                    loadGame();
                };
                option.noHandler = () => {
                    this.activateListWindow();
                };
                Iz.Life.Dialog.open(option);
            }
            else {
                this.onLoadFailure();
            }
            return;
        }
        loadGame();
    };
})();
// 共通システムデータ
(function (Iz) {
    var Life;
    (function (Life) {
        const SaveDataName = "system";
        let _loaded = false;
        const _onLoadHandlers = [];
        function addLoadSystemDataHandler(handler) {
            _onLoadHandlers.push(handler);
        }
        Life.addLoadSystemDataHandler = addLoadSystemDataHandler;
        function createSystemData() {
            const system = {
                memory: Life.Memory.save.getMemoryData(),
            };
            return system;
        }
        async function saveSystemData() {
            for (let i = 0; i < 3; i++) {
                try {
                    const data = createSystemData();
                    await StorageManager.saveObject(SaveDataName, data);
                    return true;
                }
                catch { }
            }
            return false;
        }
        Life.saveSystemData = saveSystemData;
        async function loadSystemData() {
            // NOTE:
            // ファイルの存在チェックが難しいので数回リトライする
            // ロードできない場合はデフォルト値のままとする
            const max = 3;
            let res = false;
            for (let i = 1; i <= max; i++) {
                try {
                    const data = (await StorageManager.loadObject(SaveDataName));
                    res = true;
                    _onLoadHandlers.forEach((handler) => handler(data));
                    break;
                }
                catch { }
            }
            _loaded = true;
            return res;
        }
        Life.loadSystemData = loadSystemData;
        function loadedSystemData() {
            return _loaded;
        }
        Life.loadedSystemData = loadedSystemData;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const _Scene_Boot_loadPlayerData = Scene_Boot.prototype.loadPlayerData;
    Scene_Boot.prototype.loadPlayerData = function () {
        _Scene_Boot_loadPlayerData.call(this);
        Iz.Life.loadSystemData();
    };
    const _Scene_Boot_isPlayerDataLoaded = Scene_Boot.prototype.isPlayerDataLoaded;
    Scene_Boot.prototype.isPlayerDataLoaded = function () {
        if (!Iz.Life.loadedSystemData()) {
            return false;
        }
        return _Scene_Boot_isPlayerDataLoaded.call(this);
    };
})();
//# sourceMappingURL=SaveData.js.map