
//=============================================================================
// SelfSwitchExpansion.js
// ----------------------------------------------------------------------------
// (C) 2020 Shun / inazuma_soft
// https://twitter.com/inazuma_soft
// https://ci-en.dlsite.com/creator/2713
// ----------------------------------------------------------------------------

/*:
 * @target MZ
 * @plugindesc セルフスイッチの一括リセット機能を提供します
 * @author Shun
 *
 * @help 
 * 
 * プラグインコマンド
 *
 * RESET_SELFSWITCH : [A~D] [ONCHANGE]
 * 第一引数　アルファベットの A から D を指定します
 * 第二引数　true false のいずれかを指定します
 * 
 * セルフスイッチを変更した際に既定の動作ではイベントのリフレッシュ処理などが入ります
 * ONCHANGE を false に設定した場合はリフレッシュ処理が入りません
 * 
 * @command reset
 * @text セルフスイッチのリセット
 * @desc セルフスイッチのリセット
 * 
 * @arg name
 * @text リセットするセルフスイッチ名
 * @desc リセットするセルフスイッチ名
 * @type string
 * @default A
 * 
 * @arg refresh
 * @text リフレッシュ
 * @desc スイッチ変更時のリフレッシュ処理を行うかのフラグ
 * @type boolean
 * @default false
 * 
 * SET_SELFSWITCH : [A~D] [VALUE]
 * 第一引数　アルファベットの A から D を指定します
 * 第二引数　true false のいずれかを指定します
 * 
 * セルフスイッチを変更した際に既定の動作ではイベントのリフレッシュ処理などが入ります
 * 
 * @command set
 * @text セルフスイッチのセット
 * @desc セルフスイッチのセット
 * 
 * @arg mapId
 * @text マップID
 * @desc マップID
 * @type number
 * @default 1
 * 
 * @arg eventId
 * @text イベントID
 * @desc イベントID
 * @type number
 * @default 1
 *
 * @arg name
 * @text セットするセルフスイッチ名
 * @desc セットするセルフスイッチ名
 * @type string
 * @default A
 * 
 * @arg value
 * @text ON/OFF
 * @desc スイッチ変更の値
 * @type boolean
 * @default false
 * 
 */

(function () {
    'use strict'

    const pluginName = "SelfSwitchesEx";
    const parameters = PluginManager.parameters(pluginName);

    PluginManager.registerCommand(pluginName, "reset", args => {

        var onChange = args["refresh"].toLowerCase() === 'false' ? false : true;
        $gameSelfSwitches.resetSwitch(args["name"], onChange);

    });
    PluginManager.registerCommand(pluginName, "set", args => {

        const key = [args["mapId"], args["eventId"], args["name"]];
        $gameSelfSwitches.setValue(key, args["value"]);
    });

    Game_SelfSwitches.prototype.resetSwitch = function (name, onChange = true) {
        Object.keys(this._data)
            .filter(key => key.split(',')[2] === name)
            .forEach(key => this._data[key] = false);
        if (onChange) {
            this.onChange();
        }
    };

    Game_CharacterBase.prototype.setSelfSwitch = function () {
    }

    Game_Event.prototype.setSelfSwitch = function (name, value) {
        const key = [this._mapId, this._eventId, name];
        $gameSelfSwitches.setValue(key, value);
    }

})()